/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.container;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.ContainerRetryContext;
import org.apache.hadoop.yarn.api.records.ContainerRetryPolicy;
import org.apache.hadoop.yarn.util.Clock;

@InterfaceStability.Unstable
public class SlidingWindowRetryPolicy {
    private Clock clock;

    public SlidingWindowRetryPolicy(Clock clock) {
        this.clock = (Clock)Preconditions.checkNotNull((Object)clock);
    }

    public boolean shouldRetry(RetryContext retryContext, int errorCode) {
        ContainerRetryContext containerRC = retryContext.containerRetryContext;
        Preconditions.checkNotNull((Object)containerRC, (Object)"container retry context null");
        ContainerRetryPolicy retryPolicy = containerRC.getRetryPolicy();
        if (retryPolicy == ContainerRetryPolicy.RETRY_ON_ALL_ERRORS || retryPolicy == ContainerRetryPolicy.RETRY_ON_SPECIFIC_ERROR_CODES && containerRC.getErrorCodes() != null && containerRC.getErrorCodes().contains(errorCode)) {
            return containerRC.getMaxRetries() == -1 || this.calculateRemainingRetries(retryContext) > 0;
        }
        return false;
    }

    private int calculateRemainingRetries(RetryContext retryContext) {
        ContainerRetryContext containerRC = retryContext.containerRetryContext;
        if (containerRC.getFailuresValidityInterval() > 0L) {
            long restartTime;
            int validFailuresCount = 0;
            long currentTime = this.clock.getTime();
            for (int i = retryContext.restartTimes.size() - 1; i >= 0 && currentTime - (restartTime = ((Long)retryContext.restartTimes.get(i)).longValue()) <= containerRC.getFailuresValidityInterval(); --i) {
                ++validFailuresCount;
            }
            return containerRC.getMaxRetries() - validFailuresCount;
        }
        return retryContext.getRemainingRetries();
    }

    protected void updateRetryContext(RetryContext retryContext) {
        if (retryContext.containerRetryContext.getFailuresValidityInterval() > 0L) {
            long restartTime;
            ContainerRetryContext containerRC = retryContext.containerRetryContext;
            Iterator<Long> iterator = retryContext.getRestartTimes().iterator();
            long currentTime = this.clock.getTime();
            while (iterator.hasNext() && currentTime - (restartTime = iterator.next().longValue()) > containerRC.getFailuresValidityInterval()) {
                iterator.remove();
            }
            retryContext.setRemainingRetries(containerRC.getMaxRetries() - retryContext.restartTimes.size());
            retryContext.getRestartTimes().add(currentTime);
        } else {
            retryContext.remainingRetries--;
        }
    }

    public void setClock(Clock clock) {
        this.clock = (Clock)Preconditions.checkNotNull((Object)clock);
    }

    static class RetryContext {
        private final ContainerRetryContext containerRetryContext;
        private List<Long> restartTimes = new ArrayList<Long>();
        private int remainingRetries;

        RetryContext(ContainerRetryContext containerRetryContext) {
            this.containerRetryContext = (ContainerRetryContext)Preconditions.checkNotNull((Object)containerRetryContext);
            this.remainingRetries = containerRetryContext.getMaxRetries();
        }

        ContainerRetryContext getContainerRetryContext() {
            return this.containerRetryContext;
        }

        int getRemainingRetries() {
            if (this.containerRetryContext.getMaxRetries() == -1) {
                return -1;
            }
            return this.remainingRetries;
        }

        void setRemainingRetries(int remainingRetries) {
            this.remainingRetries = remainingRetries;
        }

        List<Long> getRestartTimes() {
            return this.restartTimes;
        }

        void setRestartTimes(List<Long> restartTimes) {
            if (restartTimes != null) {
                this.restartTimes.clear();
                this.restartTimes.addAll(restartTimes);
            }
        }
    }
}

