/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.Container;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.privileged.PrivilegedOperation;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.privileged.PrivilegedOperationExecutor;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.CGroupsHandler;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.NetworkTagMappingManager;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.NetworkTagMappingManagerFactory;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.ResourceHandler;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.ResourceHandlerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class NetworkPacketTaggingHandlerImpl
implements ResourceHandler {
    private static final Logger LOG = LoggerFactory.getLogger(NetworkPacketTaggingHandlerImpl.class);
    private final CGroupsHandler cGroupsHandler;
    private Configuration conf;
    private NetworkTagMappingManager tagMappingManager;

    public NetworkPacketTaggingHandlerImpl(PrivilegedOperationExecutor privilegedOperationExecutor, CGroupsHandler cGroupsHandler) {
        this.cGroupsHandler = cGroupsHandler;
    }

    @Override
    public List<PrivilegedOperation> bootstrap(Configuration configuration) throws ResourceHandlerException {
        this.conf = configuration;
        this.cGroupsHandler.initializeCGroupController(CGroupsHandler.CGroupController.NET_CLS);
        this.tagMappingManager = this.createNetworkTagMappingManager(this.conf);
        this.tagMappingManager.initialize(this.conf);
        return null;
    }

    @Override
    public List<PrivilegedOperation> preStart(Container container) throws ResourceHandlerException {
        String containerIdStr = container.getContainerId().toString();
        String classIdStr = this.tagMappingManager.getNetworkTagHexID(container);
        this.cGroupsHandler.createCGroup(CGroupsHandler.CGroupController.NET_CLS, containerIdStr);
        this.cGroupsHandler.updateCGroupParam(CGroupsHandler.CGroupController.NET_CLS, containerIdStr, "classid", classIdStr);
        String tasksFile = this.cGroupsHandler.getPathForCGroupTasks(CGroupsHandler.CGroupController.NET_CLS, containerIdStr);
        String opArg = new StringBuffer("cgroups=").append(tasksFile).toString();
        ArrayList<PrivilegedOperation> ops = new ArrayList<PrivilegedOperation>();
        ops.add(new PrivilegedOperation(PrivilegedOperation.OperationType.ADD_PID_TO_CGROUP, opArg));
        return ops;
    }

    @Override
    public List<PrivilegedOperation> reacquireContainer(ContainerId containerId) throws ResourceHandlerException {
        return null;
    }

    @Override
    public List<PrivilegedOperation> updateContainer(Container container) throws ResourceHandlerException {
        return null;
    }

    @Override
    public List<PrivilegedOperation> postComplete(ContainerId containerId) throws ResourceHandlerException {
        LOG.info("postComplete for container: " + containerId.toString());
        this.cGroupsHandler.deleteCGroup(CGroupsHandler.CGroupController.NET_CLS, containerId.toString());
        return null;
    }

    @Override
    public List<PrivilegedOperation> teardown() throws ResourceHandlerException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("teardown(): Nothing to do");
        }
        return null;
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public NetworkTagMappingManager createNetworkTagMappingManager(Configuration conf) {
        return NetworkTagMappingManagerFactory.getManager(conf);
    }

    public String toString() {
        return NetworkPacketTaggingHandlerImpl.class.getName();
    }
}

