/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service.api.records;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.service.api.records.Artifact;
import org.apache.hadoop.yarn.service.api.records.BaseResource;
import org.apache.hadoop.yarn.service.api.records.Component;
import org.apache.hadoop.yarn.service.api.records.Configuration;
import org.apache.hadoop.yarn.service.api.records.KerberosPrincipal;
import org.apache.hadoop.yarn.service.api.records.Resource;
import org.apache.hadoop.yarn.service.api.records.ServiceState;

@InterfaceAudience.Public
@InterfaceStability.Unstable
@ApiModel(description="An Service resource has the following attributes.")
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"name", "version", "description", "state", "resource", "number_of_containers", "lifetime", "containers"})
public class Service
extends BaseResource {
    private static final long serialVersionUID = -4491694636566094885L;
    private String name = null;
    private String id = null;
    private Artifact artifact = null;
    private Resource resource = null;
    @JsonProperty(value="launch_time")
    @XmlElement(name="launch_time")
    private Date launchTime = null;
    @JsonProperty(value="number_of_running_containers")
    @XmlElement(name="number_of_running_containers")
    private Long numberOfRunningContainers = null;
    private Long lifetime = null;
    private List<Component> components = new ArrayList<Component>();
    private Configuration configuration = new Configuration();
    private ServiceState state = null;
    private Map<String, String> quicklinks = new HashMap<String, String>();
    private String queue = null;
    @JsonProperty(value="kerberos_principal")
    @XmlElement(name="kerberos_principal")
    private KerberosPrincipal kerberosPrincipal = new KerberosPrincipal();
    private String version = null;
    private String description = null;
    private String dockerClientConfig = null;
    private List<String> dependencies = new ArrayList<String>();

    public Service name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="A unique service name.")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Service id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", value="A unique service id.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @ApiModelProperty(example="null", required=true, value="Version of the service.")
    @JsonProperty(value="version")
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public Service version(String version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(example="null", value="Description of the service.")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Service description(String description) {
        this.description = description;
        return this;
    }

    public Service artifact(Artifact artifact) {
        this.artifact = artifact;
        return this;
    }

    @ApiModelProperty(example="null", value="Artifact of single-component services. Mandatory if components attribute is not specified.")
    @JsonProperty(value="artifact")
    public Artifact getArtifact() {
        return this.artifact;
    }

    public void setArtifact(Artifact artifact) {
        this.artifact = artifact;
    }

    public Service resource(Resource resource) {
        this.resource = resource;
        return this;
    }

    @ApiModelProperty(example="null", value="Resource of single-component services or the global default for multi-component services. Mandatory if it is a single-component service and if cpus and memory are not specified at the Service level.")
    @JsonProperty(value="resource")
    public Resource getResource() {
        return this.resource;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public Service launchTime(Date launchTime) {
        this.launchTime = launchTime == null ? null : (Date)launchTime.clone();
        return this;
    }

    @ApiModelProperty(example="null", value="The time when the service was created, e.g. 2016-03-16T01:01:49.000Z.")
    public Date getLaunchTime() {
        return this.launchTime == null ? null : (Date)this.launchTime.clone();
    }

    public void setLaunchTime(Date launchTime) {
        this.launchTime = launchTime == null ? null : (Date)launchTime.clone();
    }

    public Service numberOfRunningContainers(Long numberOfRunningContainers) {
        this.numberOfRunningContainers = numberOfRunningContainers;
        return this;
    }

    @ApiModelProperty(example="null", value="In get response this provides the total number of running containers for this service (across all components) at the time of request. Note, a subsequent request can return a different number as and when more containers get allocated until it reaches the total number of containers or if a flex request has been made between the two requests.")
    public Long getNumberOfRunningContainers() {
        return this.numberOfRunningContainers;
    }

    public void setNumberOfRunningContainers(Long numberOfRunningContainers) {
        this.numberOfRunningContainers = numberOfRunningContainers;
    }

    public Service lifetime(Long lifetime) {
        this.lifetime = lifetime;
        return this;
    }

    @ApiModelProperty(example="null", value="Life time (in seconds) of the service from the time it reaches the RUNNING_BUT_UNREADY state (after which it is automatically destroyed by YARN). For unlimited lifetime do not set a lifetime value.")
    @JsonProperty(value="lifetime")
    public Long getLifetime() {
        return this.lifetime;
    }

    public void setLifetime(Long lifetime) {
        this.lifetime = lifetime;
    }

    public Service components(List<Component> components) {
        this.components = components;
        return this;
    }

    @ApiModelProperty(example="null", value="Components of an service.")
    @JsonProperty(value="components")
    public List<Component> getComponents() {
        return this.components;
    }

    public void setComponents(List<Component> components) {
        this.components = components;
    }

    public void addComponent(Component component) {
        this.components.add(component);
    }

    public Component getComponent(String name) {
        for (Component component : this.components) {
            if (!component.getName().equals(name)) continue;
            return component;
        }
        return null;
    }

    public Service configuration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    @ApiModelProperty(example="null", value="Config properties of an service. Configurations provided at the service/global level are available to all the components. Specific properties can be overridden at the component level.")
    @JsonProperty(value="configuration")
    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public Service state(ServiceState state) {
        this.state = state;
        return this;
    }

    @ApiModelProperty(example="null", value="State of the service. Specifying a value for this attribute for the POST payload raises a validation error. This attribute is available only in the GET response of a started service.")
    @JsonProperty(value="state")
    public ServiceState getState() {
        return this.state;
    }

    public void setState(ServiceState state) {
        this.state = state;
    }

    public Service quicklinks(Map<String, String> quicklinks) {
        this.quicklinks = quicklinks;
        return this;
    }

    @ApiModelProperty(example="null", value="A blob of key-value pairs of quicklinks to be exported for an service.")
    @JsonProperty(value="quicklinks")
    public Map<String, String> getQuicklinks() {
        return this.quicklinks;
    }

    public void setQuicklinks(Map<String, String> quicklinks) {
        this.quicklinks = quicklinks;
    }

    public Service queue(String queue) {
        this.queue = queue;
        return this;
    }

    @ApiModelProperty(example="null", value="The YARN queue that this service should be submitted to.")
    @JsonProperty(value="queue")
    public String getQueue() {
        return this.queue;
    }

    public void setQueue(String queue) {
        this.queue = queue;
    }

    @ApiModelProperty(example="null", value="A list of dependent services.")
    @XmlElement(name="dependencies")
    @JsonProperty(value="dependencies")
    public List<String> getDependencies() {
        return this.dependencies;
    }

    public void setDependencies(List<String> dependencies) {
        this.dependencies = dependencies;
    }

    public Service kerberosPrincipal(KerberosPrincipal kerberosPrincipal) {
        this.kerberosPrincipal = kerberosPrincipal;
        return this;
    }

    @ApiModelProperty(value="The Kerberos Principal of the service")
    public KerberosPrincipal getKerberosPrincipal() {
        return this.kerberosPrincipal;
    }

    public void setKerberosPrincipal(KerberosPrincipal kerberosPrincipal) {
        this.kerberosPrincipal = kerberosPrincipal;
    }

    @JsonProperty(value="docker_client_config")
    @XmlElement(name="docker_client_config")
    public Service dockerClientConfig(String dockerClientConfig) {
        this.dockerClientConfig = dockerClientConfig;
        return this;
    }

    @ApiModelProperty(value="The Docker client config for the service")
    public String getDockerClientConfig() {
        return this.dockerClientConfig;
    }

    public void setDockerClientConfig(String dockerClientConfig) {
        this.dockerClientConfig = dockerClientConfig;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Service service = (Service)o;
        return Objects.equals(this.name, service.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Service {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    artifact: ").append(this.toIndentedString(this.artifact)).append("\n");
        sb.append("    resource: ").append(this.toIndentedString(this.resource)).append("\n");
        sb.append("    launchTime: ").append(this.toIndentedString(this.launchTime)).append("\n");
        sb.append("    numberOfRunningContainers: ").append(this.toIndentedString(this.numberOfRunningContainers)).append("\n");
        sb.append("    lifetime: ").append(this.toIndentedString(this.lifetime)).append("\n");
        sb.append("    components: ").append(this.toIndentedString(this.components)).append("\n");
        sb.append("    configuration: ").append(this.toIndentedString(this.configuration)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    quicklinks: ").append(this.toIndentedString(this.quicklinks)).append("\n");
        sb.append("    queue: ").append(this.toIndentedString(this.queue)).append("\n");
        sb.append("    kerberosPrincipal: ").append(this.toIndentedString(this.kerberosPrincipal)).append("\n");
        sb.append("    dockerClientConfig: ").append(this.toIndentedString(this.dockerClientConfig)).append("\n");
        sb.append("    dependencies: ").append(this.toIndentedString(this.dependencies)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

