/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service.api.records;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.service.api.records.BaseResource;
import org.apache.hadoop.yarn.service.api.records.ServiceState;

@InterfaceAudience.Public
@InterfaceStability.Unstable
@ApiModel(description="The current status of a submitted service, returned as a response to the GET API.")
@XmlRootElement
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ServiceStatus
extends BaseResource {
    private static final long serialVersionUID = -3469885905347851034L;
    private String diagnostics = null;
    private ServiceState state = null;
    private Integer code = null;

    public ServiceStatus diagnostics(String diagnostics) {
        this.diagnostics = diagnostics;
        return this;
    }

    @ApiModelProperty(example="null", value="Diagnostic information (if any) for the reason of the current state of the service. It typically has a non-null value, if the service is in a non-running state.")
    @JsonProperty(value="diagnostics")
    public String getDiagnostics() {
        return this.diagnostics;
    }

    public void setDiagnostics(String diagnostics) {
        this.diagnostics = diagnostics;
    }

    public ServiceStatus state(ServiceState state) {
        this.state = state;
        return this;
    }

    @ApiModelProperty(example="null", value="Service state.")
    @JsonProperty(value="state")
    public ServiceState getState() {
        return this.state;
    }

    public void setState(ServiceState state) {
        this.state = state;
    }

    public ServiceStatus code(Integer code) {
        this.code = code;
        return this;
    }

    @ApiModelProperty(example="null", value="An error code specific to a scenario which service owners should be able to use to understand the failure in addition to the diagnostic information.")
    @JsonProperty(value="code")
    public Integer getCode() {
        return this.code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceStatus serviceStatus = (ServiceStatus)o;
        return Objects.equals(this.diagnostics, serviceStatus.diagnostics) && Objects.equals((Object)this.state, (Object)serviceStatus.state) && Objects.equals(this.code, serviceStatus.code);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.diagnostics, this.state, this.code});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ServiceStatus {\n");
        sb.append("    diagnostics: ").append(this.toIndentedString(this.diagnostics)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    code: ").append(this.toIndentedString(this.code)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

