/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.server.federation.FederationTestUtils;
import org.apache.hadoop.hdfs.server.federation.MiniRouterDFSCluster;
import org.apache.hadoop.hdfs.server.federation.RouterConfigBuilder;
import org.apache.hadoop.hdfs.server.federation.StateStoreDFSCluster;
import org.apache.hadoop.hdfs.server.federation.metrics.FederationRPCMetrics;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.ipc.StandbyException;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestRouterClientRejectOverload {
    private static final Logger LOG = LoggerFactory.getLogger(TestRouterClientRejectOverload.class);
    private StateStoreDFSCluster cluster;

    @After
    public void cleanup() {
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    private void setupCluster(boolean overloadControl) throws Exception {
        this.cluster = new StateStoreDFSCluster(false, 2);
        Configuration routerConf = new RouterConfigBuilder().stateStore().metrics().admin().rpc().build();
        routerConf.setInt("dfs.federation.router.client.thread-size", 4);
        routerConf.setBoolean("dfs.federation.router.client.reject.overload", overloadControl);
        this.cluster.setNumDatanodesPerNameservice(0);
        this.cluster.addRouterOverrides(routerConf);
        this.cluster.startCluster();
        this.cluster.startRouters();
        this.cluster.waitClusterUp();
    }

    @Test
    public void testWithoutOverloadControl() throws Exception {
        this.setupCluster(false);
        this.testOverloaded(0);
        MiniDFSCluster dfsCluster = this.cluster.getCluster();
        NameNode nn0 = dfsCluster.getNameNode(0);
        FederationTestUtils.simulateSlowNamenode(nn0, 1);
        this.testOverloaded(0);
        for (MiniRouterDFSCluster.RouterContext router : this.cluster.getRouters()) {
            FederationRPCMetrics rpcMetrics = router.getRouter().getRpcServer().getRPCMetrics();
            Assert.assertEquals((long)0L, (long)rpcMetrics.getProxyOpFailureClientOverloaded());
        }
    }

    @Test
    public void testOverloadControl() throws Exception {
        this.setupCluster(true);
        List<MiniRouterDFSCluster.RouterContext> routers = this.cluster.getRouters();
        FederationRPCMetrics rpcMetrics0 = routers.get(0).getRouter().getRpcServer().getRPCMetrics();
        FederationRPCMetrics rpcMetrics1 = routers.get(1).getRouter().getRpcServer().getRPCMetrics();
        this.testOverloaded(0);
        Assert.assertEquals((long)0L, (long)rpcMetrics0.getProxyOpFailureClientOverloaded());
        Assert.assertEquals((long)0L, (long)rpcMetrics1.getProxyOpFailureClientOverloaded());
        MiniDFSCluster dfsCluster = this.cluster.getCluster();
        NameNode nn0 = dfsCluster.getNameNode(0);
        FederationTestUtils.simulateSlowNamenode(nn0, 1);
        this.testOverloaded(4, 6);
        Assert.assertTrue((rpcMetrics0.getProxyOpFailureClientOverloaded() + rpcMetrics1.getProxyOpFailureClientOverloaded() >= 4L ? 1 : 0) != 0);
        Configuration clientConf = this.cluster.getRouterClientConf();
        long iniProxyOps0 = rpcMetrics0.getProxyOps();
        long iniProxyOps1 = rpcMetrics1.getProxyOps();
        this.testOverloaded(0, 0, new URI("hdfs://fed/"), clientConf, 10);
        long proxyOps0 = rpcMetrics0.getProxyOps() - iniProxyOps0;
        long proxyOps1 = rpcMetrics1.getProxyOps() - iniProxyOps1;
        Assert.assertEquals((long)20L, (long)(proxyOps0 + proxyOps1));
        Assert.assertTrue((String)(proxyOps0 + " operations: not distributed"), (proxyOps0 >= 8L ? 1 : 0) != 0);
        Assert.assertTrue((String)(proxyOps1 + " operations: not distributed"), (proxyOps1 >= 8L ? 1 : 0) != 0);
    }

    private void testOverloaded(int expOverload) throws Exception {
        this.testOverloaded(expOverload, expOverload);
    }

    private void testOverloaded(int expOverloadMin, int expOverloadMax) throws Exception {
        MiniRouterDFSCluster.RouterContext routerContext = this.cluster.getRandomRouter();
        URI address = routerContext.getFileSystemURI();
        HdfsConfiguration conf = new HdfsConfiguration();
        this.testOverloaded(expOverloadMin, expOverloadMax, address, (Configuration)conf, 10);
    }

    private void testOverloaded(int expOverloadMin, int expOverloadMax, final URI address, final Configuration conf, int numOps) throws Exception {
        final AtomicInteger overloadException = new AtomicInteger();
        ExecutorService exec = Executors.newFixedThreadPool(numOps);
        ArrayList futures = new ArrayList();
        for (int i = 0; i < numOps; ++i) {
            final int sleepTime = i * 50;
            Future<?> future = exec.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    DFSClient routerClient = null;
                    try {
                        Thread.sleep(sleepTime);
                        routerClient = new DFSClient(address, conf);
                        String clientName = routerClient.getClientName();
                        ClientProtocol routerProto = routerClient.getNamenode();
                        routerProto.renewLease(clientName);
                    }
                    catch (RemoteException re) {
                        IOException ioe = re.unwrapRemoteException();
                        Assert.assertTrue((String)("Wrong exception: " + ioe), (boolean)(ioe instanceof StandbyException));
                        GenericTestUtils.assertExceptionContains((String)"is overloaded", (Throwable)ioe);
                        overloadException.incrementAndGet();
                    }
                    catch (IOException e) {
                        Assert.fail((String)("Unexpected exception: " + e));
                    }
                    catch (InterruptedException e) {
                        Assert.fail((String)("Cannot sleep: " + e));
                    }
                    finally {
                        if (routerClient != null) {
                            try {
                                routerClient.close();
                            }
                            catch (IOException e) {
                                LOG.error("Cannot close the client");
                            }
                        }
                    }
                }
            });
            futures.add(future);
        }
        while (!futures.isEmpty()) {
            ((Future)futures.remove(0)).get();
        }
        exec.shutdown();
        int num = overloadException.get();
        if (expOverloadMin == expOverloadMax) {
            Assert.assertEquals((long)expOverloadMin, (long)num);
        } else {
            Assert.assertTrue((String)("Expected >=" + expOverloadMin + " but was " + num), (num >= expOverloadMin ? 1 : 0) != 0);
            Assert.assertTrue((String)("Expected <=" + expOverloadMax + " but was " + num), (num <= expOverloadMax ? 1 : 0) != 0);
        }
    }
}

