/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.protocol.DirectoryListing;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.server.federation.MiniRouterDFSCluster;
import org.apache.hadoop.hdfs.server.federation.RouterConfigBuilder;
import org.apache.hadoop.hdfs.server.federation.StateStoreDFSCluster;
import org.apache.hadoop.hdfs.server.federation.resolver.MountTableManager;
import org.apache.hadoop.hdfs.server.federation.resolver.MountTableResolver;
import org.apache.hadoop.hdfs.server.federation.router.Router;
import org.apache.hadoop.hdfs.server.federation.router.RouterClient;
import org.apache.hadoop.hdfs.server.federation.store.protocol.AddMountTableEntryRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.AddMountTableEntryResponse;
import org.apache.hadoop.hdfs.server.federation.store.records.MountTable;
import org.apache.hadoop.util.Time;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestRouterMountTable {
    private static StateStoreDFSCluster cluster;
    private static MiniRouterDFSCluster.NamenodeContext nnContext;
    private static MiniRouterDFSCluster.RouterContext routerContext;
    private static MountTableResolver mountTable;
    private static ClientProtocol routerProtocol;

    @BeforeClass
    public static void globalSetUp() throws Exception {
        cluster = new StateStoreDFSCluster(false, 1);
        Configuration conf = new RouterConfigBuilder().stateStore().admin().rpc().build();
        cluster.addRouterOverrides(conf);
        cluster.startCluster();
        cluster.startRouters();
        cluster.waitClusterUp();
        nnContext = cluster.getRandomNamenode();
        routerContext = cluster.getRandomRouter();
        Router router = routerContext.getRouter();
        routerProtocol = routerContext.getClient().getNamenode();
        mountTable = (MountTableResolver)router.getSubclusterResolver();
    }

    @AfterClass
    public static void tearDown() {
        if (cluster != null) {
            cluster.stopRouter(routerContext);
            cluster.shutdown();
            cluster = null;
        }
    }

    @Test
    public void testReadOnly() throws Exception {
        MountTable readOnlyEntry = MountTable.newInstance((String)"/readonly", Collections.singletonMap("ns0", "/testdir"));
        readOnlyEntry.setReadOnly(true);
        Assert.assertTrue((boolean)this.addMountTable(readOnlyEntry));
        MountTable regularEntry = MountTable.newInstance((String)"/regular", Collections.singletonMap("ns0", "/testdir"));
        Assert.assertTrue((boolean)this.addMountTable(regularEntry));
        FileSystem nnFs = nnContext.getFileSystem();
        FileSystem routerFs = routerContext.getFileSystem();
        Assert.assertTrue((boolean)routerFs.mkdirs(new Path("/regular/newdir")));
        FileStatus dirStatusNn = nnFs.getFileStatus(new Path("/testdir/newdir"));
        Assert.assertTrue((boolean)dirStatusNn.isDirectory());
        FileStatus dirStatusRegular = routerFs.getFileStatus(new Path("/regular/newdir"));
        Assert.assertTrue((boolean)dirStatusRegular.isDirectory());
        FileStatus dirStatusReadOnly = routerFs.getFileStatus(new Path("/readonly/newdir"));
        Assert.assertTrue((boolean)dirStatusReadOnly.isDirectory());
        try {
            routerFs.mkdirs(new Path("/readonly/newdirfail"));
            Assert.fail((String)"We should not be able to write into a read only mount point");
        }
        catch (IOException ioe) {
            String msg = ioe.getMessage();
            Assert.assertTrue((boolean)msg.startsWith("/readonly/newdirfail is in a read only mount point"));
        }
    }

    private boolean addMountTable(MountTable entry) throws IOException {
        RouterClient client = routerContext.getAdminClient();
        MountTableManager mountTableManager = client.getMountTableManager();
        AddMountTableEntryRequest addRequest = AddMountTableEntryRequest.newInstance((MountTable)entry);
        AddMountTableEntryResponse addResponse = mountTableManager.addMountTableEntry(addRequest);
        mountTable.loadCache(true);
        return addResponse.getStatus();
    }

    @Test
    public void testListFilesTime() throws Exception {
        FileStatus[] iterator;
        Long beforeCreatingTime = Time.now();
        MountTable addEntry = MountTable.newInstance((String)"/testdir", Collections.singletonMap("ns0", "/testdir"));
        Assert.assertTrue((boolean)this.addMountTable(addEntry));
        addEntry = MountTable.newInstance((String)"/testdir2", Collections.singletonMap("ns0", "/testdir2"));
        Assert.assertTrue((boolean)this.addMountTable(addEntry));
        addEntry = MountTable.newInstance((String)"/testdir/subdir", Collections.singletonMap("ns0", "/testdir/subdir"));
        Assert.assertTrue((boolean)this.addMountTable(addEntry));
        addEntry = MountTable.newInstance((String)"/testdir3/subdir1", Collections.singletonMap("ns0", "/testdir3"));
        Assert.assertTrue((boolean)this.addMountTable(addEntry));
        addEntry = MountTable.newInstance((String)"/testA/testB/testC/testD", Collections.singletonMap("ns0", "/test"));
        Assert.assertTrue((boolean)this.addMountTable(addEntry));
        FileSystem nnFs = nnContext.getFileSystem();
        Assert.assertTrue((boolean)nnFs.mkdirs(new Path("/newdir")));
        TreeMap<Object, Long> pathModTime = new TreeMap<Object, Long>();
        for (FileStatus[] mount : mountTable.getMountPoints("/")) {
            if (mountTable.getMountPoint("/" + (String)mount) != null) {
                pathModTime.put(mount, mountTable.getMountPoint("/" + (String)mount).getDateModified());
                continue;
            }
            List entries = mountTable.getMounts("/" + (String)mount);
            for (MountTable entry : entries) {
                if (pathModTime.get(mount) != null && (Long)pathModTime.get(mount) >= entry.getDateModified()) continue;
                pathModTime.put(mount, entry.getDateModified());
            }
        }
        for (FileStatus file : iterator = nnFs.listStatus(new Path("/"))) {
            pathModTime.put(file.getPath().getName(), file.getModificationTime());
        }
        DirectoryListing listing = routerProtocol.getListing("/", HdfsFileStatus.EMPTY_NAME, false);
        Iterator pathModTimeIterator = pathModTime.keySet().iterator();
        for (HdfsFileStatus f : listing.getPartialListing()) {
            String fileName = (String)pathModTimeIterator.next();
            String currentFile = f.getFullPath(new Path("/")).getName();
            Long currentTime = f.getModificationTime();
            Long expectedTime = (Long)pathModTime.get(currentFile);
            Assert.assertEquals((Object)currentFile, (Object)fileName);
            Assert.assertTrue((currentTime > beforeCreatingTime ? 1 : 0) != 0);
            Assert.assertEquals((Object)currentTime, (Object)expectedTime);
        }
        Assert.assertEquals((long)pathModTime.size(), (long)listing.getPartialListing().length);
    }
}

