/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.server.federation.FederationTestUtils;
import org.apache.hadoop.hdfs.server.federation.MiniRouterDFSCluster;
import org.apache.hadoop.hdfs.server.federation.RouterConfigBuilder;
import org.apache.hadoop.hdfs.server.federation.StateStoreDFSCluster;
import org.apache.hadoop.hdfs.server.federation.metrics.FederationRPCMetrics;
import org.apache.hadoop.hdfs.server.federation.metrics.NamenodeBeanMetrics;
import org.apache.hadoop.hdfs.server.federation.resolver.FederationNamenodeContext;
import org.apache.hadoop.hdfs.server.federation.resolver.MembershipNamenodeResolver;
import org.apache.hadoop.hdfs.server.federation.resolver.NamenodeStatusReport;
import org.apache.hadoop.hdfs.server.federation.router.Router;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.test.GenericTestUtils;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;

public class TestRouterRPCClientRetries {
    private static StateStoreDFSCluster cluster;
    private static MiniRouterDFSCluster.NamenodeContext nnContext1;
    private static MiniRouterDFSCluster.RouterContext routerContext;
    private static MembershipNamenodeResolver resolver;
    private static ClientProtocol routerProtocol;
    @Rule
    public final Timeout testTimeout = new Timeout(100000);

    @Before
    public void setUp() throws Exception {
        cluster = new StateStoreDFSCluster(false, 2);
        Configuration routerConf = new RouterConfigBuilder().stateStore().metrics().admin().rpc().build();
        routerConf.setTimeDuration("dfs.federation.router.dn-report.cache-expire", 1L, TimeUnit.SECONDS);
        Configuration clientConf = new Configuration(false);
        clientConf.setInt("ipc.client.connect.max.retries", 1);
        clientConf.setInt("ipc.client.connect.retry.interval", 100);
        cluster.setIndependentDNs();
        cluster.addRouterOverrides(routerConf);
        cluster.startCluster(clientConf);
        cluster.startRouters();
        cluster.waitClusterUp();
        nnContext1 = cluster.getNamenode(cluster.getNameservices().get(0), null);
        routerContext = cluster.getRandomRouter();
        resolver = (MembershipNamenodeResolver)routerContext.getRouter().getNamenodeResolver();
        routerProtocol = routerContext.getClient().getNamenode();
    }

    @After
    public void tearDown() {
        if (cluster != null) {
            cluster.stopRouter(routerContext);
            cluster.shutdown();
            cluster = null;
        }
    }

    @Test
    public void testRetryWhenAllNameServiceDown() throws Exception {
        MiniDFSCluster dfsCluster = cluster.getCluster();
        dfsCluster.shutdown();
        this.registerInvalidNameReport();
        String dirPath = "/testRetryWhenClusterisDown";
        FsPermission permission = new FsPermission("705");
        try {
            routerProtocol.mkdirs(dirPath, permission, false);
            Assert.fail((String)"Should have thrown RemoteException error.");
        }
        catch (RemoteException e) {
            String ns0 = cluster.getNameservices().get(0);
            GenericTestUtils.assertExceptionContains((String)("No namenode available under nameservice " + ns0), (Throwable)e);
        }
        FederationRPCMetrics rpcMetrics = routerContext.getRouter().getRpcServer().getRPCMetrics();
        Assert.assertEquals((long)1L, (long)rpcMetrics.getProxyOpRetries());
    }

    @Test
    public void testRetryWhenOneNameServiceDown() throws Exception {
        MiniDFSCluster dfsCluster = cluster.getCluster();
        dfsCluster.shutdownNameNode(0);
        this.registerInvalidNameReport();
        DFSClient client = nnContext1.getClient();
        routerProtocol.renewLease(client.getClientName());
        FederationRPCMetrics rpcMetrics = routerContext.getRouter().getRpcServer().getRPCMetrics();
        Assert.assertEquals((long)0L, (long)rpcMetrics.getProxyOpRetries());
    }

    private void registerInvalidNameReport() throws IOException {
        String ns0 = cluster.getNameservices().get(0);
        List origin = resolver.getNamenodesForNameserviceId(ns0);
        FederationNamenodeContext nnInfo = (FederationNamenodeContext)origin.get(0);
        NamenodeStatusReport report = new NamenodeStatusReport(ns0, nnInfo.getNamenodeId(), nnInfo.getRpcAddress(), nnInfo.getServiceAddress(), nnInfo.getLifelineAddress(), nnInfo.getWebAddress());
        report.setRegistrationValid(false);
        Assert.assertTrue((boolean)resolver.registerNamenode(report));
        resolver.loadCache(true);
    }

    @Test
    public void testNamenodeMetricsSlow() throws Exception {
        Router router = routerContext.getRouter();
        NamenodeBeanMetrics metrics = router.getNamenodeMetrics();
        String jsonString0 = metrics.getLiveNodes();
        Assert.assertEquals((long)4L, (long)TestRouterRPCClientRetries.getNumDatanodes(jsonString0));
        Assert.assertEquals((Object)jsonString0, (Object)metrics.getLiveNodes());
        TestRouterRPCClientRetries.waitUpdateLiveNodes(jsonString0, metrics);
        String jsonString2 = metrics.getLiveNodes();
        Assert.assertNotEquals((Object)jsonString0, (Object)jsonString2);
        Assert.assertEquals((long)4L, (long)TestRouterRPCClientRetries.getNumDatanodes(jsonString2));
        MiniDFSCluster dfsCluster = cluster.getCluster();
        NameNode nn0 = dfsCluster.getNameNode(0);
        FederationTestUtils.simulateSlowNamenode(nn0, 3);
        TestRouterRPCClientRetries.waitUpdateLiveNodes(jsonString2, metrics);
        String jsonString3 = metrics.getLiveNodes();
        Assert.assertEquals((long)2L, (long)TestRouterRPCClientRetries.getNumDatanodes(jsonString3));
        NameNode nn1 = dfsCluster.getNameNode(1);
        FederationTestUtils.simulateSlowNamenode(nn1, 3);
        TestRouterRPCClientRetries.waitUpdateLiveNodes(jsonString3, metrics);
        String jsonString4 = metrics.getLiveNodes();
        Assert.assertEquals((long)0L, (long)TestRouterRPCClientRetries.getNumDatanodes(jsonString4));
    }

    private static int getNumDatanodes(String jsonString) throws JSONException {
        JSONObject jsonObject = new JSONObject(jsonString);
        if (jsonObject.length() == 0) {
            return 0;
        }
        return jsonObject.names().length();
    }

    private static void waitUpdateLiveNodes(final String oldValue, final NamenodeBeanMetrics metrics) throws Exception {
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                return !oldValue.equals(metrics.getLiveNodes());
            }
        }, (long)500L, (long)5000L);
    }
}

