/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.store;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.server.federation.resolver.FederationNamenodeServiceState;
import org.apache.hadoop.hdfs.server.federation.store.StateStoreService;
import org.apache.hadoop.hdfs.server.federation.store.driver.StateStoreDriver;
import org.apache.hadoop.hdfs.server.federation.store.driver.impl.StateStoreFileBaseImpl;
import org.apache.hadoop.hdfs.server.federation.store.driver.impl.StateStoreFileImpl;
import org.apache.hadoop.hdfs.server.federation.store.records.BaseRecord;
import org.apache.hadoop.hdfs.server.federation.store.records.MembershipState;
import org.apache.hadoop.hdfs.server.federation.store.records.MembershipStats;
import org.apache.hadoop.hdfs.server.federation.store.records.MountTable;
import org.apache.hadoop.util.Time;
import org.junit.Assert;

public final class FederationStateStoreTestUtils {
    private static final Class<? extends StateStoreDriver> FEDERATION_STORE_DRIVER_CLASS_FOR_TEST = StateStoreFileImpl.class;

    private FederationStateStoreTestUtils() {
    }

    public static Class<? extends StateStoreDriver> getTestDriverClass() {
        return FEDERATION_STORE_DRIVER_CLASS_FOR_TEST;
    }

    public static Configuration getStateStoreConfiguration() {
        Class<? extends StateStoreDriver> clazz = FederationStateStoreTestUtils.getTestDriverClass();
        return FederationStateStoreTestUtils.getStateStoreConfiguration(clazz);
    }

    public static Configuration getStateStoreConfiguration(Class<? extends StateStoreDriver> clazz) {
        HdfsConfiguration conf = new HdfsConfiguration(false);
        conf.setBoolean("dfs.permissions.enabled", true);
        conf.set("fs.defaultFS", "hdfs://test");
        conf.setClass("dfs.federation.router.store.driver.class", clazz, StateStoreDriver.class);
        if (clazz.isAssignableFrom(StateStoreFileBaseImpl.class)) {
            FederationStateStoreTestUtils.setFileConfiguration((Configuration)conf);
        }
        return conf;
    }

    public static StateStoreService newStateStore(Configuration configuration) throws IOException, InterruptedException {
        StateStoreService stateStore = new StateStoreService();
        Assert.assertNotNull((Object)stateStore);
        String identifier = UUID.randomUUID().toString();
        stateStore.setIdentifier(identifier);
        stateStore.init(configuration);
        stateStore.start();
        FederationStateStoreTestUtils.waitStateStore(stateStore, TimeUnit.SECONDS.toMillis(10L));
        return stateStore;
    }

    public static void waitStateStore(StateStoreService stateStore, long timeoutMs) throws IOException, InterruptedException {
        long startingTime = Time.monotonicNow();
        while (!stateStore.isDriverReady()) {
            Thread.sleep(100L);
            if (Time.monotonicNow() - startingTime <= timeoutMs) continue;
            throw new IOException("Timeout waiting for State Store to connect");
        }
    }

    public static void deleteStateStore() throws IOException {
        Class<? extends StateStoreDriver> driverClass = FederationStateStoreTestUtils.getTestDriverClass();
        FederationStateStoreTestUtils.deleteStateStore(driverClass);
    }

    public static void deleteStateStore(Class<? extends StateStoreDriver> driverClass) throws IOException {
        String workingDirectory;
        File dir;
        if (StateStoreFileBaseImpl.class.isAssignableFrom(driverClass) && (dir = new File((workingDirectory = System.getProperty("user.dir")) + "/statestore")).exists()) {
            FileUtils.cleanDirectory((File)dir);
        }
    }

    public static void setFileConfiguration(Configuration conf) {
        String workingPath = System.getProperty("user.dir");
        String stateStorePath = workingPath + "/statestore";
        conf.set("dfs.federation.router.store.driver.file.directory", stateStorePath);
    }

    public static boolean clearAllRecords(StateStoreService store) throws IOException {
        Collection allRecords = store.getSupportedRecords();
        for (Class recordType : allRecords) {
            if (FederationStateStoreTestUtils.clearRecords(store, recordType)) continue;
            return false;
        }
        return true;
    }

    public static <T extends BaseRecord> boolean clearRecords(StateStoreService store, Class<T> recordClass) throws IOException {
        ArrayList emptyList = new ArrayList();
        if (!FederationStateStoreTestUtils.synchronizeRecords(store, emptyList, recordClass)) {
            return false;
        }
        store.refreshCaches(true);
        return true;
    }

    public static <T extends BaseRecord> boolean synchronizeRecords(StateStoreService stateStore, List<T> records, Class<T> clazz) throws IOException {
        StateStoreDriver driver = stateStore.getDriver();
        driver.verifyDriverReady();
        return driver.removeAll(clazz) && driver.putAll(records, true, false);
    }

    public static List<MountTable> createMockMountTable(List<String> nameservices) throws IOException {
        ArrayList<MountTable> entries = new ArrayList<MountTable>();
        for (String ns : nameservices) {
            HashMap<String, String> destMap = new HashMap<String, String>();
            destMap.put(ns, "/target-" + ns);
            MountTable entry = MountTable.newInstance((String)("/" + ns), destMap);
            entries.add(entry);
        }
        return entries;
    }

    public static MembershipState createMockRegistrationForNamenode(String nameserviceId, String namenodeId, FederationNamenodeServiceState state) throws IOException {
        MembershipState entry = MembershipState.newInstance((String)"routerId", (String)nameserviceId, (String)namenodeId, (String)"clusterId", (String)"test", (String)"0.0.0.0:0", (String)"0.0.0.0:0", (String)"0.0.0.0:0", (String)"0.0.0.0:0", (FederationNamenodeServiceState)state, (boolean)false);
        MembershipStats stats = MembershipStats.newInstance();
        stats.setNumOfActiveDatanodes(100);
        stats.setNumOfDeadDatanodes(10);
        stats.setNumOfDecommissioningDatanodes(20);
        stats.setNumOfDecomActiveDatanodes(15);
        stats.setNumOfDecomDeadDatanodes(5);
        stats.setNumOfBlocks(10L);
        entry.setStats(stats);
        return entry;
    }
}

