<?php
namespace Hbase;
/**
 * Autogenerated by Thrift Compiler (0.9.0)
 *
 * DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
 *  @generated
 */
use Thrift\Base\TBase;
use Thrift\Type\TType;
use Thrift\Type\TMessageType;
use Thrift\Exception\TException;
use Thrift\Exception\TProtocolException;
use Thrift\Protocol\TProtocol;
use Thrift\Exception\TApplicationException;


interface HbaseIf {
  public function enableTable($tableName);
  public function disableTable($tableName);
  public function isTableEnabled($tableName);
  public function compact($tableNameOrRegionName);
  public function majorCompact($tableNameOrRegionName);
  public function getTableNames();
  public function getColumnDescriptors($tableName);
  public function getTableRegions($tableName);
  public function createTable($tableName, $columnFamilies);
  public function deleteTable($tableName);
  public function get($tableName, $row, $column, $attributes);
  public function getVer($tableName, $row, $column, $numVersions, $attributes);
  public function getVerTs($tableName, $row, $column, $timestamp, $numVersions, $attributes);
  public function getRow($tableName, $row, $attributes);
  public function getRowWithColumns($tableName, $row, $columns, $attributes);
  public function getRowTs($tableName, $row, $timestamp, $attributes);
  public function getRowWithColumnsTs($tableName, $row, $columns, $timestamp, $attributes);
  public function getRows($tableName, $rows, $attributes);
  public function getRowsWithColumns($tableName, $rows, $columns, $attributes);
  public function getRowsTs($tableName, $rows, $timestamp, $attributes);
  public function getRowsWithColumnsTs($tableName, $rows, $columns, $timestamp, $attributes);
  public function mutateRow($tableName, $row, $mutations, $attributes);
  public function mutateRowTs($tableName, $row, $mutations, $timestamp, $attributes);
  public function mutateRows($tableName, $rowBatches, $attributes);
  public function mutateRowsTs($tableName, $rowBatches, $timestamp, $attributes);
  public function atomicIncrement($tableName, $row, $column, $value);
  public function deleteAll($tableName, $row, $column, $attributes);
  public function deleteAllTs($tableName, $row, $column, $timestamp, $attributes);
  public function deleteAllRow($tableName, $row, $attributes);
  public function increment(\Hbase\TIncrement $increment);
  public function incrementRows($increments);
  public function deleteAllRowTs($tableName, $row, $timestamp, $attributes);
  public function scannerOpenWithScan($tableName, \Hbase\TScan $scan, $attributes);
  public function scannerOpen($tableName, $startRow, $columns, $attributes);
  public function scannerOpenWithStop($tableName, $startRow, $stopRow, $columns, $attributes);
  public function scannerOpenWithPrefix($tableName, $startAndPrefix, $columns, $attributes);
  public function scannerOpenTs($tableName, $startRow, $columns, $timestamp, $attributes);
  public function scannerOpenWithStopTs($tableName, $startRow, $stopRow, $columns, $timestamp, $attributes);
  public function scannerGet($id);
  public function scannerGetList($id, $nbRows);
  public function scannerClose($id);
  public function getRowOrBefore($tableName, $row, $family);
  public function getRegionInfo($row);
}

class HbaseClient implements \Hbase\HbaseIf {
  protected $input_ = null;
  protected $output_ = null;

  protected $seqid_ = 0;

  public function __construct($input, $output=null) {
    $this->input_ = $input;
    $this->output_ = $output ? $output : $input;
  }

  public function enableTable($tableName)
  {
    $this->send_enableTable($tableName);
    $this->recv_enableTable();
  }

  public function send_enableTable($tableName)
  {
    $args = new \Hbase\Hbase_enableTable_args();
    $args->tableName = $tableName;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'enableTable', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('enableTable', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_enableTable()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hbase\Hbase_enableTable_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hbase\Hbase_enableTable_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->io !== null) {
      throw $result->io;
    }
    return;
  }

  public function disableTable($tableName)
  {
    $this->send_disableTable($tableName);
    $this->recv_disableTable();
  }

  public function send_disableTable($tableName)
  {
    $args = new \Hbase\Hbase_disableTable_args();
    $args->tableName = $tableName;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'disableTable', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('disableTable', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_disableTable()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hbase\Hbase_disableTable_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hbase\Hbase_disableTable_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->io !== null) {
      throw $result->io;
    }
    return;
  }

  public function isTableEnabled($tableName)
  {
    $this->send_isTableEnabled($tableName);
    return $this->recv_isTableEnabled();
  }

  public function send_isTableEnabled($tableName)
  {
    $args = new \Hbase\Hbase_isTableEnabled_args();
    $args->tableName = $tableName;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'isTableEnabled', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('isTableEnabled', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_isTableEnabled()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hbase\Hbase_isTableEnabled_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hbase\Hbase_isTableEnabled_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->io !== null) {
      throw $result->io;
    }
    throw new \Exception("isTableEnabled failed: unknown result");
  }

  public function compact($tableNameOrRegionName)
  {
    $this->send_compact($tableNameOrRegionName);
    $this->recv_compact();
  }

  public function send_compact($tableNameOrRegionName)
  {
    $args = new \Hbase\Hbase_compact_args();
    $args->tableNameOrRegionName = $tableNameOrRegionName;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'compact', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('compact', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_compact()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hbase\Hbase_compact_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hbase\Hbase_compact_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->io !== null) {
      throw $result->io;
    }
    return;
  }

  public function majorCompact($tableNameOrRegionName)
  {
    $this->send_majorCompact($tableNameOrRegionName);
    $this->recv_majorCompact();
  }

  public function send_majorCompact($tableNameOrRegionName)
  {
    $args = new \Hbase\Hbase_majorCompact_args();
    $args->tableNameOrRegionName = $tableNameOrRegionName;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'majorCompact', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('majorCompact', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_majorCompact()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hbase\Hbase_majorCompact_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hbase\Hbase_majorCompact_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->io !== null) {
      throw $result->io;
    }
    return;
  }

  public function getTableNames()
  {
    $this->send_getTableNames();
    return $this->recv_getTableNames();
  }

  public function send_getTableNames()
  {
    $args = new \Hbase\Hbase_getTableNames_args();
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getTableNames', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getTableNames', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getTableNames()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hbase\Hbase_getTableNames_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hbase\Hbase_getTableNames_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->io !== null) {
      throw $result->io;
    }
    throw new \Exception("getTableNames failed: unknown result");
  }

  public function getColumnDescriptors($tableName)
  {
    $this->send_getColumnDescriptors($tableName);
    return $this->recv_getColumnDescriptors();
  }

  public function send_getColumnDescriptors($tableName)
  {
    $args = new \Hbase\Hbase_getColumnDescriptors_args();
    $args->tableName = $tableName;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getColumnDescriptors', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getColumnDescriptors', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getColumnDescriptors()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hbase\Hbase_getColumnDescriptors_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hbase\Hbase_getColumnDescriptors_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->io !== null) {
      throw $result->io;
    }
    throw new \Exception("getColumnDescriptors failed: unknown result");
  }

  public function getTableRegions($tableName)
  {
    $this->send_getTableRegions($tableName);
    return $this->recv_getTableRegions();
  }

  public function send_getTableRegions($tableName)
  {
    $args = new \Hbase\Hbase_getTableRegions_args();
    $args->tableName = $tableName;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getTableRegions', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getTableRegions', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getTableRegions()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hbase\Hbase_getTableRegions_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hbase\Hbase_getTableRegions_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->io !== null) {
      throw $result->io;
    }
    throw new \Exception("getTableRegions failed: unknown result");
  }

  public function createTable($tableName, $columnFamilies)
  {
    $this->send_createTable($tableName, $columnFamilies);
    $this->recv_createTable();
  }

  public function send_createTable($tableName, $columnFamilies)
  {
    $args = new \Hbase\Hbase_createTable_args();
    $args->tableName = $tableName;
    $args->columnFamilies = $columnFamilies;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'createTable', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('createTable', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_createTable()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hbase\Hbase_createTable_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hbase\Hbase_createTable_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->io !== null) {
      throw $result->io;
    }
    if ($result->ia !== null) {
      throw $result->ia;
    }
    if ($result->exist !== null) {
      throw $result->exist;
    }
    return;
  }

  public function deleteTable($tableName)
  {
    $this->send_deleteTable($tableName);
    $this->recv_deleteTable();
  }

  public function send_deleteTable($tableName)
  {
    $args = new \Hbase\Hbase_deleteTable_args();
    $args->tableName = $tableName;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'deleteTable', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('deleteTable', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_deleteTable()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hbase\Hbase_deleteTable_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hbase\Hbase_deleteTable_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->io !== null) {
      throw $result->io;
    }
    return;
  }

  public function get($tableName, $row, $column, $attributes)
  {
    $this->send_get($tableName, $row, $column, $attributes);
    return $this->recv_get();
  }

  public function send_get($tableName, $row, $column, $attributes)
  {
    $args = new \Hbase\Hbase_get_args();
    $args->tableName = $tableName;
    $args->row = $row;
    $args->column = $column;
    $args->attributes = $attributes;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hbase\Hbase_get_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hbase\Hbase_get_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->io !== null) {
      throw $result->io;
    }
    throw new \Exception("get failed: unknown result");
  }

  public function getVer($tableName, $row, $column, $numVersions, $attributes)
  {
    $this->send_getVer($tableName, $row, $column, $numVersions, $attributes);
    return $this->recv_getVer();
  }

  public function send_getVer($tableName, $row, $column, $numVersions, $attributes)
  {
    $args = new \Hbase\Hbase_getVer_args();
    $args->tableName = $tableName;
    $args->row = $row;
    $args->column = $column;
    $args->numVersions = $numVersions;
    $args->attributes = $attributes;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getVer', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getVer', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getVer()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hbase\Hbase_getVer_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hbase\Hbase_getVer_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->io !== null) {
      throw $result->io;
    }
    throw new \Exception("getVer failed: unknown result");
  }

  public function getVerTs($tableName, $row, $column, $timestamp, $numVersions, $attributes)
  {
    $this->send_getVerTs($tableName, $row, $column, $timestamp, $numVersions, $attributes);
    return $this->recv_getVerTs();
  }

  public function send_getVerTs($tableName, $row, $column, $timestamp, $numVersions, $attributes)
  {
    $args = new \Hbase\Hbase_getVerTs_args();
    $args->tableName = $tableName;
    $args->row = $row;
    $args->column = $column;
    $args->timestamp = $timestamp;
    $args->numVersions = $numVersions;
    $args->attributes = $attributes;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getVerTs', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getVerTs', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getVerTs()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hbase\Hbase_getVerTs_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hbase\Hbase_getVerTs_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->io !== null) {
      throw $result->io;
    }
    throw new \Exception("getVerTs failed: unknown result");
  }

  public function getRow($tableName, $row, $attributes)
  {
    $this->send_getRow($tableName, $row, $attributes);
    return $this->recv_getRow();
  }

  public function send_getRow($tableName, $row, $attributes)
  {
    $args = new \Hbase\Hbase_getRow_args();
    $args->tableName = $tableName;
    $args->row = $row;
    $args->attributes = $attributes;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getRow', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getRow', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getRow()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hbase\Hbase_getRow_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hbase\Hbase_getRow_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->io !== null) {
      throw $result->io;
    }
    throw new \Exception("getRow failed: unknown result");
  }

  public function getRowWithColumns($tableName, $row, $columns, $attributes)
  {
    $this->send_getRowWithColumns($tableName, $row, $columns, $attributes);
    return $this->recv_getRowWithColumns();
  }

  public function send_getRowWithColumns($tableName, $row, $columns, $attributes)
  {
    $args = new \Hbase\Hbase_getRowWithColumns_args();
    $args->tableName = $tableName;
    $args->row = $row;
    $args->columns = $columns;
    $args->attributes = $attributes;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getRowWithColumns', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getRowWithColumns', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getRowWithColumns()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hbase\Hbase_getRowWithColumns_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hbase\Hbase_getRowWithColumns_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->io !== null) {
      throw $result->io;
    }
    throw new \Exception("getRowWithColumns failed: unknown result");
  }

  public function getRowTs($tableName, $row, $timestamp, $attributes)
  {
    $this->send_getRowTs($tableName, $row, $timestamp, $attributes);
    return $this->recv_getRowTs();
  }

  public function send_getRowTs($tableName, $row, $timestamp, $attributes)
  {
    $args = new \Hbase\Hbase_getRowTs_args();
    $args->tableName = $tableName;
    $args->row = $row;
    $args->timestamp = $timestamp;
    $args->attributes = $attributes;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getRowTs', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getRowTs', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getRowTs()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hbase\Hbase_getRowTs_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hbase\Hbase_getRowTs_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->io !== null) {
      throw $result->io;
    }
    throw new \Exception("getRowTs failed: unknown result");
  }

  public function getRowWithColumnsTs($tableName, $row, $columns, $timestamp, $attributes)
  {
    $this->send_getRowWithColumnsTs($tableName, $row, $columns, $timestamp, $attributes);
    return $this->recv_getRowWithColumnsTs();
  }

  public function send_getRowWithColumnsTs($tableName, $row, $columns, $timestamp, $attributes)
  {
    $args = new \Hbase\Hbase_getRowWithColumnsTs_args();
    $args->tableName = $tableName;
    $args->row = $row;
    $args->columns = $columns;
    $args->timestamp = $timestamp;
    $args->attributes = $attributes;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getRowWithColumnsTs', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getRowWithColumnsTs', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getRowWithColumnsTs()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hbase\Hbase_getRowWithColumnsTs_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hbase\Hbase_getRowWithColumnsTs_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->io !== null) {
      throw $result->io;
    }
    throw new \Exception("getRowWithColumnsTs failed: unknown result");
  }

  public function getRows($tableName, $rows, $attributes)
  {
    $this->send_getRows($tableName, $rows, $attributes);
    return $this->recv_getRows();
  }

  public function send_getRows($tableName, $rows, $attributes)
  {
    $args = new \Hbase\Hbase_getRows_args();
    $args->tableName = $tableName;
    $args->rows = $rows;
    $args->attributes = $attributes;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getRows', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getRows', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getRows()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hbase\Hbase_getRows_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hbase\Hbase_getRows_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->io !== null) {
      throw $result->io;
    }
    throw new \Exception("getRows failed: unknown result");
  }

  public function getRowsWithColumns($tableName, $rows, $columns, $attributes)
  {
    $this->send_getRowsWithColumns($tableName, $rows, $columns, $attributes);
    return $this->recv_getRowsWithColumns();
  }

  public function send_getRowsWithColumns($tableName, $rows, $columns, $attributes)
  {
    $args = new \Hbase\Hbase_getRowsWithColumns_args();
    $args->tableName = $tableName;
    $args->rows = $rows;
    $args->columns = $columns;
    $args->attributes = $attributes;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getRowsWithColumns', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getRowsWithColumns', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getRowsWithColumns()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hbase\Hbase_getRowsWithColumns_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hbase\Hbase_getRowsWithColumns_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->io !== null) {
      throw $result->io;
    }
    throw new \Exception("getRowsWithColumns failed: unknown result");
  }

  public function getRowsTs($tableName, $rows, $timestamp, $attributes)
  {
    $this->send_getRowsTs($tableName, $rows, $timestamp, $attributes);
    return $this->recv_getRowsTs();
  }

  public function send_getRowsTs($tableName, $rows, $timestamp, $attributes)
  {
    $args = new \Hbase\Hbase_getRowsTs_args();
    $args->tableName = $tableName;
    $args->rows = $rows;
    $args->timestamp = $timestamp;
    $args->attributes = $attributes;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getRowsTs', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getRowsTs', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getRowsTs()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hbase\Hbase_getRowsTs_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hbase\Hbase_getRowsTs_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->io !== null) {
      throw $result->io;
    }
    throw new \Exception("getRowsTs failed: unknown result");
  }

  public function getRowsWithColumnsTs($tableName, $rows, $columns, $timestamp, $attributes)
  {
    $this->send_getRowsWithColumnsTs($tableName, $rows, $columns, $timestamp, $attributes);
    return $this->recv_getRowsWithColumnsTs();
  }

  public function send_getRowsWithColumnsTs($tableName, $rows, $columns, $timestamp, $attributes)
  {
    $args = new \Hbase\Hbase_getRowsWithColumnsTs_args();
    $args->tableName = $tableName;
    $args->rows = $rows;
    $args->columns = $columns;
    $args->timestamp = $timestamp;
    $args->attributes = $attributes;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getRowsWithColumnsTs', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getRowsWithColumnsTs', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getRowsWithColumnsTs()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hbase\Hbase_getRowsWithColumnsTs_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hbase\Hbase_getRowsWithColumnsTs_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->io !== null) {
      throw $result->io;
    }
    throw new \Exception("getRowsWithColumnsTs failed: unknown result");
  }

  public function mutateRow($tableName, $row, $mutations, $attributes)
  {
    $this->send_mutateRow($tableName, $row, $mutations, $attributes);
    $this->recv_mutateRow();
  }

  public function send_mutateRow($tableName, $row, $mutations, $attributes)
  {
    $args = new \Hbase\Hbase_mutateRow_args();
    $args->tableName = $tableName;
    $args->row = $row;
    $args->mutations = $mutations;
    $args->attributes = $attributes;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'mutateRow', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('mutateRow', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_mutateRow()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hbase\Hbase_mutateRow_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hbase\Hbase_mutateRow_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->io !== null) {
      throw $result->io;
    }
    if ($result->ia !== null) {
      throw $result->ia;
    }
    return;
  }

  public function mutateRowTs($tableName, $row, $mutations, $timestamp, $attributes)
  {
    $this->send_mutateRowTs($tableName, $row, $mutations, $timestamp, $attributes);
    $this->recv_mutateRowTs();
  }

  public function send_mutateRowTs($tableName, $row, $mutations, $timestamp, $attributes)
  {
    $args = new \Hbase\Hbase_mutateRowTs_args();
    $args->tableName = $tableName;
    $args->row = $row;
    $args->mutations = $mutations;
    $args->timestamp = $timestamp;
    $args->attributes = $attributes;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'mutateRowTs', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('mutateRowTs', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_mutateRowTs()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hbase\Hbase_mutateRowTs_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hbase\Hbase_mutateRowTs_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->io !== null) {
      throw $result->io;
    }
    if ($result->ia !== null) {
      throw $result->ia;
    }
    return;
  }

  public function mutateRows($tableName, $rowBatches, $attributes)
  {
    $this->send_mutateRows($tableName, $rowBatches, $attributes);
    $this->recv_mutateRows();
  }

  public function send_mutateRows($tableName, $rowBatches, $attributes)
  {
    $args = new \Hbase\Hbase_mutateRows_args();
    $args->tableName = $tableName;
    $args->rowBatches = $rowBatches;
    $args->attributes = $attributes;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'mutateRows', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('mutateRows', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_mutateRows()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hbase\Hbase_mutateRows_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hbase\Hbase_mutateRows_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->io !== null) {
      throw $result->io;
    }
    if ($result->ia !== null) {
      throw $result->ia;
    }
    return;
  }

  public function mutateRowsTs($tableName, $rowBatches, $timestamp, $attributes)
  {
    $this->send_mutateRowsTs($tableName, $rowBatches, $timestamp, $attributes);
    $this->recv_mutateRowsTs();
  }

  public function send_mutateRowsTs($tableName, $rowBatches, $timestamp, $attributes)
  {
    $args = new \Hbase\Hbase_mutateRowsTs_args();
    $args->tableName = $tableName;
    $args->rowBatches = $rowBatches;
    $args->timestamp = $timestamp;
    $args->attributes = $attributes;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'mutateRowsTs', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('mutateRowsTs', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_mutateRowsTs()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hbase\Hbase_mutateRowsTs_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hbase\Hbase_mutateRowsTs_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->io !== null) {
      throw $result->io;
    }
    if ($result->ia !== null) {
      throw $result->ia;
    }
    return;
  }

  public function atomicIncrement($tableName, $row, $column, $value)
  {
    $this->send_atomicIncrement($tableName, $row, $column, $value);
    return $this->recv_atomicIncrement();
  }

  public function send_atomicIncrement($tableName, $row, $column, $value)
  {
    $args = new \Hbase\Hbase_atomicIncrement_args();
    $args->tableName = $tableName;
    $args->row = $row;
    $args->column = $column;
    $args->value = $value;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'atomicIncrement', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('atomicIncrement', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_atomicIncrement()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hbase\Hbase_atomicIncrement_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hbase\Hbase_atomicIncrement_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->io !== null) {
      throw $result->io;
    }
    if ($result->ia !== null) {
      throw $result->ia;
    }
    throw new \Exception("atomicIncrement failed: unknown result");
  }

  public function deleteAll($tableName, $row, $column, $attributes)
  {
    $this->send_deleteAll($tableName, $row, $column, $attributes);
    $this->recv_deleteAll();
  }

  public function send_deleteAll($tableName, $row, $column, $attributes)
  {
    $args = new \Hbase\Hbase_deleteAll_args();
    $args->tableName = $tableName;
    $args->row = $row;
    $args->column = $column;
    $args->attributes = $attributes;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'deleteAll', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('deleteAll', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_deleteAll()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hbase\Hbase_deleteAll_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hbase\Hbase_deleteAll_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->io !== null) {
      throw $result->io;
    }
    return;
  }

  public function deleteAllTs($tableName, $row, $column, $timestamp, $attributes)
  {
    $this->send_deleteAllTs($tableName, $row, $column, $timestamp, $attributes);
    $this->recv_deleteAllTs();
  }

  public function send_deleteAllTs($tableName, $row, $column, $timestamp, $attributes)
  {
    $args = new \Hbase\Hbase_deleteAllTs_args();
    $args->tableName = $tableName;
    $args->row = $row;
    $args->column = $column;
    $args->timestamp = $timestamp;
    $args->attributes = $attributes;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'deleteAllTs', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('deleteAllTs', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_deleteAllTs()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hbase\Hbase_deleteAllTs_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hbase\Hbase_deleteAllTs_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->io !== null) {
      throw $result->io;
    }
    return;
  }

  public function deleteAllRow($tableName, $row, $attributes)
  {
    $this->send_deleteAllRow($tableName, $row, $attributes);
    $this->recv_deleteAllRow();
  }

  public function send_deleteAllRow($tableName, $row, $attributes)
  {
    $args = new \Hbase\Hbase_deleteAllRow_args();
    $args->tableName = $tableName;
    $args->row = $row;
    $args->attributes = $attributes;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'deleteAllRow', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('deleteAllRow', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_deleteAllRow()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hbase\Hbase_deleteAllRow_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hbase\Hbase_deleteAllRow_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->io !== null) {
      throw $result->io;
    }
    return;
  }

  public function increment(\Hbase\TIncrement $increment)
  {
    $this->send_increment($increment);
    $this->recv_increment();
  }

  public function send_increment(\Hbase\TIncrement $increment)
  {
    $args = new \Hbase\Hbase_increment_args();
    $args->increment = $increment;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'increment', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('increment', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_increment()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hbase\Hbase_increment_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hbase\Hbase_increment_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->io !== null) {
      throw $result->io;
    }
    return;
  }

  public function incrementRows($increments)
  {
    $this->send_incrementRows($increments);
    $this->recv_incrementRows();
  }

  public function send_incrementRows($increments)
  {
    $args = new \Hbase\Hbase_incrementRows_args();
    $args->increments = $increments;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'incrementRows', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('incrementRows', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_incrementRows()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hbase\Hbase_incrementRows_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hbase\Hbase_incrementRows_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->io !== null) {
      throw $result->io;
    }
    return;
  }

  public function deleteAllRowTs($tableName, $row, $timestamp, $attributes)
  {
    $this->send_deleteAllRowTs($tableName, $row, $timestamp, $attributes);
    $this->recv_deleteAllRowTs();
  }

  public function send_deleteAllRowTs($tableName, $row, $timestamp, $attributes)
  {
    $args = new \Hbase\Hbase_deleteAllRowTs_args();
    $args->tableName = $tableName;
    $args->row = $row;
    $args->timestamp = $timestamp;
    $args->attributes = $attributes;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'deleteAllRowTs', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('deleteAllRowTs', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_deleteAllRowTs()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hbase\Hbase_deleteAllRowTs_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hbase\Hbase_deleteAllRowTs_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->io !== null) {
      throw $result->io;
    }
    return;
  }

  public function scannerOpenWithScan($tableName, \Hbase\TScan $scan, $attributes)
  {
    $this->send_scannerOpenWithScan($tableName, $scan, $attributes);
    return $this->recv_scannerOpenWithScan();
  }

  public function send_scannerOpenWithScan($tableName, \Hbase\TScan $scan, $attributes)
  {
    $args = new \Hbase\Hbase_scannerOpenWithScan_args();
    $args->tableName = $tableName;
    $args->scan = $scan;
    $args->attributes = $attributes;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'scannerOpenWithScan', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('scannerOpenWithScan', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_scannerOpenWithScan()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hbase\Hbase_scannerOpenWithScan_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hbase\Hbase_scannerOpenWithScan_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->io !== null) {
      throw $result->io;
    }
    throw new \Exception("scannerOpenWithScan failed: unknown result");
  }

  public function scannerOpen($tableName, $startRow, $columns, $attributes)
  {
    $this->send_scannerOpen($tableName, $startRow, $columns, $attributes);
    return $this->recv_scannerOpen();
  }

  public function send_scannerOpen($tableName, $startRow, $columns, $attributes)
  {
    $args = new \Hbase\Hbase_scannerOpen_args();
    $args->tableName = $tableName;
    $args->startRow = $startRow;
    $args->columns = $columns;
    $args->attributes = $attributes;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'scannerOpen', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('scannerOpen', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_scannerOpen()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hbase\Hbase_scannerOpen_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hbase\Hbase_scannerOpen_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->io !== null) {
      throw $result->io;
    }
    throw new \Exception("scannerOpen failed: unknown result");
  }

  public function scannerOpenWithStop($tableName, $startRow, $stopRow, $columns, $attributes)
  {
    $this->send_scannerOpenWithStop($tableName, $startRow, $stopRow, $columns, $attributes);
    return $this->recv_scannerOpenWithStop();
  }

  public function send_scannerOpenWithStop($tableName, $startRow, $stopRow, $columns, $attributes)
  {
    $args = new \Hbase\Hbase_scannerOpenWithStop_args();
    $args->tableName = $tableName;
    $args->startRow = $startRow;
    $args->stopRow = $stopRow;
    $args->columns = $columns;
    $args->attributes = $attributes;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'scannerOpenWithStop', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('scannerOpenWithStop', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_scannerOpenWithStop()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hbase\Hbase_scannerOpenWithStop_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hbase\Hbase_scannerOpenWithStop_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->io !== null) {
      throw $result->io;
    }
    throw new \Exception("scannerOpenWithStop failed: unknown result");
  }

  public function scannerOpenWithPrefix($tableName, $startAndPrefix, $columns, $attributes)
  {
    $this->send_scannerOpenWithPrefix($tableName, $startAndPrefix, $columns, $attributes);
    return $this->recv_scannerOpenWithPrefix();
  }

  public function send_scannerOpenWithPrefix($tableName, $startAndPrefix, $columns, $attributes)
  {
    $args = new \Hbase\Hbase_scannerOpenWithPrefix_args();
    $args->tableName = $tableName;
    $args->startAndPrefix = $startAndPrefix;
    $args->columns = $columns;
    $args->attributes = $attributes;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'scannerOpenWithPrefix', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('scannerOpenWithPrefix', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_scannerOpenWithPrefix()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hbase\Hbase_scannerOpenWithPrefix_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hbase\Hbase_scannerOpenWithPrefix_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->io !== null) {
      throw $result->io;
    }
    throw new \Exception("scannerOpenWithPrefix failed: unknown result");
  }

  public function scannerOpenTs($tableName, $startRow, $columns, $timestamp, $attributes)
  {
    $this->send_scannerOpenTs($tableName, $startRow, $columns, $timestamp, $attributes);
    return $this->recv_scannerOpenTs();
  }

  public function send_scannerOpenTs($tableName, $startRow, $columns, $timestamp, $attributes)
  {
    $args = new \Hbase\Hbase_scannerOpenTs_args();
    $args->tableName = $tableName;
    $args->startRow = $startRow;
    $args->columns = $columns;
    $args->timestamp = $timestamp;
    $args->attributes = $attributes;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'scannerOpenTs', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('scannerOpenTs', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_scannerOpenTs()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hbase\Hbase_scannerOpenTs_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hbase\Hbase_scannerOpenTs_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->io !== null) {
      throw $result->io;
    }
    throw new \Exception("scannerOpenTs failed: unknown result");
  }

  public function scannerOpenWithStopTs($tableName, $startRow, $stopRow, $columns, $timestamp, $attributes)
  {
    $this->send_scannerOpenWithStopTs($tableName, $startRow, $stopRow, $columns, $timestamp, $attributes);
    return $this->recv_scannerOpenWithStopTs();
  }

  public function send_scannerOpenWithStopTs($tableName, $startRow, $stopRow, $columns, $timestamp, $attributes)
  {
    $args = new \Hbase\Hbase_scannerOpenWithStopTs_args();
    $args->tableName = $tableName;
    $args->startRow = $startRow;
    $args->stopRow = $stopRow;
    $args->columns = $columns;
    $args->timestamp = $timestamp;
    $args->attributes = $attributes;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'scannerOpenWithStopTs', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('scannerOpenWithStopTs', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_scannerOpenWithStopTs()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hbase\Hbase_scannerOpenWithStopTs_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hbase\Hbase_scannerOpenWithStopTs_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->io !== null) {
      throw $result->io;
    }
    throw new \Exception("scannerOpenWithStopTs failed: unknown result");
  }

  public function scannerGet($id)
  {
    $this->send_scannerGet($id);
    return $this->recv_scannerGet();
  }

  public function send_scannerGet($id)
  {
    $args = new \Hbase\Hbase_scannerGet_args();
    $args->id = $id;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'scannerGet', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('scannerGet', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_scannerGet()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hbase\Hbase_scannerGet_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hbase\Hbase_scannerGet_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->io !== null) {
      throw $result->io;
    }
    if ($result->ia !== null) {
      throw $result->ia;
    }
    throw new \Exception("scannerGet failed: unknown result");
  }

  public function scannerGetList($id, $nbRows)
  {
    $this->send_scannerGetList($id, $nbRows);
    return $this->recv_scannerGetList();
  }

  public function send_scannerGetList($id, $nbRows)
  {
    $args = new \Hbase\Hbase_scannerGetList_args();
    $args->id = $id;
    $args->nbRows = $nbRows;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'scannerGetList', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('scannerGetList', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_scannerGetList()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hbase\Hbase_scannerGetList_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hbase\Hbase_scannerGetList_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->io !== null) {
      throw $result->io;
    }
    if ($result->ia !== null) {
      throw $result->ia;
    }
    throw new \Exception("scannerGetList failed: unknown result");
  }

  public function scannerClose($id)
  {
    $this->send_scannerClose($id);
    $this->recv_scannerClose();
  }

  public function send_scannerClose($id)
  {
    $args = new \Hbase\Hbase_scannerClose_args();
    $args->id = $id;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'scannerClose', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('scannerClose', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_scannerClose()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hbase\Hbase_scannerClose_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hbase\Hbase_scannerClose_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->io !== null) {
      throw $result->io;
    }
    if ($result->ia !== null) {
      throw $result->ia;
    }
    return;
  }

  public function getRowOrBefore($tableName, $row, $family)
  {
    $this->send_getRowOrBefore($tableName, $row, $family);
    return $this->recv_getRowOrBefore();
  }

  public function send_getRowOrBefore($tableName, $row, $family)
  {
    $args = new \Hbase\Hbase_getRowOrBefore_args();
    $args->tableName = $tableName;
    $args->row = $row;
    $args->family = $family;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getRowOrBefore', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getRowOrBefore', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getRowOrBefore()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hbase\Hbase_getRowOrBefore_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hbase\Hbase_getRowOrBefore_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->io !== null) {
      throw $result->io;
    }
    throw new \Exception("getRowOrBefore failed: unknown result");
  }

  public function getRegionInfo($row)
  {
    $this->send_getRegionInfo($row);
    return $this->recv_getRegionInfo();
  }

  public function send_getRegionInfo($row)
  {
    $args = new \Hbase\Hbase_getRegionInfo_args();
    $args->row = $row;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getRegionInfo', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getRegionInfo', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getRegionInfo()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hbase\Hbase_getRegionInfo_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hbase\Hbase_getRegionInfo_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->io !== null) {
      throw $result->io;
    }
    throw new \Exception("getRegionInfo failed: unknown result");
  }

}

// HELPER FUNCTIONS AND STRUCTURES

class Hbase_enableTable_args {
  static $_TSPEC;

  public $tableName = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'tableName',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['tableName'])) {
        $this->tableName = $vals['tableName'];
      }
    }
  }

  public function getName() {
    return 'Hbase_enableTable_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tableName);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Hbase_enableTable_args');
    if ($this->tableName !== null) {
      $xfer += $output->writeFieldBegin('tableName', TType::STRING, 1);
      $xfer += $output->writeString($this->tableName);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Hbase_enableTable_result {
  static $_TSPEC;

  public $io = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'io',
          'type' => TType::STRUCT,
          'class' => '\Hbase\IOError',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['io'])) {
        $this->io = $vals['io'];
      }
    }
  }

  public function getName() {
    return 'Hbase_enableTable_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->io = new \Hbase\IOError();
            $xfer += $this->io->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Hbase_enableTable_result');
    if ($this->io !== null) {
      $xfer += $output->writeFieldBegin('io', TType::STRUCT, 1);
      $xfer += $this->io->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Hbase_disableTable_args {
  static $_TSPEC;

  public $tableName = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'tableName',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['tableName'])) {
        $this->tableName = $vals['tableName'];
      }
    }
  }

  public function getName() {
    return 'Hbase_disableTable_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tableName);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Hbase_disableTable_args');
    if ($this->tableName !== null) {
      $xfer += $output->writeFieldBegin('tableName', TType::STRING, 1);
      $xfer += $output->writeString($this->tableName);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Hbase_disableTable_result {
  static $_TSPEC;

  public $io = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'io',
          'type' => TType::STRUCT,
          'class' => '\Hbase\IOError',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['io'])) {
        $this->io = $vals['io'];
      }
    }
  }

  public function getName() {
    return 'Hbase_disableTable_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->io = new \Hbase\IOError();
            $xfer += $this->io->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Hbase_disableTable_result');
    if ($this->io !== null) {
      $xfer += $output->writeFieldBegin('io', TType::STRUCT, 1);
      $xfer += $this->io->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Hbase_isTableEnabled_args {
  static $_TSPEC;

  public $tableName = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'tableName',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['tableName'])) {
        $this->tableName = $vals['tableName'];
      }
    }
  }

  public function getName() {
    return 'Hbase_isTableEnabled_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tableName);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Hbase_isTableEnabled_args');
    if ($this->tableName !== null) {
      $xfer += $output->writeFieldBegin('tableName', TType::STRING, 1);
      $xfer += $output->writeString($this->tableName);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Hbase_isTableEnabled_result {
  static $_TSPEC;

  public $success = null;
  public $io = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::BOOL,
          ),
        1 => array(
          'var' => 'io',
          'type' => TType::STRUCT,
          'class' => '\Hbase\IOError',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['io'])) {
        $this->io = $vals['io'];
      }
    }
  }

  public function getName() {
    return 'Hbase_isTableEnabled_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->io = new \Hbase\IOError();
            $xfer += $this->io->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Hbase_isTableEnabled_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::BOOL, 0);
      $xfer += $output->writeBool($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->io !== null) {
      $xfer += $output->writeFieldBegin('io', TType::STRUCT, 1);
      $xfer += $this->io->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Hbase_compact_args {
  static $_TSPEC;

  public $tableNameOrRegionName = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'tableNameOrRegionName',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['tableNameOrRegionName'])) {
        $this->tableNameOrRegionName = $vals['tableNameOrRegionName'];
      }
    }
  }

  public function getName() {
    return 'Hbase_compact_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tableNameOrRegionName);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Hbase_compact_args');
    if ($this->tableNameOrRegionName !== null) {
      $xfer += $output->writeFieldBegin('tableNameOrRegionName', TType::STRING, 1);
      $xfer += $output->writeString($this->tableNameOrRegionName);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Hbase_compact_result {
  static $_TSPEC;

  public $io = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'io',
          'type' => TType::STRUCT,
          'class' => '\Hbase\IOError',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['io'])) {
        $this->io = $vals['io'];
      }
    }
  }

  public function getName() {
    return 'Hbase_compact_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->io = new \Hbase\IOError();
            $xfer += $this->io->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Hbase_compact_result');
    if ($this->io !== null) {
      $xfer += $output->writeFieldBegin('io', TType::STRUCT, 1);
      $xfer += $this->io->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Hbase_majorCompact_args {
  static $_TSPEC;

  public $tableNameOrRegionName = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'tableNameOrRegionName',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['tableNameOrRegionName'])) {
        $this->tableNameOrRegionName = $vals['tableNameOrRegionName'];
      }
    }
  }

  public function getName() {
    return 'Hbase_majorCompact_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tableNameOrRegionName);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Hbase_majorCompact_args');
    if ($this->tableNameOrRegionName !== null) {
      $xfer += $output->writeFieldBegin('tableNameOrRegionName', TType::STRING, 1);
      $xfer += $output->writeString($this->tableNameOrRegionName);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Hbase_majorCompact_result {
  static $_TSPEC;

  public $io = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'io',
          'type' => TType::STRUCT,
          'class' => '\Hbase\IOError',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['io'])) {
        $this->io = $vals['io'];
      }
    }
  }

  public function getName() {
    return 'Hbase_majorCompact_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->io = new \Hbase\IOError();
            $xfer += $this->io->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Hbase_majorCompact_result');
    if ($this->io !== null) {
      $xfer += $output->writeFieldBegin('io', TType::STRUCT, 1);
      $xfer += $this->io->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Hbase_getTableNames_args {
  static $_TSPEC;


  public function __construct() {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        );
    }
  }

  public function getName() {
    return 'Hbase_getTableNames_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Hbase_getTableNames_args');
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Hbase_getTableNames_result {
  static $_TSPEC;

  public $success = null;
  public $io = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        1 => array(
          'var' => 'io',
          'type' => TType::STRUCT,
          'class' => '\Hbase\IOError',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['io'])) {
        $this->io = $vals['io'];
      }
    }
  }

  public function getName() {
    return 'Hbase_getTableNames_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size23 = 0;
            $_etype26 = 0;
            $xfer += $input->readListBegin($_etype26, $_size23);
            for ($_i27 = 0; $_i27 < $_size23; ++$_i27)
            {
              $elem28 = null;
              $xfer += $input->readString($elem28);
              $this->success []= $elem28;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->io = new \Hbase\IOError();
            $xfer += $this->io->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Hbase_getTableNames_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRING, count($this->success));
        {
          foreach ($this->success as $iter29)
          {
            $xfer += $output->writeString($iter29);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->io !== null) {
      $xfer += $output->writeFieldBegin('io', TType::STRUCT, 1);
      $xfer += $this->io->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Hbase_getColumnDescriptors_args {
  static $_TSPEC;

  public $tableName = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'tableName',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['tableName'])) {
        $this->tableName = $vals['tableName'];
      }
    }
  }

  public function getName() {
    return 'Hbase_getColumnDescriptors_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tableName);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Hbase_getColumnDescriptors_args');
    if ($this->tableName !== null) {
      $xfer += $output->writeFieldBegin('tableName', TType::STRING, 1);
      $xfer += $output->writeString($this->tableName);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Hbase_getColumnDescriptors_result {
  static $_TSPEC;

  public $success = null;
  public $io = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::MAP,
          'ktype' => TType::STRING,
          'vtype' => TType::STRUCT,
          'key' => array(
            'type' => TType::STRING,
          ),
          'val' => array(
            'type' => TType::STRUCT,
            'class' => '\Hbase\ColumnDescriptor',
            ),
          ),
        1 => array(
          'var' => 'io',
          'type' => TType::STRUCT,
          'class' => '\Hbase\IOError',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['io'])) {
        $this->io = $vals['io'];
      }
    }
  }

  public function getName() {
    return 'Hbase_getColumnDescriptors_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::MAP) {
            $this->success = array();
            $_size30 = 0;
            $_ktype31 = 0;
            $_vtype32 = 0;
            $xfer += $input->readMapBegin($_ktype31, $_vtype32, $_size30);
            for ($_i34 = 0; $_i34 < $_size30; ++$_i34)
            {
              $key35 = '';
              $val36 = new \Hbase\ColumnDescriptor();
              $xfer += $input->readString($key35);
              $val36 = new \Hbase\ColumnDescriptor();
              $xfer += $val36->read($input);
              $this->success[$key35] = $val36;
            }
            $xfer += $input->readMapEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->io = new \Hbase\IOError();
            $xfer += $this->io->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Hbase_getColumnDescriptors_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::MAP, 0);
      {
        $output->writeMapBegin(TType::STRING, TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $kiter37 => $viter38)
          {
            $xfer += $output->writeString($kiter37);
            $xfer += $viter38->write($output);
          }
        }
        $output->writeMapEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->io !== null) {
      $xfer += $output->writeFieldBegin('io', TType::STRUCT, 1);
      $xfer += $this->io->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Hbase_getTableRegions_args {
  static $_TSPEC;

  public $tableName = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'tableName',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['tableName'])) {
        $this->tableName = $vals['tableName'];
      }
    }
  }

  public function getName() {
    return 'Hbase_getTableRegions_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tableName);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Hbase_getTableRegions_args');
    if ($this->tableName !== null) {
      $xfer += $output->writeFieldBegin('tableName', TType::STRING, 1);
      $xfer += $output->writeString($this->tableName);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Hbase_getTableRegions_result {
  static $_TSPEC;

  public $success = null;
  public $io = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\Hbase\TRegionInfo',
            ),
          ),
        1 => array(
          'var' => 'io',
          'type' => TType::STRUCT,
          'class' => '\Hbase\IOError',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['io'])) {
        $this->io = $vals['io'];
      }
    }
  }

  public function getName() {
    return 'Hbase_getTableRegions_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size39 = 0;
            $_etype42 = 0;
            $xfer += $input->readListBegin($_etype42, $_size39);
            for ($_i43 = 0; $_i43 < $_size39; ++$_i43)
            {
              $elem44 = null;
              $elem44 = new \Hbase\TRegionInfo();
              $xfer += $elem44->read($input);
              $this->success []= $elem44;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->io = new \Hbase\IOError();
            $xfer += $this->io->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Hbase_getTableRegions_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $iter45)
          {
            $xfer += $iter45->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->io !== null) {
      $xfer += $output->writeFieldBegin('io', TType::STRUCT, 1);
      $xfer += $this->io->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Hbase_createTable_args {
  static $_TSPEC;

  public $tableName = null;
  public $columnFamilies = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'tableName',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'columnFamilies',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\Hbase\ColumnDescriptor',
            ),
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['tableName'])) {
        $this->tableName = $vals['tableName'];
      }
      if (isset($vals['columnFamilies'])) {
        $this->columnFamilies = $vals['columnFamilies'];
      }
    }
  }

  public function getName() {
    return 'Hbase_createTable_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tableName);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::LST) {
            $this->columnFamilies = array();
            $_size46 = 0;
            $_etype49 = 0;
            $xfer += $input->readListBegin($_etype49, $_size46);
            for ($_i50 = 0; $_i50 < $_size46; ++$_i50)
            {
              $elem51 = null;
              $elem51 = new \Hbase\ColumnDescriptor();
              $xfer += $elem51->read($input);
              $this->columnFamilies []= $elem51;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Hbase_createTable_args');
    if ($this->tableName !== null) {
      $xfer += $output->writeFieldBegin('tableName', TType::STRING, 1);
      $xfer += $output->writeString($this->tableName);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->columnFamilies !== null) {
      if (!is_array($this->columnFamilies)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('columnFamilies', TType::LST, 2);
      {
        $output->writeListBegin(TType::STRUCT, count($this->columnFamilies));
        {
          foreach ($this->columnFamilies as $iter52)
          {
            $xfer += $iter52->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Hbase_createTable_result {
  static $_TSPEC;

  public $io = null;
  public $ia = null;
  public $exist = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'io',
          'type' => TType::STRUCT,
          'class' => '\Hbase\IOError',
          ),
        2 => array(
          'var' => 'ia',
          'type' => TType::STRUCT,
          'class' => '\Hbase\IllegalArgument',
          ),
        3 => array(
          'var' => 'exist',
          'type' => TType::STRUCT,
          'class' => '\Hbase\AlreadyExists',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['io'])) {
        $this->io = $vals['io'];
      }
      if (isset($vals['ia'])) {
        $this->ia = $vals['ia'];
      }
      if (isset($vals['exist'])) {
        $this->exist = $vals['exist'];
      }
    }
  }

  public function getName() {
    return 'Hbase_createTable_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->io = new \Hbase\IOError();
            $xfer += $this->io->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ia = new \Hbase\IllegalArgument();
            $xfer += $this->ia->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->exist = new \Hbase\AlreadyExists();
            $xfer += $this->exist->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Hbase_createTable_result');
    if ($this->io !== null) {
      $xfer += $output->writeFieldBegin('io', TType::STRUCT, 1);
      $xfer += $this->io->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ia !== null) {
      $xfer += $output->writeFieldBegin('ia', TType::STRUCT, 2);
      $xfer += $this->ia->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->exist !== null) {
      $xfer += $output->writeFieldBegin('exist', TType::STRUCT, 3);
      $xfer += $this->exist->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Hbase_deleteTable_args {
  static $_TSPEC;

  public $tableName = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'tableName',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['tableName'])) {
        $this->tableName = $vals['tableName'];
      }
    }
  }

  public function getName() {
    return 'Hbase_deleteTable_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tableName);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Hbase_deleteTable_args');
    if ($this->tableName !== null) {
      $xfer += $output->writeFieldBegin('tableName', TType::STRING, 1);
      $xfer += $output->writeString($this->tableName);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Hbase_deleteTable_result {
  static $_TSPEC;

  public $io = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'io',
          'type' => TType::STRUCT,
          'class' => '\Hbase\IOError',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['io'])) {
        $this->io = $vals['io'];
      }
    }
  }

  public function getName() {
    return 'Hbase_deleteTable_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->io = new \Hbase\IOError();
            $xfer += $this->io->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Hbase_deleteTable_result');
    if ($this->io !== null) {
      $xfer += $output->writeFieldBegin('io', TType::STRUCT, 1);
      $xfer += $this->io->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Hbase_get_args {
  static $_TSPEC;

  public $tableName = null;
  public $row = null;
  public $column = null;
  public $attributes = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'tableName',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'row',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'column',
          'type' => TType::STRING,
          ),
        4 => array(
          'var' => 'attributes',
          'type' => TType::MAP,
          'ktype' => TType::STRING,
          'vtype' => TType::STRING,
          'key' => array(
            'type' => TType::STRING,
          ),
          'val' => array(
            'type' => TType::STRING,
            ),
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['tableName'])) {
        $this->tableName = $vals['tableName'];
      }
      if (isset($vals['row'])) {
        $this->row = $vals['row'];
      }
      if (isset($vals['column'])) {
        $this->column = $vals['column'];
      }
      if (isset($vals['attributes'])) {
        $this->attributes = $vals['attributes'];
      }
    }
  }

  public function getName() {
    return 'Hbase_get_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tableName);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->row);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->column);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::MAP) {
            $this->attributes = array();
            $_size53 = 0;
            $_ktype54 = 0;
            $_vtype55 = 0;
            $xfer += $input->readMapBegin($_ktype54, $_vtype55, $_size53);
            for ($_i57 = 0; $_i57 < $_size53; ++$_i57)
            {
              $key58 = '';
              $val59 = '';
              $xfer += $input->readString($key58);
              $xfer += $input->readString($val59);
              $this->attributes[$key58] = $val59;
            }
            $xfer += $input->readMapEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Hbase_get_args');
    if ($this->tableName !== null) {
      $xfer += $output->writeFieldBegin('tableName', TType::STRING, 1);
      $xfer += $output->writeString($this->tableName);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->row !== null) {
      $xfer += $output->writeFieldBegin('row', TType::STRING, 2);
      $xfer += $output->writeString($this->row);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->column !== null) {
      $xfer += $output->writeFieldBegin('column', TType::STRING, 3);
      $xfer += $output->writeString($this->column);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->attributes !== null) {
      if (!is_array($this->attributes)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('attributes', TType::MAP, 4);
      {
        $output->writeMapBegin(TType::STRING, TType::STRING, count($this->attributes));
        {
          foreach ($this->attributes as $kiter60 => $viter61)
          {
            $xfer += $output->writeString($kiter60);
            $xfer += $output->writeString($viter61);
          }
        }
        $output->writeMapEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Hbase_get_result {
  static $_TSPEC;

  public $success = null;
  public $io = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\Hbase\TCell',
            ),
          ),
        1 => array(
          'var' => 'io',
          'type' => TType::STRUCT,
          'class' => '\Hbase\IOError',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['io'])) {
        $this->io = $vals['io'];
      }
    }
  }

  public function getName() {
    return 'Hbase_get_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size62 = 0;
            $_etype65 = 0;
            $xfer += $input->readListBegin($_etype65, $_size62);
            for ($_i66 = 0; $_i66 < $_size62; ++$_i66)
            {
              $elem67 = null;
              $elem67 = new \Hbase\TCell();
              $xfer += $elem67->read($input);
              $this->success []= $elem67;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->io = new \Hbase\IOError();
            $xfer += $this->io->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Hbase_get_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $iter68)
          {
            $xfer += $iter68->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->io !== null) {
      $xfer += $output->writeFieldBegin('io', TType::STRUCT, 1);
      $xfer += $this->io->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Hbase_getVer_args {
  static $_TSPEC;

  public $tableName = null;
  public $row = null;
  public $column = null;
  public $numVersions = null;
  public $attributes = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'tableName',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'row',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'column',
          'type' => TType::STRING,
          ),
        4 => array(
          'var' => 'numVersions',
          'type' => TType::I32,
          ),
        5 => array(
          'var' => 'attributes',
          'type' => TType::MAP,
          'ktype' => TType::STRING,
          'vtype' => TType::STRING,
          'key' => array(
            'type' => TType::STRING,
          ),
          'val' => array(
            'type' => TType::STRING,
            ),
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['tableName'])) {
        $this->tableName = $vals['tableName'];
      }
      if (isset($vals['row'])) {
        $this->row = $vals['row'];
      }
      if (isset($vals['column'])) {
        $this->column = $vals['column'];
      }
      if (isset($vals['numVersions'])) {
        $this->numVersions = $vals['numVersions'];
      }
      if (isset($vals['attributes'])) {
        $this->attributes = $vals['attributes'];
      }
    }
  }

  public function getName() {
    return 'Hbase_getVer_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tableName);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->row);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->column);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->numVersions);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 5:
          if ($ftype == TType::MAP) {
            $this->attributes = array();
            $_size69 = 0;
            $_ktype70 = 0;
            $_vtype71 = 0;
            $xfer += $input->readMapBegin($_ktype70, $_vtype71, $_size69);
            for ($_i73 = 0; $_i73 < $_size69; ++$_i73)
            {
              $key74 = '';
              $val75 = '';
              $xfer += $input->readString($key74);
              $xfer += $input->readString($val75);
              $this->attributes[$key74] = $val75;
            }
            $xfer += $input->readMapEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Hbase_getVer_args');
    if ($this->tableName !== null) {
      $xfer += $output->writeFieldBegin('tableName', TType::STRING, 1);
      $xfer += $output->writeString($this->tableName);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->row !== null) {
      $xfer += $output->writeFieldBegin('row', TType::STRING, 2);
      $xfer += $output->writeString($this->row);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->column !== null) {
      $xfer += $output->writeFieldBegin('column', TType::STRING, 3);
      $xfer += $output->writeString($this->column);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->numVersions !== null) {
      $xfer += $output->writeFieldBegin('numVersions', TType::I32, 4);
      $xfer += $output->writeI32($this->numVersions);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->attributes !== null) {
      if (!is_array($this->attributes)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('attributes', TType::MAP, 5);
      {
        $output->writeMapBegin(TType::STRING, TType::STRING, count($this->attributes));
        {
          foreach ($this->attributes as $kiter76 => $viter77)
          {
            $xfer += $output->writeString($kiter76);
            $xfer += $output->writeString($viter77);
          }
        }
        $output->writeMapEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Hbase_getVer_result {
  static $_TSPEC;

  public $success = null;
  public $io = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\Hbase\TCell',
            ),
          ),
        1 => array(
          'var' => 'io',
          'type' => TType::STRUCT,
          'class' => '\Hbase\IOError',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['io'])) {
        $this->io = $vals['io'];
      }
    }
  }

  public function getName() {
    return 'Hbase_getVer_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size78 = 0;
            $_etype81 = 0;
            $xfer += $input->readListBegin($_etype81, $_size78);
            for ($_i82 = 0; $_i82 < $_size78; ++$_i82)
            {
              $elem83 = null;
              $elem83 = new \Hbase\TCell();
              $xfer += $elem83->read($input);
              $this->success []= $elem83;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->io = new \Hbase\IOError();
            $xfer += $this->io->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Hbase_getVer_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $iter84)
          {
            $xfer += $iter84->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->io !== null) {
      $xfer += $output->writeFieldBegin('io', TType::STRUCT, 1);
      $xfer += $this->io->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Hbase_getVerTs_args {
  static $_TSPEC;

  public $tableName = null;
  public $row = null;
  public $column = null;
  public $timestamp = null;
  public $numVersions = null;
  public $attributes = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'tableName',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'row',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'column',
          'type' => TType::STRING,
          ),
        4 => array(
          'var' => 'timestamp',
          'type' => TType::I64,
          ),
        5 => array(
          'var' => 'numVersions',
          'type' => TType::I32,
          ),
        6 => array(
          'var' => 'attributes',
          'type' => TType::MAP,
          'ktype' => TType::STRING,
          'vtype' => TType::STRING,
          'key' => array(
            'type' => TType::STRING,
          ),
          'val' => array(
            'type' => TType::STRING,
            ),
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['tableName'])) {
        $this->tableName = $vals['tableName'];
      }
      if (isset($vals['row'])) {
        $this->row = $vals['row'];
      }
      if (isset($vals['column'])) {
        $this->column = $vals['column'];
      }
      if (isset($vals['timestamp'])) {
        $this->timestamp = $vals['timestamp'];
      }
      if (isset($vals['numVersions'])) {
        $this->numVersions = $vals['numVersions'];
      }
      if (isset($vals['attributes'])) {
        $this->attributes = $vals['attributes'];
      }
    }
  }

  public function getName() {
    return 'Hbase_getVerTs_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tableName);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->row);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->column);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->timestamp);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 5:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->numVersions);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 6:
          if ($ftype == TType::MAP) {
            $this->attributes = array();
            $_size85 = 0;
            $_ktype86 = 0;
            $_vtype87 = 0;
            $xfer += $input->readMapBegin($_ktype86, $_vtype87, $_size85);
            for ($_i89 = 0; $_i89 < $_size85; ++$_i89)
            {
              $key90 = '';
              $val91 = '';
              $xfer += $input->readString($key90);
              $xfer += $input->readString($val91);
              $this->attributes[$key90] = $val91;
            }
            $xfer += $input->readMapEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Hbase_getVerTs_args');
    if ($this->tableName !== null) {
      $xfer += $output->writeFieldBegin('tableName', TType::STRING, 1);
      $xfer += $output->writeString($this->tableName);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->row !== null) {
      $xfer += $output->writeFieldBegin('row', TType::STRING, 2);
      $xfer += $output->writeString($this->row);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->column !== null) {
      $xfer += $output->writeFieldBegin('column', TType::STRING, 3);
      $xfer += $output->writeString($this->column);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->timestamp !== null) {
      $xfer += $output->writeFieldBegin('timestamp', TType::I64, 4);
      $xfer += $output->writeI64($this->timestamp);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->numVersions !== null) {
      $xfer += $output->writeFieldBegin('numVersions', TType::I32, 5);
      $xfer += $output->writeI32($this->numVersions);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->attributes !== null) {
      if (!is_array($this->attributes)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('attributes', TType::MAP, 6);
      {
        $output->writeMapBegin(TType::STRING, TType::STRING, count($this->attributes));
        {
          foreach ($this->attributes as $kiter92 => $viter93)
          {
            $xfer += $output->writeString($kiter92);
            $xfer += $output->writeString($viter93);
          }
        }
        $output->writeMapEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Hbase_getVerTs_result {
  static $_TSPEC;

  public $success = null;
  public $io = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\Hbase\TCell',
            ),
          ),
        1 => array(
          'var' => 'io',
          'type' => TType::STRUCT,
          'class' => '\Hbase\IOError',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['io'])) {
        $this->io = $vals['io'];
      }
    }
  }

  public function getName() {
    return 'Hbase_getVerTs_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size94 = 0;
            $_etype97 = 0;
            $xfer += $input->readListBegin($_etype97, $_size94);
            for ($_i98 = 0; $_i98 < $_size94; ++$_i98)
            {
              $elem99 = null;
              $elem99 = new \Hbase\TCell();
              $xfer += $elem99->read($input);
              $this->success []= $elem99;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->io = new \Hbase\IOError();
            $xfer += $this->io->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Hbase_getVerTs_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $iter100)
          {
            $xfer += $iter100->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->io !== null) {
      $xfer += $output->writeFieldBegin('io', TType::STRUCT, 1);
      $xfer += $this->io->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Hbase_getRow_args {
  static $_TSPEC;

  public $tableName = null;
  public $row = null;
  public $attributes = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'tableName',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'row',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'attributes',
          'type' => TType::MAP,
          'ktype' => TType::STRING,
          'vtype' => TType::STRING,
          'key' => array(
            'type' => TType::STRING,
          ),
          'val' => array(
            'type' => TType::STRING,
            ),
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['tableName'])) {
        $this->tableName = $vals['tableName'];
      }
      if (isset($vals['row'])) {
        $this->row = $vals['row'];
      }
      if (isset($vals['attributes'])) {
        $this->attributes = $vals['attributes'];
      }
    }
  }

  public function getName() {
    return 'Hbase_getRow_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tableName);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->row);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::MAP) {
            $this->attributes = array();
            $_size101 = 0;
            $_ktype102 = 0;
            $_vtype103 = 0;
            $xfer += $input->readMapBegin($_ktype102, $_vtype103, $_size101);
            for ($_i105 = 0; $_i105 < $_size101; ++$_i105)
            {
              $key106 = '';
              $val107 = '';
              $xfer += $input->readString($key106);
              $xfer += $input->readString($val107);
              $this->attributes[$key106] = $val107;
            }
            $xfer += $input->readMapEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Hbase_getRow_args');
    if ($this->tableName !== null) {
      $xfer += $output->writeFieldBegin('tableName', TType::STRING, 1);
      $xfer += $output->writeString($this->tableName);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->row !== null) {
      $xfer += $output->writeFieldBegin('row', TType::STRING, 2);
      $xfer += $output->writeString($this->row);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->attributes !== null) {
      if (!is_array($this->attributes)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('attributes', TType::MAP, 3);
      {
        $output->writeMapBegin(TType::STRING, TType::STRING, count($this->attributes));
        {
          foreach ($this->attributes as $kiter108 => $viter109)
          {
            $xfer += $output->writeString($kiter108);
            $xfer += $output->writeString($viter109);
          }
        }
        $output->writeMapEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Hbase_getRow_result {
  static $_TSPEC;

  public $success = null;
  public $io = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\Hbase\TRowResult',
            ),
          ),
        1 => array(
          'var' => 'io',
          'type' => TType::STRUCT,
          'class' => '\Hbase\IOError',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['io'])) {
        $this->io = $vals['io'];
      }
    }
  }

  public function getName() {
    return 'Hbase_getRow_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size110 = 0;
            $_etype113 = 0;
            $xfer += $input->readListBegin($_etype113, $_size110);
            for ($_i114 = 0; $_i114 < $_size110; ++$_i114)
            {
              $elem115 = null;
              $elem115 = new \Hbase\TRowResult();
              $xfer += $elem115->read($input);
              $this->success []= $elem115;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->io = new \Hbase\IOError();
            $xfer += $this->io->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Hbase_getRow_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $iter116)
          {
            $xfer += $iter116->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->io !== null) {
      $xfer += $output->writeFieldBegin('io', TType::STRUCT, 1);
      $xfer += $this->io->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Hbase_getRowWithColumns_args {
  static $_TSPEC;

  public $tableName = null;
  public $row = null;
  public $columns = null;
  public $attributes = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'tableName',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'row',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'columns',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        4 => array(
          'var' => 'attributes',
          'type' => TType::MAP,
          'ktype' => TType::STRING,
          'vtype' => TType::STRING,
          'key' => array(
            'type' => TType::STRING,
          ),
          'val' => array(
            'type' => TType::STRING,
            ),
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['tableName'])) {
        $this->tableName = $vals['tableName'];
      }
      if (isset($vals['row'])) {
        $this->row = $vals['row'];
      }
      if (isset($vals['columns'])) {
        $this->columns = $vals['columns'];
      }
      if (isset($vals['attributes'])) {
        $this->attributes = $vals['attributes'];
      }
    }
  }

  public function getName() {
    return 'Hbase_getRowWithColumns_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tableName);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->row);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::LST) {
            $this->columns = array();
            $_size117 = 0;
            $_etype120 = 0;
            $xfer += $input->readListBegin($_etype120, $_size117);
            for ($_i121 = 0; $_i121 < $_size117; ++$_i121)
            {
              $elem122 = null;
              $xfer += $input->readString($elem122);
              $this->columns []= $elem122;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::MAP) {
            $this->attributes = array();
            $_size123 = 0;
            $_ktype124 = 0;
            $_vtype125 = 0;
            $xfer += $input->readMapBegin($_ktype124, $_vtype125, $_size123);
            for ($_i127 = 0; $_i127 < $_size123; ++$_i127)
            {
              $key128 = '';
              $val129 = '';
              $xfer += $input->readString($key128);
              $xfer += $input->readString($val129);
              $this->attributes[$key128] = $val129;
            }
            $xfer += $input->readMapEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Hbase_getRowWithColumns_args');
    if ($this->tableName !== null) {
      $xfer += $output->writeFieldBegin('tableName', TType::STRING, 1);
      $xfer += $output->writeString($this->tableName);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->row !== null) {
      $xfer += $output->writeFieldBegin('row', TType::STRING, 2);
      $xfer += $output->writeString($this->row);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->columns !== null) {
      if (!is_array($this->columns)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('columns', TType::LST, 3);
      {
        $output->writeListBegin(TType::STRING, count($this->columns));
        {
          foreach ($this->columns as $iter130)
          {
            $xfer += $output->writeString($iter130);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->attributes !== null) {
      if (!is_array($this->attributes)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('attributes', TType::MAP, 4);
      {
        $output->writeMapBegin(TType::STRING, TType::STRING, count($this->attributes));
        {
          foreach ($this->attributes as $kiter131 => $viter132)
          {
            $xfer += $output->writeString($kiter131);
            $xfer += $output->writeString($viter132);
          }
        }
        $output->writeMapEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Hbase_getRowWithColumns_result {
  static $_TSPEC;

  public $success = null;
  public $io = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\Hbase\TRowResult',
            ),
          ),
        1 => array(
          'var' => 'io',
          'type' => TType::STRUCT,
          'class' => '\Hbase\IOError',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['io'])) {
        $this->io = $vals['io'];
      }
    }
  }

  public function getName() {
    return 'Hbase_getRowWithColumns_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size133 = 0;
            $_etype136 = 0;
            $xfer += $input->readListBegin($_etype136, $_size133);
            for ($_i137 = 0; $_i137 < $_size133; ++$_i137)
            {
              $elem138 = null;
              $elem138 = new \Hbase\TRowResult();
              $xfer += $elem138->read($input);
              $this->success []= $elem138;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->io = new \Hbase\IOError();
            $xfer += $this->io->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Hbase_getRowWithColumns_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $iter139)
          {
            $xfer += $iter139->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->io !== null) {
      $xfer += $output->writeFieldBegin('io', TType::STRUCT, 1);
      $xfer += $this->io->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Hbase_getRowTs_args {
  static $_TSPEC;

  public $tableName = null;
  public $row = null;
  public $timestamp = null;
  public $attributes = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'tableName',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'row',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'timestamp',
          'type' => TType::I64,
          ),
        4 => array(
          'var' => 'attributes',
          'type' => TType::MAP,
          'ktype' => TType::STRING,
          'vtype' => TType::STRING,
          'key' => array(
            'type' => TType::STRING,
          ),
          'val' => array(
            'type' => TType::STRING,
            ),
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['tableName'])) {
        $this->tableName = $vals['tableName'];
      }
      if (isset($vals['row'])) {
        $this->row = $vals['row'];
      }
      if (isset($vals['timestamp'])) {
        $this->timestamp = $vals['timestamp'];
      }
      if (isset($vals['attributes'])) {
        $this->attributes = $vals['attributes'];
      }
    }
  }

  public function getName() {
    return 'Hbase_getRowTs_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tableName);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->row);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->timestamp);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::MAP) {
            $this->attributes = array();
            $_size140 = 0;
            $_ktype141 = 0;
            $_vtype142 = 0;
            $xfer += $input->readMapBegin($_ktype141, $_vtype142, $_size140);
            for ($_i144 = 0; $_i144 < $_size140; ++$_i144)
            {
              $key145 = '';
              $val146 = '';
              $xfer += $input->readString($key145);
              $xfer += $input->readString($val146);
              $this->attributes[$key145] = $val146;
            }
            $xfer += $input->readMapEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Hbase_getRowTs_args');
    if ($this->tableName !== null) {
      $xfer += $output->writeFieldBegin('tableName', TType::STRING, 1);
      $xfer += $output->writeString($this->tableName);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->row !== null) {
      $xfer += $output->writeFieldBegin('row', TType::STRING, 2);
      $xfer += $output->writeString($this->row);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->timestamp !== null) {
      $xfer += $output->writeFieldBegin('timestamp', TType::I64, 3);
      $xfer += $output->writeI64($this->timestamp);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->attributes !== null) {
      if (!is_array($this->attributes)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('attributes', TType::MAP, 4);
      {
        $output->writeMapBegin(TType::STRING, TType::STRING, count($this->attributes));
        {
          foreach ($this->attributes as $kiter147 => $viter148)
          {
            $xfer += $output->writeString($kiter147);
            $xfer += $output->writeString($viter148);
          }
        }
        $output->writeMapEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Hbase_getRowTs_result {
  static $_TSPEC;

  public $success = null;
  public $io = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\Hbase\TRowResult',
            ),
          ),
        1 => array(
          'var' => 'io',
          'type' => TType::STRUCT,
          'class' => '\Hbase\IOError',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['io'])) {
        $this->io = $vals['io'];
      }
    }
  }

  public function getName() {
    return 'Hbase_getRowTs_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size149 = 0;
            $_etype152 = 0;
            $xfer += $input->readListBegin($_etype152, $_size149);
            for ($_i153 = 0; $_i153 < $_size149; ++$_i153)
            {
              $elem154 = null;
              $elem154 = new \Hbase\TRowResult();
              $xfer += $elem154->read($input);
              $this->success []= $elem154;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->io = new \Hbase\IOError();
            $xfer += $this->io->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Hbase_getRowTs_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $iter155)
          {
            $xfer += $iter155->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->io !== null) {
      $xfer += $output->writeFieldBegin('io', TType::STRUCT, 1);
      $xfer += $this->io->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Hbase_getRowWithColumnsTs_args {
  static $_TSPEC;

  public $tableName = null;
  public $row = null;
  public $columns = null;
  public $timestamp = null;
  public $attributes = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'tableName',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'row',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'columns',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        4 => array(
          'var' => 'timestamp',
          'type' => TType::I64,
          ),
        5 => array(
          'var' => 'attributes',
          'type' => TType::MAP,
          'ktype' => TType::STRING,
          'vtype' => TType::STRING,
          'key' => array(
            'type' => TType::STRING,
          ),
          'val' => array(
            'type' => TType::STRING,
            ),
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['tableName'])) {
        $this->tableName = $vals['tableName'];
      }
      if (isset($vals['row'])) {
        $this->row = $vals['row'];
      }
      if (isset($vals['columns'])) {
        $this->columns = $vals['columns'];
      }
      if (isset($vals['timestamp'])) {
        $this->timestamp = $vals['timestamp'];
      }
      if (isset($vals['attributes'])) {
        $this->attributes = $vals['attributes'];
      }
    }
  }

  public function getName() {
    return 'Hbase_getRowWithColumnsTs_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tableName);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->row);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::LST) {
            $this->columns = array();
            $_size156 = 0;
            $_etype159 = 0;
            $xfer += $input->readListBegin($_etype159, $_size156);
            for ($_i160 = 0; $_i160 < $_size156; ++$_i160)
            {
              $elem161 = null;
              $xfer += $input->readString($elem161);
              $this->columns []= $elem161;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->timestamp);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 5:
          if ($ftype == TType::MAP) {
            $this->attributes = array();
            $_size162 = 0;
            $_ktype163 = 0;
            $_vtype164 = 0;
            $xfer += $input->readMapBegin($_ktype163, $_vtype164, $_size162);
            for ($_i166 = 0; $_i166 < $_size162; ++$_i166)
            {
              $key167 = '';
              $val168 = '';
              $xfer += $input->readString($key167);
              $xfer += $input->readString($val168);
              $this->attributes[$key167] = $val168;
            }
            $xfer += $input->readMapEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Hbase_getRowWithColumnsTs_args');
    if ($this->tableName !== null) {
      $xfer += $output->writeFieldBegin('tableName', TType::STRING, 1);
      $xfer += $output->writeString($this->tableName);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->row !== null) {
      $xfer += $output->writeFieldBegin('row', TType::STRING, 2);
      $xfer += $output->writeString($this->row);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->columns !== null) {
      if (!is_array($this->columns)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('columns', TType::LST, 3);
      {
        $output->writeListBegin(TType::STRING, count($this->columns));
        {
          foreach ($this->columns as $iter169)
          {
            $xfer += $output->writeString($iter169);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->timestamp !== null) {
      $xfer += $output->writeFieldBegin('timestamp', TType::I64, 4);
      $xfer += $output->writeI64($this->timestamp);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->attributes !== null) {
      if (!is_array($this->attributes)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('attributes', TType::MAP, 5);
      {
        $output->writeMapBegin(TType::STRING, TType::STRING, count($this->attributes));
        {
          foreach ($this->attributes as $kiter170 => $viter171)
          {
            $xfer += $output->writeString($kiter170);
            $xfer += $output->writeString($viter171);
          }
        }
        $output->writeMapEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Hbase_getRowWithColumnsTs_result {
  static $_TSPEC;

  public $success = null;
  public $io = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\Hbase\TRowResult',
            ),
          ),
        1 => array(
          'var' => 'io',
          'type' => TType::STRUCT,
          'class' => '\Hbase\IOError',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['io'])) {
        $this->io = $vals['io'];
      }
    }
  }

  public function getName() {
    return 'Hbase_getRowWithColumnsTs_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size172 = 0;
            $_etype175 = 0;
            $xfer += $input->readListBegin($_etype175, $_size172);
            for ($_i176 = 0; $_i176 < $_size172; ++$_i176)
            {
              $elem177 = null;
              $elem177 = new \Hbase\TRowResult();
              $xfer += $elem177->read($input);
              $this->success []= $elem177;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->io = new \Hbase\IOError();
            $xfer += $this->io->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Hbase_getRowWithColumnsTs_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $iter178)
          {
            $xfer += $iter178->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->io !== null) {
      $xfer += $output->writeFieldBegin('io', TType::STRUCT, 1);
      $xfer += $this->io->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Hbase_getRows_args {
  static $_TSPEC;

  public $tableName = null;
  public $rows = null;
  public $attributes = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'tableName',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'rows',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        3 => array(
          'var' => 'attributes',
          'type' => TType::MAP,
          'ktype' => TType::STRING,
          'vtype' => TType::STRING,
          'key' => array(
            'type' => TType::STRING,
          ),
          'val' => array(
            'type' => TType::STRING,
            ),
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['tableName'])) {
        $this->tableName = $vals['tableName'];
      }
      if (isset($vals['rows'])) {
        $this->rows = $vals['rows'];
      }
      if (isset($vals['attributes'])) {
        $this->attributes = $vals['attributes'];
      }
    }
  }

  public function getName() {
    return 'Hbase_getRows_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tableName);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::LST) {
            $this->rows = array();
            $_size179 = 0;
            $_etype182 = 0;
            $xfer += $input->readListBegin($_etype182, $_size179);
            for ($_i183 = 0; $_i183 < $_size179; ++$_i183)
            {
              $elem184 = null;
              $xfer += $input->readString($elem184);
              $this->rows []= $elem184;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::MAP) {
            $this->attributes = array();
            $_size185 = 0;
            $_ktype186 = 0;
            $_vtype187 = 0;
            $xfer += $input->readMapBegin($_ktype186, $_vtype187, $_size185);
            for ($_i189 = 0; $_i189 < $_size185; ++$_i189)
            {
              $key190 = '';
              $val191 = '';
              $xfer += $input->readString($key190);
              $xfer += $input->readString($val191);
              $this->attributes[$key190] = $val191;
            }
            $xfer += $input->readMapEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Hbase_getRows_args');
    if ($this->tableName !== null) {
      $xfer += $output->writeFieldBegin('tableName', TType::STRING, 1);
      $xfer += $output->writeString($this->tableName);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->rows !== null) {
      if (!is_array($this->rows)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('rows', TType::LST, 2);
      {
        $output->writeListBegin(TType::STRING, count($this->rows));
        {
          foreach ($this->rows as $iter192)
          {
            $xfer += $output->writeString($iter192);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->attributes !== null) {
      if (!is_array($this->attributes)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('attributes', TType::MAP, 3);
      {
        $output->writeMapBegin(TType::STRING, TType::STRING, count($this->attributes));
        {
          foreach ($this->attributes as $kiter193 => $viter194)
          {
            $xfer += $output->writeString($kiter193);
            $xfer += $output->writeString($viter194);
          }
        }
        $output->writeMapEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Hbase_getRows_result {
  static $_TSPEC;

  public $success = null;
  public $io = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\Hbase\TRowResult',
            ),
          ),
        1 => array(
          'var' => 'io',
          'type' => TType::STRUCT,
          'class' => '\Hbase\IOError',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['io'])) {
        $this->io = $vals['io'];
      }
    }
  }

  public function getName() {
    return 'Hbase_getRows_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size195 = 0;
            $_etype198 = 0;
            $xfer += $input->readListBegin($_etype198, $_size195);
            for ($_i199 = 0; $_i199 < $_size195; ++$_i199)
            {
              $elem200 = null;
              $elem200 = new \Hbase\TRowResult();
              $xfer += $elem200->read($input);
              $this->success []= $elem200;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->io = new \Hbase\IOError();
            $xfer += $this->io->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Hbase_getRows_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $iter201)
          {
            $xfer += $iter201->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->io !== null) {
      $xfer += $output->writeFieldBegin('io', TType::STRUCT, 1);
      $xfer += $this->io->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Hbase_getRowsWithColumns_args {
  static $_TSPEC;

  public $tableName = null;
  public $rows = null;
  public $columns = null;
  public $attributes = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'tableName',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'rows',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        3 => array(
          'var' => 'columns',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        4 => array(
          'var' => 'attributes',
          'type' => TType::MAP,
          'ktype' => TType::STRING,
          'vtype' => TType::STRING,
          'key' => array(
            'type' => TType::STRING,
          ),
          'val' => array(
            'type' => TType::STRING,
            ),
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['tableName'])) {
        $this->tableName = $vals['tableName'];
      }
      if (isset($vals['rows'])) {
        $this->rows = $vals['rows'];
      }
      if (isset($vals['columns'])) {
        $this->columns = $vals['columns'];
      }
      if (isset($vals['attributes'])) {
        $this->attributes = $vals['attributes'];
      }
    }
  }

  public function getName() {
    return 'Hbase_getRowsWithColumns_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tableName);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::LST) {
            $this->rows = array();
            $_size202 = 0;
            $_etype205 = 0;
            $xfer += $input->readListBegin($_etype205, $_size202);
            for ($_i206 = 0; $_i206 < $_size202; ++$_i206)
            {
              $elem207 = null;
              $xfer += $input->readString($elem207);
              $this->rows []= $elem207;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::LST) {
            $this->columns = array();
            $_size208 = 0;
            $_etype211 = 0;
            $xfer += $input->readListBegin($_etype211, $_size208);
            for ($_i212 = 0; $_i212 < $_size208; ++$_i212)
            {
              $elem213 = null;
              $xfer += $input->readString($elem213);
              $this->columns []= $elem213;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::MAP) {
            $this->attributes = array();
            $_size214 = 0;
            $_ktype215 = 0;
            $_vtype216 = 0;
            $xfer += $input->readMapBegin($_ktype215, $_vtype216, $_size214);
            for ($_i218 = 0; $_i218 < $_size214; ++$_i218)
            {
              $key219 = '';
              $val220 = '';
              $xfer += $input->readString($key219);
              $xfer += $input->readString($val220);
              $this->attributes[$key219] = $val220;
            }
            $xfer += $input->readMapEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Hbase_getRowsWithColumns_args');
    if ($this->tableName !== null) {
      $xfer += $output->writeFieldBegin('tableName', TType::STRING, 1);
      $xfer += $output->writeString($this->tableName);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->rows !== null) {
      if (!is_array($this->rows)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('rows', TType::LST, 2);
      {
        $output->writeListBegin(TType::STRING, count($this->rows));
        {
          foreach ($this->rows as $iter221)
          {
            $xfer += $output->writeString($iter221);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->columns !== null) {
      if (!is_array($this->columns)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('columns', TType::LST, 3);
      {
        $output->writeListBegin(TType::STRING, count($this->columns));
        {
          foreach ($this->columns as $iter222)
          {
            $xfer += $output->writeString($iter222);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->attributes !== null) {
      if (!is_array($this->attributes)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('attributes', TType::MAP, 4);
      {
        $output->writeMapBegin(TType::STRING, TType::STRING, count($this->attributes));
        {
          foreach ($this->attributes as $kiter223 => $viter224)
          {
            $xfer += $output->writeString($kiter223);
            $xfer += $output->writeString($viter224);
          }
        }
        $output->writeMapEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Hbase_getRowsWithColumns_result {
  static $_TSPEC;

  public $success = null;
  public $io = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\Hbase\TRowResult',
            ),
          ),
        1 => array(
          'var' => 'io',
          'type' => TType::STRUCT,
          'class' => '\Hbase\IOError',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['io'])) {
        $this->io = $vals['io'];
      }
    }
  }

  public function getName() {
    return 'Hbase_getRowsWithColumns_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size225 = 0;
            $_etype228 = 0;
            $xfer += $input->readListBegin($_etype228, $_size225);
            for ($_i229 = 0; $_i229 < $_size225; ++$_i229)
            {
              $elem230 = null;
              $elem230 = new \Hbase\TRowResult();
              $xfer += $elem230->read($input);
              $this->success []= $elem230;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->io = new \Hbase\IOError();
            $xfer += $this->io->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Hbase_getRowsWithColumns_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $iter231)
          {
            $xfer += $iter231->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->io !== null) {
      $xfer += $output->writeFieldBegin('io', TType::STRUCT, 1);
      $xfer += $this->io->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Hbase_getRowsTs_args {
  static $_TSPEC;

  public $tableName = null;
  public $rows = null;
  public $timestamp = null;
  public $attributes = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'tableName',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'rows',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        3 => array(
          'var' => 'timestamp',
          'type' => TType::I64,
          ),
        4 => array(
          'var' => 'attributes',
          'type' => TType::MAP,
          'ktype' => TType::STRING,
          'vtype' => TType::STRING,
          'key' => array(
            'type' => TType::STRING,
          ),
          'val' => array(
            'type' => TType::STRING,
            ),
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['tableName'])) {
        $this->tableName = $vals['tableName'];
      }
      if (isset($vals['rows'])) {
        $this->rows = $vals['rows'];
      }
      if (isset($vals['timestamp'])) {
        $this->timestamp = $vals['timestamp'];
      }
      if (isset($vals['attributes'])) {
        $this->attributes = $vals['attributes'];
      }
    }
  }

  public function getName() {
    return 'Hbase_getRowsTs_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tableName);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::LST) {
            $this->rows = array();
            $_size232 = 0;
            $_etype235 = 0;
            $xfer += $input->readListBegin($_etype235, $_size232);
            for ($_i236 = 0; $_i236 < $_size232; ++$_i236)
            {
              $elem237 = null;
              $xfer += $input->readString($elem237);
              $this->rows []= $elem237;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->timestamp);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::MAP) {
            $this->attributes = array();
            $_size238 = 0;
            $_ktype239 = 0;
            $_vtype240 = 0;
            $xfer += $input->readMapBegin($_ktype239, $_vtype240, $_size238);
            for ($_i242 = 0; $_i242 < $_size238; ++$_i242)
            {
              $key243 = '';
              $val244 = '';
              $xfer += $input->readString($key243);
              $xfer += $input->readString($val244);
              $this->attributes[$key243] = $val244;
            }
            $xfer += $input->readMapEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Hbase_getRowsTs_args');
    if ($this->tableName !== null) {
      $xfer += $output->writeFieldBegin('tableName', TType::STRING, 1);
      $xfer += $output->writeString($this->tableName);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->rows !== null) {
      if (!is_array($this->rows)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('rows', TType::LST, 2);
      {
        $output->writeListBegin(TType::STRING, count($this->rows));
        {
          foreach ($this->rows as $iter245)
          {
            $xfer += $output->writeString($iter245);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->timestamp !== null) {
      $xfer += $output->writeFieldBegin('timestamp', TType::I64, 3);
      $xfer += $output->writeI64($this->timestamp);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->attributes !== null) {
      if (!is_array($this->attributes)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('attributes', TType::MAP, 4);
      {
        $output->writeMapBegin(TType::STRING, TType::STRING, count($this->attributes));
        {
          foreach ($this->attributes as $kiter246 => $viter247)
          {
            $xfer += $output->writeString($kiter246);
            $xfer += $output->writeString($viter247);
          }
        }
        $output->writeMapEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Hbase_getRowsTs_result {
  static $_TSPEC;

  public $success = null;
  public $io = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\Hbase\TRowResult',
            ),
          ),
        1 => array(
          'var' => 'io',
          'type' => TType::STRUCT,
          'class' => '\Hbase\IOError',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['io'])) {
        $this->io = $vals['io'];
      }
    }
  }

  public function getName() {
    return 'Hbase_getRowsTs_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size248 = 0;
            $_etype251 = 0;
            $xfer += $input->readListBegin($_etype251, $_size248);
            for ($_i252 = 0; $_i252 < $_size248; ++$_i252)
            {
              $elem253 = null;
              $elem253 = new \Hbase\TRowResult();
              $xfer += $elem253->read($input);
              $this->success []= $elem253;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->io = new \Hbase\IOError();
            $xfer += $this->io->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Hbase_getRowsTs_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $iter254)
          {
            $xfer += $iter254->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->io !== null) {
      $xfer += $output->writeFieldBegin('io', TType::STRUCT, 1);
      $xfer += $this->io->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Hbase_getRowsWithColumnsTs_args {
  static $_TSPEC;

  public $tableName = null;
  public $rows = null;
  public $columns = null;
  public $timestamp = null;
  public $attributes = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'tableName',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'rows',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        3 => array(
          'var' => 'columns',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        4 => array(
          'var' => 'timestamp',
          'type' => TType::I64,
          ),
        5 => array(
          'var' => 'attributes',
          'type' => TType::MAP,
          'ktype' => TType::STRING,
          'vtype' => TType::STRING,
          'key' => array(
            'type' => TType::STRING,
          ),
          'val' => array(
            'type' => TType::STRING,
            ),
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['tableName'])) {
        $this->tableName = $vals['tableName'];
      }
      if (isset($vals['rows'])) {
        $this->rows = $vals['rows'];
      }
      if (isset($vals['columns'])) {
        $this->columns = $vals['columns'];
      }
      if (isset($vals['timestamp'])) {
        $this->timestamp = $vals['timestamp'];
      }
      if (isset($vals['attributes'])) {
        $this->attributes = $vals['attributes'];
      }
    }
  }

  public function getName() {
    return 'Hbase_getRowsWithColumnsTs_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tableName);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::LST) {
            $this->rows = array();
            $_size255 = 0;
            $_etype258 = 0;
            $xfer += $input->readListBegin($_etype258, $_size255);
            for ($_i259 = 0; $_i259 < $_size255; ++$_i259)
            {
              $elem260 = null;
              $xfer += $input->readString($elem260);
              $this->rows []= $elem260;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::LST) {
            $this->columns = array();
            $_size261 = 0;
            $_etype264 = 0;
            $xfer += $input->readListBegin($_etype264, $_size261);
            for ($_i265 = 0; $_i265 < $_size261; ++$_i265)
            {
              $elem266 = null;
              $xfer += $input->readString($elem266);
              $this->columns []= $elem266;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->timestamp);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 5:
          if ($ftype == TType::MAP) {
            $this->attributes = array();
            $_size267 = 0;
            $_ktype268 = 0;
            $_vtype269 = 0;
            $xfer += $input->readMapBegin($_ktype268, $_vtype269, $_size267);
            for ($_i271 = 0; $_i271 < $_size267; ++$_i271)
            {
              $key272 = '';
              $val273 = '';
              $xfer += $input->readString($key272);
              $xfer += $input->readString($val273);
              $this->attributes[$key272] = $val273;
            }
            $xfer += $input->readMapEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Hbase_getRowsWithColumnsTs_args');
    if ($this->tableName !== null) {
      $xfer += $output->writeFieldBegin('tableName', TType::STRING, 1);
      $xfer += $output->writeString($this->tableName);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->rows !== null) {
      if (!is_array($this->rows)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('rows', TType::LST, 2);
      {
        $output->writeListBegin(TType::STRING, count($this->rows));
        {
          foreach ($this->rows as $iter274)
          {
            $xfer += $output->writeString($iter274);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->columns !== null) {
      if (!is_array($this->columns)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('columns', TType::LST, 3);
      {
        $output->writeListBegin(TType::STRING, count($this->columns));
        {
          foreach ($this->columns as $iter275)
          {
            $xfer += $output->writeString($iter275);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->timestamp !== null) {
      $xfer += $output->writeFieldBegin('timestamp', TType::I64, 4);
      $xfer += $output->writeI64($this->timestamp);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->attributes !== null) {
      if (!is_array($this->attributes)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('attributes', TType::MAP, 5);
      {
        $output->writeMapBegin(TType::STRING, TType::STRING, count($this->attributes));
        {
          foreach ($this->attributes as $kiter276 => $viter277)
          {
            $xfer += $output->writeString($kiter276);
            $xfer += $output->writeString($viter277);
          }
        }
        $output->writeMapEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Hbase_getRowsWithColumnsTs_result {
  static $_TSPEC;

  public $success = null;
  public $io = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\Hbase\TRowResult',
            ),
          ),
        1 => array(
          'var' => 'io',
          'type' => TType::STRUCT,
          'class' => '\Hbase\IOError',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['io'])) {
        $this->io = $vals['io'];
      }
    }
  }

  public function getName() {
    return 'Hbase_getRowsWithColumnsTs_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size278 = 0;
            $_etype281 = 0;
            $xfer += $input->readListBegin($_etype281, $_size278);
            for ($_i282 = 0; $_i282 < $_size278; ++$_i282)
            {
              $elem283 = null;
              $elem283 = new \Hbase\TRowResult();
              $xfer += $elem283->read($input);
              $this->success []= $elem283;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->io = new \Hbase\IOError();
            $xfer += $this->io->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Hbase_getRowsWithColumnsTs_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $iter284)
          {
            $xfer += $iter284->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->io !== null) {
      $xfer += $output->writeFieldBegin('io', TType::STRUCT, 1);
      $xfer += $this->io->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Hbase_mutateRow_args {
  static $_TSPEC;

  public $tableName = null;
  public $row = null;
  public $mutations = null;
  public $attributes = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'tableName',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'row',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'mutations',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\Hbase\Mutation',
            ),
          ),
        4 => array(
          'var' => 'attributes',
          'type' => TType::MAP,
          'ktype' => TType::STRING,
          'vtype' => TType::STRING,
          'key' => array(
            'type' => TType::STRING,
          ),
          'val' => array(
            'type' => TType::STRING,
            ),
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['tableName'])) {
        $this->tableName = $vals['tableName'];
      }
      if (isset($vals['row'])) {
        $this->row = $vals['row'];
      }
      if (isset($vals['mutations'])) {
        $this->mutations = $vals['mutations'];
      }
      if (isset($vals['attributes'])) {
        $this->attributes = $vals['attributes'];
      }
    }
  }

  public function getName() {
    return 'Hbase_mutateRow_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tableName);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->row);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::LST) {
            $this->mutations = array();
            $_size285 = 0;
            $_etype288 = 0;
            $xfer += $input->readListBegin($_etype288, $_size285);
            for ($_i289 = 0; $_i289 < $_size285; ++$_i289)
            {
              $elem290 = null;
              $elem290 = new \Hbase\Mutation();
              $xfer += $elem290->read($input);
              $this->mutations []= $elem290;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::MAP) {
            $this->attributes = array();
            $_size291 = 0;
            $_ktype292 = 0;
            $_vtype293 = 0;
            $xfer += $input->readMapBegin($_ktype292, $_vtype293, $_size291);
            for ($_i295 = 0; $_i295 < $_size291; ++$_i295)
            {
              $key296 = '';
              $val297 = '';
              $xfer += $input->readString($key296);
              $xfer += $input->readString($val297);
              $this->attributes[$key296] = $val297;
            }
            $xfer += $input->readMapEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Hbase_mutateRow_args');
    if ($this->tableName !== null) {
      $xfer += $output->writeFieldBegin('tableName', TType::STRING, 1);
      $xfer += $output->writeString($this->tableName);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->row !== null) {
      $xfer += $output->writeFieldBegin('row', TType::STRING, 2);
      $xfer += $output->writeString($this->row);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->mutations !== null) {
      if (!is_array($this->mutations)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('mutations', TType::LST, 3);
      {
        $output->writeListBegin(TType::STRUCT, count($this->mutations));
        {
          foreach ($this->mutations as $iter298)
          {
            $xfer += $iter298->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->attributes !== null) {
      if (!is_array($this->attributes)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('attributes', TType::MAP, 4);
      {
        $output->writeMapBegin(TType::STRING, TType::STRING, count($this->attributes));
        {
          foreach ($this->attributes as $kiter299 => $viter300)
          {
            $xfer += $output->writeString($kiter299);
            $xfer += $output->writeString($viter300);
          }
        }
        $output->writeMapEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Hbase_mutateRow_result {
  static $_TSPEC;

  public $io = null;
  public $ia = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'io',
          'type' => TType::STRUCT,
          'class' => '\Hbase\IOError',
          ),
        2 => array(
          'var' => 'ia',
          'type' => TType::STRUCT,
          'class' => '\Hbase\IllegalArgument',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['io'])) {
        $this->io = $vals['io'];
      }
      if (isset($vals['ia'])) {
        $this->ia = $vals['ia'];
      }
    }
  }

  public function getName() {
    return 'Hbase_mutateRow_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->io = new \Hbase\IOError();
            $xfer += $this->io->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ia = new \Hbase\IllegalArgument();
            $xfer += $this->ia->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Hbase_mutateRow_result');
    if ($this->io !== null) {
      $xfer += $output->writeFieldBegin('io', TType::STRUCT, 1);
      $xfer += $this->io->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ia !== null) {
      $xfer += $output->writeFieldBegin('ia', TType::STRUCT, 2);
      $xfer += $this->ia->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Hbase_mutateRowTs_args {
  static $_TSPEC;

  public $tableName = null;
  public $row = null;
  public $mutations = null;
  public $timestamp = null;
  public $attributes = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'tableName',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'row',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'mutations',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\Hbase\Mutation',
            ),
          ),
        4 => array(
          'var' => 'timestamp',
          'type' => TType::I64,
          ),
        5 => array(
          'var' => 'attributes',
          'type' => TType::MAP,
          'ktype' => TType::STRING,
          'vtype' => TType::STRING,
          'key' => array(
            'type' => TType::STRING,
          ),
          'val' => array(
            'type' => TType::STRING,
            ),
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['tableName'])) {
        $this->tableName = $vals['tableName'];
      }
      if (isset($vals['row'])) {
        $this->row = $vals['row'];
      }
      if (isset($vals['mutations'])) {
        $this->mutations = $vals['mutations'];
      }
      if (isset($vals['timestamp'])) {
        $this->timestamp = $vals['timestamp'];
      }
      if (isset($vals['attributes'])) {
        $this->attributes = $vals['attributes'];
      }
    }
  }

  public function getName() {
    return 'Hbase_mutateRowTs_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tableName);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->row);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::LST) {
            $this->mutations = array();
            $_size301 = 0;
            $_etype304 = 0;
            $xfer += $input->readListBegin($_etype304, $_size301);
            for ($_i305 = 0; $_i305 < $_size301; ++$_i305)
            {
              $elem306 = null;
              $elem306 = new \Hbase\Mutation();
              $xfer += $elem306->read($input);
              $this->mutations []= $elem306;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->timestamp);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 5:
          if ($ftype == TType::MAP) {
            $this->attributes = array();
            $_size307 = 0;
            $_ktype308 = 0;
            $_vtype309 = 0;
            $xfer += $input->readMapBegin($_ktype308, $_vtype309, $_size307);
            for ($_i311 = 0; $_i311 < $_size307; ++$_i311)
            {
              $key312 = '';
              $val313 = '';
              $xfer += $input->readString($key312);
              $xfer += $input->readString($val313);
              $this->attributes[$key312] = $val313;
            }
            $xfer += $input->readMapEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Hbase_mutateRowTs_args');
    if ($this->tableName !== null) {
      $xfer += $output->writeFieldBegin('tableName', TType::STRING, 1);
      $xfer += $output->writeString($this->tableName);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->row !== null) {
      $xfer += $output->writeFieldBegin('row', TType::STRING, 2);
      $xfer += $output->writeString($this->row);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->mutations !== null) {
      if (!is_array($this->mutations)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('mutations', TType::LST, 3);
      {
        $output->writeListBegin(TType::STRUCT, count($this->mutations));
        {
          foreach ($this->mutations as $iter314)
          {
            $xfer += $iter314->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->timestamp !== null) {
      $xfer += $output->writeFieldBegin('timestamp', TType::I64, 4);
      $xfer += $output->writeI64($this->timestamp);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->attributes !== null) {
      if (!is_array($this->attributes)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('attributes', TType::MAP, 5);
      {
        $output->writeMapBegin(TType::STRING, TType::STRING, count($this->attributes));
        {
          foreach ($this->attributes as $kiter315 => $viter316)
          {
            $xfer += $output->writeString($kiter315);
            $xfer += $output->writeString($viter316);
          }
        }
        $output->writeMapEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Hbase_mutateRowTs_result {
  static $_TSPEC;

  public $io = null;
  public $ia = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'io',
          'type' => TType::STRUCT,
          'class' => '\Hbase\IOError',
          ),
        2 => array(
          'var' => 'ia',
          'type' => TType::STRUCT,
          'class' => '\Hbase\IllegalArgument',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['io'])) {
        $this->io = $vals['io'];
      }
      if (isset($vals['ia'])) {
        $this->ia = $vals['ia'];
      }
    }
  }

  public function getName() {
    return 'Hbase_mutateRowTs_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->io = new \Hbase\IOError();
            $xfer += $this->io->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ia = new \Hbase\IllegalArgument();
            $xfer += $this->ia->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Hbase_mutateRowTs_result');
    if ($this->io !== null) {
      $xfer += $output->writeFieldBegin('io', TType::STRUCT, 1);
      $xfer += $this->io->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ia !== null) {
      $xfer += $output->writeFieldBegin('ia', TType::STRUCT, 2);
      $xfer += $this->ia->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Hbase_mutateRows_args {
  static $_TSPEC;

  public $tableName = null;
  public $rowBatches = null;
  public $attributes = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'tableName',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'rowBatches',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\Hbase\BatchMutation',
            ),
          ),
        3 => array(
          'var' => 'attributes',
          'type' => TType::MAP,
          'ktype' => TType::STRING,
          'vtype' => TType::STRING,
          'key' => array(
            'type' => TType::STRING,
          ),
          'val' => array(
            'type' => TType::STRING,
            ),
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['tableName'])) {
        $this->tableName = $vals['tableName'];
      }
      if (isset($vals['rowBatches'])) {
        $this->rowBatches = $vals['rowBatches'];
      }
      if (isset($vals['attributes'])) {
        $this->attributes = $vals['attributes'];
      }
    }
  }

  public function getName() {
    return 'Hbase_mutateRows_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tableName);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::LST) {
            $this->rowBatches = array();
            $_size317 = 0;
            $_etype320 = 0;
            $xfer += $input->readListBegin($_etype320, $_size317);
            for ($_i321 = 0; $_i321 < $_size317; ++$_i321)
            {
              $elem322 = null;
              $elem322 = new \Hbase\BatchMutation();
              $xfer += $elem322->read($input);
              $this->rowBatches []= $elem322;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::MAP) {
            $this->attributes = array();
            $_size323 = 0;
            $_ktype324 = 0;
            $_vtype325 = 0;
            $xfer += $input->readMapBegin($_ktype324, $_vtype325, $_size323);
            for ($_i327 = 0; $_i327 < $_size323; ++$_i327)
            {
              $key328 = '';
              $val329 = '';
              $xfer += $input->readString($key328);
              $xfer += $input->readString($val329);
              $this->attributes[$key328] = $val329;
            }
            $xfer += $input->readMapEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Hbase_mutateRows_args');
    if ($this->tableName !== null) {
      $xfer += $output->writeFieldBegin('tableName', TType::STRING, 1);
      $xfer += $output->writeString($this->tableName);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->rowBatches !== null) {
      if (!is_array($this->rowBatches)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('rowBatches', TType::LST, 2);
      {
        $output->writeListBegin(TType::STRUCT, count($this->rowBatches));
        {
          foreach ($this->rowBatches as $iter330)
          {
            $xfer += $iter330->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->attributes !== null) {
      if (!is_array($this->attributes)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('attributes', TType::MAP, 3);
      {
        $output->writeMapBegin(TType::STRING, TType::STRING, count($this->attributes));
        {
          foreach ($this->attributes as $kiter331 => $viter332)
          {
            $xfer += $output->writeString($kiter331);
            $xfer += $output->writeString($viter332);
          }
        }
        $output->writeMapEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Hbase_mutateRows_result {
  static $_TSPEC;

  public $io = null;
  public $ia = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'io',
          'type' => TType::STRUCT,
          'class' => '\Hbase\IOError',
          ),
        2 => array(
          'var' => 'ia',
          'type' => TType::STRUCT,
          'class' => '\Hbase\IllegalArgument',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['io'])) {
        $this->io = $vals['io'];
      }
      if (isset($vals['ia'])) {
        $this->ia = $vals['ia'];
      }
    }
  }

  public function getName() {
    return 'Hbase_mutateRows_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->io = new \Hbase\IOError();
            $xfer += $this->io->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ia = new \Hbase\IllegalArgument();
            $xfer += $this->ia->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Hbase_mutateRows_result');
    if ($this->io !== null) {
      $xfer += $output->writeFieldBegin('io', TType::STRUCT, 1);
      $xfer += $this->io->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ia !== null) {
      $xfer += $output->writeFieldBegin('ia', TType::STRUCT, 2);
      $xfer += $this->ia->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Hbase_mutateRowsTs_args {
  static $_TSPEC;

  public $tableName = null;
  public $rowBatches = null;
  public $timestamp = null;
  public $attributes = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'tableName',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'rowBatches',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\Hbase\BatchMutation',
            ),
          ),
        3 => array(
          'var' => 'timestamp',
          'type' => TType::I64,
          ),
        4 => array(
          'var' => 'attributes',
          'type' => TType::MAP,
          'ktype' => TType::STRING,
          'vtype' => TType::STRING,
          'key' => array(
            'type' => TType::STRING,
          ),
          'val' => array(
            'type' => TType::STRING,
            ),
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['tableName'])) {
        $this->tableName = $vals['tableName'];
      }
      if (isset($vals['rowBatches'])) {
        $this->rowBatches = $vals['rowBatches'];
      }
      if (isset($vals['timestamp'])) {
        $this->timestamp = $vals['timestamp'];
      }
      if (isset($vals['attributes'])) {
        $this->attributes = $vals['attributes'];
      }
    }
  }

  public function getName() {
    return 'Hbase_mutateRowsTs_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tableName);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::LST) {
            $this->rowBatches = array();
            $_size333 = 0;
            $_etype336 = 0;
            $xfer += $input->readListBegin($_etype336, $_size333);
            for ($_i337 = 0; $_i337 < $_size333; ++$_i337)
            {
              $elem338 = null;
              $elem338 = new \Hbase\BatchMutation();
              $xfer += $elem338->read($input);
              $this->rowBatches []= $elem338;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->timestamp);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::MAP) {
            $this->attributes = array();
            $_size339 = 0;
            $_ktype340 = 0;
            $_vtype341 = 0;
            $xfer += $input->readMapBegin($_ktype340, $_vtype341, $_size339);
            for ($_i343 = 0; $_i343 < $_size339; ++$_i343)
            {
              $key344 = '';
              $val345 = '';
              $xfer += $input->readString($key344);
              $xfer += $input->readString($val345);
              $this->attributes[$key344] = $val345;
            }
            $xfer += $input->readMapEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Hbase_mutateRowsTs_args');
    if ($this->tableName !== null) {
      $xfer += $output->writeFieldBegin('tableName', TType::STRING, 1);
      $xfer += $output->writeString($this->tableName);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->rowBatches !== null) {
      if (!is_array($this->rowBatches)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('rowBatches', TType::LST, 2);
      {
        $output->writeListBegin(TType::STRUCT, count($this->rowBatches));
        {
          foreach ($this->rowBatches as $iter346)
          {
            $xfer += $iter346->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->timestamp !== null) {
      $xfer += $output->writeFieldBegin('timestamp', TType::I64, 3);
      $xfer += $output->writeI64($this->timestamp);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->attributes !== null) {
      if (!is_array($this->attributes)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('attributes', TType::MAP, 4);
      {
        $output->writeMapBegin(TType::STRING, TType::STRING, count($this->attributes));
        {
          foreach ($this->attributes as $kiter347 => $viter348)
          {
            $xfer += $output->writeString($kiter347);
            $xfer += $output->writeString($viter348);
          }
        }
        $output->writeMapEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Hbase_mutateRowsTs_result {
  static $_TSPEC;

  public $io = null;
  public $ia = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'io',
          'type' => TType::STRUCT,
          'class' => '\Hbase\IOError',
          ),
        2 => array(
          'var' => 'ia',
          'type' => TType::STRUCT,
          'class' => '\Hbase\IllegalArgument',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['io'])) {
        $this->io = $vals['io'];
      }
      if (isset($vals['ia'])) {
        $this->ia = $vals['ia'];
      }
    }
  }

  public function getName() {
    return 'Hbase_mutateRowsTs_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->io = new \Hbase\IOError();
            $xfer += $this->io->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ia = new \Hbase\IllegalArgument();
            $xfer += $this->ia->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Hbase_mutateRowsTs_result');
    if ($this->io !== null) {
      $xfer += $output->writeFieldBegin('io', TType::STRUCT, 1);
      $xfer += $this->io->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ia !== null) {
      $xfer += $output->writeFieldBegin('ia', TType::STRUCT, 2);
      $xfer += $this->ia->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Hbase_atomicIncrement_args {
  static $_TSPEC;

  public $tableName = null;
  public $row = null;
  public $column = null;
  public $value = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'tableName',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'row',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'column',
          'type' => TType::STRING,
          ),
        4 => array(
          'var' => 'value',
          'type' => TType::I64,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['tableName'])) {
        $this->tableName = $vals['tableName'];
      }
      if (isset($vals['row'])) {
        $this->row = $vals['row'];
      }
      if (isset($vals['column'])) {
        $this->column = $vals['column'];
      }
      if (isset($vals['value'])) {
        $this->value = $vals['value'];
      }
    }
  }

  public function getName() {
    return 'Hbase_atomicIncrement_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tableName);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->row);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->column);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->value);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Hbase_atomicIncrement_args');
    if ($this->tableName !== null) {
      $xfer += $output->writeFieldBegin('tableName', TType::STRING, 1);
      $xfer += $output->writeString($this->tableName);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->row !== null) {
      $xfer += $output->writeFieldBegin('row', TType::STRING, 2);
      $xfer += $output->writeString($this->row);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->column !== null) {
      $xfer += $output->writeFieldBegin('column', TType::STRING, 3);
      $xfer += $output->writeString($this->column);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->value !== null) {
      $xfer += $output->writeFieldBegin('value', TType::I64, 4);
      $xfer += $output->writeI64($this->value);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Hbase_atomicIncrement_result {
  static $_TSPEC;

  public $success = null;
  public $io = null;
  public $ia = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::I64,
          ),
        1 => array(
          'var' => 'io',
          'type' => TType::STRUCT,
          'class' => '\Hbase\IOError',
          ),
        2 => array(
          'var' => 'ia',
          'type' => TType::STRUCT,
          'class' => '\Hbase\IllegalArgument',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['io'])) {
        $this->io = $vals['io'];
      }
      if (isset($vals['ia'])) {
        $this->ia = $vals['ia'];
      }
    }
  }

  public function getName() {
    return 'Hbase_atomicIncrement_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->io = new \Hbase\IOError();
            $xfer += $this->io->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ia = new \Hbase\IllegalArgument();
            $xfer += $this->ia->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Hbase_atomicIncrement_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::I64, 0);
      $xfer += $output->writeI64($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->io !== null) {
      $xfer += $output->writeFieldBegin('io', TType::STRUCT, 1);
      $xfer += $this->io->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ia !== null) {
      $xfer += $output->writeFieldBegin('ia', TType::STRUCT, 2);
      $xfer += $this->ia->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Hbase_deleteAll_args {
  static $_TSPEC;

  public $tableName = null;
  public $row = null;
  public $column = null;
  public $attributes = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'tableName',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'row',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'column',
          'type' => TType::STRING,
          ),
        4 => array(
          'var' => 'attributes',
          'type' => TType::MAP,
          'ktype' => TType::STRING,
          'vtype' => TType::STRING,
          'key' => array(
            'type' => TType::STRING,
          ),
          'val' => array(
            'type' => TType::STRING,
            ),
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['tableName'])) {
        $this->tableName = $vals['tableName'];
      }
      if (isset($vals['row'])) {
        $this->row = $vals['row'];
      }
      if (isset($vals['column'])) {
        $this->column = $vals['column'];
      }
      if (isset($vals['attributes'])) {
        $this->attributes = $vals['attributes'];
      }
    }
  }

  public function getName() {
    return 'Hbase_deleteAll_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tableName);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->row);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->column);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::MAP) {
            $this->attributes = array();
            $_size349 = 0;
            $_ktype350 = 0;
            $_vtype351 = 0;
            $xfer += $input->readMapBegin($_ktype350, $_vtype351, $_size349);
            for ($_i353 = 0; $_i353 < $_size349; ++$_i353)
            {
              $key354 = '';
              $val355 = '';
              $xfer += $input->readString($key354);
              $xfer += $input->readString($val355);
              $this->attributes[$key354] = $val355;
            }
            $xfer += $input->readMapEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Hbase_deleteAll_args');
    if ($this->tableName !== null) {
      $xfer += $output->writeFieldBegin('tableName', TType::STRING, 1);
      $xfer += $output->writeString($this->tableName);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->row !== null) {
      $xfer += $output->writeFieldBegin('row', TType::STRING, 2);
      $xfer += $output->writeString($this->row);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->column !== null) {
      $xfer += $output->writeFieldBegin('column', TType::STRING, 3);
      $xfer += $output->writeString($this->column);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->attributes !== null) {
      if (!is_array($this->attributes)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('attributes', TType::MAP, 4);
      {
        $output->writeMapBegin(TType::STRING, TType::STRING, count($this->attributes));
        {
          foreach ($this->attributes as $kiter356 => $viter357)
          {
            $xfer += $output->writeString($kiter356);
            $xfer += $output->writeString($viter357);
          }
        }
        $output->writeMapEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Hbase_deleteAll_result {
  static $_TSPEC;

  public $io = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'io',
          'type' => TType::STRUCT,
          'class' => '\Hbase\IOError',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['io'])) {
        $this->io = $vals['io'];
      }
    }
  }

  public function getName() {
    return 'Hbase_deleteAll_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->io = new \Hbase\IOError();
            $xfer += $this->io->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Hbase_deleteAll_result');
    if ($this->io !== null) {
      $xfer += $output->writeFieldBegin('io', TType::STRUCT, 1);
      $xfer += $this->io->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Hbase_deleteAllTs_args {
  static $_TSPEC;

  public $tableName = null;
  public $row = null;
  public $column = null;
  public $timestamp = null;
  public $attributes = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'tableName',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'row',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'column',
          'type' => TType::STRING,
          ),
        4 => array(
          'var' => 'timestamp',
          'type' => TType::I64,
          ),
        5 => array(
          'var' => 'attributes',
          'type' => TType::MAP,
          'ktype' => TType::STRING,
          'vtype' => TType::STRING,
          'key' => array(
            'type' => TType::STRING,
          ),
          'val' => array(
            'type' => TType::STRING,
            ),
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['tableName'])) {
        $this->tableName = $vals['tableName'];
      }
      if (isset($vals['row'])) {
        $this->row = $vals['row'];
      }
      if (isset($vals['column'])) {
        $this->column = $vals['column'];
      }
      if (isset($vals['timestamp'])) {
        $this->timestamp = $vals['timestamp'];
      }
      if (isset($vals['attributes'])) {
        $this->attributes = $vals['attributes'];
      }
    }
  }

  public function getName() {
    return 'Hbase_deleteAllTs_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tableName);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->row);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->column);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->timestamp);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 5:
          if ($ftype == TType::MAP) {
            $this->attributes = array();
            $_size358 = 0;
            $_ktype359 = 0;
            $_vtype360 = 0;
            $xfer += $input->readMapBegin($_ktype359, $_vtype360, $_size358);
            for ($_i362 = 0; $_i362 < $_size358; ++$_i362)
            {
              $key363 = '';
              $val364 = '';
              $xfer += $input->readString($key363);
              $xfer += $input->readString($val364);
              $this->attributes[$key363] = $val364;
            }
            $xfer += $input->readMapEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Hbase_deleteAllTs_args');
    if ($this->tableName !== null) {
      $xfer += $output->writeFieldBegin('tableName', TType::STRING, 1);
      $xfer += $output->writeString($this->tableName);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->row !== null) {
      $xfer += $output->writeFieldBegin('row', TType::STRING, 2);
      $xfer += $output->writeString($this->row);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->column !== null) {
      $xfer += $output->writeFieldBegin('column', TType::STRING, 3);
      $xfer += $output->writeString($this->column);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->timestamp !== null) {
      $xfer += $output->writeFieldBegin('timestamp', TType::I64, 4);
      $xfer += $output->writeI64($this->timestamp);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->attributes !== null) {
      if (!is_array($this->attributes)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('attributes', TType::MAP, 5);
      {
        $output->writeMapBegin(TType::STRING, TType::STRING, count($this->attributes));
        {
          foreach ($this->attributes as $kiter365 => $viter366)
          {
            $xfer += $output->writeString($kiter365);
            $xfer += $output->writeString($viter366);
          }
        }
        $output->writeMapEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Hbase_deleteAllTs_result {
  static $_TSPEC;

  public $io = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'io',
          'type' => TType::STRUCT,
          'class' => '\Hbase\IOError',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['io'])) {
        $this->io = $vals['io'];
      }
    }
  }

  public function getName() {
    return 'Hbase_deleteAllTs_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->io = new \Hbase\IOError();
            $xfer += $this->io->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Hbase_deleteAllTs_result');
    if ($this->io !== null) {
      $xfer += $output->writeFieldBegin('io', TType::STRUCT, 1);
      $xfer += $this->io->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Hbase_deleteAllRow_args {
  static $_TSPEC;

  public $tableName = null;
  public $row = null;
  public $attributes = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'tableName',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'row',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'attributes',
          'type' => TType::MAP,
          'ktype' => TType::STRING,
          'vtype' => TType::STRING,
          'key' => array(
            'type' => TType::STRING,
          ),
          'val' => array(
            'type' => TType::STRING,
            ),
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['tableName'])) {
        $this->tableName = $vals['tableName'];
      }
      if (isset($vals['row'])) {
        $this->row = $vals['row'];
      }
      if (isset($vals['attributes'])) {
        $this->attributes = $vals['attributes'];
      }
    }
  }

  public function getName() {
    return 'Hbase_deleteAllRow_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tableName);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->row);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::MAP) {
            $this->attributes = array();
            $_size367 = 0;
            $_ktype368 = 0;
            $_vtype369 = 0;
            $xfer += $input->readMapBegin($_ktype368, $_vtype369, $_size367);
            for ($_i371 = 0; $_i371 < $_size367; ++$_i371)
            {
              $key372 = '';
              $val373 = '';
              $xfer += $input->readString($key372);
              $xfer += $input->readString($val373);
              $this->attributes[$key372] = $val373;
            }
            $xfer += $input->readMapEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Hbase_deleteAllRow_args');
    if ($this->tableName !== null) {
      $xfer += $output->writeFieldBegin('tableName', TType::STRING, 1);
      $xfer += $output->writeString($this->tableName);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->row !== null) {
      $xfer += $output->writeFieldBegin('row', TType::STRING, 2);
      $xfer += $output->writeString($this->row);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->attributes !== null) {
      if (!is_array($this->attributes)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('attributes', TType::MAP, 3);
      {
        $output->writeMapBegin(TType::STRING, TType::STRING, count($this->attributes));
        {
          foreach ($this->attributes as $kiter374 => $viter375)
          {
            $xfer += $output->writeString($kiter374);
            $xfer += $output->writeString($viter375);
          }
        }
        $output->writeMapEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Hbase_deleteAllRow_result {
  static $_TSPEC;

  public $io = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'io',
          'type' => TType::STRUCT,
          'class' => '\Hbase\IOError',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['io'])) {
        $this->io = $vals['io'];
      }
    }
  }

  public function getName() {
    return 'Hbase_deleteAllRow_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->io = new \Hbase\IOError();
            $xfer += $this->io->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Hbase_deleteAllRow_result');
    if ($this->io !== null) {
      $xfer += $output->writeFieldBegin('io', TType::STRUCT, 1);
      $xfer += $this->io->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Hbase_increment_args {
  static $_TSPEC;

  public $increment = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'increment',
          'type' => TType::STRUCT,
          'class' => '\Hbase\TIncrement',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['increment'])) {
        $this->increment = $vals['increment'];
      }
    }
  }

  public function getName() {
    return 'Hbase_increment_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->increment = new \Hbase\TIncrement();
            $xfer += $this->increment->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Hbase_increment_args');
    if ($this->increment !== null) {
      if (!is_object($this->increment)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('increment', TType::STRUCT, 1);
      $xfer += $this->increment->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Hbase_increment_result {
  static $_TSPEC;

  public $io = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'io',
          'type' => TType::STRUCT,
          'class' => '\Hbase\IOError',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['io'])) {
        $this->io = $vals['io'];
      }
    }
  }

  public function getName() {
    return 'Hbase_increment_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->io = new \Hbase\IOError();
            $xfer += $this->io->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Hbase_increment_result');
    if ($this->io !== null) {
      $xfer += $output->writeFieldBegin('io', TType::STRUCT, 1);
      $xfer += $this->io->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Hbase_incrementRows_args {
  static $_TSPEC;

  public $increments = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'increments',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\Hbase\TIncrement',
            ),
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['increments'])) {
        $this->increments = $vals['increments'];
      }
    }
  }

  public function getName() {
    return 'Hbase_incrementRows_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::LST) {
            $this->increments = array();
            $_size376 = 0;
            $_etype379 = 0;
            $xfer += $input->readListBegin($_etype379, $_size376);
            for ($_i380 = 0; $_i380 < $_size376; ++$_i380)
            {
              $elem381 = null;
              $elem381 = new \Hbase\TIncrement();
              $xfer += $elem381->read($input);
              $this->increments []= $elem381;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Hbase_incrementRows_args');
    if ($this->increments !== null) {
      if (!is_array($this->increments)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('increments', TType::LST, 1);
      {
        $output->writeListBegin(TType::STRUCT, count($this->increments));
        {
          foreach ($this->increments as $iter382)
          {
            $xfer += $iter382->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Hbase_incrementRows_result {
  static $_TSPEC;

  public $io = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'io',
          'type' => TType::STRUCT,
          'class' => '\Hbase\IOError',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['io'])) {
        $this->io = $vals['io'];
      }
    }
  }

  public function getName() {
    return 'Hbase_incrementRows_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->io = new \Hbase\IOError();
            $xfer += $this->io->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Hbase_incrementRows_result');
    if ($this->io !== null) {
      $xfer += $output->writeFieldBegin('io', TType::STRUCT, 1);
      $xfer += $this->io->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Hbase_deleteAllRowTs_args {
  static $_TSPEC;

  public $tableName = null;
  public $row = null;
  public $timestamp = null;
  public $attributes = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'tableName',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'row',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'timestamp',
          'type' => TType::I64,
          ),
        4 => array(
          'var' => 'attributes',
          'type' => TType::MAP,
          'ktype' => TType::STRING,
          'vtype' => TType::STRING,
          'key' => array(
            'type' => TType::STRING,
          ),
          'val' => array(
            'type' => TType::STRING,
            ),
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['tableName'])) {
        $this->tableName = $vals['tableName'];
      }
      if (isset($vals['row'])) {
        $this->row = $vals['row'];
      }
      if (isset($vals['timestamp'])) {
        $this->timestamp = $vals['timestamp'];
      }
      if (isset($vals['attributes'])) {
        $this->attributes = $vals['attributes'];
      }
    }
  }

  public function getName() {
    return 'Hbase_deleteAllRowTs_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tableName);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->row);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->timestamp);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::MAP) {
            $this->attributes = array();
            $_size383 = 0;
            $_ktype384 = 0;
            $_vtype385 = 0;
            $xfer += $input->readMapBegin($_ktype384, $_vtype385, $_size383);
            for ($_i387 = 0; $_i387 < $_size383; ++$_i387)
            {
              $key388 = '';
              $val389 = '';
              $xfer += $input->readString($key388);
              $xfer += $input->readString($val389);
              $this->attributes[$key388] = $val389;
            }
            $xfer += $input->readMapEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Hbase_deleteAllRowTs_args');
    if ($this->tableName !== null) {
      $xfer += $output->writeFieldBegin('tableName', TType::STRING, 1);
      $xfer += $output->writeString($this->tableName);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->row !== null) {
      $xfer += $output->writeFieldBegin('row', TType::STRING, 2);
      $xfer += $output->writeString($this->row);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->timestamp !== null) {
      $xfer += $output->writeFieldBegin('timestamp', TType::I64, 3);
      $xfer += $output->writeI64($this->timestamp);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->attributes !== null) {
      if (!is_array($this->attributes)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('attributes', TType::MAP, 4);
      {
        $output->writeMapBegin(TType::STRING, TType::STRING, count($this->attributes));
        {
          foreach ($this->attributes as $kiter390 => $viter391)
          {
            $xfer += $output->writeString($kiter390);
            $xfer += $output->writeString($viter391);
          }
        }
        $output->writeMapEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Hbase_deleteAllRowTs_result {
  static $_TSPEC;

  public $io = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'io',
          'type' => TType::STRUCT,
          'class' => '\Hbase\IOError',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['io'])) {
        $this->io = $vals['io'];
      }
    }
  }

  public function getName() {
    return 'Hbase_deleteAllRowTs_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->io = new \Hbase\IOError();
            $xfer += $this->io->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Hbase_deleteAllRowTs_result');
    if ($this->io !== null) {
      $xfer += $output->writeFieldBegin('io', TType::STRUCT, 1);
      $xfer += $this->io->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Hbase_scannerOpenWithScan_args {
  static $_TSPEC;

  public $tableName = null;
  public $scan = null;
  public $attributes = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'tableName',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'scan',
          'type' => TType::STRUCT,
          'class' => '\Hbase\TScan',
          ),
        3 => array(
          'var' => 'attributes',
          'type' => TType::MAP,
          'ktype' => TType::STRING,
          'vtype' => TType::STRING,
          'key' => array(
            'type' => TType::STRING,
          ),
          'val' => array(
            'type' => TType::STRING,
            ),
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['tableName'])) {
        $this->tableName = $vals['tableName'];
      }
      if (isset($vals['scan'])) {
        $this->scan = $vals['scan'];
      }
      if (isset($vals['attributes'])) {
        $this->attributes = $vals['attributes'];
      }
    }
  }

  public function getName() {
    return 'Hbase_scannerOpenWithScan_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tableName);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->scan = new \Hbase\TScan();
            $xfer += $this->scan->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::MAP) {
            $this->attributes = array();
            $_size392 = 0;
            $_ktype393 = 0;
            $_vtype394 = 0;
            $xfer += $input->readMapBegin($_ktype393, $_vtype394, $_size392);
            for ($_i396 = 0; $_i396 < $_size392; ++$_i396)
            {
              $key397 = '';
              $val398 = '';
              $xfer += $input->readString($key397);
              $xfer += $input->readString($val398);
              $this->attributes[$key397] = $val398;
            }
            $xfer += $input->readMapEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Hbase_scannerOpenWithScan_args');
    if ($this->tableName !== null) {
      $xfer += $output->writeFieldBegin('tableName', TType::STRING, 1);
      $xfer += $output->writeString($this->tableName);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->scan !== null) {
      if (!is_object($this->scan)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('scan', TType::STRUCT, 2);
      $xfer += $this->scan->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->attributes !== null) {
      if (!is_array($this->attributes)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('attributes', TType::MAP, 3);
      {
        $output->writeMapBegin(TType::STRING, TType::STRING, count($this->attributes));
        {
          foreach ($this->attributes as $kiter399 => $viter400)
          {
            $xfer += $output->writeString($kiter399);
            $xfer += $output->writeString($viter400);
          }
        }
        $output->writeMapEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Hbase_scannerOpenWithScan_result {
  static $_TSPEC;

  public $success = null;
  public $io = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::I32,
          ),
        1 => array(
          'var' => 'io',
          'type' => TType::STRUCT,
          'class' => '\Hbase\IOError',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['io'])) {
        $this->io = $vals['io'];
      }
    }
  }

  public function getName() {
    return 'Hbase_scannerOpenWithScan_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->io = new \Hbase\IOError();
            $xfer += $this->io->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Hbase_scannerOpenWithScan_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::I32, 0);
      $xfer += $output->writeI32($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->io !== null) {
      $xfer += $output->writeFieldBegin('io', TType::STRUCT, 1);
      $xfer += $this->io->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Hbase_scannerOpen_args {
  static $_TSPEC;

  public $tableName = null;
  public $startRow = null;
  public $columns = null;
  public $attributes = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'tableName',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'startRow',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'columns',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        4 => array(
          'var' => 'attributes',
          'type' => TType::MAP,
          'ktype' => TType::STRING,
          'vtype' => TType::STRING,
          'key' => array(
            'type' => TType::STRING,
          ),
          'val' => array(
            'type' => TType::STRING,
            ),
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['tableName'])) {
        $this->tableName = $vals['tableName'];
      }
      if (isset($vals['startRow'])) {
        $this->startRow = $vals['startRow'];
      }
      if (isset($vals['columns'])) {
        $this->columns = $vals['columns'];
      }
      if (isset($vals['attributes'])) {
        $this->attributes = $vals['attributes'];
      }
    }
  }

  public function getName() {
    return 'Hbase_scannerOpen_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tableName);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->startRow);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::LST) {
            $this->columns = array();
            $_size401 = 0;
            $_etype404 = 0;
            $xfer += $input->readListBegin($_etype404, $_size401);
            for ($_i405 = 0; $_i405 < $_size401; ++$_i405)
            {
              $elem406 = null;
              $xfer += $input->readString($elem406);
              $this->columns []= $elem406;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::MAP) {
            $this->attributes = array();
            $_size407 = 0;
            $_ktype408 = 0;
            $_vtype409 = 0;
            $xfer += $input->readMapBegin($_ktype408, $_vtype409, $_size407);
            for ($_i411 = 0; $_i411 < $_size407; ++$_i411)
            {
              $key412 = '';
              $val413 = '';
              $xfer += $input->readString($key412);
              $xfer += $input->readString($val413);
              $this->attributes[$key412] = $val413;
            }
            $xfer += $input->readMapEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Hbase_scannerOpen_args');
    if ($this->tableName !== null) {
      $xfer += $output->writeFieldBegin('tableName', TType::STRING, 1);
      $xfer += $output->writeString($this->tableName);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->startRow !== null) {
      $xfer += $output->writeFieldBegin('startRow', TType::STRING, 2);
      $xfer += $output->writeString($this->startRow);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->columns !== null) {
      if (!is_array($this->columns)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('columns', TType::LST, 3);
      {
        $output->writeListBegin(TType::STRING, count($this->columns));
        {
          foreach ($this->columns as $iter414)
          {
            $xfer += $output->writeString($iter414);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->attributes !== null) {
      if (!is_array($this->attributes)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('attributes', TType::MAP, 4);
      {
        $output->writeMapBegin(TType::STRING, TType::STRING, count($this->attributes));
        {
          foreach ($this->attributes as $kiter415 => $viter416)
          {
            $xfer += $output->writeString($kiter415);
            $xfer += $output->writeString($viter416);
          }
        }
        $output->writeMapEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Hbase_scannerOpen_result {
  static $_TSPEC;

  public $success = null;
  public $io = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::I32,
          ),
        1 => array(
          'var' => 'io',
          'type' => TType::STRUCT,
          'class' => '\Hbase\IOError',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['io'])) {
        $this->io = $vals['io'];
      }
    }
  }

  public function getName() {
    return 'Hbase_scannerOpen_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->io = new \Hbase\IOError();
            $xfer += $this->io->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Hbase_scannerOpen_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::I32, 0);
      $xfer += $output->writeI32($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->io !== null) {
      $xfer += $output->writeFieldBegin('io', TType::STRUCT, 1);
      $xfer += $this->io->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Hbase_scannerOpenWithStop_args {
  static $_TSPEC;

  public $tableName = null;
  public $startRow = null;
  public $stopRow = null;
  public $columns = null;
  public $attributes = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'tableName',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'startRow',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'stopRow',
          'type' => TType::STRING,
          ),
        4 => array(
          'var' => 'columns',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        5 => array(
          'var' => 'attributes',
          'type' => TType::MAP,
          'ktype' => TType::STRING,
          'vtype' => TType::STRING,
          'key' => array(
            'type' => TType::STRING,
          ),
          'val' => array(
            'type' => TType::STRING,
            ),
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['tableName'])) {
        $this->tableName = $vals['tableName'];
      }
      if (isset($vals['startRow'])) {
        $this->startRow = $vals['startRow'];
      }
      if (isset($vals['stopRow'])) {
        $this->stopRow = $vals['stopRow'];
      }
      if (isset($vals['columns'])) {
        $this->columns = $vals['columns'];
      }
      if (isset($vals['attributes'])) {
        $this->attributes = $vals['attributes'];
      }
    }
  }

  public function getName() {
    return 'Hbase_scannerOpenWithStop_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tableName);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->startRow);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->stopRow);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::LST) {
            $this->columns = array();
            $_size417 = 0;
            $_etype420 = 0;
            $xfer += $input->readListBegin($_etype420, $_size417);
            for ($_i421 = 0; $_i421 < $_size417; ++$_i421)
            {
              $elem422 = null;
              $xfer += $input->readString($elem422);
              $this->columns []= $elem422;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 5:
          if ($ftype == TType::MAP) {
            $this->attributes = array();
            $_size423 = 0;
            $_ktype424 = 0;
            $_vtype425 = 0;
            $xfer += $input->readMapBegin($_ktype424, $_vtype425, $_size423);
            for ($_i427 = 0; $_i427 < $_size423; ++$_i427)
            {
              $key428 = '';
              $val429 = '';
              $xfer += $input->readString($key428);
              $xfer += $input->readString($val429);
              $this->attributes[$key428] = $val429;
            }
            $xfer += $input->readMapEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Hbase_scannerOpenWithStop_args');
    if ($this->tableName !== null) {
      $xfer += $output->writeFieldBegin('tableName', TType::STRING, 1);
      $xfer += $output->writeString($this->tableName);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->startRow !== null) {
      $xfer += $output->writeFieldBegin('startRow', TType::STRING, 2);
      $xfer += $output->writeString($this->startRow);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->stopRow !== null) {
      $xfer += $output->writeFieldBegin('stopRow', TType::STRING, 3);
      $xfer += $output->writeString($this->stopRow);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->columns !== null) {
      if (!is_array($this->columns)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('columns', TType::LST, 4);
      {
        $output->writeListBegin(TType::STRING, count($this->columns));
        {
          foreach ($this->columns as $iter430)
          {
            $xfer += $output->writeString($iter430);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->attributes !== null) {
      if (!is_array($this->attributes)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('attributes', TType::MAP, 5);
      {
        $output->writeMapBegin(TType::STRING, TType::STRING, count($this->attributes));
        {
          foreach ($this->attributes as $kiter431 => $viter432)
          {
            $xfer += $output->writeString($kiter431);
            $xfer += $output->writeString($viter432);
          }
        }
        $output->writeMapEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Hbase_scannerOpenWithStop_result {
  static $_TSPEC;

  public $success = null;
  public $io = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::I32,
          ),
        1 => array(
          'var' => 'io',
          'type' => TType::STRUCT,
          'class' => '\Hbase\IOError',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['io'])) {
        $this->io = $vals['io'];
      }
    }
  }

  public function getName() {
    return 'Hbase_scannerOpenWithStop_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->io = new \Hbase\IOError();
            $xfer += $this->io->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Hbase_scannerOpenWithStop_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::I32, 0);
      $xfer += $output->writeI32($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->io !== null) {
      $xfer += $output->writeFieldBegin('io', TType::STRUCT, 1);
      $xfer += $this->io->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Hbase_scannerOpenWithPrefix_args {
  static $_TSPEC;

  public $tableName = null;
  public $startAndPrefix = null;
  public $columns = null;
  public $attributes = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'tableName',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'startAndPrefix',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'columns',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        4 => array(
          'var' => 'attributes',
          'type' => TType::MAP,
          'ktype' => TType::STRING,
          'vtype' => TType::STRING,
          'key' => array(
            'type' => TType::STRING,
          ),
          'val' => array(
            'type' => TType::STRING,
            ),
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['tableName'])) {
        $this->tableName = $vals['tableName'];
      }
      if (isset($vals['startAndPrefix'])) {
        $this->startAndPrefix = $vals['startAndPrefix'];
      }
      if (isset($vals['columns'])) {
        $this->columns = $vals['columns'];
      }
      if (isset($vals['attributes'])) {
        $this->attributes = $vals['attributes'];
      }
    }
  }

  public function getName() {
    return 'Hbase_scannerOpenWithPrefix_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tableName);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->startAndPrefix);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::LST) {
            $this->columns = array();
            $_size433 = 0;
            $_etype436 = 0;
            $xfer += $input->readListBegin($_etype436, $_size433);
            for ($_i437 = 0; $_i437 < $_size433; ++$_i437)
            {
              $elem438 = null;
              $xfer += $input->readString($elem438);
              $this->columns []= $elem438;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::MAP) {
            $this->attributes = array();
            $_size439 = 0;
            $_ktype440 = 0;
            $_vtype441 = 0;
            $xfer += $input->readMapBegin($_ktype440, $_vtype441, $_size439);
            for ($_i443 = 0; $_i443 < $_size439; ++$_i443)
            {
              $key444 = '';
              $val445 = '';
              $xfer += $input->readString($key444);
              $xfer += $input->readString($val445);
              $this->attributes[$key444] = $val445;
            }
            $xfer += $input->readMapEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Hbase_scannerOpenWithPrefix_args');
    if ($this->tableName !== null) {
      $xfer += $output->writeFieldBegin('tableName', TType::STRING, 1);
      $xfer += $output->writeString($this->tableName);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->startAndPrefix !== null) {
      $xfer += $output->writeFieldBegin('startAndPrefix', TType::STRING, 2);
      $xfer += $output->writeString($this->startAndPrefix);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->columns !== null) {
      if (!is_array($this->columns)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('columns', TType::LST, 3);
      {
        $output->writeListBegin(TType::STRING, count($this->columns));
        {
          foreach ($this->columns as $iter446)
          {
            $xfer += $output->writeString($iter446);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->attributes !== null) {
      if (!is_array($this->attributes)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('attributes', TType::MAP, 4);
      {
        $output->writeMapBegin(TType::STRING, TType::STRING, count($this->attributes));
        {
          foreach ($this->attributes as $kiter447 => $viter448)
          {
            $xfer += $output->writeString($kiter447);
            $xfer += $output->writeString($viter448);
          }
        }
        $output->writeMapEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Hbase_scannerOpenWithPrefix_result {
  static $_TSPEC;

  public $success = null;
  public $io = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::I32,
          ),
        1 => array(
          'var' => 'io',
          'type' => TType::STRUCT,
          'class' => '\Hbase\IOError',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['io'])) {
        $this->io = $vals['io'];
      }
    }
  }

  public function getName() {
    return 'Hbase_scannerOpenWithPrefix_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->io = new \Hbase\IOError();
            $xfer += $this->io->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Hbase_scannerOpenWithPrefix_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::I32, 0);
      $xfer += $output->writeI32($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->io !== null) {
      $xfer += $output->writeFieldBegin('io', TType::STRUCT, 1);
      $xfer += $this->io->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Hbase_scannerOpenTs_args {
  static $_TSPEC;

  public $tableName = null;
  public $startRow = null;
  public $columns = null;
  public $timestamp = null;
  public $attributes = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'tableName',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'startRow',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'columns',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        4 => array(
          'var' => 'timestamp',
          'type' => TType::I64,
          ),
        5 => array(
          'var' => 'attributes',
          'type' => TType::MAP,
          'ktype' => TType::STRING,
          'vtype' => TType::STRING,
          'key' => array(
            'type' => TType::STRING,
          ),
          'val' => array(
            'type' => TType::STRING,
            ),
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['tableName'])) {
        $this->tableName = $vals['tableName'];
      }
      if (isset($vals['startRow'])) {
        $this->startRow = $vals['startRow'];
      }
      if (isset($vals['columns'])) {
        $this->columns = $vals['columns'];
      }
      if (isset($vals['timestamp'])) {
        $this->timestamp = $vals['timestamp'];
      }
      if (isset($vals['attributes'])) {
        $this->attributes = $vals['attributes'];
      }
    }
  }

  public function getName() {
    return 'Hbase_scannerOpenTs_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tableName);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->startRow);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::LST) {
            $this->columns = array();
            $_size449 = 0;
            $_etype452 = 0;
            $xfer += $input->readListBegin($_etype452, $_size449);
            for ($_i453 = 0; $_i453 < $_size449; ++$_i453)
            {
              $elem454 = null;
              $xfer += $input->readString($elem454);
              $this->columns []= $elem454;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->timestamp);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 5:
          if ($ftype == TType::MAP) {
            $this->attributes = array();
            $_size455 = 0;
            $_ktype456 = 0;
            $_vtype457 = 0;
            $xfer += $input->readMapBegin($_ktype456, $_vtype457, $_size455);
            for ($_i459 = 0; $_i459 < $_size455; ++$_i459)
            {
              $key460 = '';
              $val461 = '';
              $xfer += $input->readString($key460);
              $xfer += $input->readString($val461);
              $this->attributes[$key460] = $val461;
            }
            $xfer += $input->readMapEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Hbase_scannerOpenTs_args');
    if ($this->tableName !== null) {
      $xfer += $output->writeFieldBegin('tableName', TType::STRING, 1);
      $xfer += $output->writeString($this->tableName);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->startRow !== null) {
      $xfer += $output->writeFieldBegin('startRow', TType::STRING, 2);
      $xfer += $output->writeString($this->startRow);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->columns !== null) {
      if (!is_array($this->columns)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('columns', TType::LST, 3);
      {
        $output->writeListBegin(TType::STRING, count($this->columns));
        {
          foreach ($this->columns as $iter462)
          {
            $xfer += $output->writeString($iter462);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->timestamp !== null) {
      $xfer += $output->writeFieldBegin('timestamp', TType::I64, 4);
      $xfer += $output->writeI64($this->timestamp);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->attributes !== null) {
      if (!is_array($this->attributes)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('attributes', TType::MAP, 5);
      {
        $output->writeMapBegin(TType::STRING, TType::STRING, count($this->attributes));
        {
          foreach ($this->attributes as $kiter463 => $viter464)
          {
            $xfer += $output->writeString($kiter463);
            $xfer += $output->writeString($viter464);
          }
        }
        $output->writeMapEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Hbase_scannerOpenTs_result {
  static $_TSPEC;

  public $success = null;
  public $io = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::I32,
          ),
        1 => array(
          'var' => 'io',
          'type' => TType::STRUCT,
          'class' => '\Hbase\IOError',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['io'])) {
        $this->io = $vals['io'];
      }
    }
  }

  public function getName() {
    return 'Hbase_scannerOpenTs_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->io = new \Hbase\IOError();
            $xfer += $this->io->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Hbase_scannerOpenTs_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::I32, 0);
      $xfer += $output->writeI32($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->io !== null) {
      $xfer += $output->writeFieldBegin('io', TType::STRUCT, 1);
      $xfer += $this->io->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Hbase_scannerOpenWithStopTs_args {
  static $_TSPEC;

  public $tableName = null;
  public $startRow = null;
  public $stopRow = null;
  public $columns = null;
  public $timestamp = null;
  public $attributes = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'tableName',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'startRow',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'stopRow',
          'type' => TType::STRING,
          ),
        4 => array(
          'var' => 'columns',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        5 => array(
          'var' => 'timestamp',
          'type' => TType::I64,
          ),
        6 => array(
          'var' => 'attributes',
          'type' => TType::MAP,
          'ktype' => TType::STRING,
          'vtype' => TType::STRING,
          'key' => array(
            'type' => TType::STRING,
          ),
          'val' => array(
            'type' => TType::STRING,
            ),
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['tableName'])) {
        $this->tableName = $vals['tableName'];
      }
      if (isset($vals['startRow'])) {
        $this->startRow = $vals['startRow'];
      }
      if (isset($vals['stopRow'])) {
        $this->stopRow = $vals['stopRow'];
      }
      if (isset($vals['columns'])) {
        $this->columns = $vals['columns'];
      }
      if (isset($vals['timestamp'])) {
        $this->timestamp = $vals['timestamp'];
      }
      if (isset($vals['attributes'])) {
        $this->attributes = $vals['attributes'];
      }
    }
  }

  public function getName() {
    return 'Hbase_scannerOpenWithStopTs_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tableName);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->startRow);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->stopRow);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::LST) {
            $this->columns = array();
            $_size465 = 0;
            $_etype468 = 0;
            $xfer += $input->readListBegin($_etype468, $_size465);
            for ($_i469 = 0; $_i469 < $_size465; ++$_i469)
            {
              $elem470 = null;
              $xfer += $input->readString($elem470);
              $this->columns []= $elem470;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 5:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->timestamp);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 6:
          if ($ftype == TType::MAP) {
            $this->attributes = array();
            $_size471 = 0;
            $_ktype472 = 0;
            $_vtype473 = 0;
            $xfer += $input->readMapBegin($_ktype472, $_vtype473, $_size471);
            for ($_i475 = 0; $_i475 < $_size471; ++$_i475)
            {
              $key476 = '';
              $val477 = '';
              $xfer += $input->readString($key476);
              $xfer += $input->readString($val477);
              $this->attributes[$key476] = $val477;
            }
            $xfer += $input->readMapEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Hbase_scannerOpenWithStopTs_args');
    if ($this->tableName !== null) {
      $xfer += $output->writeFieldBegin('tableName', TType::STRING, 1);
      $xfer += $output->writeString($this->tableName);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->startRow !== null) {
      $xfer += $output->writeFieldBegin('startRow', TType::STRING, 2);
      $xfer += $output->writeString($this->startRow);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->stopRow !== null) {
      $xfer += $output->writeFieldBegin('stopRow', TType::STRING, 3);
      $xfer += $output->writeString($this->stopRow);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->columns !== null) {
      if (!is_array($this->columns)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('columns', TType::LST, 4);
      {
        $output->writeListBegin(TType::STRING, count($this->columns));
        {
          foreach ($this->columns as $iter478)
          {
            $xfer += $output->writeString($iter478);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->timestamp !== null) {
      $xfer += $output->writeFieldBegin('timestamp', TType::I64, 5);
      $xfer += $output->writeI64($this->timestamp);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->attributes !== null) {
      if (!is_array($this->attributes)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('attributes', TType::MAP, 6);
      {
        $output->writeMapBegin(TType::STRING, TType::STRING, count($this->attributes));
        {
          foreach ($this->attributes as $kiter479 => $viter480)
          {
            $xfer += $output->writeString($kiter479);
            $xfer += $output->writeString($viter480);
          }
        }
        $output->writeMapEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Hbase_scannerOpenWithStopTs_result {
  static $_TSPEC;

  public $success = null;
  public $io = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::I32,
          ),
        1 => array(
          'var' => 'io',
          'type' => TType::STRUCT,
          'class' => '\Hbase\IOError',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['io'])) {
        $this->io = $vals['io'];
      }
    }
  }

  public function getName() {
    return 'Hbase_scannerOpenWithStopTs_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->io = new \Hbase\IOError();
            $xfer += $this->io->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Hbase_scannerOpenWithStopTs_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::I32, 0);
      $xfer += $output->writeI32($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->io !== null) {
      $xfer += $output->writeFieldBegin('io', TType::STRUCT, 1);
      $xfer += $this->io->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Hbase_scannerGet_args {
  static $_TSPEC;

  public $id = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'id',
          'type' => TType::I32,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['id'])) {
        $this->id = $vals['id'];
      }
    }
  }

  public function getName() {
    return 'Hbase_scannerGet_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->id);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Hbase_scannerGet_args');
    if ($this->id !== null) {
      $xfer += $output->writeFieldBegin('id', TType::I32, 1);
      $xfer += $output->writeI32($this->id);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Hbase_scannerGet_result {
  static $_TSPEC;

  public $success = null;
  public $io = null;
  public $ia = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\Hbase\TRowResult',
            ),
          ),
        1 => array(
          'var' => 'io',
          'type' => TType::STRUCT,
          'class' => '\Hbase\IOError',
          ),
        2 => array(
          'var' => 'ia',
          'type' => TType::STRUCT,
          'class' => '\Hbase\IllegalArgument',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['io'])) {
        $this->io = $vals['io'];
      }
      if (isset($vals['ia'])) {
        $this->ia = $vals['ia'];
      }
    }
  }

  public function getName() {
    return 'Hbase_scannerGet_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size481 = 0;
            $_etype484 = 0;
            $xfer += $input->readListBegin($_etype484, $_size481);
            for ($_i485 = 0; $_i485 < $_size481; ++$_i485)
            {
              $elem486 = null;
              $elem486 = new \Hbase\TRowResult();
              $xfer += $elem486->read($input);
              $this->success []= $elem486;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->io = new \Hbase\IOError();
            $xfer += $this->io->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ia = new \Hbase\IllegalArgument();
            $xfer += $this->ia->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Hbase_scannerGet_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $iter487)
          {
            $xfer += $iter487->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->io !== null) {
      $xfer += $output->writeFieldBegin('io', TType::STRUCT, 1);
      $xfer += $this->io->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ia !== null) {
      $xfer += $output->writeFieldBegin('ia', TType::STRUCT, 2);
      $xfer += $this->ia->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Hbase_scannerGetList_args {
  static $_TSPEC;

  public $id = null;
  public $nbRows = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'id',
          'type' => TType::I32,
          ),
        2 => array(
          'var' => 'nbRows',
          'type' => TType::I32,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['id'])) {
        $this->id = $vals['id'];
      }
      if (isset($vals['nbRows'])) {
        $this->nbRows = $vals['nbRows'];
      }
    }
  }

  public function getName() {
    return 'Hbase_scannerGetList_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->id);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->nbRows);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Hbase_scannerGetList_args');
    if ($this->id !== null) {
      $xfer += $output->writeFieldBegin('id', TType::I32, 1);
      $xfer += $output->writeI32($this->id);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->nbRows !== null) {
      $xfer += $output->writeFieldBegin('nbRows', TType::I32, 2);
      $xfer += $output->writeI32($this->nbRows);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Hbase_scannerGetList_result {
  static $_TSPEC;

  public $success = null;
  public $io = null;
  public $ia = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\Hbase\TRowResult',
            ),
          ),
        1 => array(
          'var' => 'io',
          'type' => TType::STRUCT,
          'class' => '\Hbase\IOError',
          ),
        2 => array(
          'var' => 'ia',
          'type' => TType::STRUCT,
          'class' => '\Hbase\IllegalArgument',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['io'])) {
        $this->io = $vals['io'];
      }
      if (isset($vals['ia'])) {
        $this->ia = $vals['ia'];
      }
    }
  }

  public function getName() {
    return 'Hbase_scannerGetList_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size488 = 0;
            $_etype491 = 0;
            $xfer += $input->readListBegin($_etype491, $_size488);
            for ($_i492 = 0; $_i492 < $_size488; ++$_i492)
            {
              $elem493 = null;
              $elem493 = new \Hbase\TRowResult();
              $xfer += $elem493->read($input);
              $this->success []= $elem493;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->io = new \Hbase\IOError();
            $xfer += $this->io->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ia = new \Hbase\IllegalArgument();
            $xfer += $this->ia->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Hbase_scannerGetList_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $iter494)
          {
            $xfer += $iter494->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->io !== null) {
      $xfer += $output->writeFieldBegin('io', TType::STRUCT, 1);
      $xfer += $this->io->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ia !== null) {
      $xfer += $output->writeFieldBegin('ia', TType::STRUCT, 2);
      $xfer += $this->ia->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Hbase_scannerClose_args {
  static $_TSPEC;

  public $id = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'id',
          'type' => TType::I32,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['id'])) {
        $this->id = $vals['id'];
      }
    }
  }

  public function getName() {
    return 'Hbase_scannerClose_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->id);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Hbase_scannerClose_args');
    if ($this->id !== null) {
      $xfer += $output->writeFieldBegin('id', TType::I32, 1);
      $xfer += $output->writeI32($this->id);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Hbase_scannerClose_result {
  static $_TSPEC;

  public $io = null;
  public $ia = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'io',
          'type' => TType::STRUCT,
          'class' => '\Hbase\IOError',
          ),
        2 => array(
          'var' => 'ia',
          'type' => TType::STRUCT,
          'class' => '\Hbase\IllegalArgument',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['io'])) {
        $this->io = $vals['io'];
      }
      if (isset($vals['ia'])) {
        $this->ia = $vals['ia'];
      }
    }
  }

  public function getName() {
    return 'Hbase_scannerClose_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->io = new \Hbase\IOError();
            $xfer += $this->io->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ia = new \Hbase\IllegalArgument();
            $xfer += $this->ia->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Hbase_scannerClose_result');
    if ($this->io !== null) {
      $xfer += $output->writeFieldBegin('io', TType::STRUCT, 1);
      $xfer += $this->io->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ia !== null) {
      $xfer += $output->writeFieldBegin('ia', TType::STRUCT, 2);
      $xfer += $this->ia->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Hbase_getRowOrBefore_args {
  static $_TSPEC;

  public $tableName = null;
  public $row = null;
  public $family = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'tableName',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'row',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'family',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['tableName'])) {
        $this->tableName = $vals['tableName'];
      }
      if (isset($vals['row'])) {
        $this->row = $vals['row'];
      }
      if (isset($vals['family'])) {
        $this->family = $vals['family'];
      }
    }
  }

  public function getName() {
    return 'Hbase_getRowOrBefore_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tableName);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->row);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->family);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Hbase_getRowOrBefore_args');
    if ($this->tableName !== null) {
      $xfer += $output->writeFieldBegin('tableName', TType::STRING, 1);
      $xfer += $output->writeString($this->tableName);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->row !== null) {
      $xfer += $output->writeFieldBegin('row', TType::STRING, 2);
      $xfer += $output->writeString($this->row);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->family !== null) {
      $xfer += $output->writeFieldBegin('family', TType::STRING, 3);
      $xfer += $output->writeString($this->family);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Hbase_getRowOrBefore_result {
  static $_TSPEC;

  public $success = null;
  public $io = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\Hbase\TCell',
            ),
          ),
        1 => array(
          'var' => 'io',
          'type' => TType::STRUCT,
          'class' => '\Hbase\IOError',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['io'])) {
        $this->io = $vals['io'];
      }
    }
  }

  public function getName() {
    return 'Hbase_getRowOrBefore_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size495 = 0;
            $_etype498 = 0;
            $xfer += $input->readListBegin($_etype498, $_size495);
            for ($_i499 = 0; $_i499 < $_size495; ++$_i499)
            {
              $elem500 = null;
              $elem500 = new \Hbase\TCell();
              $xfer += $elem500->read($input);
              $this->success []= $elem500;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->io = new \Hbase\IOError();
            $xfer += $this->io->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Hbase_getRowOrBefore_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $iter501)
          {
            $xfer += $iter501->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->io !== null) {
      $xfer += $output->writeFieldBegin('io', TType::STRUCT, 1);
      $xfer += $this->io->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Hbase_getRegionInfo_args {
  static $_TSPEC;

  public $row = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'row',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['row'])) {
        $this->row = $vals['row'];
      }
    }
  }

  public function getName() {
    return 'Hbase_getRegionInfo_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->row);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Hbase_getRegionInfo_args');
    if ($this->row !== null) {
      $xfer += $output->writeFieldBegin('row', TType::STRING, 1);
      $xfer += $output->writeString($this->row);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Hbase_getRegionInfo_result {
  static $_TSPEC;

  public $success = null;
  public $io = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\Hbase\TRegionInfo',
          ),
        1 => array(
          'var' => 'io',
          'type' => TType::STRUCT,
          'class' => '\Hbase\IOError',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['io'])) {
        $this->io = $vals['io'];
      }
    }
  }

  public function getName() {
    return 'Hbase_getRegionInfo_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \Hbase\TRegionInfo();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->io = new \Hbase\IOError();
            $xfer += $this->io->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Hbase_getRegionInfo_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->io !== null) {
      $xfer += $output->writeFieldBegin('io', TType::STRUCT, 1);
      $xfer += $this->io->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}


