/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.ConnectionConfiguration;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class AsyncConnectionConfiguration {
    public static final String START_LOG_ERRORS_AFTER_COUNT_KEY = "hbase.client.start.log.errors.counter";
    public static final int DEFAULT_START_LOG_ERRORS_AFTER_COUNT = 5;
    private final long metaOperationTimeoutNs;
    private final long operationTimeoutNs;
    private final long rpcTimeoutNs;
    private final long readRpcTimeoutNs;
    private final long metaReadRpcTimeoutNs;
    private final long writeRpcTimeoutNs;
    private final long pauseNs;
    private final long pauseNsForServerOverloaded;
    private final int maxRetries;
    private final int startLogErrorsCnt;
    private final long scanTimeoutNs;
    private final long metaScanTimeoutNs;
    private final int scannerCaching;
    private final int metaScannerCaching;
    private final long scannerMaxResultSize;
    private final long writeBufferSize;
    private final long writeBufferPeriodicFlushTimeoutNs;
    private final long primaryCallTimeoutNs;
    private final long primaryScanTimeoutNs;
    private final long primaryMetaScanTimeoutNs;
    private final int maxKeyValueSize;

    AsyncConnectionConfiguration(Configuration conf) {
        ConnectionConfiguration connectionConf = new ConnectionConfiguration(conf);
        this.scannerCaching = connectionConf.getScannerCaching();
        this.scannerMaxResultSize = connectionConf.getScannerMaxResultSize();
        this.writeBufferSize = connectionConf.getWriteBufferSize();
        this.writeBufferPeriodicFlushTimeoutNs = connectionConf.getWriteBufferPeriodicFlushTimeoutMs();
        this.maxKeyValueSize = connectionConf.getMaxKeyValueSize();
        this.maxRetries = connectionConf.getRetriesNumber();
        this.metaOperationTimeoutNs = TimeUnit.MILLISECONDS.toNanos(connectionConf.getMetaOperationTimeout());
        this.operationTimeoutNs = TimeUnit.MILLISECONDS.toNanos(connectionConf.getOperationTimeout());
        this.rpcTimeoutNs = TimeUnit.MILLISECONDS.toNanos(connectionConf.getRpcTimeout());
        long readRpcTimeoutMillis = conf.getLong("hbase.rpc.read.timeout", (long)connectionConf.getRpcTimeout());
        this.readRpcTimeoutNs = TimeUnit.MILLISECONDS.toNanos(readRpcTimeoutMillis);
        this.metaReadRpcTimeoutNs = TimeUnit.MILLISECONDS.toNanos(conf.getLong("hbase.client.meta.read.rpc.timeout", readRpcTimeoutMillis));
        this.writeRpcTimeoutNs = TimeUnit.MILLISECONDS.toNanos(conf.getLong("hbase.rpc.write.timeout", (long)connectionConf.getWriteRpcTimeout()));
        this.pauseNs = TimeUnit.MILLISECONDS.toNanos(connectionConf.getPauseMillis());
        this.pauseNsForServerOverloaded = TimeUnit.MILLISECONDS.toNanos(connectionConf.getPauseMillisForServerOverloaded());
        this.primaryCallTimeoutNs = TimeUnit.MICROSECONDS.toNanos(connectionConf.getPrimaryCallTimeoutMicroSecond());
        this.primaryScanTimeoutNs = TimeUnit.MICROSECONDS.toNanos(connectionConf.getReplicaCallTimeoutMicroSecondScan());
        this.primaryMetaScanTimeoutNs = TimeUnit.MICROSECONDS.toNanos(connectionConf.getMetaReplicaCallTimeoutMicroSecondScan());
        long scannerTimeoutMillis = conf.getLong("hbase.client.scanner.timeout.period", 60000L);
        this.scanTimeoutNs = TimeUnit.MILLISECONDS.toNanos(scannerTimeoutMillis);
        this.metaScanTimeoutNs = TimeUnit.MILLISECONDS.toNanos(conf.getLong("hbase.client.meta.scanner.timeout.period", scannerTimeoutMillis));
        this.startLogErrorsCnt = conf.getInt(START_LOG_ERRORS_AFTER_COUNT_KEY, 5);
        this.metaScannerCaching = conf.getInt("hbase.meta.scanner.caching", 100);
    }

    long getMetaOperationTimeoutNs() {
        return this.metaOperationTimeoutNs;
    }

    long getOperationTimeoutNs() {
        return this.operationTimeoutNs;
    }

    long getRpcTimeoutNs() {
        return this.rpcTimeoutNs;
    }

    long getReadRpcTimeoutNs() {
        return this.readRpcTimeoutNs;
    }

    long getMetaReadRpcTimeoutNs() {
        return this.metaReadRpcTimeoutNs;
    }

    long getWriteRpcTimeoutNs() {
        return this.writeRpcTimeoutNs;
    }

    long getPauseNs() {
        return this.pauseNs;
    }

    long getPauseNsForServerOverloaded() {
        return this.pauseNsForServerOverloaded;
    }

    int getMaxRetries() {
        return this.maxRetries;
    }

    int getStartLogErrorsCnt() {
        return this.startLogErrorsCnt;
    }

    long getScanTimeoutNs() {
        return this.scanTimeoutNs;
    }

    long getMetaScanTimeoutNs() {
        return this.metaScanTimeoutNs;
    }

    int getScannerCaching() {
        return this.scannerCaching;
    }

    int getMetaScannerCaching() {
        return this.metaScannerCaching;
    }

    long getScannerMaxResultSize() {
        return this.scannerMaxResultSize;
    }

    long getWriteBufferSize() {
        return this.writeBufferSize;
    }

    long getWriteBufferPeriodicFlushTimeoutNs() {
        return this.writeBufferPeriodicFlushTimeoutNs;
    }

    long getPrimaryCallTimeoutNs() {
        return this.primaryCallTimeoutNs;
    }

    long getPrimaryScanTimeoutNs() {
        return this.primaryScanTimeoutNs;
    }

    long getPrimaryMetaScanTimeoutNs() {
        return this.primaryMetaScanTimeoutNs;
    }

    int getMaxKeyValueSize() {
        return this.maxKeyValueSize;
    }
}

