/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connector.catalog;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.spark.sql.catalyst.analysis.AsOfTimestamp;
import org.apache.spark.sql.catalyst.analysis.AsOfVersion;
import org.apache.spark.sql.catalyst.analysis.NamedRelation;
import org.apache.spark.sql.catalyst.analysis.NoSuchDatabaseException;
import org.apache.spark.sql.catalyst.analysis.NoSuchFunctionException;
import org.apache.spark.sql.catalyst.analysis.NoSuchNamespaceException;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.catalyst.analysis.TimeTravelSpec;
import org.apache.spark.sql.catalyst.plans.logical.SerdeInfo;
import org.apache.spark.sql.catalyst.plans.logical.TableSpec;
import org.apache.spark.sql.connector.catalog.CatalogManager;
import org.apache.spark.sql.connector.catalog.CatalogManager$;
import org.apache.spark.sql.connector.catalog.CatalogPlugin;
import org.apache.spark.sql.connector.catalog.CatalogV2Implicits$;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.NamespaceChange;
import org.apache.spark.sql.connector.catalog.SupportsCatalogOptions;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.connector.catalog.TableChange;
import org.apache.spark.sql.connector.catalog.functions.UnboundFunction;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Relation$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.apache.spark.util.Utils$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map$;
import scala.collection.immutable.MapLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

public final class CatalogV2Util$ {
    public static CatalogV2Util$ MODULE$;
    private final Seq<String> TABLE_RESERVED_PROPERTIES;
    private final Seq<String> NAMESPACE_RESERVED_PROPERTIES;

    static {
        new CatalogV2Util$();
    }

    public Seq<String> TABLE_RESERVED_PROPERTIES() {
        return this.TABLE_RESERVED_PROPERTIES;
    }

    public Seq<String> NAMESPACE_RESERVED_PROPERTIES() {
        return this.NAMESPACE_RESERVED_PROPERTIES;
    }

    public scala.collection.immutable.Map<String, String> applyNamespaceChanges(scala.collection.immutable.Map<String, String> properties, Seq<NamespaceChange> changes) {
        return ((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(this.applyNamespaceChanges((Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(properties).asJava(), changes)).asScala()).toMap(Predef$.MODULE$.$conforms());
    }

    public Map<String, String> applyNamespaceChanges(Map<String, String> properties, Seq<NamespaceChange> changes) {
        HashMap<String, String> newProperties = new HashMap<String, String>(properties);
        changes.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Object object;
            NamespaceChange namespaceChange = x0$1;
            if (namespaceChange instanceof NamespaceChange.SetProperty) {
                NamespaceChange.SetProperty setProperty = (NamespaceChange.SetProperty)namespaceChange;
                object = newProperties.put(setProperty.property(), setProperty.value());
            } else if (namespaceChange instanceof NamespaceChange.RemoveProperty) {
                NamespaceChange.RemoveProperty removeProperty = (NamespaceChange.RemoveProperty)namespaceChange;
                object = newProperties.remove(removeProperty.property());
            } else {
                object = BoxedUnit.UNIT;
            }
            return object;
        });
        return Collections.unmodifiableMap(newProperties);
    }

    public scala.collection.immutable.Map<String, String> applyPropertiesChanges(scala.collection.immutable.Map<String, String> properties, Seq<TableChange> changes) {
        return ((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(this.applyPropertiesChanges((Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(properties).asJava(), changes)).asScala()).toMap(Predef$.MODULE$.$conforms());
    }

    public Map<String, String> applyPropertiesChanges(Map<String, String> properties, Seq<TableChange> changes) {
        HashMap<String, String> newProperties = new HashMap<String, String>(properties);
        changes.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Object object;
            TableChange tableChange = x0$1;
            if (tableChange instanceof TableChange.SetProperty) {
                TableChange.SetProperty setProperty = (TableChange.SetProperty)tableChange;
                object = newProperties.put(setProperty.property(), setProperty.value());
            } else if (tableChange instanceof TableChange.RemoveProperty) {
                TableChange.RemoveProperty removeProperty = (TableChange.RemoveProperty)tableChange;
                object = newProperties.remove(removeProperty.property());
            } else {
                object = BoxedUnit.UNIT;
            }
            return object;
        });
        return Collections.unmodifiableMap(newProperties);
    }

    public StructType applySchemaChanges(StructType schema2, Seq<TableChange> changes) {
        return (StructType)changes.foldLeft((Object)schema2, (Function2 & Serializable & scala.Serializable)(schema, change) -> {
            StructType structType;
            TableChange tableChange = change;
            if (tableChange instanceof TableChange.AddColumn) {
                StructType structType2;
                TableChange.AddColumn addColumn = (TableChange.AddColumn)tableChange;
                String[] stringArray = addColumn.fieldNames();
                Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
                if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(1) == 0) {
                    String name = (String)((SeqLike)option.get()).apply(0);
                    StructField field2 = new StructField(name, addColumn.dataType(), addColumn.isNullable(), StructField$.MODULE$.apply$default$4());
                    StructField newField = (StructField)Option$.MODULE$.apply((Object)addColumn.comment()).map((Function1 & Serializable & scala.Serializable)comment -> field2.withComment((String)comment)).getOrElse((Function0 & Serializable & scala.Serializable)() -> field2);
                    structType2 = MODULE$.addField((StructType)schema, newField, addColumn.position());
                } else {
                    structType2 = MODULE$.replace((StructType)schema, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])stringArray)).init()), (Function1<StructField, Option<StructField>>)(Function1 & Serializable & scala.Serializable)parent -> {
                        DataType dataType = parent.dataType();
                        if (!(dataType instanceof StructType)) {
                            throw new IllegalArgumentException(new StringBuilder(14).append("Not a struct: ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])stringArray)).init())).last()).toString());
                        }
                        StructType structType = (StructType)dataType;
                        StructField field = new StructField((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])stringArray)).last(), addColumn.dataType(), addColumn.isNullable(), StructField$.MODULE$.apply$default$4());
                        StructField newField = (StructField)Option$.MODULE$.apply((Object)addColumn.comment()).map((Function1 & Serializable & scala.Serializable)comment -> field.withComment((String)comment)).getOrElse((Function0 & Serializable & scala.Serializable)() -> field);
                        StructType x$1 = MODULE$.addField(structType, newField, addColumn.position());
                        String x$2 = parent.copy$default$1();
                        boolean x$3 = parent.copy$default$3();
                        Metadata x$4 = parent.copy$default$4();
                        Some some = new Some((Object)parent.copy(x$2, x$1, x$3, x$4));
                        return some;
                    }, MODULE$.replace$default$4());
                }
                structType = structType2;
            } else if (tableChange instanceof TableChange.RenameColumn) {
                TableChange.RenameColumn renameColumn = (TableChange.RenameColumn)tableChange;
                structType = MODULE$.replace((StructType)schema, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])renameColumn.fieldNames()), (Function1<StructField, Option<StructField>>)(Function1 & Serializable & scala.Serializable)field -> new Some((Object)new StructField(renameColumn.newName(), field.dataType(), field.nullable(), field.metadata())), MODULE$.replace$default$4());
            } else if (tableChange instanceof TableChange.UpdateColumnType) {
                TableChange.UpdateColumnType updateColumnType = (TableChange.UpdateColumnType)tableChange;
                structType = MODULE$.replace((StructType)schema, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])updateColumnType.fieldNames()), (Function1<StructField, Option<StructField>>)(Function1 & Serializable & scala.Serializable)field -> {
                    DataType x$5 = updateColumnType.newDataType();
                    String x$6 = field.copy$default$1();
                    boolean x$7 = field.copy$default$3();
                    Metadata x$8 = field.copy$default$4();
                    return new Some((Object)field.copy(x$6, x$5, x$7, x$8));
                }, MODULE$.replace$default$4());
            } else if (tableChange instanceof TableChange.UpdateColumnNullability) {
                TableChange.UpdateColumnNullability updateColumnNullability = (TableChange.UpdateColumnNullability)tableChange;
                structType = MODULE$.replace((StructType)schema, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])updateColumnNullability.fieldNames()), (Function1<StructField, Option<StructField>>)(Function1 & Serializable & scala.Serializable)field -> {
                    boolean x$9 = updateColumnNullability.nullable();
                    String x$10 = field.copy$default$1();
                    DataType x$11 = field.copy$default$2();
                    Metadata x$12 = field.copy$default$4();
                    return new Some((Object)field.copy(x$10, x$11, x$9, x$12));
                }, MODULE$.replace$default$4());
            } else if (tableChange instanceof TableChange.UpdateColumnComment) {
                TableChange.UpdateColumnComment updateColumnComment = (TableChange.UpdateColumnComment)tableChange;
                structType = MODULE$.replace((StructType)schema, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])updateColumnComment.fieldNames()), (Function1<StructField, Option<StructField>>)(Function1 & Serializable & scala.Serializable)field -> new Some((Object)field.withComment(updateColumnComment.newComment())), MODULE$.replace$default$4());
            } else if (tableChange instanceof TableChange.UpdateColumnPosition) {
                StructType structType3;
                TableChange.UpdateColumnPosition updateColumnPosition = (TableChange.UpdateColumnPosition)tableChange;
                String[] stringArray = updateColumnPosition.fieldNames();
                Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
                if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(1) == 0) {
                    String name = (String)((SeqLike)option.get()).apply(0);
                    structType3 = CatalogV2Util$.updateFieldPos$1(schema, name, updateColumnPosition);
                } else {
                    structType3 = MODULE$.replace((StructType)schema, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])stringArray)).init()), (Function1<StructField, Option<StructField>>)(Function1 & Serializable & scala.Serializable)parent -> {
                        DataType dataType = parent.dataType();
                        if (!(dataType instanceof StructType)) {
                            throw new IllegalArgumentException(new StringBuilder(14).append("Not a struct: ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])stringArray)).init())).last()).toString());
                        }
                        StructType structType = (StructType)dataType;
                        StructType x$13 = CatalogV2Util$.updateFieldPos$1(structType, (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])stringArray)).last(), updateColumnPosition);
                        String x$14 = parent.copy$default$1();
                        boolean x$15 = parent.copy$default$3();
                        Metadata x$16 = parent.copy$default$4();
                        Some some = new Some((Object)parent.copy(x$14, x$13, x$15, x$16));
                        return some;
                    }, MODULE$.replace$default$4());
                }
                structType = structType3;
            } else if (tableChange instanceof TableChange.DeleteColumn) {
                TableChange.DeleteColumn deleteColumn = (TableChange.DeleteColumn)tableChange;
                structType = MODULE$.replace((StructType)schema, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])deleteColumn.fieldNames()), (Function1<StructField, Option<StructField>>)(Function1 & Serializable & scala.Serializable)x$3 -> None$.MODULE$, Predef$.MODULE$.Boolean2boolean(deleteColumn.ifExists()));
            } else {
                structType = schema;
            }
            return structType;
        });
    }

    private StructType addField(StructType schema, StructField field, TableChange.ColumnPosition position) {
        StructType structType;
        if (position == null) {
            structType = schema.add(field);
        } else if (position instanceof TableChange.First) {
            StructField structField = field;
            StructType structType2 = new StructType((StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.fields())).$plus$colon((Object)structField, ClassTag$.MODULE$.apply(StructField.class)));
            structType = structType2;
        } else {
            String afterCol = ((TableChange.After)position).column();
            int fieldIndex = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.fields())).indexWhere((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)CatalogV2Util$.$anonfun$addField$1(afterCol, x$5)));
            if (fieldIndex == -1) {
                throw new IllegalArgumentException(new StringBuilder(24).append("AFTER column not found: ").append(afterCol).toString());
            }
            Tuple2 tuple2 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.fields())).splitAt(fieldIndex + 1);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            StructField[] before = (StructField[])tuple2._1();
            StructField[] after = (StructField[])tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)before, (Object)after);
            Tuple2 tuple23 = tuple22;
            StructField[] before2 = (StructField[])tuple23._1();
            StructField[] after2 = (StructField[])tuple23._2();
            StructField structField = field;
            StructType structType3 = new StructType((StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])before2)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])after2)).$plus$colon((Object)structField, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class))))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class))));
            structType = structType3;
        }
        return structType;
    }

    /*
     * Unable to fully structure code
     */
    private StructType replace(StructType struct, Seq<String> fieldNames, Function1<StructField, Option<StructField>> update, boolean ifExists) {
        block8: {
            block14: {
                block13: {
                    block12: {
                        block11: {
                            block10: {
                                block9: {
                                    block7: {
                                        posOpt = struct.getFieldIndex((String)fieldNames.head());
                                        if (posOpt.isEmpty()) {
                                            if (ifExists) {
                                                return struct;
                                            }
                                            throw new IllegalArgumentException(new StringBuilder(19).append("Cannot find field: ").append(fieldNames.head()).toString());
                                        }
                                        pos = BoxesRunTime.unboxToInt((Object)posOpt.get());
                                        field = struct.fields()[pos];
                                        var10_8 = new Tuple2(fieldNames.tail(), (Object)field.dataType());
                                        if (var10_8 == null || (var12_10 = Seq$.MODULE$.unapplySeq(var11_9 = (Seq)var10_8._1())).isEmpty() || var12_10.get() == null || ((SeqLike)var12_10.get()).lengthCompare(0) != 0) break block7;
                                        var5_11 = (Option)update.apply((Object)field);
                                        break block8;
                                    }
                                    if (var10_8 == null) break block9;
                                    names = (Seq)var10_8._1();
                                    struct = (DataType)var10_8._2();
                                    if (!(struct instanceof StructType)) break block9;
                                    var15_14 = (StructType)struct;
                                    updatedType = this.replace(var15_14, (Seq<String>)names, update, ifExists);
                                    var5_11 = new Some((Object)new StructField(field.name(), updatedType, field.nullable(), field.metadata()));
                                    break block8;
                                }
                                if (var10_8 == null) break block10;
                                var17_16 = (Seq)var10_8._1();
                                map = (DataType)var10_8._2();
                                var19_18 = Seq$.MODULE$.unapplySeq(var17_16);
                                if (var19_18.isEmpty() || var19_18.get() == null || ((SeqLike)var19_18.get()).lengthCompare(1) != 0 || !"key".equals(var20_19 = (String)((SeqLike)var19_18.get()).apply(0)) || !(map instanceof MapType)) break block10;
                                var21_20 = (MapType)map;
                                keyType = var21_20.keyType();
                                updated = (StructField)((Option)update.apply((Object)new StructField("key", keyType, false, StructField$.MODULE$.apply$default$4()))).getOrElse((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$replace$1(), ()Lscala/runtime/Nothing$;)());
                                x$1 = var21_20.copy(updated.dataType(), var21_20.copy$default$2(), var21_20.copy$default$3());
                                x$2 = field.copy$default$1();
                                x$3 = field.copy$default$3();
                                x$4 = field.copy$default$4();
                                var5_11 = new Some((Object)field.copy(x$2, x$1, x$3, x$4));
                                break block8;
                            }
                            if (var10_8 == null) break block11;
                            var28_27 = (Seq)var10_8._1();
                            map = (DataType)var10_8._2();
                            var30_29 = Seq$.MODULE$.unapplySeq(var28_27);
                            if (var30_29.isEmpty() || var30_29.get() == null || ((SeqLike)var30_29.get()).lengthCompare(1) < 0) break block11;
                            var31_30 = (String)((SeqLike)var30_29.get()).apply(0);
                            names = (Seq)((IterableLike)var30_29.get()).drop(1);
                            if (!"key".equals(var31_30) || !(map instanceof MapType) || !((keyStruct = (var33_32 = (MapType)map).keyType()) instanceof StructType)) break block11;
                            var35_34 = (StructType)keyStruct;
                            x$5 = var33_32.copy(this.replace(var35_34, (Seq<String>)names, update, ifExists), var33_32.copy$default$2(), var33_32.copy$default$3());
                            x$6 = field.copy$default$1();
                            x$7 = field.copy$default$3();
                            x$8 = field.copy$default$4();
                            var5_11 = new Some((Object)field.copy(x$6, x$5, x$7, x$8));
                            break block8;
                        }
                        if (var10_8 == null) break block12;
                        var40_39 = (Seq)var10_8._1();
                        map = (DataType)var10_8._2();
                        var42_41 = Seq$.MODULE$.unapplySeq(var40_39);
                        if (var42_41.isEmpty() || var42_41.get() == null || ((SeqLike)var42_41.get()).lengthCompare(1) != 0 || !"value".equals(var43_42 = (String)((SeqLike)var42_41.get()).apply(0)) || !(map instanceof MapType)) break block12;
                        var44_43 = (MapType)map;
                        mapValueType = var44_43.valueType();
                        isNullable = var44_43.valueContainsNull();
                        updated = (StructField)((Option)update.apply((Object)new StructField("value", mapValueType, isNullable, StructField$.MODULE$.apply$default$4()))).getOrElse((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$replace$2(), ()Lscala/runtime/Nothing$;)());
                        x$9 = updated.dataType();
                        x$10 = updated.nullable();
                        x$11 = var44_43.copy$default$1();
                        x$12 = var44_43.copy(x$11, x$9, x$10);
                        x$13 = field.copy$default$1();
                        x$14 = field.copy$default$3();
                        x$15 = field.copy$default$4();
                        var5_11 = new Some((Object)field.copy(x$13, x$12, x$14, x$15));
                        break block8;
                    }
                    if (var10_8 == null) break block13;
                    var55_54 = (Seq)var10_8._1();
                    map = (DataType)var10_8._2();
                    var57_56 = Seq$.MODULE$.unapplySeq(var55_54);
                    if (var57_56.isEmpty() || var57_56.get() == null || ((SeqLike)var57_56.get()).lengthCompare(1) < 0) break block13;
                    var58_57 = (String)((SeqLike)var57_56.get()).apply(0);
                    names = (Seq)((IterableLike)var57_56.get()).drop(1);
                    if (!"value".equals(var58_57) || !(map instanceof MapType) || !((valueStruct = (var60_59 = (MapType)map).valueType()) instanceof StructType)) break block13;
                    var62_61 = (StructType)valueStruct;
                    x$16 = this.replace(var62_61, (Seq<String>)names, update, ifExists);
                    x$17 = var60_59.copy$default$1();
                    x$18 = var60_59.copy$default$3();
                    x$19 = var60_59.copy(x$17, x$16, x$18);
                    x$20 = field.copy$default$1();
                    x$21 = field.copy$default$3();
                    x$22 = field.copy$default$4();
                    var5_11 = new Some((Object)field.copy(x$20, x$19, x$21, x$22));
                    break block8;
                }
                if (var10_8 == null) break block14;
                var70_69 = (Seq)var10_8._1();
                array = (DataType)var10_8._2();
                var72_71 = Seq$.MODULE$.unapplySeq(var70_69);
                if (var72_71.isEmpty() || var72_71.get() == null || ((SeqLike)var72_71.get()).lengthCompare(1) != 0 || !"element".equals(var73_72 = (String)((SeqLike)var72_71.get()).apply(0)) || !(array instanceof ArrayType)) break block14;
                var74_73 = (ArrayType)array;
                elementType = var74_73.elementType();
                isNullable = var74_73.containsNull();
                updated = (StructField)((Option)update.apply((Object)new StructField("element", elementType, isNullable, StructField$.MODULE$.apply$default$4()))).getOrElse((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$replace$3(), ()Lscala/runtime/Nothing$;)());
                x$23 = var74_73.copy(updated.dataType(), updated.nullable());
                x$24 = field.copy$default$1();
                x$25 = field.copy$default$3();
                x$26 = field.copy$default$4();
                var5_11 = new Some((Object)field.copy(x$24, x$23, x$25, x$26));
                break block8;
            }
            if (var10_8 == null) ** GOTO lbl-1000
            var82_81 = (Seq)var10_8._1();
            array = (DataType)var10_8._2();
            var84_83 = Seq$.MODULE$.unapplySeq(var82_81);
            if (var84_83.isEmpty() || var84_83.get() == null || ((SeqLike)var84_83.get()).lengthCompare(1) < 0) ** GOTO lbl-1000
            var85_84 = (String)((SeqLike)var84_83.get()).apply(0);
            names = (Seq)((IterableLike)var84_83.get()).drop(1);
            if ("element".equals(var85_84) && array instanceof ArrayType && (elementStruct = (var87_86 = (ArrayType)array).elementType()) instanceof StructType) {
                var89_88 = (StructType)elementStruct;
                x$27 = var87_86.copy(this.replace(var89_88, (Seq<String>)names, update, ifExists), var87_86.copy$default$2());
                x$28 = field.copy$default$1();
                x$29 = field.copy$default$3();
                x$30 = field.copy$default$4();
                var5_11 = new Some((Object)field.copy(x$28, x$27, x$29, x$30));
            } else if (var10_8 != null) {
                names = (Seq)var10_8._1();
                dataType = (DataType)var10_8._2();
                if (!ifExists) {
                    throw new IllegalArgumentException(new StringBuilder(23).append("Cannot find field: ").append(names.head()).append(" in ").append(dataType.simpleString()).toString());
                }
                var5_11 = None$.MODULE$;
            } else {
                throw new MatchError((Object)var10_8);
            }
        }
        replacement = var5_11;
        newFields = (StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])struct.fields())).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).flatMap((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$replace$4(int scala.Option scala.Tuple2 ), (Lscala/Tuple2;)Lscala/collection/Iterable;)((int)pos, (Option)replacement), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class)));
        return new StructType(newFields);
    }

    private boolean replace$default$4() {
        return false;
    }

    public Option<Table> loadTable(CatalogPlugin catalog, Identifier ident, Option<TimeTravelSpec> timeTravelSpec) {
        None$ none$;
        block9: {
            try {
                if (timeTravelSpec.nonEmpty()) {
                    Option option;
                    TimeTravelSpec timeTravelSpec2 = (TimeTravelSpec)timeTravelSpec.get();
                    if (timeTravelSpec2 instanceof AsOfVersion) {
                        AsOfVersion asOfVersion = (AsOfVersion)timeTravelSpec2;
                        option = Option$.MODULE$.apply((Object)CatalogV2Implicits$.MODULE$.CatalogHelper(catalog).asTableCatalog().loadTable(ident, asOfVersion.version()));
                    } else if (timeTravelSpec2 instanceof AsOfTimestamp) {
                        AsOfTimestamp asOfTimestamp = (AsOfTimestamp)timeTravelSpec2;
                        option = Option$.MODULE$.apply((Object)CatalogV2Implicits$.MODULE$.CatalogHelper(catalog).asTableCatalog().loadTable(ident, asOfTimestamp.timestamp()));
                    } else {
                        throw new MatchError((Object)timeTravelSpec2);
                    }
                    none$ = option;
                    break block9;
                }
                none$ = Option$.MODULE$.apply((Object)CatalogV2Implicits$.MODULE$.CatalogHelper(catalog).asTableCatalog().loadTable(ident));
            }
            catch (NoSuchTableException noSuchTableException) {
                none$ = None$.MODULE$;
            }
            catch (NoSuchDatabaseException noSuchDatabaseException) {
                none$ = None$.MODULE$;
            }
            catch (NoSuchNamespaceException noSuchNamespaceException) {
                none$ = None$.MODULE$;
            }
        }
        return none$;
    }

    public Option<TimeTravelSpec> loadTable$default$3() {
        return None$.MODULE$;
    }

    public Option<UnboundFunction> loadFunction(CatalogPlugin catalog, Identifier ident) {
        None$ none$;
        try {
            none$ = Option$.MODULE$.apply((Object)CatalogV2Implicits$.MODULE$.CatalogHelper(catalog).asFunctionCatalog().loadFunction(ident));
        }
        catch (NoSuchFunctionException noSuchFunctionException) {
            none$ = None$.MODULE$;
        }
        catch (NoSuchDatabaseException noSuchDatabaseException) {
            none$ = None$.MODULE$;
        }
        catch (NoSuchNamespaceException noSuchNamespaceException) {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public Option<NamedRelation> loadRelation(CatalogPlugin catalog, Identifier ident) {
        return this.loadTable(catalog, ident, this.loadTable$default$3()).map((Function1 & Serializable & scala.Serializable)x$8 -> DataSourceV2Relation$.MODULE$.create((Table)x$8, (Option<CatalogPlugin>)new Some((Object)catalog), (Option<Identifier>)new Some((Object)ident)));
    }

    public boolean isSessionCatalog(CatalogPlugin catalog) {
        return catalog.name().equalsIgnoreCase(CatalogManager$.MODULE$.SESSION_CATALOG_NAME());
    }

    public scala.collection.immutable.Map<String, String> convertTableProperties(TableSpec t) {
        scala.collection.immutable.Map<String, String> props = this.convertTableProperties(t.properties(), t.options(), t.serde(), t.location(), t.comment(), t.provider(), t.external());
        return this.withDefaultOwnership(props);
    }

    private scala.collection.immutable.Map<String, String> convertTableProperties(scala.collection.immutable.Map<String, String> properties, scala.collection.immutable.Map<String, String> options, Option<SerdeInfo> serdeInfo, Option<String> location, Option<String> comment, Option<String> provider, boolean external) {
        return properties.$plus$plus(options).$plus$plus((GenTraversableOnce)options.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String key = (String)tuple2._1();
            String value = (String)tuple2._2();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(7).append("option.").append(key).toString()), (Object)value);
            return tuple22;
        }, Map$.MODULE$.canBuildFrom())).$plus$plus(this.convertToProperties(serdeInfo)).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable((Option)(external ? new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"external"), (Object)"true")) : None$.MODULE$))).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(provider.map((Function1 & Serializable & scala.Serializable)x$9 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"provider"), x$9)))).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(comment.map((Function1 & Serializable & scala.Serializable)x$10 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"comment"), x$10)))).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(location.map((Function1 & Serializable & scala.Serializable)x$11 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"location"), x$11))));
    }

    private boolean convertTableProperties$default$7() {
        return false;
    }

    private scala.collection.immutable.Map<String, String> convertToProperties(Option<SerdeInfo> serdeInfo) {
        scala.collection.immutable.Map map;
        Option<SerdeInfo> option = serdeInfo;
        if (option instanceof Some) {
            Some some = (Some)option;
            SerdeInfo s = (SerdeInfo)some.value();
            map = ((MapLike)s.formatClasses().map((Function1 & Serializable & scala.Serializable)f -> (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hive.input-format"), (Object)f.input()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hive.output-format"), (Object)f.output())}))).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Map().empty())).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(s.storedAs().map((Function1 & Serializable & scala.Serializable)x$12 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hive.stored-as"), x$12)))).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(s.serde().map((Function1 & Serializable & scala.Serializable)x$13 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hive.serde"), x$13)))).$plus$plus((GenTraversableOnce)s.serdeProperties().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String key = (String)tuple2._1();
                String value = (String)tuple2._2();
                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(7).append("option.").append(key).toString()), (Object)value);
                return tuple22;
            }, Map$.MODULE$.canBuildFrom()));
        } else if (None$.MODULE$.equals(option)) {
            map = Predef$.MODULE$.Map().empty();
        } else {
            throw new MatchError(option);
        }
        return map;
    }

    public scala.collection.immutable.Map<String, String> withDefaultOwnership(scala.collection.immutable.Map<String, String> properties) {
        return properties.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"owner"), (Object)Utils$.MODULE$.getCurrentUserName())})));
    }

    public TableCatalog getTableProviderCatalog(SupportsCatalogOptions provider, CatalogManager catalogManager, CaseInsensitiveStringMap options) {
        return CatalogV2Implicits$.MODULE$.CatalogHelper((CatalogPlugin)Option$.MODULE$.apply((Object)provider.extractCatalog(options)).map((Function1 & Serializable & scala.Serializable)name -> catalogManager.catalog((String)name)).getOrElse((Function0 & Serializable & scala.Serializable)() -> catalogManager.v2SessionCatalog())).asTableCatalog();
    }

    public static final /* synthetic */ boolean $anonfun$applySchemaChanges$11(String name$1, StructField x$1) {
        String string = x$1.name();
        String string2 = name$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$applySchemaChanges$13(StructField oldField$1, StructField x$2) {
        StructField structField = x$2;
        StructField structField2 = oldField$1;
        return structField == null ? structField2 != null : !((Object)structField).equals(structField2);
    }

    private static final StructType updateFieldPos$1(StructType struct, String name, TableChange.UpdateColumnPosition x7$1) {
        StructField oldField = (StructField)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])struct.fields())).find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)CatalogV2Util$.$anonfun$applySchemaChanges$11(name, x$1))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(17).append("Field not found: ").append(name).toString());
        });
        StructType withFieldRemoved = new StructType((StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])struct.fields())).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)CatalogV2Util$.$anonfun$applySchemaChanges$13(oldField, x$2))));
        return MODULE$.addField(withFieldRemoved, oldField, x7$1.position());
    }

    public static final /* synthetic */ boolean $anonfun$addField$1(String afterCol$1, StructField x$5) {
        String string = x$5.name();
        String string2 = afterCol$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ Nothing$ $anonfun$replace$1() {
        throw new IllegalArgumentException("Cannot delete map key");
    }

    public static final /* synthetic */ Nothing$ $anonfun$replace$2() {
        throw new IllegalArgumentException("Cannot delete map value");
    }

    public static final /* synthetic */ Nothing$ $anonfun$replace$3() {
        throw new IllegalArgumentException("Cannot delete array element");
    }

    public static final /* synthetic */ Iterable $anonfun$replace$4(int pos$1, Option replacement$1, Tuple2 x0$1) {
        Iterable iterable;
        int index;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null && pos$1 == (index = tuple2._2$mcI$sp())) {
            iterable = Option$.MODULE$.option2Iterable(replacement$1);
        } else if (tuple2 != null) {
            StructField other = (StructField)tuple2._1();
            iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)other));
        } else {
            throw new MatchError((Object)tuple2);
        }
        return iterable;
    }

    private CatalogV2Util$() {
        MODULE$ = this;
        this.TABLE_RESERVED_PROPERTIES = (Seq)new .colon.colon((Object)"comment", (List)new .colon.colon((Object)"location", (List)new .colon.colon((Object)"provider", (List)new .colon.colon((Object)"owner", (List)new .colon.colon((Object)"external", (List)new .colon.colon((Object)"is_managed_location", (List)Nil$.MODULE$))))));
        this.NAMESPACE_RESERVED_PROPERTIES = (Seq)new .colon.colon((Object)"comment", (List)new .colon.colon((Object)"location", (List)new .colon.colon((Object)"owner", (List)Nil$.MODULE$)));
    }
}

