/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.memory;

import java.util.IdentityHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.arrow.memory.AllocationManager;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.memory.BaseAllocator;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.BufferManager;
import org.apache.arrow.memory.OwnershipTransferResult;
import org.apache.arrow.memory.ReferenceManager;
import org.apache.arrow.memory.ValueWithKeyIncluded;
import org.apache.arrow.memory.util.CommonUtil;
import org.apache.arrow.memory.util.HistoricalLog;
import org.apache.arrow.util.Preconditions;

public class BufferLedger
implements ValueWithKeyIncluded<BufferAllocator>,
ReferenceManager {
    private final IdentityHashMap<ArrowBuf, Object> buffers = BaseAllocator.DEBUG ? new IdentityHashMap() : null;
    private static final AtomicLong LEDGER_ID_GENERATOR = new AtomicLong(0L);
    private final long ledgerId = LEDGER_ID_GENERATOR.incrementAndGet();
    private final AtomicInteger bufRefCnt = new AtomicInteger(0);
    private final long lCreationTime = System.nanoTime();
    private final BufferAllocator allocator;
    private final AllocationManager allocationManager;
    private final HistoricalLog historicalLog = BaseAllocator.DEBUG ? new HistoricalLog(6, "BufferLedger[%d]", 1) : null;
    private volatile long lDestructionTime = 0L;

    BufferLedger(BufferAllocator allocator, AllocationManager allocationManager) {
        this.allocator = allocator;
        this.allocationManager = allocationManager;
    }

    boolean isOwningLedger() {
        return this == this.allocationManager.getOwningLedger();
    }

    @Override
    public BufferAllocator getKey() {
        return this.allocator;
    }

    @Override
    public BufferAllocator getAllocator() {
        return this.allocator;
    }

    @Override
    public int getRefCount() {
        return this.bufRefCnt.get();
    }

    void increment() {
        this.bufRefCnt.incrementAndGet();
    }

    @Override
    public boolean release() {
        return this.release(1);
    }

    @Override
    public boolean release(int decrement) {
        Preconditions.checkState(decrement >= 1, "ref count decrement should be greater than or equal to 1");
        int refCnt = this.decrement(decrement);
        if (BaseAllocator.DEBUG) {
            this.historicalLog.recordEvent("release(%d). original value: %d", decrement, refCnt + decrement);
        }
        Preconditions.checkState(refCnt >= 0, "RefCnt has gone negative");
        return refCnt == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int decrement(int decrement) {
        int outcome;
        this.allocator.assertOpen();
        AllocationManager allocationManager = this.allocationManager;
        synchronized (allocationManager) {
            outcome = this.bufRefCnt.addAndGet(-decrement);
            if (outcome == 0) {
                this.lDestructionTime = System.nanoTime();
                this.allocationManager.release(this);
            }
        }
        return outcome;
    }

    @Override
    public void retain() {
        this.retain(1);
    }

    @Override
    public void retain(int increment) {
        int originalReferenceCount;
        Preconditions.checkArgument(increment > 0, "retain(%s) argument is not positive", increment);
        if (BaseAllocator.DEBUG) {
            this.historicalLog.recordEvent("retain(%d)", increment);
        }
        Preconditions.checkArgument((originalReferenceCount = this.bufRefCnt.getAndAdd(increment)) > 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArrowBuf deriveBuffer(ArrowBuf sourceBuffer, long index, long length) {
        long derivedBufferAddress = sourceBuffer.memoryAddress() + index;
        ArrowBuf derivedBuf = new ArrowBuf(this, null, length, derivedBufferAddress);
        if (BaseAllocator.DEBUG) {
            this.historicalLog.recordEvent("ArrowBuf(BufferLedger, BufferAllocator[%s], UnsafeDirectLittleEndian[identityHashCode == %d](%s)) => ledger hc == %d", this.allocator.getName(), System.identityHashCode(derivedBuf), derivedBuf.toString(), System.identityHashCode(this));
            IdentityHashMap<ArrowBuf, Object> identityHashMap = this.buffers;
            synchronized (identityHashMap) {
                this.buffers.put(derivedBuf, null);
            }
        }
        return derivedBuf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ArrowBuf newArrowBuf(long length, BufferManager manager) {
        this.allocator.assertOpen();
        long startAddress = this.allocationManager.memoryAddress();
        ArrowBuf buf = new ArrowBuf(this, manager, length, startAddress);
        if (BaseAllocator.DEBUG) {
            this.historicalLog.recordEvent("ArrowBuf(BufferLedger, BufferAllocator[%s], UnsafeDirectLittleEndian[identityHashCode == %d](%s)) => ledger hc == %d", this.allocator.getName(), System.identityHashCode(buf), buf.toString(), System.identityHashCode(this));
            IdentityHashMap<ArrowBuf, Object> identityHashMap = this.buffers;
            synchronized (identityHashMap) {
                this.buffers.put(buf, null);
            }
        }
        return buf;
    }

    @Override
    public ArrowBuf retain(ArrowBuf srcBuffer, BufferAllocator target) {
        if (BaseAllocator.DEBUG) {
            this.historicalLog.recordEvent("retain(%s)", target.getName());
        }
        BufferLedger targetRefManager = this.allocationManager.associate(target);
        long targetBufLength = srcBuffer.capacity();
        ArrowBuf targetArrowBuf = targetRefManager.deriveBuffer(srcBuffer, 0L, targetBufLength);
        targetArrowBuf.readerIndex(srcBuffer.readerIndex());
        targetArrowBuf.writerIndex(srcBuffer.writerIndex());
        return targetArrowBuf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean transferBalance(ReferenceManager targetReferenceManager) {
        Preconditions.checkArgument(targetReferenceManager != null, "Expecting valid target reference manager");
        BufferAllocator targetAllocator = targetReferenceManager.getAllocator();
        Preconditions.checkArgument(this.allocator.getRoot() == targetAllocator.getRoot(), "You can only transfer between two allocators that share the same root.");
        this.allocator.assertOpen();
        targetReferenceManager.getAllocator().assertOpen();
        if (targetReferenceManager == this) {
            return true;
        }
        AllocationManager allocationManager = this.allocationManager;
        synchronized (allocationManager) {
            if (this.allocationManager.getOwningLedger() != this) {
                return true;
            }
            if (BaseAllocator.DEBUG) {
                this.historicalLog.recordEvent("transferBalance(%s)", targetReferenceManager.getAllocator().getName());
            }
            boolean overlimit = targetAllocator.forceAllocate(this.allocationManager.getSize());
            this.allocator.releaseBytes(this.allocationManager.getSize());
            this.allocationManager.setOwningLedger((BufferLedger)targetReferenceManager);
            return overlimit;
        }
    }

    @Override
    public TransferResult transferOwnership(ArrowBuf srcBuffer, BufferAllocator target) {
        BufferLedger targetRefManager = this.allocationManager.associate(target);
        long targetBufLength = srcBuffer.capacity();
        ArrowBuf targetArrowBuf = targetRefManager.deriveBuffer(srcBuffer, 0L, targetBufLength);
        targetArrowBuf.readerIndex(srcBuffer.readerIndex());
        targetArrowBuf.writerIndex(srcBuffer.writerIndex());
        boolean allocationFit = this.transferBalance(targetRefManager);
        return new TransferResult(allocationFit, targetArrowBuf);
    }

    @Override
    public long getSize() {
        return this.allocationManager.getSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getAccountedSize() {
        AllocationManager allocationManager = this.allocationManager;
        synchronized (allocationManager) {
            if (this.allocationManager.getOwningLedger() == this) {
                return this.allocationManager.getSize();
            }
            return 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void print(StringBuilder sb, int indent, BaseAllocator.Verbosity verbosity) {
        CommonUtil.indent(sb, indent).append("ledger[").append(this.ledgerId).append("] allocator: ").append(this.allocator.getName()).append("), isOwning: ").append(", size: ").append(", references: ").append(this.bufRefCnt.get()).append(", life: ").append(this.lCreationTime).append("..").append(this.lDestructionTime).append(", allocatorManager: [").append(", life: ");
        if (!BaseAllocator.DEBUG) {
            sb.append("]\n");
        } else {
            IdentityHashMap<ArrowBuf, Object> identityHashMap = this.buffers;
            synchronized (identityHashMap) {
                sb.append("] holds ").append(this.buffers.size()).append(" buffers. \n");
                for (ArrowBuf buf : this.buffers.keySet()) {
                    buf.print(sb, indent + 2, verbosity);
                    sb.append('\n');
                }
            }
        }
    }

    public AllocationManager getAllocationManager() {
        return this.allocationManager;
    }

    public class TransferResult
    implements OwnershipTransferResult {
        final boolean allocationFit;
        public final ArrowBuf buffer;

        private TransferResult(boolean allocationFit, ArrowBuf buffer) {
            this.allocationFit = allocationFit;
            this.buffer = buffer;
        }

        @Override
        public ArrowBuf getTransferredBuffer() {
            return this.buffer;
        }

        @Override
        public boolean getAllocationFit() {
            return this.allocationFit;
        }
    }
}

