/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.hbase.exceptions.HBaseException;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class PrettyPrinter {
    private static final Logger LOG = LoggerFactory.getLogger(PrettyPrinter.class);
    private static final String INTERVAL_REGEX = "((\\d+)\\s*SECONDS?\\s*\\()?\\s*((\\d+)\\s*DAYS?)?\\s*((\\d+)\\s*HOURS?)?\\s*((\\d+)\\s*MINUTES?)?\\s*((\\d+)\\s*SECONDS?)?\\s*\\)?";
    private static final Pattern INTERVAL_PATTERN = Pattern.compile("((\\d+)\\s*SECONDS?\\s*\\()?\\s*((\\d+)\\s*DAYS?)?\\s*((\\d+)\\s*HOURS?)?\\s*((\\d+)\\s*MINUTES?)?\\s*((\\d+)\\s*SECONDS?)?\\s*\\)?", 2);
    private static final String SIZE_REGEX = "((\\d+)\\s*B?\\s*\\()?\\s*((\\d+)\\s*TB?)?\\s*((\\d+)\\s*GB?)?\\s*((\\d+)\\s*MB?)?\\s*((\\d+)\\s*KB?)?\\s*((\\d+)\\s*B?)?\\s*\\)?";
    private static final Pattern SIZE_PATTERN = Pattern.compile("((\\d+)\\s*B?\\s*\\()?\\s*((\\d+)\\s*TB?)?\\s*((\\d+)\\s*GB?)?\\s*((\\d+)\\s*MB?)?\\s*((\\d+)\\s*KB?)?\\s*((\\d+)\\s*B?)?\\s*\\)?", 2);

    public static String format(String value, Unit unit) {
        StringBuilder human = new StringBuilder();
        switch (unit) {
            case TIME_INTERVAL: {
                human.append(PrettyPrinter.humanReadableTTL(Long.parseLong(value)));
                break;
            }
            case LONG: {
                byte[] longBytes = Bytes.toBytesBinary(value);
                human.append(String.valueOf(Bytes.toLong(longBytes)));
                break;
            }
            case BOOLEAN: {
                byte[] booleanBytes = Bytes.toBytesBinary(value);
                human.append(String.valueOf(Bytes.toBoolean(booleanBytes)));
                break;
            }
            case BYTE: {
                human.append(PrettyPrinter.humanReadableByte(Long.parseLong(value)));
                break;
            }
            default: {
                human.append(value);
            }
        }
        return human.toString();
    }

    public static String valueOf(String pretty, Unit unit) throws HBaseException {
        StringBuilder value = new StringBuilder();
        switch (unit) {
            case TIME_INTERVAL: {
                value.append(PrettyPrinter.humanReadableIntervalToSec(pretty));
                break;
            }
            case BYTE: {
                value.append(PrettyPrinter.humanReadableSizeToBytes(pretty));
                break;
            }
            default: {
                value.append(pretty);
            }
        }
        return value.toString();
    }

    @SuppressWarnings(value={"ICAST_INTEGER_MULTIPLY_CAST_TO_LONG"}, justification="Will not overflow")
    private static String humanReadableTTL(long interval) {
        StringBuilder sb = new StringBuilder();
        if (interval == Integer.MAX_VALUE) {
            sb.append("FOREVER");
            return sb.toString();
        }
        if (interval < 60L) {
            sb.append(interval);
            sb.append(" SECOND").append(interval == 1L ? "" : "S");
            return sb.toString();
        }
        int days = (int)(interval / 86400L);
        int hours = (int)(interval - (long)(86400 * days)) / 3600;
        int minutes = (int)(interval - (long)(86400 * days) - (long)(3600 * hours)) / 60;
        int seconds = (int)(interval - (long)(86400 * days) - (long)(3600 * hours) - (long)(60 * minutes));
        sb.append(interval);
        sb.append(" SECONDS (");
        if (days > 0) {
            sb.append(days);
            sb.append(" DAY").append(days == 1 ? "" : "S");
        }
        if (hours > 0) {
            sb.append(days > 0 ? " " : "");
            sb.append(hours);
            sb.append(" HOUR").append(hours == 1 ? "" : "S");
        }
        if (minutes > 0) {
            sb.append(days + hours > 0 ? " " : "");
            sb.append(minutes);
            sb.append(" MINUTE").append(minutes == 1 ? "" : "S");
        }
        if (seconds > 0) {
            sb.append(days + hours + minutes > 0 ? " " : "");
            sb.append(seconds);
            sb.append(" SECOND").append(minutes == 1 ? "" : "S");
        }
        sb.append(")");
        return sb.toString();
    }

    private static long humanReadableIntervalToSec(String humanReadableInterval) throws HBaseException {
        if (humanReadableInterval == null || humanReadableInterval.equalsIgnoreCase("FOREVER")) {
            return Integer.MAX_VALUE;
        }
        try {
            return Long.parseLong(humanReadableInterval);
        }
        catch (NumberFormatException ex) {
            LOG.debug("Given interval value is not a number, parsing for human readable format");
            String days = null;
            String hours = null;
            String minutes = null;
            String seconds = null;
            String expectedTtl = null;
            Matcher matcher = INTERVAL_PATTERN.matcher(humanReadableInterval);
            if (matcher.matches()) {
                expectedTtl = matcher.group(2);
                days = matcher.group(4);
                hours = matcher.group(6);
                minutes = matcher.group(8);
                seconds = matcher.group(10);
            }
            long ttl = 0L;
            ttl += days != null ? Long.parseLong(days) * 86400L : 0L;
            ttl += hours != null ? Long.parseLong(hours) * 3600L : 0L;
            ttl += minutes != null ? Long.parseLong(minutes) * 60L : 0L;
            if (expectedTtl != null && Long.parseLong(expectedTtl) != (ttl += seconds != null ? Long.parseLong(seconds) : 0L)) {
                throw new HBaseException("Malformed TTL string: TTL values in seconds and human readableformat do not match");
            }
            return ttl;
        }
    }

    private static String humanReadableByte(long size) {
        StringBuilder sb = new StringBuilder();
        if (size < 1024L) {
            sb.append(size);
            sb.append(" B");
            return sb.toString();
        }
        long tb = size / 0x10000000000L;
        long gb = (size - 0x10000000000L * tb) / 0x40000000L;
        long mb = (size - 0x10000000000L * tb - 0x40000000L * gb) / 0x100000L;
        long kb = (size - 0x10000000000L * tb - 0x40000000L * gb - 0x100000L * mb) / 1024L;
        long b = size - 0x10000000000L * tb - 0x40000000L * gb - 0x100000L * mb - 1024L * kb;
        sb.append(size).append(" B (");
        if (tb > 0L) {
            sb.append(tb);
            sb.append("TB");
        }
        if (gb > 0L) {
            sb.append(tb > 0L ? " " : "");
            sb.append(gb);
            sb.append("GB");
        }
        if (mb > 0L) {
            sb.append(tb + gb > 0L ? " " : "");
            sb.append(mb);
            sb.append("MB");
        }
        if (kb > 0L) {
            sb.append(tb + gb + mb > 0L ? " " : "");
            sb.append(kb);
            sb.append("KB");
        }
        if (b > 0L) {
            sb.append(tb + gb + mb + kb > 0L ? " " : "");
            sb.append(b);
            sb.append("B");
        }
        sb.append(")");
        return sb.toString();
    }

    private static long humanReadableSizeToBytes(String humanReadableSize) throws HBaseException {
        if (humanReadableSize == null) {
            return -1L;
        }
        try {
            return Long.parseLong(humanReadableSize);
        }
        catch (NumberFormatException ex) {
            LOG.debug("Given size value is not a number, parsing for human readable format");
            String tb = null;
            String gb = null;
            String mb = null;
            String kb = null;
            String b = null;
            String expectedSize = null;
            long size = 0L;
            Matcher matcher = SIZE_PATTERN.matcher(humanReadableSize);
            if (matcher.matches()) {
                expectedSize = matcher.group(2);
                tb = matcher.group(4);
                gb = matcher.group(6);
                mb = matcher.group(8);
                kb = matcher.group(10);
                b = matcher.group(12);
            }
            size += tb != null ? Long.parseLong(tb) * 0x10000000000L : 0L;
            size += gb != null ? Long.parseLong(gb) * 0x40000000L : 0L;
            size += mb != null ? Long.parseLong(mb) * 0x100000L : 0L;
            size += kb != null ? Long.parseLong(kb) * 1024L : 0L;
            if (expectedSize != null && Long.parseLong(expectedSize) != (size += b != null ? Long.parseLong(b) : 0L)) {
                throw new HBaseException("Malformed size string: values in byte and human readableformat do not match");
            }
            return size;
        }
    }

    public static String toString(Collection<?> collection) {
        ArrayList<String> stringList = new ArrayList<String>();
        for (Object o : collection) {
            stringList.add(Objects.toString(o));
        }
        return "[" + String.join((CharSequence)",", stringList) + "]";
    }

    public static enum Unit {
        TIME_INTERVAL,
        LONG,
        BOOLEAN,
        BYTE,
        NONE;

    }
}

