/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.spark;

import java.io.Serializable;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapred.TableOutputFormat;
import org.apache.hadoop.hbase.spark.AndLogicExpression;
import org.apache.hadoop.hbase.spark.DefaultSourceStaticUtils$;
import org.apache.hadoop.hbase.spark.DynamicLogicExpression;
import org.apache.hadoop.hbase.spark.EqualLogicExpression;
import org.apache.hadoop.hbase.spark.GreaterThanLogicExpression;
import org.apache.hadoop.hbase.spark.GreaterThanOrEqualLogicExpression;
import org.apache.hadoop.hbase.spark.HBaseConnectionCache$;
import org.apache.hadoop.hbase.spark.HBaseContext;
import org.apache.hadoop.hbase.spark.HBaseContext$;
import org.apache.hadoop.hbase.spark.HBaseRelation$;
import org.apache.hadoop.hbase.spark.IsNullLogicExpression;
import org.apache.hadoop.hbase.spark.LatestHBaseContextCache$;
import org.apache.hadoop.hbase.spark.LessThanLogicExpression;
import org.apache.hadoop.hbase.spark.LessThanOrEqualLogicExpression;
import org.apache.hadoop.hbase.spark.Logging;
import org.apache.hadoop.hbase.spark.OrLogicExpression;
import org.apache.hadoop.hbase.spark.PassThroughLogicExpression;
import org.apache.hadoop.hbase.spark.RowKeyFilter;
import org.apache.hadoop.hbase.spark.RowKeyFilter$;
import org.apache.hadoop.hbase.spark.ScanRange;
import org.apache.hadoop.hbase.spark.SmartConnection;
import org.apache.hadoop.hbase.spark.SparkSQLPushDownFilter;
import org.apache.hadoop.hbase.spark.StartsWithLogicExpression;
import org.apache.hadoop.hbase.spark.datasources.BoundRanges;
import org.apache.hadoop.hbase.spark.datasources.BytesEncoder;
import org.apache.hadoop.hbase.spark.datasources.Field;
import org.apache.hadoop.hbase.spark.datasources.HBaseSparkConf$;
import org.apache.hadoop.hbase.spark.datasources.HBaseTableCatalog;
import org.apache.hadoop.hbase.spark.datasources.HBaseTableCatalog$;
import org.apache.hadoop.hbase.spark.datasources.HBaseTableScanRDD;
import org.apache.hadoop.hbase.spark.datasources.JavaBytesEncoder$;
import org.apache.hadoop.hbase.spark.datasources.SerializableConfiguration;
import org.apache.hadoop.hbase.spark.datasources.Utils$;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapred.JobConf;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.sources.And;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.sources.EqualTo;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.sources.GreaterThan;
import org.apache.spark.sql.sources.GreaterThanOrEqual;
import org.apache.spark.sql.sources.InsertableRelation;
import org.apache.spark.sql.sources.IsNotNull;
import org.apache.spark.sql.sources.IsNull;
import org.apache.spark.sql.sources.LessThan;
import org.apache.spark.sql.sources.LessThanOrEqual;
import org.apache.spark.sql.sources.Or;
import org.apache.spark.sql.sources.PrunedFilteredScan;
import org.apache.spark.sql.sources.StringStartsWith;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.MutableList;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@InterfaceAudience.Private
@ScalaSignature(bytes="\u0006\u0001\r\u0015e\u0001\u0002$H\u0001JC\u0001b\u001c\u0001\u0003\u0016\u0004%\t\u0001\u001d\u0005\t\u007f\u0002\u0011\t\u0012)A\u0005c\"Q\u0011\u0011\u0002\u0001\u0003\u0016\u0004%\t!a\u0003\t\u0015\u0005}\u0001A!E!\u0002\u0013\ti\u0001\u0003\u0006\u0002\"\u0001\u0011)\u0019!C\u0001\u0003GA!\"!\f\u0001\u0005\u0003\u0005\u000b\u0011BA\u0013\u0011\u001d\t\t\u0004\u0001C\u0001\u0003gA\u0011\"a\u0010\u0001\u0005\u0004%\t!!\u0011\t\u0011\u0005-\u0003\u0001)A\u0005\u0003\u0007B\u0011\"!\u0014\u0001\u0005\u0004%\t!!\u0011\t\u0011\u0005=\u0003\u0001)A\u0005\u0003\u0007B\u0011\"!\u0015\u0001\u0005\u0004%\t!!\u0011\t\u0011\u0005M\u0003\u0001)A\u0005\u0003\u0007B\u0011\"!\u0016\u0001\u0005\u0004%\t!a\u0016\t\u0011\u0005\u0005\u0004\u0001)A\u0005\u00033B\u0011\"a\u0019\u0001\u0005\u0004%\t!!\u001a\t\u000f\u0005\u001d\u0004\u0001)A\u0005y\"I\u0011\u0011\u000e\u0001C\u0002\u0013\u0005\u00111\u000e\u0005\t\u0003s\u0002\u0001\u0015!\u0003\u0002n!I\u0011Q\u0010\u0001C\u0002\u0013\u0005\u0011q\u0010\u0005\t\u0003\u000f\u0003\u0001\u0015!\u0003\u0002\u0002\"9\u0011\u0011\u0012\u0001\u0005\u0002\u0005\u0015\u0004\"CAF\u0001\t\u0007I\u0011AAG\u0011!\t\t\n\u0001Q\u0001\n\u0005=\u0005\"CAJ\u0001\t\u0007I\u0011AAK\u0011!\ti\n\u0001Q\u0001\n\u0005]\u0005\"CAP\u0001\t\u0007I\u0011AAK\u0011!\t\t\u000b\u0001Q\u0001\n\u0005]\u0005\"CAR\u0001\t\u0007I\u0011AAK\u0011!\t)\u000b\u0001Q\u0001\n\u0005]\u0005\"CAT\u0001\t\u0007I\u0011AAU\u0011!\tY\u000b\u0001Q\u0001\n\u0005m\u0003\"CAW\u0001\t\u0007I\u0011AAU\u0011!\ty\u000b\u0001Q\u0001\n\u0005m\u0003\"CAY\u0001\t\u0007I\u0011AAU\u0011!\t\u0019\f\u0001Q\u0001\n\u0005m\u0003\"CA[\u0001\t\u0007I\u0011AA\\\u0011!\ty\f\u0001Q\u0001\n\u0005e\u0006\"CAa\u0001\t\u0007I\u0011AAb\u0011!\tY\r\u0001Q\u0001\n\u0005\u0015\u0007bBAg\u0001\u0011\u0005\u0011q\u001a\u0005\n\u0003;\u0004!\u0019!C!\u0003?D\u0001\"!9\u0001A\u0003%\u00111\u0003\u0005\b\u0003G\u0004A\u0011AAs\u0011\u001d\ti\u000f\u0001C!\u0003_DqAa\u0006\u0001\t\u0003\u0011I\u0002C\u0004\u0003B\u0001!\tAa\u0011\t\u000f\t}\u0003\u0001\"\u0001\u0003b!9!Q\u0010\u0001\u0005B\t}\u0004b\u0002BN\u0001\u0011\u0005!Q\u0014\u0005\b\u0005k\u0003A\u0011\u0001B\\\u0011%\u0011)\u000eAA\u0001\n\u0003\u00119\u000eC\u0005\u0003b\u0002\t\n\u0011\"\u0001\u0003d\"I!\u0011 \u0001\u0012\u0002\u0013\u0005!1 \u0005\n\u0005\u007f\u0004\u0011\u0011!C!\u0007\u0003A\u0011b!\u0005\u0001\u0003\u0003%\t!!+\t\u0013\rM\u0001!!A\u0005\u0002\rU\u0001\"CB\u000e\u0001\u0005\u0005I\u0011IB\u000f\u0011%\u00199\u0003AA\u0001\n\u0003\u0019I\u0003C\u0005\u0004.\u0001\t\t\u0011\"\u0011\u00040!I1\u0011\u0007\u0001\u0002\u0002\u0013\u000531\u0007\u0005\n\u0007k\u0001\u0011\u0011!C!\u0007o9\u0011b!\u0016H\u0003\u0003E\taa\u0016\u0007\u0011\u0019;\u0015\u0011!E\u0001\u00073Bq!!\rA\t\u0003\u0019\t\u0007C\u0005\u00042\u0001\u000b\t\u0011\"\u0012\u00044!I11\r!\u0002\u0002\u0013\u00055Q\r\u0005\n\u0007_\u0002\u0015\u0011!CA\u0007cB\u0011ba\u001fA\u0003\u0003%Ia! \u0003\u001b!\u0013\u0015m]3SK2\fG/[8o\u0015\tA\u0015*A\u0003ta\u0006\u00148N\u0003\u0002K\u0017\u0006)\u0001NY1tK*\u0011A*T\u0001\u0007Q\u0006$wn\u001c9\u000b\u00059{\u0015AB1qC\u000eDWMC\u0001Q\u0003\ry'oZ\u0002\u0001'\u001d\u00011\u000bX0cM2\u0004\"\u0001\u0016.\u000e\u0003US!AV,\u0002\u000fM|WO]2fg*\u0011\u0001,W\u0001\u0004gFd'B\u0001%N\u0013\tYVK\u0001\u0007CCN,'+\u001a7bi&|g\u000e\u0005\u0002U;&\u0011a,\u0016\u0002\u0013!J,h.\u001a3GS2$XM]3e'\u000e\fg\u000e\u0005\u0002UA&\u0011\u0011-\u0016\u0002\u0013\u0013:\u001cXM\u001d;bE2,'+\u001a7bi&|g\u000e\u0005\u0002dI6\tq)\u0003\u0002f\u000f\n9Aj\\4hS:<\u0007CA4k\u001b\u0005A'\"A5\u0002\u000bM\u001c\u0017\r\\1\n\u0005-D'a\u0002)s_\u0012,8\r\u001e\t\u0003O6L!A\u001c5\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\u0015A\f'/Y7fi\u0016\u00148/F\u0001r!\u0011\u0011\u0018\u0010 ?\u000f\u0005M<\bC\u0001;i\u001b\u0005)(B\u0001<R\u0003\u0019a$o\\8u}%\u0011\u0001\u0010[\u0001\u0007!J,G-\u001a4\n\u0005i\\(aA'ba*\u0011\u0001\u0010\u001b\t\u0003evL!A`>\u0003\rM#(/\u001b8h\u0003-\u0001\u0018M]1nKR,'o\u001d\u0011)\u0007\t\t\u0019\u0001E\u0002h\u0003\u000bI1!a\u0002i\u0005%!(/\u00198tS\u0016tG/A\nvg\u0016\u00148\u000b]3dS\u001aLW\rZ*dQ\u0016l\u0017-\u0006\u0002\u0002\u000eA)q-a\u0004\u0002\u0014%\u0019\u0011\u0011\u00035\u0003\r=\u0003H/[8o!\u0011\t)\"a\u0007\u000e\u0005\u0005]!bAA\r/\u0006)A/\u001f9fg&!\u0011QDA\f\u0005)\u0019FO];diRK\b/Z\u0001\u0015kN,'o\u00159fG&4\u0017.\u001a3TG\",W.\u0019\u0011\u0002\u0015M\fHnQ8oi\u0016DH/\u0006\u0002\u0002&A!\u0011qEA\u0015\u001b\u00059\u0016bAA\u0016/\nQ1+\u0015'D_:$X\r\u001f;\u0002\u0017M\fHnQ8oi\u0016DH\u000f\t\u0015\u0004\r\u0005\r\u0011A\u0002\u001fj]&$h\b\u0006\u0004\u00026\u0005m\u0012Q\b\u000b\u0005\u0003o\tI\u0004\u0005\u0002d\u0001!9\u0011\u0011E\u0004A\u0002\u0005\u0015\u0002\"B8\b\u0001\u0004\t\bbBA\u0005\u000f\u0001\u0007\u0011QB\u0001\ni&lWm\u001d;b[B,\"!a\u0011\u0011\u000b\u001d\fy!!\u0012\u0011\u0007\u001d\f9%C\u0002\u0002J!\u0014A\u0001T8oO\u0006QA/[7fgR\fW\u000e\u001d\u0011\u0002\u00195Lg\u000eV5nKN$\u0018-\u001c9\u0002\u001b5Lg\u000eV5nKN$\u0018-\u001c9!\u00031i\u0017\r\u001f+j[\u0016\u001cH/Y7q\u00035i\u0017\r\u001f+j[\u0016\u001cH/Y7qA\u0005YQ.\u0019=WKJ\u001c\u0018n\u001c8t+\t\tI\u0006E\u0003h\u0003\u001f\tY\u0006E\u0002h\u0003;J1!a\u0018i\u0005\rIe\u000e^\u0001\r[\u0006Dh+\u001a:tS>t7\u000fI\u0001\u000fK:\u001cw\u000eZ3s\u00072\u001ch*Y7f+\u0005a\u0018aD3oG>$WM]\"mg:\u000bW.\u001a\u0011\u0002\u000f\u0015t7m\u001c3feV\u0011\u0011Q\u000e\t\u0005\u0003_\n)(\u0004\u0002\u0002r)\u0019\u00111O$\u0002\u0017\u0011\fG/Y:pkJ\u001cWm]\u0005\u0005\u0003o\n\tH\u0001\u0007CsR,7/\u00128d_\u0012,'/\u0001\u0005f]\u000e|G-\u001a:!Q\r\u0019\u00121A\u0001\bG\u0006$\u0018\r\\8h+\t\t\t\t\u0005\u0003\u0002p\u0005\r\u0015\u0002BAC\u0003c\u0012\u0011\u0003\u0013\"bg\u0016$\u0016M\u00197f\u0007\u0006$\u0018\r\\8h\u0003!\u0019\u0017\r^1m_\u001e\u0004\u0013!\u0003;bE2,g*Y7f\u0003=\u0019wN\u001c4jOJ+7o\\;sG\u0016\u001cXCAAH!\u00119\u0017q\u0002?\u0002!\r|gNZ5h%\u0016\u001cx.\u001e:dKN\u0004\u0013aD;tK\"\u0013\u0015m]3D_:$X\r\u001f;\u0016\u0005\u0005]\u0005cA4\u0002\u001a&\u0019\u00111\u00145\u0003\u000f\t{w\u000e\\3b]\u0006\u0001Ro]3I\u0005\u0006\u001cXmQ8oi\u0016DH\u000fI\u0001\u0018kN,\u0007+^:i\t><hnQ8mk6tg)\u001b7uKJ\f\u0001$^:f!V\u001c\b\u000eR8x]\u000e{G.^7o\r&dG/\u001a:!\u0003A\u0011Gn\\2l\u0007\u0006\u001c\u0007.Z#oC\ndW-A\tcY>\u001c7nQ1dQ\u0016,e.\u00192mK\u0002\n\u0011bY1dQ\u0016\u001c\u0016N_3\u0016\u0005\u0005m\u0013AC2bG\",7+\u001b>fA\u0005A!-\u0019;dQ:+X.A\u0005cCR\u001c\u0007NT;nA\u0005Y!-\u001e7l\u000f\u0016$8+\u001b>f\u00031\u0011W\u000f\\6HKR\u001c\u0016N_3!\u00031A'-Y:f\u0007>tG/\u001a=u+\t\tI\fE\u0002d\u0003wK1!!0H\u00051A%)Y:f\u0007>tG/\u001a=u\u00035A'-Y:f\u0007>tG/\u001a=uA\u0005YqO]1qa\u0016$7i\u001c8g+\t\t)\r\u0005\u0003\u0002p\u0005\u001d\u0017\u0002BAe\u0003c\u0012\u0011dU3sS\u0006d\u0017N_1cY\u0016\u001cuN\u001c4jOV\u0014\u0018\r^5p]\u0006aqO]1qa\u0016$7i\u001c8gA\u0005I\u0001NY1tK\u000e{gNZ\u000b\u0003\u0003#\u0004B!a5\u0002Z6\u0011\u0011Q\u001b\u0006\u0004\u0003/\\\u0015\u0001B2p]\u001aLA!a7\u0002V\ni1i\u001c8gS\u001e,(/\u0019;j_:\faa]2iK6\fWCAA\n\u0003\u001d\u00198\r[3nC\u0002\n1b\u0019:fCR,G+\u00192mKR\u0011\u0011q\u001d\t\u0004O\u0006%\u0018bAAvQ\n!QK\\5u\u0003\u0019Ign]3siR1\u0011q]Ay\u0005'Aq!a=.\u0001\u0004\t)0\u0001\u0003eCR\f\u0007\u0003BA|\u0005\u001bqA!!?\u0003\n9!\u00111 B\u0004\u001d\u0011\tiP!\u0002\u000f\t\u0005}(1\u0001\b\u0004i\n\u0005\u0011\"\u0001)\n\u00059{\u0015B\u0001%N\u0013\tA\u0016,C\u0002\u0003\f]\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0003\u0010\tE!!\u0003#bi\u00064%/Y7f\u0015\r\u0011Ya\u0016\u0005\b\u0005+i\u0003\u0019AAL\u0003%yg/\u001a:xe&$X-A\u000bhKRLe\u000eZ3yK\u0012\u0004&o\u001c6fGRLwN\\:\u0015\t\tm!q\u0007\t\u0007\u0005;\u0011)Ca\u000b\u000f\t\t}!1\u0005\b\u0004i\n\u0005\u0012\"A5\n\u0007\t-\u0001.\u0003\u0003\u0003(\t%\"aA*fc*\u0019!1\u00025\u0011\u000f\u001d\u0014iC!\r\u0002\\%\u0019!q\u00065\u0003\rQ+\b\u000f\\33!\u0011\tyGa\r\n\t\tU\u0012\u0011\u000f\u0002\u0006\r&,G\u000e\u001a\u0005\b\u0005sq\u0003\u0019\u0001B\u001e\u0003=\u0011X-];je\u0016$7i\u001c7v[:\u001c\b\u0003B4\u0003>qL1Aa\u0010i\u0005\u0015\t%O]1z\u0003-\u0001\u0018M]:f%><8*Z=\u0015\r\t\u0015#Q\nB-!\u0019\u0011\u0018P!\r\u0003HA\u0019qM!\u0013\n\u0007\t-\u0003NA\u0002B]fDqAa\u00140\u0001\u0004\u0011\t&A\u0002s_^\u0004Ra\u001aB\u001f\u0005'\u00022a\u001aB+\u0013\r\u00119\u0006\u001b\u0002\u0005\u0005f$X\rC\u0004\u0003\\=\u0002\rA!\u0018\u0002\u0013-,\u0017PR5fY\u0012\u001c\bC\u0002B\u000f\u0005K\u0011\t$\u0001\u0005ck&dGMU8x)\u0019\u0011\u0019G!\u001b\u0003nA!\u0011q\u0005B3\u0013\r\u00119g\u0016\u0002\u0004%><\bb\u0002B6a\u0001\u0007!QL\u0001\u0007M&,G\u000eZ:\t\u000f\t=\u0004\u00071\u0001\u0003r\u00051!/Z:vYR\u0004BAa\u001d\u0003z5\u0011!Q\u000f\u0006\u0004\u0005oJ\u0015AB2mS\u0016tG/\u0003\u0003\u0003|\tU$A\u0002*fgVdG/A\u0005ck&dGmU2b]R1!\u0011\u0011BG\u0005\u001f\u0003bAa!\u0003\n\n\rTB\u0001BC\u0015\r\u00119)W\u0001\u0004e\u0012$\u0017\u0002\u0002BF\u0005\u000b\u00131A\u0015#E\u0011\u001d\u0011I$\ra\u0001\u0005wAqA!%2\u0001\u0004\u0011\u0019*A\u0004gS2$XM]:\u0011\u000b\u001d\u0014iD!&\u0011\u0007Q\u00139*C\u0002\u0003\u001aV\u0013aAR5mi\u0016\u0014\u0018a\b2vS2$\u0007+^:i\t><h\u000e\u0015:fI&\u001c\u0017\r^3t%\u0016\u001cx.\u001e:dKR!!q\u0014BZ!%9'\u0011\u0015BS\u0005W\u0013\t,C\u0002\u0003$\"\u0014a\u0001V;qY\u0016\u001c\u0004cA2\u0003(&\u0019!\u0011V$\u0003\u0019I{woS3z\r&dG/\u001a:\u0011\u0007\r\u0014i+C\u0002\u00030\u001e\u0013a\u0003R=oC6L7\rT8hS\u000e,\u0005\u0010\u001d:fgNLwN\u001c\t\u0006O\nu\"\u0011\u000b\u0005\b\u0005#\u0013\u0004\u0019\u0001BJ\u0003Q!(/\u00198tm\u0016\u00148/\u001a$jYR,'\u000f\u0016:fKRA!1\u0016B]\u0005{\u0013\t\u000eC\u0004\u0003<N\u0002\rA!*\u0002%A\f'/\u001a8u%><8*Z=GS2$XM\u001d\u0005\b\u0005\u007f\u001b\u0004\u0019\u0001Ba\u0003)1\u0018\r\\;f\u0003J\u0014\u0018-\u001f\t\u0007\u0005\u0007\u0014iM!\u0015\u000e\u0005\t\u0015'\u0002\u0002Bd\u0005\u0013\fq!\\;uC\ndWMC\u0002\u0003L\"\f!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011yM!2\u0003\u00175+H/\u00192mK2K7\u000f\u001e\u0005\b\u0005'\u001c\u0004\u0019\u0001BK\u0003\u00191\u0017\u000e\u001c;fe\u0006!1m\u001c9z)\u0019\u0011IN!8\u0003`R!\u0011q\u0007Bn\u0011\u001d\t\t\u0003\u000ea\u0001\u0003KAqa\u001c\u001b\u0011\u0002\u0003\u0007\u0011\u000fC\u0005\u0002\nQ\u0002\n\u00111\u0001\u0002\u000e\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nTC\u0001BsU\r\t(q]\u0016\u0003\u0005S\u0004BAa;\u0003v6\u0011!Q\u001e\u0006\u0005\u0005_\u0014\t0A\u0005v]\u000eDWmY6fI*\u0019!1\u001f5\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003x\n5(!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TC\u0001B\u007fU\u0011\tiAa:\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\u0019\u0019\u0001\u0005\u0003\u0004\u0006\r=QBAB\u0004\u0015\u0011\u0019Iaa\u0003\u0002\t1\fgn\u001a\u0006\u0003\u0007\u001b\tAA[1wC&\u0019apa\u0002\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!!qIB\f\u0011%\u0019I\"OA\u0001\u0002\u0004\tY&A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0007?\u0001ba!\t\u0004$\t\u001dSB\u0001Be\u0013\u0011\u0019)C!3\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003/\u001bY\u0003C\u0005\u0004\u001am\n\t\u00111\u0001\u0003H\u0005A\u0001.Y:i\u0007>$W\r\u0006\u0002\u0002\\\u0005AAo\\*ue&tw\r\u0006\u0002\u0004\u0004\u00051Q-];bYN$B!a&\u0004:!I1\u0011\u0004 \u0002\u0002\u0003\u0007!q\t\u0015\u0004\u0001\ru\u0002\u0003BB \u0007\u001frAa!\u0011\u0004L5\u001111\t\u0006\u0005\u0007\u000b\u001a9%\u0001\u0005bk\u0012LWM\\2f\u0015\r\u0019I%T\u0001\u0006s\u0016$Xo]\u0005\u0005\u0007\u001b\u001a\u0019%A\tJ]R,'OZ1dK\u0006+H-[3oG\u0016LAa!\u0015\u0004T\t9\u0001K]5wCR,'\u0002BB'\u0007\u0007\nQ\u0002\u0013\"bg\u0016\u0014V\r\\1uS>t\u0007CA2A'\u0011\u000151\f7\u0011\u0007\u001d\u001ci&C\u0002\u0004`!\u0014a!\u00118z%\u00164GCAB,\u0003\u0015\t\u0007\u000f\u001d7z)\u0019\u00199ga\u001b\u0004nQ!\u0011qGB5\u0011\u001d\t\tc\u0011a\u0001\u0003KAQa\\\"A\u0002EDq!!\u0003D\u0001\u0004\ti!A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\rM4q\u000f\t\u0006O\u0006=1Q\u000f\t\u0007O\n5\u0012/!\u0004\t\u0013\reD)!AA\u0002\u0005]\u0012a\u0001=%a\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\u0019y\b\u0005\u0003\u0004\u0006\r\u0005\u0015\u0002BBB\u0007\u000f\u0011aa\u00142kK\u000e$\b")
public class HBaseRelation
extends BaseRelation
implements PrunedFilteredScan,
InsertableRelation,
Logging,
Product,
scala.Serializable {
    private final transient Map<String, String> parameters;
    private final Option<StructType> userSpecifiedSchema;
    private final transient SQLContext sqlContext;
    private final Option<Object> timestamp;
    private final Option<Object> minTimestamp;
    private final Option<Object> maxTimestamp;
    private final Option<Object> maxVersions;
    private final String encoderClsName;
    private final transient BytesEncoder encoder;
    private final HBaseTableCatalog catalog;
    private final Option<String> configResources;
    private final boolean useHBaseContext;
    private final boolean usePushDownColumnFilter;
    private final boolean blockCacheEnable;
    private final int cacheSize;
    private final int batchNum;
    private final int bulkGetSize;
    private final HBaseContext hbaseContext;
    private final SerializableConfiguration wrappedConf;
    private final StructType schema;
    private transient Logger org$apache$hadoop$hbase$spark$Logging$$log_;

    public static Option<Tuple2<Map<String, String>, Option<StructType>>> unapply(HBaseRelation hBaseRelation) {
        return HBaseRelation$.MODULE$.unapply(hBaseRelation);
    }

    public static HBaseRelation apply(Map<String, String> map, Option<StructType> option, SQLContext sQLContext) {
        return HBaseRelation$.MODULE$.apply(map, option, sQLContext);
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public Logger org$apache$hadoop$hbase$spark$Logging$$log_() {
        return this.org$apache$hadoop$hbase$spark$Logging$$log_;
    }

    @Override
    public void org$apache$hadoop$hbase$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$hadoop$hbase$spark$Logging$$log_ = x$1;
    }

    public Map<String, String> parameters() {
        return this.parameters;
    }

    public Option<StructType> userSpecifiedSchema() {
        return this.userSpecifiedSchema;
    }

    public SQLContext sqlContext() {
        return this.sqlContext;
    }

    public Option<Object> timestamp() {
        return this.timestamp;
    }

    public Option<Object> minTimestamp() {
        return this.minTimestamp;
    }

    public Option<Object> maxTimestamp() {
        return this.maxTimestamp;
    }

    public Option<Object> maxVersions() {
        return this.maxVersions;
    }

    public String encoderClsName() {
        return this.encoderClsName;
    }

    public BytesEncoder encoder() {
        return this.encoder;
    }

    public HBaseTableCatalog catalog() {
        return this.catalog;
    }

    public String tableName() {
        return new StringBuilder(1).append(this.catalog().namespace()).append(":").append(this.catalog().name()).toString();
    }

    public Option<String> configResources() {
        return this.configResources;
    }

    public boolean useHBaseContext() {
        return this.useHBaseContext;
    }

    public boolean usePushDownColumnFilter() {
        return this.usePushDownColumnFilter;
    }

    public boolean blockCacheEnable() {
        return this.blockCacheEnable;
    }

    public int cacheSize() {
        return this.cacheSize;
    }

    public int batchNum() {
        return this.batchNum;
    }

    public int bulkGetSize() {
        return this.bulkGetSize;
    }

    public HBaseContext hbaseContext() {
        return this.hbaseContext;
    }

    public SerializableConfiguration wrappedConf() {
        return this.wrappedConf;
    }

    public Configuration hbaseConf() {
        return this.wrappedConf().value();
    }

    public StructType schema() {
        return this.schema;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void createTable() {
        int numReg = BoxesRunTime.unboxToInt((Object)this.parameters().get((Object)HBaseTableCatalog$.MODULE$.newTable()).map((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToInteger((int)HBaseRelation.$anonfun$createTable$1(x))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
        byte[] startKey = Bytes.toBytes((String)((String)this.parameters().get((Object)HBaseTableCatalog$.MODULE$.regionStart()).getOrElse((Function0 & Serializable & scala.Serializable)() -> HBaseTableCatalog$.MODULE$.defaultRegionStart())));
        byte[] endKey = Bytes.toBytes((String)((String)this.parameters().get((Object)HBaseTableCatalog$.MODULE$.regionEnd()).getOrElse((Function0 & Serializable & scala.Serializable)() -> HBaseTableCatalog$.MODULE$.defaultRegionEnd())));
        if (numReg > 3) {
            TableName tName = TableName.valueOf((String)this.tableName());
            Seq<String> cfs = this.catalog().getColumnFamilies();
            SmartConnection connection = HBaseConnectionCache$.MODULE$.getConnection(this.hbaseConf());
            Admin admin = connection.getAdmin();
            try {
                if (admin.tableExists(tName)) return;
                HTableDescriptor tableDesc = new HTableDescriptor(tName);
                cfs.foreach((Function1 & Serializable & scala.Serializable)x -> {
                    HColumnDescriptor cf = new HColumnDescriptor(x.getBytes());
                    this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(15).append("add family ").append((String)x).append(" to ").append(this.tableName()).toString());
                    return tableDesc.addFamily(cf);
                });
                byte[][] splitKeys = Bytes.split((byte[])startKey, (byte[])endKey, (int)numReg);
                admin.createTable((TableDescriptor)tableDesc, splitKeys);
                return;
            }
            finally {
                admin.close();
                connection.close();
            }
        } else {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(70).append(HBaseTableCatalog$.MODULE$.newTable()).append("\n           |is not defined or no larger than 3, skip the create table").toString())).stripMargin());
        }
    }

    public void insert(Dataset<Row> data, boolean overwrite) {
        JobConf jobConfig = new JobConf(this.hbaseConf(), this.getClass());
        jobConfig.setOutputFormat(TableOutputFormat.class);
        jobConfig.set("hbase.mapred.outputtable", this.tableName());
        IntRef count = IntRef.create((int)0);
        Seq<Field> rkFields = this.catalog().getRowKey();
        Seq rkIdxedFields = (Seq)rkFields.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Field field = x0$1;
            Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)this.schema().fieldIndex(field.colName())), (Object)field);
            return tuple2;
        }, Seq$.MODULE$.canBuildFrom());
        Tuple2[] colsIdxedFields = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.schema().fieldNames())).partition((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)HBaseRelation.$anonfun$insert$2(rkFields, x)))._2())).map((Function1 & Serializable & scala.Serializable)x -> new Tuple2((Object)BoxesRunTime.boxToInteger((int)this.schema().fieldIndex(x)), (Object)this.catalog().getField((String)x)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
        RDD rdd = data.rdd();
        RDD$.MODULE$.rddToPairRDDFunctions(rdd.map((Function1 & Serializable & scala.Serializable)x$13 -> this.convertToPut$1((Row)x$13, rkIdxedFields, colsIdxedFields, count), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(ImmutableBytesWritable.class), ClassTag$.MODULE$.apply(Put.class), Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms())).saveAsHadoopDataset(jobConfig);
    }

    public Seq<Tuple2<Field, Object>> getIndexedProjections(String[] requiredColumns) {
        return (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])requiredColumns)).map((Function1 & Serializable & scala.Serializable)x$14 -> this.catalog().sMap().getField((String)x$14), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Field.class))))).zipWithIndex(Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
    }

    public Map<Field, Object> parseRowKey(byte[] row, Seq<Field> keyFields) {
        return ((TraversableOnce)((Tuple2)keyFields.foldLeft((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)0), (Object)Nil$.MODULE$), (Function2 & Serializable & scala.Serializable)(state, field) -> {
            Tuple2 tuple2;
            int idx = state._1$mcI$sp();
            Seq parsed = (Seq)state._2();
            if (field.length() != -1) {
                Object value = Utils$.MODULE$.hbaseFieldToScalaType((Field)field, row, idx, field.length());
                tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)(idx + field.length())), parsed.$plus$plus((GenTraversableOnce)new .colon.colon((Object)new Tuple2(field, value), (List)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom()));
            } else {
                Tuple2 tuple22;
                DataType dataType = field.dt();
                if (StringType$.MODULE$.equals(dataType)) {
                    Tuple2 tuple23;
                    int pos = new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(row)).indexOf((Object)BoxesRunTime.boxToByte((byte)HBaseTableCatalog$.MODULE$.delimiter()), idx);
                    if (pos == -1 || pos > row.length) {
                        Object value = Utils$.MODULE$.hbaseFieldToScalaType((Field)field, row, idx, row.length);
                        tuple23 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)(row.length + 1)), parsed.$plus$plus((GenTraversableOnce)new .colon.colon((Object)new Tuple2(field, value), (List)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom()));
                    } else {
                        Object value = Utils$.MODULE$.hbaseFieldToScalaType((Field)field, row, idx, pos - idx);
                        tuple23 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)pos), parsed.$plus$plus((GenTraversableOnce)new .colon.colon((Object)new Tuple2(field, value), (List)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom()));
                    }
                    tuple22 = tuple23;
                } else {
                    tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)(row.length + 1)), parsed.$plus$plus((GenTraversableOnce)new .colon.colon((Object)new Tuple2(field, Utils$.MODULE$.hbaseFieldToScalaType((Field)field, row, idx, row.length)), (List)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom()));
                }
                tuple2 = tuple22;
            }
            return tuple2;
        }))._2()).toMap(Predef$.MODULE$.$conforms());
    }

    public Row buildRow(Seq<Field> fields, Result result) {
        byte[] r = result.getRow();
        Map<Field, Object> keySeq = this.parseRowKey(r, this.catalog().getRowKey());
        Map valueSeq = ((TraversableOnce)((TraversableLike)fields.filter((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)HBaseRelation.$anonfun$buildRow$1(x$15)))).map((Function1 & Serializable & scala.Serializable)x -> {
            Tuple2 tuple2;
            Cell kv = result.getColumnLatestCell(Bytes.toBytes((String)x.cf()), Bytes.toBytes((String)x.col()));
            if (kv == null || kv.getValueLength() == 0) {
                tuple2 = new Tuple2(x, null);
            } else {
                byte[] v = CellUtil.cloneValue((Cell)kv);
                DataType dataType = x.dt();
                Object object = BinaryType$.MODULE$.equals(dataType) ? v : (Object)Utils$.MODULE$.hbaseFieldToScalaType((Field)x, v, 0, v.length);
                Tuple2 tuple22 = new Tuple2(x, object);
                tuple2 = tuple22;
            }
            return tuple2;
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Map unionedRow = keySeq.$plus$plus((GenTraversableOnce)valueSeq);
        return Row$.MODULE$.fromSeq((Seq)fields.map((Function1 & Serializable & scala.Serializable)x$16 -> unionedRow.get(x$16).getOrElse((Function0 & Serializable & scala.Serializable)() -> null), Seq$.MODULE$.canBuildFrom()));
    }

    public RDD<Row> buildScan(String[] requiredColumns, Filter[] filters) {
        RDD resultRDD;
        block2: {
            RDD rdd;
            Tuple3<RowKeyFilter, DynamicLogicExpression, byte[][]> pushDownTuple = this.buildPushDownPredicatesResource(filters);
            RowKeyFilter pushDownRowKeyFilter = (RowKeyFilter)pushDownTuple._1();
            ObjectRef pushDownDynamicLogicExpression = ObjectRef.create((Object)((DynamicLogicExpression)pushDownTuple._2()));
            byte[][] valueArray = (byte[][])pushDownTuple._3();
            if (!this.usePushDownColumnFilter()) {
                pushDownDynamicLogicExpression.elem = null;
            }
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("pushDownRowKeyFilter:           ").append(pushDownRowKeyFilter.ranges()).toString());
            if ((DynamicLogicExpression)pushDownDynamicLogicExpression.elem != null) {
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("pushDownDynamicLogicExpression: ").append(((DynamicLogicExpression)pushDownDynamicLogicExpression$1.elem).toExpressionString()).toString());
            }
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("valueArray:                     ").append(valueArray.length).toString());
            MutableList requiredQualifierDefinitionList = new MutableList();
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])requiredColumns)).foreach((Function1 & Serializable & scala.Serializable)c -> {
                Field field = this.catalog().getField((String)c);
                return requiredQualifierDefinitionList.$plus$eq((Object)field);
            });
            DefaultSourceStaticUtils$.MODULE$.populateLatestExecutionRules(pushDownRowKeyFilter, (DynamicLogicExpression)pushDownDynamicLogicExpression.elem);
            ArrayList getList = new ArrayList();
            ArrayList rddList = new ArrayList();
            pushDownRowKeyFilter.points().foreach((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)HBaseRelation.$anonfun$buildScan$5(requiredQualifierDefinitionList, getList, p)));
            None$ pushDownFilterJava = this.usePushDownColumnFilter() && (DynamicLogicExpression)pushDownDynamicLogicExpression.elem != null ? new Some((Object)new SparkSQLPushDownFilter((DynamicLogicExpression)pushDownDynamicLogicExpression.elem, valueArray, (MutableList<Field>)requiredQualifierDefinitionList, this.encoderClsName())) : None$.MODULE$;
            HBaseTableScanRDD hRdd = new HBaseTableScanRDD(this, this.hbaseContext(), (Option<SparkSQLPushDownFilter>)pushDownFilterJava, (Seq<Field>)requiredQualifierDefinitionList.seq());
            pushDownRowKeyFilter.points().foreach((Function1 & Serializable & scala.Serializable)x$17 -> {
                hRdd.addPoint(x$17);
                return BoxedUnit.UNIT;
            });
            pushDownRowKeyFilter.ranges().foreach((Function1 & Serializable & scala.Serializable)x$18 -> {
                hRdd.addRange(x$18);
                return BoxedUnit.UNIT;
            });
            RDD tmp = hRdd.map((Function1 & Serializable & scala.Serializable)r -> {
                Seq indexedFields = (Seq)this.getIndexedProjections(requiredColumns).map((Function1 & Serializable & scala.Serializable)x$19 -> (Field)x$19._1(), Seq$.MODULE$.canBuildFrom());
                return this.buildRow((Seq<Field>)indexedFields, (Result)r);
            }, ClassTag$.MODULE$.apply(Row.class));
            Object object = resultRDD = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])tmp.partitions())).size() > 0 ? tmp : null;
            if (resultRDD != null) break block2;
            Scan scan = new Scan();
            scan.setCacheBlocks(this.blockCacheEnable());
            scan.setBatch(this.batchNum());
            scan.setCaching(this.cacheSize());
            requiredQualifierDefinitionList.foreach((Function1 & Serializable & scala.Serializable)d -> scan.addColumn(d.cfBytes(), d.colBytes()));
            resultRDD = rdd = this.hbaseContext().hbaseRDD(TableName.valueOf((String)this.tableName()), scan).map((Function1 & Serializable & scala.Serializable)r -> {
                Seq indexedFields = (Seq)this.getIndexedProjections(requiredColumns).map((Function1 & Serializable & scala.Serializable)x$20 -> (Field)x$20._1(), Seq$.MODULE$.canBuildFrom());
                return this.buildRow((Seq<Field>)indexedFields, (Result)r._2());
            }, ClassTag$.MODULE$.apply(Row.class));
        }
        return resultRDD;
    }

    public Tuple3<RowKeyFilter, DynamicLogicExpression, byte[][]> buildPushDownPredicatesResource(Filter[] filters) {
        ObjectRef superRowKeyFilter = ObjectRef.create(null);
        MutableList queryValueList = new MutableList();
        ObjectRef superDynamicLogicExpression = ObjectRef.create(null);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filters)).foreach((Function1 & Serializable & scala.Serializable)f -> {
            Object object;
            RowKeyFilter rowKeyFilter = new RowKeyFilter(RowKeyFilter$.MODULE$.$lessinit$greater$default$1(), RowKeyFilter$.MODULE$.$lessinit$greater$default$2(), RowKeyFilter$.MODULE$.$lessinit$greater$default$3(), RowKeyFilter$.MODULE$.$lessinit$greater$default$4());
            DynamicLogicExpression logicExpression = this.transverseFilterTree(rowKeyFilter, (MutableList<byte[]>)queryValueList, (Filter)f);
            if ((DynamicLogicExpression)superDynamicLogicExpression$1.elem == null) {
                superDynamicLogicExpression$1.elem = logicExpression;
                superRowKeyFilter$1.elem = rowKeyFilter;
                object = BoxedUnit.UNIT;
            } else {
                superDynamicLogicExpression$1.elem = new AndLogicExpression((DynamicLogicExpression)superDynamicLogicExpression$1.elem, logicExpression);
                object = ((RowKeyFilter)superRowKeyFilter$1.elem).mergeIntersect(rowKeyFilter);
            }
            return object;
        });
        byte[][] queryValueArray = (byte[][])queryValueList.toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
        if ((RowKeyFilter)superRowKeyFilter.elem == null) {
            superRowKeyFilter.elem = new RowKeyFilter(RowKeyFilter$.MODULE$.$lessinit$greater$default$1(), RowKeyFilter$.MODULE$.$lessinit$greater$default$2(), RowKeyFilter$.MODULE$.$lessinit$greater$default$3(), RowKeyFilter$.MODULE$.$lessinit$greater$default$4());
        }
        return new Tuple3((Object)((RowKeyFilter)superRowKeyFilter.elem), (Object)((DynamicLogicExpression)superDynamicLogicExpression.elem), (Object)queryValueArray);
    }

    public DynamicLogicExpression transverseFilterTree(RowKeyFilter parentRowKeyFilter, MutableList<byte[]> valueArray, Filter filter) {
        DynamicLogicExpression dynamicLogicExpression;
        Filter filter2 = filter;
        if (filter2 instanceof EqualTo) {
            BoxedUnit boxedUnit;
            EqualTo equalTo = (EqualTo)filter2;
            String attr = equalTo.attribute();
            Object value = equalTo.value();
            Field field = this.catalog().getField(attr);
            if (field != null) {
                Object object = field.isRowKey() ? parentRowKeyFilter.mergeIntersect(new RowKeyFilter(Utils$.MODULE$.toBytes(value, field), null, RowKeyFilter$.MODULE$.$lessinit$greater$default$3(), RowKeyFilter$.MODULE$.$lessinit$greater$default$4())) : BoxedUnit.UNIT;
                byte[] byteValue = Utils$.MODULE$.toBytes(value, field);
                boxedUnit = valueArray.$plus$eq((Object)byteValue);
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            dynamicLogicExpression = new EqualLogicExpression(attr, valueArray.length() - 1, false);
        } else if (filter2 instanceof LessThan) {
            BoxedUnit boxedUnit;
            LessThan lessThan = (LessThan)filter2;
            String attr = lessThan.attribute();
            Object value = lessThan.value();
            Field field = this.catalog().getField(attr);
            if (field != null) {
                BoxedUnit boxedUnit2;
                if (field.isRowKey()) {
                    Option<BoundRanges> b = this.encoder().ranges(value);
                    BooleanRef inc = BooleanRef.create((boolean)false);
                    boxedUnit2 = b.map((Function1 & Serializable & scala.Serializable)x$21 -> (RowKeyFilter[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$21.less())).map((Function1 & Serializable & scala.Serializable)x -> {
                        void var2_2;
                        RowKeyFilter r = new RowKeyFilter(null, new ScanRange(x.upper(), inc$1.elem, x.low(), true), RowKeyFilter$.MODULE$.$lessinit$greater$default$3(), RowKeyFilter$.MODULE$.$lessinit$greater$default$4());
                        inc$1.elem = true;
                        return var2_2;
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(RowKeyFilter.class)))).map((Function1 & Serializable & scala.Serializable)x -> (RowKeyFilter)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x)).reduce((Function2 & Serializable & scala.Serializable)(i, j) -> i.mergeUnion((RowKeyFilter)j))).map((Function1 & Serializable & scala.Serializable)x$22 -> parentRowKeyFilter.mergeIntersect((RowKeyFilter)x$22));
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                byte[] byteValue = this.encoder().encode(field.dt(), value);
                boxedUnit = valueArray.$plus$eq((Object)byteValue);
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            dynamicLogicExpression = new LessThanLogicExpression(attr, valueArray.length() - 1);
        } else if (filter2 instanceof GreaterThan) {
            BoxedUnit boxedUnit;
            GreaterThan greaterThan = (GreaterThan)filter2;
            String attr = greaterThan.attribute();
            Object value = greaterThan.value();
            Field field = this.catalog().getField(attr);
            if (field != null) {
                BoxedUnit boxedUnit3;
                if (field.isRowKey()) {
                    Option<BoundRanges> b = this.encoder().ranges(value);
                    BooleanRef inc = BooleanRef.create((boolean)false);
                    boxedUnit3 = b.map((Function1 & Serializable & scala.Serializable)x$23 -> (RowKeyFilter[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$23.greater())).map((Function1 & Serializable & scala.Serializable)x -> {
                        void var2_2;
                        RowKeyFilter r = new RowKeyFilter(null, new ScanRange(x.upper(), true, x.low(), inc$2.elem), RowKeyFilter$.MODULE$.$lessinit$greater$default$3(), RowKeyFilter$.MODULE$.$lessinit$greater$default$4());
                        inc$2.elem = true;
                        return var2_2;
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(RowKeyFilter.class)))).map((Function1 & Serializable & scala.Serializable)x -> (RowKeyFilter)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x)).reduce((Function2 & Serializable & scala.Serializable)(i, j) -> i.mergeUnion((RowKeyFilter)j))).map((Function1 & Serializable & scala.Serializable)x$24 -> parentRowKeyFilter.mergeIntersect((RowKeyFilter)x$24));
                } else {
                    boxedUnit3 = BoxedUnit.UNIT;
                }
                byte[] byteValue = this.encoder().encode(field.dt(), value);
                boxedUnit = valueArray.$plus$eq((Object)byteValue);
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            dynamicLogicExpression = new GreaterThanLogicExpression(attr, valueArray.length() - 1);
        } else if (filter2 instanceof LessThanOrEqual) {
            BoxedUnit boxedUnit;
            LessThanOrEqual lessThanOrEqual = (LessThanOrEqual)filter2;
            String attr = lessThanOrEqual.attribute();
            Object value = lessThanOrEqual.value();
            Field field = this.catalog().getField(attr);
            if (field != null) {
                BoxedUnit boxedUnit4;
                if (field.isRowKey()) {
                    Option<BoundRanges> b = this.encoder().ranges(value);
                    boxedUnit4 = b.map((Function1 & Serializable & scala.Serializable)x$25 -> (RowKeyFilter[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$25.less())).map((Function1 & Serializable & scala.Serializable)x -> new RowKeyFilter(null, new ScanRange(x.upper(), true, x.low(), true), RowKeyFilter$.MODULE$.$lessinit$greater$default$3(), RowKeyFilter$.MODULE$.$lessinit$greater$default$4()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(RowKeyFilter.class)))).map((Function1 & Serializable & scala.Serializable)x -> (RowKeyFilter)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x)).reduce((Function2 & Serializable & scala.Serializable)(i, j) -> i.mergeUnion((RowKeyFilter)j))).map((Function1 & Serializable & scala.Serializable)x$26 -> parentRowKeyFilter.mergeIntersect((RowKeyFilter)x$26));
                } else {
                    boxedUnit4 = BoxedUnit.UNIT;
                }
                byte[] byteValue = this.encoder().encode(field.dt(), value);
                boxedUnit = valueArray.$plus$eq((Object)byteValue);
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            dynamicLogicExpression = new LessThanOrEqualLogicExpression(attr, valueArray.length() - 1);
        } else if (filter2 instanceof GreaterThanOrEqual) {
            BoxedUnit boxedUnit;
            GreaterThanOrEqual greaterThanOrEqual = (GreaterThanOrEqual)filter2;
            String attr = greaterThanOrEqual.attribute();
            Object value = greaterThanOrEqual.value();
            Field field = this.catalog().getField(attr);
            if (field != null) {
                BoxedUnit boxedUnit5;
                if (field.isRowKey()) {
                    Option<BoundRanges> b = this.encoder().ranges(value);
                    boxedUnit5 = b.map((Function1 & Serializable & scala.Serializable)x$27 -> (RowKeyFilter[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$27.greater())).map((Function1 & Serializable & scala.Serializable)x -> new RowKeyFilter(null, new ScanRange(x.upper(), true, x.low(), true), RowKeyFilter$.MODULE$.$lessinit$greater$default$3(), RowKeyFilter$.MODULE$.$lessinit$greater$default$4()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(RowKeyFilter.class)))).map((Function1 & Serializable & scala.Serializable)x -> (RowKeyFilter)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x)).reduce((Function2 & Serializable & scala.Serializable)(i, j) -> i.mergeUnion((RowKeyFilter)j))).map((Function1 & Serializable & scala.Serializable)x$28 -> parentRowKeyFilter.mergeIntersect((RowKeyFilter)x$28));
                } else {
                    boxedUnit5 = BoxedUnit.UNIT;
                }
                byte[] byteValue = this.encoder().encode(field.dt(), value);
                boxedUnit = valueArray.$plus$eq((Object)byteValue);
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            dynamicLogicExpression = new GreaterThanOrEqualLogicExpression(attr, valueArray.length() - 1);
        } else if (filter2 instanceof StringStartsWith) {
            BoxedUnit boxedUnit;
            StringStartsWith stringStartsWith = (StringStartsWith)filter2;
            String attr = stringStartsWith.attribute();
            String value = stringStartsWith.value();
            Field field = this.catalog().getField(attr);
            if (field != null) {
                Object object;
                if (field.isRowKey()) {
                    byte[] p = Utils$.MODULE$.toBytes(value, field);
                    byte[] endRange = Utils$.MODULE$.incrementByteArray(p);
                    object = parentRowKeyFilter.mergeIntersect(new RowKeyFilter(null, new ScanRange(endRange, false, p, true), RowKeyFilter$.MODULE$.$lessinit$greater$default$3(), RowKeyFilter$.MODULE$.$lessinit$greater$default$4()));
                } else {
                    object = BoxedUnit.UNIT;
                }
                byte[] byteValue = Utils$.MODULE$.toBytes(value, field);
                boxedUnit = valueArray.$plus$eq((Object)byteValue);
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            dynamicLogicExpression = new StartsWithLogicExpression(attr, valueArray.length() - 1);
        } else if (filter2 instanceof Or) {
            Or or = (Or)filter2;
            Filter left = or.left();
            Filter right = or.right();
            DynamicLogicExpression leftExpression = this.transverseFilterTree(parentRowKeyFilter, valueArray, left);
            RowKeyFilter rightSideRowKeyFilter = new RowKeyFilter(RowKeyFilter$.MODULE$.$lessinit$greater$default$1(), RowKeyFilter$.MODULE$.$lessinit$greater$default$2(), RowKeyFilter$.MODULE$.$lessinit$greater$default$3(), RowKeyFilter$.MODULE$.$lessinit$greater$default$4());
            DynamicLogicExpression rightExpression = this.transverseFilterTree(rightSideRowKeyFilter, valueArray, right);
            parentRowKeyFilter.mergeUnion(rightSideRowKeyFilter);
            dynamicLogicExpression = new OrLogicExpression(leftExpression, rightExpression);
        } else if (filter2 instanceof And) {
            And and = (And)filter2;
            Filter left = and.left();
            Filter right = and.right();
            DynamicLogicExpression leftExpression = this.transverseFilterTree(parentRowKeyFilter, valueArray, left);
            RowKeyFilter rightSideRowKeyFilter = new RowKeyFilter(RowKeyFilter$.MODULE$.$lessinit$greater$default$1(), RowKeyFilter$.MODULE$.$lessinit$greater$default$2(), RowKeyFilter$.MODULE$.$lessinit$greater$default$3(), RowKeyFilter$.MODULE$.$lessinit$greater$default$4());
            DynamicLogicExpression rightExpression = this.transverseFilterTree(rightSideRowKeyFilter, valueArray, right);
            parentRowKeyFilter.mergeIntersect(rightSideRowKeyFilter);
            dynamicLogicExpression = new AndLogicExpression(leftExpression, rightExpression);
        } else if (filter2 instanceof IsNull) {
            IsNull isNull = (IsNull)filter2;
            String attr = isNull.attribute();
            dynamicLogicExpression = new IsNullLogicExpression(attr, false);
        } else if (filter2 instanceof IsNotNull) {
            IsNotNull isNotNull = (IsNotNull)filter2;
            String attr = isNotNull.attribute();
            dynamicLogicExpression = new IsNullLogicExpression(attr, true);
        } else {
            dynamicLogicExpression = new PassThroughLogicExpression();
        }
        return dynamicLogicExpression;
    }

    public HBaseRelation copy(Map<String, String> parameters, Option<StructType> userSpecifiedSchema, SQLContext sqlContext) {
        return new HBaseRelation(parameters, userSpecifiedSchema, sqlContext);
    }

    public Map<String, String> copy$default$1() {
        return this.parameters();
    }

    public Option<StructType> copy$default$2() {
        return this.userSpecifiedSchema();
    }

    public String productPrefix() {
        return "HBaseRelation";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Map<String, String> map;
        int n = x$1;
        switch (n) {
            case 0: {
                map = this.parameters();
                break;
            }
            case 1: {
                map = this.userSpecifiedSchema();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return map;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof HBaseRelation;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof HBaseRelation)) return false;
        boolean bl = true;
        if (!bl) return false;
        HBaseRelation hBaseRelation = (HBaseRelation)x$1;
        Map<String, String> map = this.parameters();
        Map<String, String> map2 = hBaseRelation.parameters();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!map.equals(map2)) return false;
        Option<StructType> option = this.userSpecifiedSchema();
        Option<StructType> option2 = hBaseRelation.userSpecifiedSchema();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!hBaseRelation.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ long $anonfun$timestamp$1(String x$1) {
        return new StringOps(Predef$.MODULE$.augmentString(x$1)).toLong();
    }

    public static final /* synthetic */ long $anonfun$minTimestamp$1(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2)).toLong();
    }

    public static final /* synthetic */ long $anonfun$maxTimestamp$1(String x$3) {
        return new StringOps(Predef$.MODULE$.augmentString(x$3)).toLong();
    }

    public static final /* synthetic */ int $anonfun$maxVersions$1(String x$4) {
        return new StringOps(Predef$.MODULE$.augmentString(x$4)).toInt();
    }

    public static final /* synthetic */ boolean $anonfun$useHBaseContext$1(String x$5) {
        return new StringOps(Predef$.MODULE$.augmentString(x$5)).toBoolean();
    }

    public static final /* synthetic */ boolean $anonfun$usePushDownColumnFilter$1(String x$6) {
        return new StringOps(Predef$.MODULE$.augmentString(x$6)).toBoolean();
    }

    public static final /* synthetic */ boolean $anonfun$blockCacheEnable$1(String x$7) {
        return new StringOps(Predef$.MODULE$.augmentString(x$7)).toBoolean();
    }

    public static final /* synthetic */ int $anonfun$cacheSize$1(String x$8) {
        return new StringOps(Predef$.MODULE$.augmentString(x$8)).toInt();
    }

    public static final /* synthetic */ int $anonfun$batchNum$1(String x$9) {
        return new StringOps(Predef$.MODULE$.augmentString(x$9)).toInt();
    }

    public static final /* synthetic */ int $anonfun$bulkGetSize$1(String x$10) {
        return new StringOps(Predef$.MODULE$.augmentString(x$10)).toInt();
    }

    public static final /* synthetic */ void $anonfun$hbaseContext$1(Configuration config$1, String resource) {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])resource.split(","))).foreach((Function1 & Serializable & scala.Serializable)r -> {
            config$1.addResource(r);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ int $anonfun$createTable$1(String x) {
        return new StringOps(Predef$.MODULE$.augmentString(x)).toInt();
    }

    public static final /* synthetic */ boolean $anonfun$insert$2(Seq rkFields$1, String x) {
        return ((SeqLike)rkFields$1.map((Function1 & Serializable & scala.Serializable)x$11 -> x$11.colName(), Seq$.MODULE$.canBuildFrom())).contains((Object)x);
    }

    public static final /* synthetic */ int $anonfun$insert$6(int x0$2, byte[] x1$1) {
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)x0$2), (Object)x1$1);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int x = tuple2._1$mcI$sp();
        byte[] y = (byte[])tuple2._2();
        int n = x + y.length;
        return n;
    }

    public static final /* synthetic */ void $anonfun$insert$7(byte[] rBytes$1, IntRef offset$1, byte[] x) {
        System.arraycopy(x, 0, rBytes$1, offset$1.elem, x.length);
        offset$1.elem += x.length;
    }

    public static final /* synthetic */ Put $anonfun$insert$9(byte[] rBytes$1, long x$12) {
        return new Put(rBytes$1, x$12);
    }

    private final Tuple2 convertToPut$1(Row row, Seq rkIdxedFields$1, Tuple2[] colsIdxedFields$1, IntRef count$1) {
        Seq rowBytes = (Seq)rkIdxedFields$1.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int x = tuple2._1$mcI$sp();
            Field y = (Field)tuple2._2();
            byte[] byArray = Utils$.MODULE$.toBytes(row.apply(x), y);
            return byArray;
        }, Seq$.MODULE$.canBuildFrom());
        int rLen = BoxesRunTime.unboxToInt((Object)rowBytes.foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2 & Serializable & scala.Serializable)(x0$2, x1$1) -> BoxesRunTime.boxToInteger((int)HBaseRelation.$anonfun$insert$6(BoxesRunTime.unboxToInt((Object)x0$2), x1$1))));
        byte[] rBytes = new byte[rLen];
        IntRef offset = IntRef.create((int)0);
        rowBytes.foreach((Function1 & Serializable & scala.Serializable)x -> {
            HBaseRelation.$anonfun$insert$7(rBytes, offset, x);
            return BoxedUnit.UNIT;
        });
        Put put = (Put)this.timestamp().fold((Function0 & Serializable & scala.Serializable)() -> new Put(rBytes), (Function1 & Serializable & scala.Serializable)x$12 -> HBaseRelation.$anonfun$insert$9(rBytes, BoxesRunTime.unboxToLong((Object)x$12)));
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])colsIdxedFields$1)).foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
            BoxedUnit boxedUnit;
            Tuple2 tuple2 = x0$3;
            if (tuple2 != null) {
                int x = tuple2._1$mcI$sp();
                Field y = (Field)tuple2._2();
                Object r = row.apply(x);
                if (r != null) {
                    byte[] b = Utils$.MODULE$.toBytes(r, y);
                    boxedUnit = put.addColumn(Bytes.toBytes((String)y.cf()), Bytes.toBytes((String)y.col()), b);
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            BoxedUnit boxedUnit2 = boxedUnit;
            return boxedUnit2;
        });
        ++count$1.elem;
        return new Tuple2((Object)new ImmutableBytesWritable(), (Object)put);
    }

    public static final /* synthetic */ boolean $anonfun$buildRow$1(Field x$15) {
        return !x$15.isRowKey();
    }

    public static final /* synthetic */ boolean $anonfun$buildScan$5(MutableList requiredQualifierDefinitionList$1, ArrayList getList$1, byte[] p) {
        Get get = new Get(p);
        requiredQualifierDefinitionList$1.foreach((Function1 & Serializable & scala.Serializable)d -> d.isRowKey() ? get.addColumn(d.cfBytes(), d.colBytes()) : BoxedUnit.UNIT);
        return getList$1.add(get);
    }

    public HBaseRelation(Map<String, String> parameters, Option<StructType> userSpecifiedSchema, SQLContext sqlContext) {
        HBaseContext hBaseContext;
        this.parameters = parameters;
        this.userSpecifiedSchema = userSpecifiedSchema;
        this.sqlContext = sqlContext;
        Logging.$init$(this);
        Product.$init$((Product)this);
        this.timestamp = parameters.get((Object)HBaseSparkConf$.MODULE$.TIMESTAMP()).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)HBaseRelation.$anonfun$timestamp$1(x$1)));
        this.minTimestamp = parameters.get((Object)HBaseSparkConf$.MODULE$.TIMERANGE_START()).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)HBaseRelation.$anonfun$minTimestamp$1(x$2)));
        this.maxTimestamp = parameters.get((Object)HBaseSparkConf$.MODULE$.TIMERANGE_END()).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)HBaseRelation.$anonfun$maxTimestamp$1(x$3)));
        this.maxVersions = parameters.get((Object)HBaseSparkConf$.MODULE$.MAX_VERSIONS()).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)HBaseRelation.$anonfun$maxVersions$1(x$4)));
        this.encoderClsName = (String)parameters.get((Object)HBaseSparkConf$.MODULE$.QUERY_ENCODER()).getOrElse((Function0 & Serializable & scala.Serializable)() -> HBaseSparkConf$.MODULE$.DEFAULT_QUERY_ENCODER());
        this.encoder = JavaBytesEncoder$.MODULE$.create(this.encoderClsName());
        this.catalog = HBaseTableCatalog$.MODULE$.apply(parameters);
        this.configResources = parameters.get((Object)HBaseSparkConf$.MODULE$.HBASE_CONFIG_LOCATION());
        this.useHBaseContext = BoxesRunTime.unboxToBoolean((Object)parameters.get((Object)HBaseSparkConf$.MODULE$.USE_HBASECONTEXT()).map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)HBaseRelation.$anonfun$useHBaseContext$1(x$5))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> HBaseSparkConf$.MODULE$.DEFAULT_USE_HBASECONTEXT()));
        this.usePushDownColumnFilter = BoxesRunTime.unboxToBoolean((Object)parameters.get((Object)HBaseSparkConf$.MODULE$.PUSHDOWN_COLUMN_FILTER()).map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)HBaseRelation.$anonfun$usePushDownColumnFilter$1(x$6))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> HBaseSparkConf$.MODULE$.DEFAULT_PUSHDOWN_COLUMN_FILTER()));
        this.blockCacheEnable = BoxesRunTime.unboxToBoolean((Object)parameters.get((Object)HBaseSparkConf$.MODULE$.QUERY_CACHEBLOCKS()).map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)HBaseRelation.$anonfun$blockCacheEnable$1(x$7))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.sqlContext().sparkContext().getConf().getBoolean(HBaseSparkConf$.MODULE$.QUERY_CACHEBLOCKS(), HBaseSparkConf$.MODULE$.DEFAULT_QUERY_CACHEBLOCKS())));
        this.cacheSize = BoxesRunTime.unboxToInt((Object)parameters.get((Object)HBaseSparkConf$.MODULE$.QUERY_CACHEDROWS()).map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToInteger((int)HBaseRelation.$anonfun$cacheSize$1(x$8))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> this.sqlContext().sparkContext().getConf().getInt(HBaseSparkConf$.MODULE$.QUERY_CACHEDROWS(), -1)));
        this.batchNum = BoxesRunTime.unboxToInt((Object)parameters.get((Object)HBaseSparkConf$.MODULE$.QUERY_BATCHSIZE()).map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToInteger((int)HBaseRelation.$anonfun$batchNum$1(x$9))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> this.sqlContext().sparkContext().getConf().getInt(HBaseSparkConf$.MODULE$.QUERY_BATCHSIZE(), -1)));
        this.bulkGetSize = BoxesRunTime.unboxToInt((Object)parameters.get((Object)HBaseSparkConf$.MODULE$.BULKGET_SIZE()).map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToInteger((int)HBaseRelation.$anonfun$bulkGetSize$1(x$10))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> this.sqlContext().sparkContext().getConf().getInt(HBaseSparkConf$.MODULE$.BULKGET_SIZE(), HBaseSparkConf$.MODULE$.DEFAULT_BULKGET_SIZE())));
        if (this.useHBaseContext()) {
            hBaseContext = LatestHBaseContextCache$.MODULE$.latest();
        } else {
            Configuration hadoopConfig = sqlContext.sparkContext().hadoopConfiguration();
            Configuration config = HBaseConfiguration.create((Configuration)hadoopConfig);
            this.configResources().map((Function1 & Serializable & scala.Serializable)resource -> {
                HBaseRelation.$anonfun$hbaseContext$1(config, resource);
                return BoxedUnit.UNIT;
            });
            hBaseContext = new HBaseContext(sqlContext.sparkContext(), config, HBaseContext$.MODULE$.$lessinit$greater$default$3());
        }
        this.hbaseContext = hBaseContext;
        this.wrappedConf = new SerializableConfiguration(this.hbaseContext().config());
        this.schema = (StructType)userSpecifiedSchema.getOrElse((Function0 & Serializable & scala.Serializable)() -> this.catalog().toDataType());
    }
}

