/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.spark.example.hbasecontext;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.spark.HBaseContext;
import org.apache.hadoop.hbase.spark.HBaseContext$;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.apache.yetus.audience.InterfaceAudience;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.reflect.ClassTag$;

@InterfaceAudience.Private
public final class HBaseBulkPutExampleFromFile$ {
    public static HBaseBulkPutExampleFromFile$ MODULE$;

    static {
        new HBaseBulkPutExampleFromFile$();
    }

    public void main(String[] args) {
        if (args.length < 3) {
            Predef$.MODULE$.println((Object)"HBaseBulkPutExampleFromFile {tableName} {columnFamily} {inputFile} are missing an argument");
            return;
        }
        String tableName = args[0];
        String columnFamily = args[1];
        String inputFile = args[2];
        SparkConf sparkConf = new SparkConf().setAppName(new StringBuilder(30).append("HBaseBulkPutExampleFromFile ").append(tableName).append(" ").append(columnFamily).append(" ").append(inputFile).toString());
        SparkContext sc = new SparkContext(sparkConf);
        try {
            RDD rdd = sc.hadoopFile(inputFile, TextInputFormat.class, LongWritable.class, Text.class, sc.hadoopFile$default$5()).map((Function1 & java.io.Serializable & Serializable)v -> {
                System.out.println(new StringBuilder(8).append("reading-").append(((Text)v._2()).toString()).toString());
                return ((Text)v._2()).toString();
            }, ClassTag$.MODULE$.apply(String.class));
            Configuration conf = HBaseConfiguration.create();
            HBaseContext hbaseContext = new HBaseContext(sc, conf, HBaseContext$.MODULE$.$lessinit$greater$default$3());
            hbaseContext.bulkPut(rdd, TableName.valueOf((String)tableName), (Function1 & java.io.Serializable & Serializable)putRecord -> {
                void var1_1;
                System.out.println(new StringBuilder(6).append("hbase-").append((String)putRecord).toString());
                Put put = new Put(Bytes.toBytes((String)new StringBuilder(7).append("Value- ").append((String)putRecord).toString()));
                put.addColumn(Bytes.toBytes((String)"c"), Bytes.toBytes((String)"1"), Bytes.toBytes((int)putRecord.length()));
                return var1_1;
            });
        }
        finally {
            sc.stop();
        }
    }

    private HBaseBulkPutExampleFromFile$() {
        MODULE$ = this;
    }
}

