/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.message.extended;

import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.ldap.model.message.SearchResultDoneImpl;

public class SearchNoDResponse
extends SearchResultDoneImpl {
    public static final String EXTENSION_OID = "1.3.6.1.4.1.1466.20036";
    private static final byte[] EMPTY_RESPONSE = new byte[0];
    public static final SearchNoDResponse UNAVAILABLE = new SearchNoDResponse(ResultCodeEnum.UNAVAILABLE);
    public static final SearchNoDResponse PROTOCOLERROR = new SearchNoDResponse(ResultCodeEnum.PROTOCOL_ERROR);
    public static final SearchNoDResponse STRONGAUTHREQUIRED = new SearchNoDResponse(ResultCodeEnum.STRONG_AUTH_REQUIRED);

    private SearchNoDResponse(ResultCodeEnum rcode) {
        switch (rcode) {
            case UNAVAILABLE: {
                break;
            }
            case PROTOCOL_ERROR: {
                break;
            }
            case STRONG_AUTH_REQUIRED: {
                break;
            }
            default: {
                throw new IllegalArgumentException(I18n.err(I18n.ERR_04166, new Object[]{ResultCodeEnum.UNAVAILABLE, ResultCodeEnum.PROTOCOL_ERROR, ResultCodeEnum.STRONG_AUTH_REQUIRED}));
            }
        }
        super.getLdapResult().setDiagnosticMessage(rcode.toString() + ": The server will disconnect!");
        super.getLdapResult().setMatchedDn(null);
        super.getLdapResult().setResultCode(rcode);
    }

    public byte[] getResponse() {
        return EMPTY_RESPONSE;
    }

    public String getResponseName() {
        return EXTENSION_OID;
    }
}

