/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Queue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;

@Metrics(context="yarn")
public class PartitionQueueMetrics
extends QueueMetrics {
    private String partition;

    protected PartitionQueueMetrics(MetricsSystem ms, String queueName, Queue parent, boolean enableUserMetrics, Configuration conf, String partition) {
        super(ms, queueName, parent, enableUserMetrics, conf);
        this.partition = partition;
        if (this.getParentQueue() != null) {
            String newQueueName = this.getParentQueue() instanceof CSQueue ? ((CSQueue)this.getParentQueue()).getQueuePath() : this.getParentQueue().getQueueName();
            String parentMetricName = partition + "." + newQueueName;
            this.setParent(PartitionQueueMetrics.getQueueMetrics().get(parentMetricName));
        }
    }

    @Override
    public synchronized QueueMetrics getUserMetrics(String userName) {
        if (this.users == null) {
            return null;
        }
        String partitionJMXStr = this.partition.equals("default") ? "" : this.partition;
        PartitionQueueMetrics metrics = (PartitionQueueMetrics)this.users.get(userName);
        if (metrics == null) {
            metrics = new PartitionQueueMetrics(this.metricsSystem, this.queueName, null, false, this.conf, this.partition);
            this.users.put(userName, metrics);
            this.metricsSystem.register(PartitionQueueMetrics.pSourceName(partitionJMXStr).append((CharSequence)PartitionQueueMetrics.qSourceName(this.queueName)).append(",user=").append(userName).toString(), "Metrics for user '" + userName + "' in queue '" + this.queueName + "'", (Object)((PartitionQueueMetrics)metrics.tag(PARTITION_INFO, partitionJMXStr).tag(QUEUE_INFO, this.queueName)).tag(USER_INFO, userName));
        }
        return metrics;
    }
}

