/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.actions.modifyDnRequest;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.api.ldap.codec.api.ResponseCarryingException;
import org.apache.directory.api.ldap.codec.decorators.ModifyDnRequestDecorator;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.message.ModifyDnRequest;
import org.apache.directory.api.ldap.model.message.ModifyDnResponseImpl;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.ldap.model.message.ResultResponse;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.name.Rdn;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreModifyDnRequestNewRdn
extends GrammarAction<LdapMessageContainer<ModifyDnRequestDecorator>> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreModifyDnRequestNewRdn.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    public StoreModifyDnRequestNewRdn() {
        super("Store ModifyDN request new RDN");
    }

    public void action(LdapMessageContainer<ModifyDnRequestDecorator> container) throws DecoderException {
        ModifyDnRequest modifyDnRequest = container.getMessage();
        TLV tlv = container.getCurrentTLV();
        Rdn newRdn = null;
        if (tlv.getLength() == 0) {
            String msg = I18n.err((I18n)I18n.ERR_04090, (Object[])new Object[0]);
            LOG.error(msg);
            ModifyDnResponseImpl response = new ModifyDnResponseImpl(modifyDnRequest.getMessageId());
            throw new ResponseCarryingException(msg, (ResultResponse)response, ResultCodeEnum.INVALID_DN_SYNTAX, modifyDnRequest.getName(), null);
        }
        byte[] dnBytes = tlv.getValue().getData();
        String dnStr = Strings.utf8ToString((byte[])dnBytes);
        try {
            Dn dn = new Dn(new String[]{dnStr});
            newRdn = dn.getRdn(dn.size() - 1);
        }
        catch (LdapInvalidDnException ine) {
            String msg = "Invalid new Rdn given : " + dnStr + " (" + Strings.dumpBytes((byte[])dnBytes) + ") is invalid";
            LOG.error("{} : {}", (Object)msg, (Object)ine.getMessage());
            ModifyDnResponseImpl response = new ModifyDnResponseImpl(modifyDnRequest.getMessageId());
            throw new ResponseCarryingException(msg, (ResultResponse)response, ResultCodeEnum.INVALID_DN_SYNTAX, modifyDnRequest.getName(), ine);
        }
        modifyDnRequest.setNewRdn(newRdn);
        if (IS_DEBUG) {
            LOG.debug("Modifying with new Rdn {}", (Object)newRdn);
        }
    }
}

