/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.parsers;

import antlr.RecognitionException;
import antlr.TokenStreamException;
import java.text.ParseException;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.schema.DitStructureRule;
import org.apache.directory.api.ldap.model.schema.parsers.AbstractSchemaParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DitStructureRuleDescriptionSchemaParser
extends AbstractSchemaParser {
    protected static final Logger LOG = LoggerFactory.getLogger(DitStructureRuleDescriptionSchemaParser.class);

    public synchronized DitStructureRule parseDITStructureRuleDescription(String ditStructureRuleDescription) throws ParseException {
        LOG.debug("Parsing a DitStructureRule : {}", (Object)ditStructureRuleDescription);
        if (ditStructureRuleDescription == null) {
            LOG.error(I18n.err((I18n)I18n.ERR_04233, (Object[])new Object[0]));
            throw new ParseException("Null", 0);
        }
        this.reset(ditStructureRuleDescription);
        try {
            DitStructureRule ditStructureRule = this.parser.ditStructureRuleDescription();
            DitStructureRuleDescriptionSchemaParser.updateSchemaName(ditStructureRule);
            return ditStructureRule;
        }
        catch (RecognitionException re) {
            String msg = I18n.err((I18n)I18n.ERR_04234, (Object[])new Object[]{ditStructureRuleDescription, re.getMessage(), re.getColumn()});
            LOG.error(msg);
            throw new ParseException(msg, re.getColumn());
        }
        catch (TokenStreamException tse) {
            String msg = I18n.err((I18n)I18n.ERR_04235, (Object[])new Object[]{ditStructureRuleDescription, tse.getMessage()});
            LOG.error(msg);
            throw new ParseException(msg, 0);
        }
    }

    @Override
    public DitStructureRule parse(String schemaDescription) throws ParseException {
        return this.parseDITStructureRuleDescription(schemaDescription);
    }
}

