/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.I0Itec.zkclient.exception.ZkNoNodeException;
import org.apache.helix.BaseDataAccessor;
import org.apache.helix.ZNRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupCommit {
    private static Logger LOG = LoggerFactory.getLogger(GroupCommit.class);
    private static int MAX_RETRY = 3;
    private final Queue[] _queues = new Queue[100];

    public GroupCommit() {
        for (int i = 0; i < this._queues.length; ++i) {
            this._queues[i] = new Queue();
        }
    }

    private Queue getQueue(String key) {
        return this._queues[(key.hashCode() & Integer.MAX_VALUE) % this._queues.length];
    }

    public boolean commit(BaseDataAccessor<ZNRecord> accessor, int options, String key, ZNRecord record) {
        return this.commit(accessor, options, key, record, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean commit(BaseDataAccessor<ZNRecord> accessor, int options, String key, ZNRecord record, boolean removeIfEmpty) {
        Queue queue = this.getQueue(key);
        Entry entry = new Entry(key, record);
        boolean success = true;
        queue._pending.add(entry);
        while (!entry._sent.get()) {
            if (queue._running.compareAndSet(null, Thread.currentThread())) {
                Object first;
                ArrayList<Entry> processed;
                block29: {
                    processed = new ArrayList<Entry>();
                    if (queue._pending.peek() != null) break block29;
                    boolean bl = true;
                    queue._running.set(null);
                    Iterator iterator = processed.iterator();
                    while (iterator.hasNext()) {
                        Entry e;
                        Entry entry2 = e = (Entry)iterator.next();
                        synchronized (entry2) {
                            e._sent.set(true);
                            e.notify();
                        }
                    }
                    return bl;
                }
                try {
                    first = queue._pending.poll();
                    processed.add((Entry)first);
                    String mergedKey = ((Entry)first)._key;
                    ZNRecord merged = null;
                    try {
                        merged = accessor.get(mergedKey, null, options);
                    }
                    catch (ZkNoNodeException zkNoNodeException) {
                        // empty catch block
                    }
                    if (merged == null) {
                        merged = new ZNRecord(((Entry)first)._record);
                    }
                    merged.merge(((Entry)first)._record);
                    Iterator<Entry> it = queue._pending.iterator();
                    while (it.hasNext()) {
                        Entry ent = it.next();
                        if (!ent._key.equals(mergedKey)) continue;
                        processed.add(ent);
                        merged.merge(ent._record);
                        it.remove();
                    }
                    int retry = 0;
                    success = false;
                    while (++retry <= MAX_RETRY && !success) {
                        if (removeIfEmpty && merged.getMapFields().isEmpty()) {
                            success = accessor.remove(mergedKey, options);
                            if (!success) {
                                LOG.error("Fails to remove " + mergedKey + " from ZK, retry it!");
                                continue;
                            }
                            LOG.info("Removed " + mergedKey);
                            continue;
                        }
                        success = accessor.set(mergedKey, merged, options);
                        if (success) continue;
                        LOG.error("Fails to update " + mergedKey + " to ZK, retry it! ");
                    }
                    queue._running.set(null);
                    first = processed.iterator();
                }
                catch (Throwable throwable) {
                    queue._running.set(null);
                    Iterator iterator = processed.iterator();
                    while (iterator.hasNext()) {
                        Entry e;
                        Entry entry3 = e = (Entry)iterator.next();
                        synchronized (entry3) {
                            e._sent.set(true);
                            e.notify();
                        }
                    }
                    throw throwable;
                }
                while (first.hasNext()) {
                    Entry e;
                    Entry entry4 = e = (Entry)first.next();
                    synchronized (entry4) {
                        e._sent.set(true);
                        e.notify();
                    }
                }
                continue;
            }
            Entry entry5 = entry;
            synchronized (entry5) {
                try {
                    entry.wait(10L);
                }
                catch (InterruptedException e) {
                    LOG.error("Interrupted while committing change, key: " + key + ", record: " + record, (Throwable)e);
                    Thread.currentThread().interrupt();
                    return false;
                }
            }
        }
        return success;
    }

    private static class Entry {
        final String _key;
        final ZNRecord _record;
        AtomicBoolean _sent = new AtomicBoolean(false);

        Entry(String key, ZNRecord record) {
            this._key = key;
            this._record = record;
        }
    }

    private static class Queue {
        final AtomicReference<Thread> _running = new AtomicReference();
        final ConcurrentLinkedQueue<Entry> _pending = new ConcurrentLinkedQueue();

        private Queue() {
        }
    }
}

