/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.stages;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.helix.HelixDefinedState;
import org.apache.helix.HelixException;
import org.apache.helix.HelixManager;
import org.apache.helix.api.config.StateTransitionThrottleConfig;
import org.apache.helix.controller.LogUtil;
import org.apache.helix.controller.common.PartitionStateMap;
import org.apache.helix.controller.dataproviders.ResourceControllerDataProvider;
import org.apache.helix.controller.pipeline.AbstractBaseStage;
import org.apache.helix.controller.pipeline.StageException;
import org.apache.helix.controller.stages.AttributeName;
import org.apache.helix.controller.stages.BestPossibleStateOutput;
import org.apache.helix.controller.stages.ClusterEvent;
import org.apache.helix.controller.stages.CurrentStateOutput;
import org.apache.helix.controller.stages.IntermediateStateOutput;
import org.apache.helix.controller.stages.StateTransitionThrottleController;
import org.apache.helix.model.BuiltInStateModelDefinitions;
import org.apache.helix.model.ClusterConfig;
import org.apache.helix.model.IdealState;
import org.apache.helix.model.MaintenanceSignal;
import org.apache.helix.model.Partition;
import org.apache.helix.model.Resource;
import org.apache.helix.model.StateModelDefinition;
import org.apache.helix.monitoring.mbeans.ClusterStatusMonitor;
import org.apache.helix.monitoring.mbeans.ResourceMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntermediateStateCalcStage
extends AbstractBaseStage {
    private static final Logger logger = LoggerFactory.getLogger((String)IntermediateStateCalcStage.class.getName());

    @Override
    public void process(ClusterEvent event) throws Exception {
        this._eventId = event.getEventId();
        CurrentStateOutput currentStateOutput = (CurrentStateOutput)event.getAttribute(AttributeName.CURRENT_STATE.name());
        BestPossibleStateOutput bestPossibleStateOutput = (BestPossibleStateOutput)event.getAttribute(AttributeName.BEST_POSSIBLE_STATE.name());
        Map resourceToRebalance = (Map)event.getAttribute(AttributeName.RESOURCES_TO_REBALANCE.name());
        ResourceControllerDataProvider cache = (ResourceControllerDataProvider)event.getAttribute(AttributeName.ControllerDataProvider.name());
        if (currentStateOutput == null || bestPossibleStateOutput == null || resourceToRebalance == null || cache == null) {
            throw new StageException(String.format("Missing attributes in event: %s. Requires CURRENT_STATE (%s) |BEST_POSSIBLE_STATE (%s) |RESOURCES (%s) |DataCache (%s)", event, currentStateOutput, bestPossibleStateOutput, resourceToRebalance, cache));
        }
        IntermediateStateOutput intermediateStateOutput = this.compute(event, resourceToRebalance, currentStateOutput, bestPossibleStateOutput);
        event.addAttribute(AttributeName.INTERMEDIATE_STATE.name(), intermediateStateOutput);
        int maxPartitionPerInstance = cache.getClusterConfig().getMaxPartitionsPerInstance();
        if (maxPartitionPerInstance > 0) {
            this.validateMaxPartitionsPerInstance(event, cache, intermediateStateOutput, maxPartitionPerInstance);
        }
    }

    private IntermediateStateOutput compute(ClusterEvent event, Map<String, Resource> resourceMap, CurrentStateOutput currentStateOutput, BestPossibleStateOutput bestPossibleStateOutput) {
        IntermediateStateOutput output = new IntermediateStateOutput();
        ResourceControllerDataProvider dataCache = (ResourceControllerDataProvider)event.getAttribute(AttributeName.ControllerDataProvider.name());
        StateTransitionThrottleController throttleController = new StateTransitionThrottleController(resourceMap.keySet(), dataCache.getClusterConfig(), dataCache.getLiveInstances().keySet());
        ArrayList<ResourcePriority> prioritizedResourceList = new ArrayList<ResourcePriority>();
        for (String string : resourceMap.keySet()) {
            prioritizedResourceList.add(new ResourcePriority(string, Integer.MIN_VALUE));
        }
        if (dataCache.getClusterConfig().getResourcePriorityField() != null) {
            String priorityField = dataCache.getClusterConfig().getResourcePriorityField();
            for (ResourcePriority resourcePriority : prioritizedResourceList) {
                String resourceName = resourcePriority.getResourceName();
                if (dataCache.getResourceConfig(resourceName) != null && dataCache.getResourceConfig(resourceName).getSimpleConfig(priorityField) != null) {
                    resourcePriority.setPriority(dataCache.getResourceConfig(resourceName).getSimpleConfig(priorityField));
                    continue;
                }
                if (dataCache.getIdealState(resourceName) == null || dataCache.getIdealState(resourceName).getRecord().getSimpleField(priorityField) == null) continue;
                resourcePriority.setPriority(dataCache.getIdealState(resourceName).getRecord().getSimpleField(priorityField));
            }
            prioritizedResourceList.sort(new ResourcePriorityComparator());
        }
        ClusterStatusMonitor clusterStatusMonitor = (ClusterStatusMonitor)event.getAttribute(AttributeName.clusterStatusMonitor.name());
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ResourcePriority resourcePriority : prioritizedResourceList) {
            String resourceName = resourcePriority.getResourceName();
            if (!bestPossibleStateOutput.containsResource(resourceName)) {
                LogUtil.logInfo(logger, this._eventId, String.format("Skip calculating intermediate state for resource %s because the best possible state is not available.", resourceName));
                continue;
            }
            Resource resource = resourceMap.get(resourceName);
            IdealState idealState = dataCache.getIdealState(resourceName);
            if (idealState == null) {
                LogUtil.logInfo(logger, this._eventId, String.format("IdealState for resource %s does not exist; resource may not exist anymore", resourceName));
                idealState = new IdealState(resourceName);
                idealState.setStateModelDefRef(resource.getStateModelDefRef());
            }
            try {
                output.setState(resourceName, this.computeIntermediatePartitionState(dataCache, clusterStatusMonitor, idealState, resourceMap.get(resourceName), currentStateOutput, bestPossibleStateOutput.getPartitionStateMap(resourceName), bestPossibleStateOutput.getPreferenceLists(resourceName), throttleController));
            }
            catch (HelixException ex) {
                LogUtil.logInfo(logger, this._eventId, "Failed to calculate intermediate partition states for resource " + resourceName, ex);
                arrayList.add(resourceName);
            }
        }
        if (clusterStatusMonitor != null) {
            clusterStatusMonitor.setResourceRebalanceStates(arrayList, ResourceMonitor.RebalanceStatus.INTERMEDIATE_STATE_CAL_FAILED);
            clusterStatusMonitor.setResourceRebalanceStates(output.resourceSet(), ResourceMonitor.RebalanceStatus.NORMAL);
        }
        return output;
    }

    private void validateMaxPartitionsPerInstance(ClusterEvent event, ResourceControllerDataProvider cache, IntermediateStateOutput intermediateStateOutput, int maxPartitionPerInstance) {
        Map<String, PartitionStateMap> resourceStatesMap = intermediateStateOutput.getResourceStatesMap();
        HashMap<String, Integer> instancePartitionCounts = new HashMap<String, Integer>();
        for (String resource : resourceStatesMap.keySet()) {
            IdealState idealState = cache.getIdealState(resource);
            if (idealState != null && idealState.getStateModelDefRef().equals(BuiltInStateModelDefinitions.Task.name())) continue;
            PartitionStateMap partitionStateMap = resourceStatesMap.get(resource);
            Map<Partition, Map<String, String>> stateMaps = partitionStateMap.getStateMap();
            for (Partition p : stateMaps.keySet()) {
                Map<String, String> stateMap = stateMaps.get(p);
                for (String instance : stateMap.keySet()) {
                    String state = stateMap.get(instance);
                    if (state.equals(HelixDefinedState.DROPPED.name())) continue;
                    if (!instancePartitionCounts.containsKey(instance)) {
                        instancePartitionCounts.put(instance, 0);
                    }
                    int partitionCount = (Integer)instancePartitionCounts.get(instance);
                    if (++partitionCount > maxPartitionPerInstance) {
                        HelixManager manager = (HelixManager)event.getAttribute(AttributeName.helixmanager.name());
                        String errMsg = String.format("Problem: according to this assignment, instance %s contains more replicas/partitions than the maximum number allowed (%d). Pipeline will stop the rebalance and put the cluster %s into maintenance mode", instance, maxPartitionPerInstance, cache.getClusterName());
                        if (manager != null) {
                            if (manager.getHelixDataAccessor().getProperty(manager.getHelixDataAccessor().keyBuilder().maintenance()) == null) {
                                manager.getClusterManagmentTool().autoEnableMaintenanceMode(manager.getClusterName(), true, errMsg, MaintenanceSignal.AutoTriggerReason.MAX_PARTITION_PER_INSTANCE_EXCEEDED);
                            }
                            LogUtil.logWarn(logger, this._eventId, errMsg);
                        } else {
                            LogUtil.logError(logger, this._eventId, "HelixManager is not set/null! Failed to pause this cluster/enable maintenance mode due to an instance being assigned more replicas/partitions than the limit.");
                        }
                        ClusterStatusMonitor clusterStatusMonitor = (ClusterStatusMonitor)event.getAttribute(AttributeName.clusterStatusMonitor.name());
                        if (clusterStatusMonitor != null) {
                            clusterStatusMonitor.setResourceRebalanceStates(Collections.singletonList(resource), ResourceMonitor.RebalanceStatus.INTERMEDIATE_STATE_CAL_FAILED);
                        }
                        throw new HelixException(errMsg);
                    }
                    instancePartitionCounts.put(instance, partitionCount);
                }
            }
        }
    }

    private PartitionStateMap computeIntermediatePartitionState(ResourceControllerDataProvider cache, ClusterStatusMonitor clusterStatusMonitor, IdealState idealState, Resource resource, CurrentStateOutput currentStateOutput, PartitionStateMap bestPossiblePartitionStateMap, Map<String, List<String>> preferenceLists, StateTransitionThrottleController throttleController) {
        String resourceName = resource.getResourceName();
        LogUtil.logDebug(logger, this._eventId, String.format("Processing resource: %s", resourceName));
        if (!throttleController.isThrottleEnabled() || !IdealState.RebalanceMode.FULL_AUTO.equals((Object)idealState.getRebalanceMode())) {
            return bestPossiblePartitionStateMap;
        }
        String stateModelDefName = idealState.getStateModelDefRef();
        StateModelDefinition stateModelDef = cache.getStateModelDef(stateModelDefName);
        PartitionStateMap intermediatePartitionStateMap = new PartitionStateMap(resourceName);
        HashSet<Partition> partitionsNeedRecovery = new HashSet<Partition>();
        HashSet<Partition> partitionsNeedLoadBalance = new HashSet<Partition>();
        HashSet<Partition> partitionsWithErrorStateReplica = new HashSet<Partition>();
        for (Partition partition : resource.getPartitions()) {
            Map<String, String> currentStateMap = currentStateOutput.getCurrentStateMap(resourceName, partition);
            Map<String, String> bestPossibleMap = bestPossiblePartitionStateMap.getPartitionMap(partition);
            List<String> preferenceList = preferenceLists.get(partition.getPartitionName());
            StateTransitionThrottleConfig.RebalanceType rebalanceType = this.getRebalanceType(cache, bestPossibleMap, preferenceList, stateModelDef, currentStateMap, idealState, partition.getPartitionName());
            boolean isRebalanceNeeded = false;
            if (currentStateMap.values().contains(HelixDefinedState.ERROR.name())) {
                partitionsWithErrorStateReplica.add(partition);
            }
            if (rebalanceType.equals((Object)StateTransitionThrottleConfig.RebalanceType.RECOVERY_BALANCE)) {
                if (!currentStateMap.equals(bestPossibleMap)) {
                    partitionsNeedRecovery.add(partition);
                    isRebalanceNeeded = true;
                }
            } else if (rebalanceType.equals((Object)StateTransitionThrottleConfig.RebalanceType.LOAD_BALANCE)) {
                partitionsNeedLoadBalance.add(partition);
                isRebalanceNeeded = true;
            }
            if (isRebalanceNeeded) continue;
            HashMap<String, String> intermediateMap = new HashMap<String, String>(bestPossibleMap);
            intermediatePartitionStateMap.setState(partition, intermediateMap);
        }
        if (!partitionsNeedRecovery.isEmpty()) {
            LogUtil.logInfo(logger, this._eventId, String.format("Recovery balance needed for %s partitions: %s", resourceName, partitionsNeedRecovery));
        }
        if (!partitionsNeedLoadBalance.isEmpty()) {
            LogUtil.logInfo(logger, this._eventId, String.format("Load balance needed for %s partitions: %s", resourceName, partitionsNeedLoadBalance));
        }
        if (!partitionsWithErrorStateReplica.isEmpty()) {
            LogUtil.logInfo(logger, this._eventId, String.format("Partition currently has an ERROR replica in %s partitions: %s", resourceName, partitionsWithErrorStateReplica));
        }
        this.chargePendingTransition(resource, currentStateOutput, throttleController, partitionsNeedRecovery, partitionsNeedLoadBalance, cache);
        Set<Partition> recoveryThrottledPartitions = this.recoveryRebalance(resource, bestPossiblePartitionStateMap, throttleController, intermediatePartitionStateMap, partitionsNeedRecovery, currentStateOutput, cache.getStateModelDef(resource.getStateModelDefRef()).getTopState(), cache);
        ClusterConfig clusterConfig = cache.getClusterConfig();
        int threshold = 1;
        int partitionCount = partitionsWithErrorStateReplica.size();
        if (clusterConfig.getErrorOrRecoveryPartitionThresholdForLoadBalance() != -1) {
            threshold = clusterConfig.getErrorOrRecoveryPartitionThresholdForLoadBalance();
            partitionCount += partitionsNeedRecovery.size();
        } else if (clusterConfig.getErrorPartitionThresholdForLoadBalance() != 0) {
            threshold = clusterConfig.getErrorPartitionThresholdForLoadBalance();
        }
        boolean onlyDownwardLoadBalance = partitionCount > threshold;
        Set<Partition> loadbalanceThrottledPartitions = this.loadRebalance(resource, currentStateOutput, bestPossiblePartitionStateMap, throttleController, intermediatePartitionStateMap, partitionsNeedLoadBalance, currentStateOutput.getCurrentStateMap(resourceName), onlyDownwardLoadBalance, stateModelDef, cache);
        if (clusterStatusMonitor != null) {
            clusterStatusMonitor.updateRebalancerStats(resourceName, partitionsNeedRecovery.size(), partitionsNeedLoadBalance.size(), recoveryThrottledPartitions.size(), loadbalanceThrottledPartitions.size());
        }
        if (logger.isDebugEnabled()) {
            this.logPartitionMapState(resourceName, new HashSet<Partition>(resource.getPartitions()), partitionsNeedRecovery, recoveryThrottledPartitions, partitionsNeedLoadBalance, loadbalanceThrottledPartitions, currentStateOutput, bestPossiblePartitionStateMap, intermediatePartitionStateMap);
        }
        LogUtil.logDebug(logger, this._eventId, String.format("End processing resource: %s", resourceName));
        return intermediatePartitionStateMap;
    }

    private boolean isLoadBalanceDownwardForAllReplicas(Map<String, String> currentStateMap, Map<String, String> bestPossibleMap, StateModelDefinition stateModelDef) {
        HashSet<String> allInstances = new HashSet<String>();
        allInstances.addAll(currentStateMap.keySet());
        allInstances.addAll(bestPossibleMap.keySet());
        Map<String, Integer> statePriorityMap = stateModelDef.getStatePriorityMap();
        for (String instance : allInstances) {
            String currentState = currentStateMap.get(instance);
            String bestPossibleState = bestPossibleMap.get(instance);
            if (currentState == null) {
                return false;
            }
            if (bestPossibleState == null) continue;
            if (!statePriorityMap.containsKey(currentState) || !statePriorityMap.containsKey(bestPossibleState)) {
                return false;
            }
            if (statePriorityMap.get(currentState) <= statePriorityMap.get(bestPossibleState)) continue;
            return false;
        }
        return true;
    }

    private void chargePendingTransition(Resource resource, CurrentStateOutput currentStateOutput, StateTransitionThrottleController throttleController, Set<Partition> partitionsNeedRecovery, Set<Partition> partitionsNeedLoadbalance, ResourceControllerDataProvider cache) {
        String resourceName = resource.getResourceName();
        for (Partition partition : resource.getPartitions()) {
            Map<String, String> currentStateMap = currentStateOutput.getCurrentStateMap(resourceName, partition);
            Map<String, String> pendingMap = currentStateOutput.getPendingStateMap(resourceName, partition);
            StateTransitionThrottleConfig.RebalanceType rebalanceType = StateTransitionThrottleConfig.RebalanceType.NONE;
            if (partitionsNeedRecovery.contains(partition)) {
                rebalanceType = StateTransitionThrottleConfig.RebalanceType.RECOVERY_BALANCE;
            } else if (partitionsNeedLoadbalance.contains(partition)) {
                rebalanceType = StateTransitionThrottleConfig.RebalanceType.LOAD_BALANCE;
            }
            if (pendingMap.size() <= 0) continue;
            boolean shouldChargePartition = false;
            for (String instance : pendingMap.keySet()) {
                String currentState = currentStateMap.get(instance);
                String pendingState = pendingMap.get(instance);
                if (pendingState == null || pendingState.equals(currentState) || cache.getDisabledInstancesForPartition(resourceName, partition.getPartitionName()).contains(instance)) continue;
                throttleController.chargeInstance(rebalanceType, instance);
                shouldChargePartition = true;
            }
            if (!shouldChargePartition) continue;
            throttleController.chargeCluster(rebalanceType);
            throttleController.chargeResource(rebalanceType, resourceName);
        }
    }

    private Set<Partition> recoveryRebalance(Resource resource, PartitionStateMap bestPossiblePartitionStateMap, StateTransitionThrottleController throttleController, PartitionStateMap intermediatePartitionStateMap, Set<Partition> partitionsNeedRecovery, CurrentStateOutput currentStateOutput, String topState, ResourceControllerDataProvider cache) {
        String resourceName = resource.getResourceName();
        HashSet<Partition> partitionRecoveryBalanceThrottled = new HashSet<Partition>();
        Map<Partition, Map<String, String>> currentStateMap = currentStateOutput.getCurrentStateMap(resourceName);
        ArrayList<Partition> partitionsNeedRecoveryPrioritized = new ArrayList<Partition>(partitionsNeedRecovery);
        partitionsNeedRecoveryPrioritized.sort(Comparator.comparing(Partition::getPartitionName));
        partitionsNeedRecoveryPrioritized.sort(new PartitionPriorityComparator(bestPossiblePartitionStateMap.getStateMap(), currentStateMap, topState, true));
        for (Partition partition : partitionsNeedRecoveryPrioritized) {
            this.throttleStateTransitionsForPartition(throttleController, resourceName, partition, currentStateOutput, bestPossiblePartitionStateMap, partitionRecoveryBalanceThrottled, intermediatePartitionStateMap, StateTransitionThrottleConfig.RebalanceType.RECOVERY_BALANCE, cache);
        }
        LogUtil.logInfo(logger, this._eventId, String.format("For resource %s: Num of partitions needing recovery: %d, Num of partitions needing recovery but throttled (not recovered): %d", resourceName, partitionsNeedRecovery.size(), partitionRecoveryBalanceThrottled.size()));
        return partitionRecoveryBalanceThrottled;
    }

    private Set<Partition> loadRebalance(Resource resource, CurrentStateOutput currentStateOutput, PartitionStateMap bestPossiblePartitionStateMap, StateTransitionThrottleController throttleController, PartitionStateMap intermediatePartitionStateMap, Set<Partition> partitionsNeedLoadbalance, Map<Partition, Map<String, String>> currentStateMap, boolean onlyDownwardLoadBalance, StateModelDefinition stateModelDef, ResourceControllerDataProvider cache) {
        String resourceName = resource.getResourceName();
        HashSet<Partition> partitionsLoadbalanceThrottled = new HashSet<Partition>();
        ArrayList<Partition> partitionsNeedLoadRebalancePrioritized = new ArrayList<Partition>(partitionsNeedLoadbalance);
        partitionsNeedLoadRebalancePrioritized.sort(Comparator.comparing(Partition::getPartitionName));
        partitionsNeedLoadRebalancePrioritized.sort(new PartitionPriorityComparator(bestPossiblePartitionStateMap.getStateMap(), currentStateMap, "", false));
        for (Partition partition : partitionsNeedLoadRebalancePrioritized) {
            Map<String, String> bestPossibleMapForPartition;
            Map<String, String> currentStateMapForPartition;
            if (onlyDownwardLoadBalance && !this.isLoadBalanceDownwardForAllReplicas(currentStateMapForPartition = currentStateOutput.getCurrentStateMap(resourceName, partition), bestPossibleMapForPartition = bestPossiblePartitionStateMap.getPartitionMap(partition), stateModelDef)) {
                intermediatePartitionStateMap.setState(partition, currentStateMapForPartition);
                continue;
            }
            this.throttleStateTransitionsForPartition(throttleController, resourceName, partition, currentStateOutput, bestPossiblePartitionStateMap, partitionsLoadbalanceThrottled, intermediatePartitionStateMap, StateTransitionThrottleConfig.RebalanceType.LOAD_BALANCE, cache);
        }
        LogUtil.logInfo(logger, this._eventId, String.format("For resource %s: Num of partitions needing load-balance: %d, Num of partitions needing load-balance but throttled (not load-balanced): %d", resourceName, partitionsNeedLoadbalance.size(), partitionsLoadbalanceThrottled.size()));
        return partitionsLoadbalanceThrottled;
    }

    private void throttleStateTransitionsForPartition(StateTransitionThrottleController throttleController, String resourceName, Partition partition, CurrentStateOutput currentStateOutput, PartitionStateMap bestPossiblePartitionStateMap, Set<Partition> partitionsThrottled, PartitionStateMap intermediatePartitionStateMap, StateTransitionThrottleConfig.RebalanceType rebalanceType, ResourceControllerDataProvider cache) {
        String bestPossibleState;
        String currentState;
        boolean hasReachedThrottlingLimit;
        HashMap<String, String> intermediateMap;
        HashSet<String> allInstances;
        Map<String, String> bestPossibleMap;
        Map<String, String> currentStateMap;
        block9: {
            block8: {
                currentStateMap = currentStateOutput.getCurrentStateMap(resourceName, partition);
                bestPossibleMap = bestPossiblePartitionStateMap.getPartitionMap(partition);
                allInstances = new HashSet<String>(currentStateMap.keySet());
                allInstances.addAll(bestPossibleMap.keySet());
                intermediateMap = new HashMap<String, String>();
                hasReachedThrottlingLimit = false;
                if (!throttleController.shouldThrottleForResource(rebalanceType, resourceName)) break block8;
                hasReachedThrottlingLimit = true;
                if (!logger.isDebugEnabled()) break block9;
                LogUtil.logDebug(logger, this._eventId, String.format("Throttled on partition: %s in resource: %s", partition.getPartitionName(), resourceName));
                break block9;
            }
            for (String string : allInstances) {
                currentState = currentStateMap.get(string);
                bestPossibleState = bestPossibleMap.get(string);
                if (bestPossibleState == null || bestPossibleState.equals(currentState) || cache.getDisabledInstancesForPartition(resourceName, partition.getPartitionName()).contains(string) || !throttleController.shouldThrottleForInstance(rebalanceType, string)) continue;
                hasReachedThrottlingLimit = true;
                if (!logger.isDebugEnabled()) break;
                LogUtil.logDebug(logger, this._eventId, String.format("Throttled because of instance: %s for partition: %s in resource: %s", string, partition.getPartitionName(), resourceName));
                break;
            }
        }
        if (!hasReachedThrottlingLimit) {
            intermediateMap.putAll(bestPossibleMap);
            boolean shouldChargeForPartition = false;
            for (String instance : allInstances) {
                String currentState2 = currentStateMap.get(instance);
                String bestPossibleState2 = bestPossibleMap.get(instance);
                if (bestPossibleState2 == null || bestPossibleState2.equals(currentState2) || cache.getDisabledInstancesForPartition(resourceName, partition.getPartitionName()).contains(instance)) continue;
                throttleController.chargeInstance(rebalanceType, instance);
                shouldChargeForPartition = true;
            }
            if (shouldChargeForPartition) {
                throttleController.chargeCluster(rebalanceType);
                throttleController.chargeResource(rebalanceType, resourceName);
            }
        } else {
            for (String string : allInstances) {
                currentState = currentStateMap.get(string);
                bestPossibleState = bestPossibleMap.get(string);
                if (bestPossibleState != null && !bestPossibleState.equals(currentState) && cache.getDisabledInstancesForPartition(resourceName, partition.getPartitionName()).contains(string)) {
                    intermediateMap.put(string, bestPossibleState);
                    continue;
                }
                if (currentState != null) {
                    intermediateMap.put(string, currentState);
                }
                partitionsThrottled.add(partition);
            }
        }
        intermediatePartitionStateMap.setState(partition, intermediateMap);
    }

    private StateTransitionThrottleConfig.RebalanceType getRebalanceType(ResourceControllerDataProvider cache, Map<String, String> bestPossibleMap, List<String> preferenceList, StateModelDefinition stateModelDef, Map<String, String> currentStateMap, IdealState idealState, String partitionName) {
        if (preferenceList == null) {
            preferenceList = Collections.emptyList();
        }
        int replica = idealState.getMinActiveReplicas() == -1 ? idealState.getReplicaCount(preferenceList.size()) : idealState.getMinActiveReplicas();
        HashSet<String> activeList = new HashSet<String>(preferenceList);
        activeList.retainAll(cache.getEnabledLiveInstances());
        LinkedHashMap<String, Integer> expectedStateCountMap = stateModelDef.getStateCountMap(activeList.size(), replica);
        HashMap<String, String> currentStateMapWithoutDisabled = new HashMap<String, String>(currentStateMap);
        currentStateMapWithoutDisabled.keySet().removeAll(cache.getDisabledInstancesForPartition(idealState.getResourceName(), partitionName));
        Map<String, Integer> currentStateCounts = StateModelDefinition.getStateCounts(currentStateMapWithoutDisabled);
        for (String state : expectedStateCountMap.keySet()) {
            Integer expectedCount = expectedStateCountMap.get(state);
            Integer currentCount = currentStateCounts.get(state);
            expectedCount = expectedCount == null ? 0 : expectedCount;
            if ((currentCount = Integer.valueOf(currentCount == null ? 0 : currentCount)) >= expectedCount || state.equals(HelixDefinedState.DROPPED.name()) || state.equals(HelixDefinedState.ERROR.name()) || state.equals(stateModelDef.getInitialState())) continue;
            return StateTransitionThrottleConfig.RebalanceType.RECOVERY_BALANCE;
        }
        if (currentStateMap.equals(bestPossibleMap)) {
            return StateTransitionThrottleConfig.RebalanceType.NONE;
        }
        return StateTransitionThrottleConfig.RebalanceType.LOAD_BALANCE;
    }

    private void logPartitionMapState(String resource, Set<Partition> allPartitions, Set<Partition> recoveryPartitions, Set<Partition> recoveryThrottledPartitions, Set<Partition> loadbalancePartitions, Set<Partition> loadbalanceThrottledPartitions, CurrentStateOutput currentStateOutput, PartitionStateMap bestPossibleStateMap, PartitionStateMap intermediateStateMap) {
        if (logger.isDebugEnabled()) {
            LogUtil.logDebug(logger, this._eventId, String.format("Partitions need recovery: %s\nPartitions get throttled on recovery: %s", recoveryPartitions, recoveryThrottledPartitions));
            LogUtil.logDebug(logger, this._eventId, String.format("Partitions need loadbalance: %s\nPartitions get throttled on load-balance: %s", loadbalancePartitions, loadbalanceThrottledPartitions));
        }
        for (Partition partition : allPartitions) {
            if (!logger.isDebugEnabled()) continue;
            LogUtil.logDebug(logger, this._eventId, String.format("%s : Best possible map: %s", partition, bestPossibleStateMap.getPartitionMap(partition)));
            LogUtil.logDebug(logger, this._eventId, String.format("%s : Current State: %s", partition, currentStateOutput.getCurrentStateMap(resource, partition)));
            LogUtil.logDebug(logger, this._eventId, String.format("%s: Pending state: %s", partition, currentStateOutput.getPendingMessageMap(resource, partition)));
            LogUtil.logDebug(logger, this._eventId, String.format("%s: Intermediate state: %s", partition, intermediateStateMap.getPartitionMap(partition)));
        }
    }

    private class PartitionPriorityComparator
    implements Comparator<Partition> {
        private Map<Partition, Map<String, String>> _bestPossibleMap;
        private Map<Partition, Map<String, String>> _currentStateMap;
        private String _topState;
        private boolean _recoveryRebalance;

        PartitionPriorityComparator(Map<Partition, Map<String, String>> bestPossibleMap, Map<Partition, Map<String, String>> currentStateMap, String topState, boolean recoveryRebalance) {
            this._bestPossibleMap = bestPossibleMap;
            this._currentStateMap = currentStateMap;
            this._topState = topState;
            this._recoveryRebalance = recoveryRebalance;
        }

        @Override
        public int compare(Partition p1, Partition p2) {
            if (this._recoveryRebalance) {
                int missTopState2;
                int missTopState1 = this.getMissTopStateIndex(p1);
                if (missTopState1 != (missTopState2 = this.getMissTopStateIndex(p2))) {
                    return Integer.compare(missTopState1, missTopState2);
                }
                int currentActiveReplicas1 = this.getCurrentActiveReplicas(p1);
                int currentActiveReplicas2 = this.getCurrentActiveReplicas(p2);
                return Integer.compare(currentActiveReplicas1, currentActiveReplicas2);
            }
            int idealStateMatched1 = this.getIdealStateMatched(p1);
            int idealStateMatched2 = this.getIdealStateMatched(p2);
            return Integer.compare(idealStateMatched1, idealStateMatched2);
        }

        private int getMissTopStateIndex(Partition partition) {
            if (!this._currentStateMap.containsKey(partition) || !this._currentStateMap.get(partition).values().contains(this._topState)) {
                return 0;
            }
            return 1;
        }

        private int getCurrentActiveReplicas(Partition partition) {
            int currentActiveReplicas = 0;
            if (!this._currentStateMap.containsKey(partition)) {
                return currentActiveReplicas;
            }
            HashMap<String, Integer> stateCountMap = new HashMap<String, Integer>();
            for (String state : this._bestPossibleMap.get(partition).values()) {
                if (!stateCountMap.containsKey(state)) {
                    stateCountMap.put(state, 0);
                }
                stateCountMap.put(state, (Integer)stateCountMap.get(state) + 1);
            }
            for (String state : this._currentStateMap.get(partition).values()) {
                if (!stateCountMap.containsKey(state) || (Integer)stateCountMap.get(state) <= 0) continue;
                ++currentActiveReplicas;
                stateCountMap.put(state, (Integer)stateCountMap.get(state) - 1);
            }
            return currentActiveReplicas;
        }

        private int getIdealStateMatched(Partition partition) {
            int matchedState = 0;
            if (!this._currentStateMap.containsKey(partition)) {
                return matchedState;
            }
            for (String instance : this._bestPossibleMap.get(partition).keySet()) {
                if (!this._bestPossibleMap.get(partition).get(instance).equals(this._currentStateMap.get(partition).get(instance))) continue;
                ++matchedState;
            }
            return matchedState;
        }
    }

    private static class ResourcePriorityComparator
    implements Comparator<ResourcePriority> {
        private ResourcePriorityComparator() {
        }

        @Override
        public int compare(ResourcePriority priority1, ResourcePriority priority2) {
            return priority2.compareTo(priority1);
        }
    }

    private static class ResourcePriority {
        private String _resourceName;
        private int _priority;

        ResourcePriority(String resourceName, Integer priority) {
            this._resourceName = resourceName;
            this._priority = priority;
        }

        public int compareTo(ResourcePriority resourcePriority) {
            return Integer.compare(this._priority, resourcePriority._priority);
        }

        public String getResourceName() {
            return this._resourceName;
        }

        public void setPriority(String priority) {
            try {
                this._priority = Integer.parseInt(priority);
            }
            catch (Exception e) {
                logger.warn(String.format("Invalid priority field %s for resource %s", priority, this._resourceName));
            }
        }
    }
}

