/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.helix.HelixProperty;
import org.apache.helix.ZNRecord;
import org.apache.helix.model.Partition;

public class ResourceAssignment
extends HelixProperty {
    public ResourceAssignment(String resourceName) {
        super(resourceName);
    }

    public ResourceAssignment(ZNRecord existingMapping) {
        super(existingMapping);
    }

    public String getResourceName() {
        return this.getId();
    }

    public List<Partition> getMappedPartitions() {
        ArrayList<Partition> partitions = new ArrayList<Partition>();
        for (String partitionName : this._record.getMapFields().keySet()) {
            partitions.add(new Partition(partitionName));
        }
        return partitions;
    }

    public Map<String, String> getReplicaMap(Partition partition) {
        if (this._record.getMapFields().containsKey(partition.getPartitionName())) {
            return this._record.getMapField(partition.getPartitionName());
        }
        return Collections.emptyMap();
    }

    public void addReplicaMap(Partition partition, Map<String, String> replicaMap) {
        this._record.setMapField(partition.getPartitionName(), replicaMap);
    }
}

