/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.monitoring.mbeans;

import com.codahale.metrics.Histogram;
import com.codahale.metrics.Reservoir;
import com.codahale.metrics.SlidingTimeWindowArrayReservoir;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import javax.management.JMException;
import org.apache.helix.monitoring.mbeans.ClusterStatusMonitor;
import org.apache.helix.monitoring.mbeans.dynamicMBeans.DynamicMBeanProvider;
import org.apache.helix.monitoring.mbeans.dynamicMBeans.HistogramDynamicMetric;
import org.apache.helix.monitoring.mbeans.dynamicMBeans.SimpleDynamicMetric;

public class ClusterEventMonitor
extends DynamicMBeanProvider {
    private static final String CLUSTEREVENT_DN_KEY = "ClusterEventStatus";
    private static final String EVENT_DN_KEY = "eventName";
    private static final String PHASE_DN_KEY = "phaseName";
    private final String _phaseName;
    private SimpleDynamicMetric<Long> _totalDuration;
    private SimpleDynamicMetric<Long> _maxDuration;
    private SimpleDynamicMetric<Long> _count;
    private HistogramDynamicMetric _duration;
    private long _lastResetTime;
    private ClusterStatusMonitor _clusterStatusMonitor;

    public ClusterEventMonitor(ClusterStatusMonitor clusterStatusMonitor, String phaseName) {
        this._phaseName = phaseName;
        this._clusterStatusMonitor = clusterStatusMonitor;
        this._duration = new HistogramDynamicMetric("DurationGauge", new Histogram((Reservoir)new SlidingTimeWindowArrayReservoir(this.getResetIntervalInMs().longValue(), TimeUnit.MILLISECONDS)));
        this._count = new SimpleDynamicMetric<Long>("EventCounter", 0L);
        this._maxDuration = new SimpleDynamicMetric<Long>("MaxSingleDurationGauge", 0L);
        this._totalDuration = new SimpleDynamicMetric<Long>("TotalDurationCounter", 0L);
    }

    public ClusterEventMonitor(ClusterStatusMonitor clusterStatusMonitor, String phaseName, int histogramTimeWindowMs) {
        this._phaseName = phaseName;
        this._clusterStatusMonitor = clusterStatusMonitor;
        this._duration = new HistogramDynamicMetric("DurationGauge", new Histogram((Reservoir)new SlidingTimeWindowArrayReservoir((long)histogramTimeWindowMs, TimeUnit.MILLISECONDS)));
        this._count = new SimpleDynamicMetric<Long>("EventCounter", 0L);
        this._maxDuration = new SimpleDynamicMetric<Long>("MaxSingleDurationGauge", 0L);
        this._totalDuration = new SimpleDynamicMetric<Long>("TotalDurationCounter", 0L);
    }

    public void reportDuration(long duration) {
        this._totalDuration.updateValue(this._totalDuration.getValue() + duration);
        this._count.updateValue(this._count.getValue() + 1L);
        this._duration.updateValue(duration);
        if (this._lastResetTime + 3600000L <= System.currentTimeMillis() || duration > this._maxDuration.getValue()) {
            this._maxDuration.updateValue(duration);
            this._lastResetTime = System.currentTimeMillis();
        }
    }

    @Override
    public String getSensorName() {
        return String.format("%s.%s.%s.%s", CLUSTEREVENT_DN_KEY, this._clusterStatusMonitor.getClusterName(), "DEFAULT", this._phaseName);
    }

    private String getBeanName() {
        return String.format("%s,%s=%s,%s=%s", this._clusterStatusMonitor.clusterBeanName(), EVENT_DN_KEY, "ClusterEvent", PHASE_DN_KEY, this._phaseName);
    }

    @Override
    public ClusterEventMonitor register() throws JMException {
        ArrayList attributeList = new ArrayList();
        attributeList.add(this._totalDuration);
        attributeList.add(this._maxDuration);
        attributeList.add(this._count);
        attributeList.add(this._duration);
        this.doRegister(attributeList, this._clusterStatusMonitor.getObjectName(this.getBeanName()));
        return this;
    }

    public static enum PhaseName {
        Callback,
        InQueue,
        TotalProcessed;

    }
}

