/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.tools.ClusterVerifiers;

import java.util.List;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.I0Itec.zkclient.IZkChildListener;
import org.I0Itec.zkclient.IZkDataListener;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.PropertyKey;
import org.apache.helix.ZNRecord;
import org.apache.helix.api.listeners.PreFetch;
import org.apache.helix.manager.zk.ZKHelixDataAccessor;
import org.apache.helix.manager.zk.ZNRecordSerializer;
import org.apache.helix.manager.zk.ZkBaseDataAccessor;
import org.apache.helix.manager.zk.ZkClient;
import org.apache.helix.manager.zk.client.DedicatedZkClientFactory;
import org.apache.helix.manager.zk.client.HelixZkClient;
import org.apache.helix.model.ResourceConfig;
import org.apache.helix.tools.ClusterVerifiers.HelixClusterVerifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ZkHelixClusterVerifier
implements IZkChildListener,
IZkDataListener,
HelixClusterVerifier {
    private static Logger LOG = LoggerFactory.getLogger(ZkHelixClusterVerifier.class);
    protected static int DEFAULT_TIMEOUT = 300000;
    protected static int DEFAULT_PERIOD = 500;
    protected final HelixZkClient _zkClient;
    protected final String _clusterName;
    protected final HelixDataAccessor _accessor;
    protected final PropertyKey.Builder _keyBuilder;
    private CountDownLatch _countdown;
    private ExecutorService _verifyTaskThreadPool = Executors.newSingleThreadExecutor(r -> new Thread(r, "ZkHelixClusterVerifier-verify_thread"));

    public ZkHelixClusterVerifier(HelixZkClient zkClient, String clusterName) {
        if (zkClient == null || clusterName == null) {
            throw new IllegalArgumentException("requires zkClient|clusterName");
        }
        this._zkClient = zkClient;
        this._clusterName = clusterName;
        this._accessor = new ZKHelixDataAccessor(clusterName, new ZkBaseDataAccessor<ZNRecord>(this._zkClient));
        this._keyBuilder = this._accessor.keyBuilder();
    }

    public ZkHelixClusterVerifier(String zkAddr, String clusterName) {
        if (zkAddr == null || clusterName == null) {
            throw new IllegalArgumentException("requires zkAddr|clusterName");
        }
        this._zkClient = DedicatedZkClientFactory.getInstance().buildZkClient(new HelixZkClient.ZkConnectionConfig(zkAddr));
        this._zkClient.setZkSerializer(new ZNRecordSerializer());
        this._clusterName = clusterName;
        this._accessor = new ZKHelixDataAccessor(clusterName, new ZkBaseDataAccessor<ZNRecord>(this._zkClient));
        this._keyBuilder = this._accessor.keyBuilder();
    }

    @Override
    public boolean verify(long timeout) {
        return this.verifyByZkCallback(timeout);
    }

    @Override
    public boolean verify() {
        return this.verify(DEFAULT_TIMEOUT);
    }

    public abstract boolean verifyByZkCallback(long var1);

    public boolean verifyByZkCallback() {
        return this.verifyByZkCallback(DEFAULT_TIMEOUT);
    }

    public boolean verifyByPolling(long timeout, long period) {
        try {
            long start = System.currentTimeMillis();
            do {
                ZkHelixClusterVerifier.invokeRebalance(this._accessor);
                boolean success = this.verifyState();
                if (success) {
                    return true;
                }
                TimeUnit.MILLISECONDS.sleep(period);
            } while (System.currentTimeMillis() - start <= timeout);
        }
        catch (Exception e) {
            LOG.error("Exception in verifier", (Throwable)e);
        }
        return false;
    }

    public boolean verifyByPolling() {
        return this.verifyByPolling(DEFAULT_TIMEOUT, DEFAULT_PERIOD);
    }

    protected boolean verifyByCallback(long timeout, List<ClusterVerifyTrigger> triggers) {
        this._countdown = new CountDownLatch(1);
        for (ClusterVerifyTrigger trigger : triggers) {
            this.subscribeTrigger(trigger);
        }
        boolean success = false;
        try {
            success = this.verifyState();
            if (!success && !(success = this._countdown.await(timeout, TimeUnit.MILLISECONDS))) {
                success = this.verifyState();
            }
        }
        catch (Exception e) {
            LOG.error("Exception in verifier", (Throwable)e);
        }
        this._zkClient.unsubscribeAll();
        this._verifyTaskThreadPool.shutdownNow();
        return success;
    }

    private void subscribeTrigger(ClusterVerifyTrigger trigger) {
        String path = trigger.getTriggerKey().getPath();
        if (trigger.isTriggerOnDataChange()) {
            this._zkClient.subscribeDataChanges(path, this);
        }
        if (trigger.isTriggerOnChildChange()) {
            this._zkClient.subscribeChildChanges(path, this);
        }
        if (trigger.isTriggerOnChildDataChange()) {
            List<String> childs = this._zkClient.getChildren(path);
            for (String child : childs) {
                String childPath = String.format("%s/%s", path, child);
                this._zkClient.subscribeDataChanges(childPath, this);
            }
        }
    }

    protected abstract boolean verifyState() throws Exception;

    @PreFetch(enabled=false)
    public void handleDataChange(String dataPath, Object data) throws Exception {
        if (!this._verifyTaskThreadPool.isShutdown()) {
            this._verifyTaskThreadPool.submit(new VerifyStateCallbackTask());
        }
    }

    public void handleDataDeleted(String dataPath) throws Exception {
        this._zkClient.unsubscribeDataChanges(dataPath, this);
        if (!this._verifyTaskThreadPool.isShutdown()) {
            this._verifyTaskThreadPool.submit(new VerifyStateCallbackTask());
        }
    }

    public void handleChildChange(String parentPath, List<String> currentChilds) throws Exception {
        for (String child : currentChilds) {
            String childPath = String.format("%s/%s", parentPath, child);
            this._zkClient.subscribeDataChanges(childPath, this);
        }
        if (!this._verifyTaskThreadPool.isShutdown()) {
            this._verifyTaskThreadPool.submit(new VerifyStateCallbackTask());
        }
    }

    public HelixZkClient getHelixZkClient() {
        return this._zkClient;
    }

    @Deprecated
    public ZkClient getZkClient() {
        return (ZkClient)this.getHelixZkClient();
    }

    public String getClusterName() {
        return this._clusterName;
    }

    public static synchronized void invokeRebalance(HelixDataAccessor accessor) {
        String dummyName = UUID.randomUUID().toString();
        ResourceConfig dummyConfig = new ResourceConfig(dummyName);
        accessor.updateProperty(accessor.keyBuilder().resourceConfig(dummyName), dummyConfig);
        accessor.removeProperty(accessor.keyBuilder().resourceConfig(dummyName));
    }

    class VerifyStateCallbackTask
    implements Runnable {
        VerifyStateCallbackTask() {
        }

        @Override
        public void run() {
            try {
                boolean success = ZkHelixClusterVerifier.this.verifyState();
                if (success) {
                    ZkHelixClusterVerifier.this._countdown.countDown();
                }
            }
            catch (Exception ex) {
                LOG.info("verifyState() throws exception: " + ex);
            }
        }
    }

    protected static class ClusterVerifyTrigger {
        final PropertyKey _triggerKey;
        final boolean _triggerOnDataChange;
        final boolean _triggerOnChildChange;
        final boolean _triggerOnChildDataChange;

        public ClusterVerifyTrigger(PropertyKey triggerKey, boolean triggerOnDataChange, boolean triggerOnChildChange, boolean triggerOnChildDataChange) {
            this._triggerKey = triggerKey;
            this._triggerOnDataChange = triggerOnDataChange;
            this._triggerOnChildChange = triggerOnChildChange;
            this._triggerOnChildDataChange = triggerOnChildDataChange;
        }

        public boolean isTriggerOnDataChange() {
            return this._triggerOnDataChange;
        }

        public PropertyKey getTriggerKey() {
            return this._triggerKey;
        }

        public boolean isTriggerOnChildChange() {
            return this._triggerOnChildChange;
        }

        public boolean isTriggerOnChildDataChange() {
            return this._triggerOnChildDataChange;
        }
    }
}

