ace.define("ace/mode/terraform_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"],function(a,d,p){"use strict";var m=a("../lib/oop"),u=a("./text_highlight_rules").TextHighlightRules,o=function(){this.$rules={start:[{token:["storage.function.terraform"],regex:"\\b(output|resource|data|variable|module|export)\\b"},{token:"variable.terraform",regex:"\\$\\s",push:[{token:"keyword.terraform",regex:"(-var-file|-var)"},{token:"variable.terraform",regex:"\\n|$",next:"pop"},{include:"strings"},{include:"variables"},{include:"operators"},{defaultToken:"text"}]},{token:"language.support.class",regex:"\\b(timeouts|provider|connection|provisioner|lifecycleprovider|atlas)\\b"},{token:"singleline.comment.terraform",regex:"#.*$"},{token:"singleline.comment.terraform",regex:"//.*$"},{token:"multiline.comment.begin.terraform",regex:/\/\*/,push:"blockComment"},{token:"storage.function.terraform",regex:"^\\s*(locals|terraform)\\s*{"},{token:"paren.lparen",regex:"[[({]"},{token:"paren.rparen",regex:"[\\])}]"},{include:"constants"},{include:"strings"},{include:"operators"},{include:"variables"}],blockComment:[{regex:/\*\//,token:"multiline.comment.end.terraform",next:"pop"},{defaultToken:"comment"}],constants:[{token:"constant.language.terraform",regex:"\\b(true|false|yes|no|on|off|EOF)\\b"},{token:"constant.numeric.terraform",regex:"(\\b([0-9]+)([kKmMgG]b?)?\\b)|(\\b(0x[0-9A-Fa-f]+)([kKmMgG]b?)?\\b)"}],variables:[{token:["variable.assignment.terraform","keyword.operator"],regex:"\\b([a-zA-Z_]+)(\\s*=)"}],interpolated_variables:[{token:"variable.terraform",regex:"\\b(var|self|count|path|local)\\b(?:\\.*[a-zA-Z_-]*)?"}],strings:[{token:"punctuation.quote.terraform",regex:"'",push:[{token:"punctuation.quote.terraform",regex:"'",next:"pop"},{include:"escaped_chars"},{defaultToken:"string"}]},{token:"punctuation.quote.terraform",regex:'"',push:[{token:"punctuation.quote.terraform",regex:'"',next:"pop"},{include:"interpolation"},{include:"escaped_chars"},{defaultToken:"string"}]}],escaped_chars:[{token:"constant.escaped_char.terraform",regex:"\\\\."}],operators:[{token:"keyword.operator",regex:"\\?|:|==|!=|>|<|>=|<=|&&|\\|\\||!|%|&|\\*|\\+|\\-|/|="}],interpolation:[{token:"punctuation.interpolated.begin.terraform",regex:"\\$?\\$\\{",push:[{token:"punctuation.interpolated.end.terraform",regex:"\\}",next:"pop"},{include:"interpolated_variables"},{include:"operators"},{include:"constants"},{include:"strings"},{include:"functions"},{include:"parenthesis"},{defaultToken:"punctuation"}]}],functions:[{token:"keyword.function.terraform",regex:"\\b(abs|basename|base64decode|base64encode|base64gzip|base64sha256|base64sha512|bcrypt|ceil|chomp|chunklist|cidrhost|cidrnetmask|cidrsubnet|coalesce|coalescelist|compact|concat|contains|dirname|distinct|element|file|floor|flatten|format|formatlist|indent|index|join|jsonencode|keys|length|list|log|lookup|lower|map|matchkeys|max|merge|min|md5|pathexpand|pow|replace|rsadecrypt|sha1|sha256|sha512|signum|slice|sort|split|substr|timestamp|timeadd|title|transpose|trimspace|upper|urlencode|uuid|values|zipmap)\\b"}],parenthesis:[{token:"paren.lparen",regex:"\\["},{token:"paren.rparen",regex:"\\]"}]},this.normalizeRules()};m.inherits(o,u),d.TerraformHighlightRules=o}),ace.define("ace/mode/folding/cstyle",["require","exports","module","ace/lib/oop","ace/range","ace/mode/folding/fold_mode"],function(a,d,p){"use strict";var m=a("../../lib/oop"),u=a("../../range").Range,o=a("./fold_mode").FoldMode,s=d.FoldMode=function(e){e&&(this.foldingStartMarker=new RegExp(this.foldingStartMarker.source.replace(/\|[^|]*?$/,"|"+e.start)),this.foldingStopMarker=new RegExp(this.foldingStopMarker.source.replace(/\|[^|]*?$/,"|"+e.end)))};m.inherits(s,o),function(){this.foldingStartMarker=/([\{\[\(])[^\}\]\)]*$|^\s*(\/\*)/,this.foldingStopMarker=/^[^\[\{\(]*([\}\]\)])|^[\s\*]*(\*\/)/,this.singleLineBlockCommentRe=/^\s*(\/\*).*\*\/\s*$/,this.tripleStarBlockCommentRe=/^\s*(\/\*\*\*).*\*\/\s*$/,this.startRegionRe=/^\s*(\/\*|\/\/)#?region\b/,this._getFoldWidgetBase=this.getFoldWidget,this.getFoldWidget=function(e,t,r){var i=e.getLine(r);if(this.singleLineBlockCommentRe.test(i)&&!this.startRegionRe.test(i)&&!this.tripleStarBlockCommentRe.test(i))return"";var l=this._getFoldWidgetBase(e,t,r);return!l&&this.startRegionRe.test(i)?"start":l},this.getFoldWidgetRange=function(e,t,r,i){var n,l=e.getLine(r);if(this.startRegionRe.test(l))return this.getCommentRegionBlock(e,l,r);if(n=l.match(this.foldingStartMarker)){var g=n.index;if(n[1])return this.openingBracketBlock(e,n[1],r,g);var c=e.getCommentFoldRange(r,g+n[0].length,1);return c&&!c.isMultiLine()&&(i?c=this.getSectionRange(e,r):"all"!=t&&(c=null)),c}return"markbegin"!==t&&(n=l.match(this.foldingStopMarker))?(g=n.index+n[0].length,n[1]?this.closingBracketBlock(e,n[1],r,g):e.getCommentFoldRange(r,g,-1)):void 0},this.getSectionRange=function(e,t){for(var r=e.getLine(t),i=r.search(/\S/),l=t,g=r.length,c=t+=1,n=e.getLength();++t<n;){var f=(r=e.getLine(t)).search(/\S/);if(-1!==f){if(i>f)break;var h=this.getFoldWidgetRange(e,"all",t);if(h){if(h.start.row<=l)break;if(h.isMultiLine())t=h.end.row;else if(i==f)break}c=t}}return new u(l,g,c,e.getLine(c).length)},this.getCommentRegionBlock=function(e,t,r){for(var i=t.search(/\s*$/),l=e.getLength(),g=r,c=/^\s*(?:\/\*|\/\/|--)#?(end)?region\b/,n=1;++r<l;){t=e.getLine(r);var f=c.exec(t);if(f&&(f[1]?n--:n++,!n))break}if(r>g)return new u(g,i,r,t.length)}}.call(s.prototype)}),ace.define("ace/mode/matching_brace_outdent",["require","exports","module","ace/range"],function(a,d,p){"use strict";var m=a("../range").Range,u=function(){};(function(){this.checkOutdent=function(o,s){return!!/^\s+$/.test(o)&&/^\s*\}/.test(s)},this.autoOutdent=function(o,s){var t=o.getLine(s).match(/^(\s*\})/);if(!t)return 0;var r=t[1].length,i=o.findMatchingBracket({row:s,column:r});if(!i||i.row==s)return 0;var l=this.$getIndent(o.getLine(i.row));o.replace(new m(s,0,s,r-1),l)},this.$getIndent=function(o){return o.match(/^\s*/)[0]}}).call(u.prototype),d.MatchingBraceOutdent=u}),ace.define("ace/mode/terraform",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/terraform_highlight_rules","ace/mode/folding/cstyle","ace/mode/matching_brace_outdent"],function(a,d,p){"use strict";var m=a("../lib/oop"),u=a("./text").Mode,o=a("./terraform_highlight_rules").TerraformHighlightRules,s=a("./folding/cstyle").FoldMode,e=a("./matching_brace_outdent").MatchingBraceOutdent,t=function(){u.call(this),this.HighlightRules=o,this.$outdent=new e,this.$behaviour=this.$defaultBehaviour,this.foldingRules=new s};m.inherits(t,u),function(){this.lineCommentStart=["#","//"],this.blockComment={start:"/*",end:"*/"},this.$id="ace/mode/terraform"}.call(t.prototype),d.Mode=t}),ace.require(["ace/mode/terraform"],function(a){"object"==typeof module&&"object"==typeof exports&&module&&(module.exports=a)});