/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.rebalancer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.helix.HelixDefinedState;
import org.apache.helix.api.config.StateTransitionThrottleConfig;
import org.apache.helix.controller.dataproviders.ResourceControllerDataProvider;
import org.apache.helix.controller.rebalancer.AbstractRebalancer;
import org.apache.helix.controller.rebalancer.constraint.MonitoredAbnormalResolver;
import org.apache.helix.controller.rebalancer.util.DelayedRebalanceUtil;
import org.apache.helix.controller.rebalancer.util.WagedValidationUtil;
import org.apache.helix.controller.stages.CurrentStateOutput;
import org.apache.helix.model.ClusterConfig;
import org.apache.helix.model.IdealState;
import org.apache.helix.model.InstanceConfig;
import org.apache.helix.model.Partition;
import org.apache.helix.model.Resource;
import org.apache.helix.model.ResourceAssignment;
import org.apache.helix.model.ResourceConfig;
import org.apache.helix.model.StateModelDefinition;
import org.apache.helix.zookeeper.datamodel.ZNRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelayedAutoRebalancer
extends AbstractRebalancer<ResourceControllerDataProvider> {
    private static final Logger LOG = LoggerFactory.getLogger(DelayedAutoRebalancer.class);
    public static final Set<String> INSTANCE_OPERATION_TO_EXCLUDE_FROM_ASSIGNMENT = Set.of("EVACUATE", "SWAP_IN");

    @Override
    public IdealState computeNewIdealState(String resourceName, IdealState currentIdealState, CurrentStateOutput currentStateOutput, ResourceControllerDataProvider clusterData) {
        ZNRecord newIdealMapping;
        Set<String> allNodes;
        Set<String> liveEnabledNodes;
        String instanceTag;
        IdealState cachedIdealState = this.getCachedIdealState(resourceName, clusterData);
        if (cachedIdealState != null) {
            LOG.debug("Use cached IdealState for {}", (Object)resourceName);
            return cachedIdealState;
        }
        LOG.info("Computing IdealState for " + resourceName);
        List<String> allPartitions = this.getStablePartitionList(clusterData, currentIdealState);
        if (allPartitions.size() == 0) {
            LOG.info("Partition count is 0 for resource " + resourceName + ", stop calculate ideal mapping for the resource.");
            return this.generateNewIdealState(resourceName, currentIdealState, this.emptyMapping(currentIdealState));
        }
        Map<Object, Object> userDefinedPreferenceList = new HashMap();
        ClusterConfig clusterConfig = clusterData.getClusterConfig();
        ResourceConfig resourceConfig = clusterData.getResourceConfig(resourceName);
        boolean delayRebalanceEnabled = DelayedRebalanceUtil.isDelayRebalanceEnabled(currentIdealState, clusterConfig);
        if (resourceConfig != null && !(userDefinedPreferenceList = resourceConfig.getPreferenceLists()).isEmpty()) {
            LOG.info("Using user defined preference list for partitions: " + userDefinedPreferenceList.keySet());
        }
        if ((instanceTag = currentIdealState.getInstanceGroupTag()) != null) {
            liveEnabledNodes = clusterData.getEnabledLiveInstancesWithTag(instanceTag);
            allNodes = clusterData.getInstancesWithTag(instanceTag);
            if (LOG.isInfoEnabled()) {
                LOG.info(String.format("Found the following participants with tag %s for %s: instances: %s, liveEnabledInstances: %s", currentIdealState.getInstanceGroupTag(), resourceName, allNodes, liveEnabledNodes));
            }
        } else {
            liveEnabledNodes = clusterData.getEnabledLiveInstances();
            allNodes = clusterData.getAllInstances();
        }
        long delay = DelayedRebalanceUtil.getRebalanceDelay(currentIdealState, clusterConfig);
        Set<String> activeNodes = DelayedRebalanceUtil.getActiveNodes(allNodes, currentIdealState, liveEnabledNodes, clusterData.getInstanceOfflineTimeMap(), clusterData.getLiveInstances().keySet(), clusterData.getInstanceConfigMap(), delay, clusterConfig);
        if (delayRebalanceEnabled) {
            HashSet<String> offlineOrDisabledInstances = new HashSet<String>(activeNodes);
            offlineOrDisabledInstances.removeAll(liveEnabledNodes);
            DelayedRebalanceUtil.setRebalanceScheduler(currentIdealState.getResourceName(), true, offlineOrDisabledInstances, clusterData.getInstanceOfflineTimeMap(), clusterData.getLiveInstances().keySet(), clusterData.getInstanceConfigMap(), delay, clusterConfig, this._manager);
        }
        if (allNodes.isEmpty() || activeNodes.isEmpty()) {
            LOG.error(String.format("No instances or active instances available for resource %s, allInstances: %s, liveInstances: %s, activeInstances: %s", resourceName, allNodes, liveEnabledNodes, activeNodes));
            return this.generateNewIdealState(resourceName, currentIdealState, this.emptyMapping(currentIdealState));
        }
        StateModelDefinition stateModelDef = clusterData.getStateModelDef(currentIdealState.getStateModelDefRef());
        int replicaCount = currentIdealState.getReplicaCount(activeNodes.size());
        if (replicaCount == 0) {
            LOG.error("Replica count is 0 for resource " + resourceName + ", stop calculate ideal mapping for the resource.");
            return this.generateNewIdealState(resourceName, currentIdealState, this.emptyMapping(currentIdealState));
        }
        LinkedHashMap<String, Integer> stateCountMap = stateModelDef.getStateCountMap(activeNodes.size(), replicaCount);
        Map<String, Map<String, String>> currentMapping = this.currentMapping(currentStateOutput, resourceName, allPartitions, stateCountMap);
        int maxPartition = currentIdealState.getMaxPartitionsPerInstance();
        this._rebalanceStrategy = this.getRebalanceStrategy(currentIdealState.getRebalanceStrategy(), allPartitions, resourceName, stateCountMap, maxPartition);
        ArrayList<String> allNodeList = new ArrayList<String>(allNodes);
        List<String> liveEnabledAssignableNodeList = DelayedAutoRebalancer.filterOutOnOperationInstances(clusterData.getInstanceConfigMap(), liveEnabledNodes);
        Collections.sort(allNodeList);
        Collections.sort(liveEnabledAssignableNodeList);
        ZNRecord finalMapping = newIdealMapping = this._rebalanceStrategy.computePartitionAssignment(allNodeList, liveEnabledAssignableNodeList, currentMapping, clusterData);
        if (DelayedRebalanceUtil.isDelayRebalanceEnabled(currentIdealState, clusterConfig) || liveEnabledAssignableNodeList.size() != activeNodes.size()) {
            ArrayList<String> activeNodeList = new ArrayList<String>(activeNodes);
            Collections.sort(activeNodeList);
            int minActiveReplicas = DelayedRebalanceUtil.getMinActiveReplica(ResourceConfig.mergeIdealStateWithResourceConfig(resourceConfig, currentIdealState), currentIdealState, replicaCount);
            ZNRecord newActiveMapping = this._rebalanceStrategy.computePartitionAssignment(allNodeList, activeNodeList, currentMapping, clusterData);
            finalMapping = this.getFinalDelayedMapping(currentIdealState, newIdealMapping, newActiveMapping, liveEnabledNodes, replicaCount, minActiveReplicas);
        }
        finalMapping.getListFields().putAll(userDefinedPreferenceList);
        LOG.debug("currentMapping: {}", currentMapping);
        LOG.debug("stateCountMap: {}", stateCountMap);
        LOG.debug("liveEnabledNodes: {}", liveEnabledNodes);
        LOG.debug("activeNodes: {}", activeNodes);
        LOG.debug("allNodes: {}", allNodes);
        LOG.debug("maxPartition: {}", (Object)maxPartition);
        LOG.debug("newIdealMapping: {}", (Object)newIdealMapping);
        LOG.debug("finalMapping: {}", (Object)finalMapping);
        IdealState idealState = this.generateNewIdealState(resourceName, currentIdealState, finalMapping);
        clusterData.setCachedIdealMapping(resourceName, idealState.getRecord());
        return idealState;
    }

    private static List<String> filterOutOnOperationInstances(Map<String, InstanceConfig> instanceConfigMap, Set<String> nodes) {
        return nodes.stream().filter(instance -> !INSTANCE_OPERATION_TO_EXCLUDE_FROM_ASSIGNMENT.contains(((InstanceConfig)instanceConfigMap.get(instance)).getInstanceOperation())).collect(Collectors.toList());
    }

    private IdealState generateNewIdealState(String resourceName, IdealState currentIdealState, ZNRecord newMapping) {
        IdealState newIdealState = new IdealState(resourceName);
        newIdealState.getRecord().setSimpleFields(currentIdealState.getRecord().getSimpleFields());
        newIdealState.setRebalanceMode(currentIdealState.getRebalanceMode());
        newIdealState.getRecord().setListFields(newMapping.getListFields());
        return newIdealState;
    }

    private ZNRecord getFinalDelayedMapping(IdealState idealState, ZNRecord newIdealMapping, ZNRecord newActiveMapping, Set<String> liveInstances, int numReplica, int minActiveReplica) {
        if (minActiveReplica >= numReplica) {
            return newIdealMapping;
        }
        ZNRecord finalMapping = new ZNRecord(idealState.getResourceName());
        finalMapping.setListFields(DelayedRebalanceUtil.getFinalDelayedMapping(newIdealMapping.getListFields(), newActiveMapping.getListFields(), liveInstances, minActiveReplica));
        return finalMapping;
    }

    private ZNRecord emptyMapping(IdealState idealState) {
        ZNRecord emptyMapping = new ZNRecord(idealState.getResourceName());
        for (String partition : idealState.getPartitionSet()) {
            emptyMapping.setListField(partition, new ArrayList<String>());
        }
        return emptyMapping;
    }

    @Override
    public ResourceAssignment computeBestPossiblePartitionState(ResourceControllerDataProvider cache, IdealState idealState, Resource resource, CurrentStateOutput currentStateOutput) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Processing resource:" + resource.getResourceName());
        }
        Set<String> allNodes = cache.getEnabledInstances();
        Set<String> liveNodes = cache.getLiveInstances().keySet();
        ClusterConfig clusterConfig = cache.getClusterConfig();
        long delayTime = DelayedRebalanceUtil.getRebalanceDelay(idealState, clusterConfig);
        Set<String> activeNodes = DelayedRebalanceUtil.getActiveNodes(allNodes, idealState, liveNodes, cache.getInstanceOfflineTimeMap(), cache.getLiveInstances().keySet(), cache.getInstanceConfigMap(), delayTime, clusterConfig);
        String stateModelDefName = idealState.getStateModelDefRef();
        StateModelDefinition stateModelDef = cache.getStateModelDef(stateModelDefName);
        ResourceAssignment partitionMapping = new ResourceAssignment(resource.getResourceName());
        for (Partition partition : resource.getPartitions()) {
            Set<String> disabledInstancesForPartition = cache.getDisabledInstancesForPartition(resource.getResourceName(), partition.toString());
            List<String> preferenceList = DelayedAutoRebalancer.getPreferenceList(partition, idealState, activeNodes);
            Map<String, String> bestStateForPartition = this.computeBestPossibleStateForPartition(liveNodes, stateModelDef, preferenceList, currentStateOutput, disabledInstancesForPartition, idealState, clusterConfig, partition, cache.getAbnormalStateResolver(stateModelDefName), cache);
            partitionMapping.addReplicaMap(partition, bestStateForPartition);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Best possible mapping for resource  " + resource.getResourceName() + ": " + partitionMapping);
        }
        return partitionMapping;
    }

    @Override
    protected Map<String, String> computeBestPossibleStateForPartition(Set<String> liveInstances, StateModelDefinition stateModelDef, List<String> preferenceList, CurrentStateOutput currentStateOutput, Set<String> disabledInstancesForPartition, IdealState idealState, ClusterConfig clusterConfig, Partition partition, MonitoredAbnormalResolver monitoredResolver) {
        return this.computeBestPossibleStateForPartition(liveInstances, stateModelDef, preferenceList, currentStateOutput, disabledInstancesForPartition, idealState, clusterConfig, partition, monitoredResolver, (ResourceControllerDataProvider)null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected Map<String, String> computeBestPossibleStateForPartition(Set<String> liveInstances, StateModelDefinition stateModelDef, List<String> preferenceList, CurrentStateOutput currentStateOutput, Set<String> disabledInstancesForPartition, IdealState idealState, ClusterConfig clusterConfig, Partition partition, MonitoredAbnormalResolver monitoredResolver, ResourceControllerDataProvider cache) {
        boolean isWaged;
        Optional<Map<String, String>> optionalOverwrittenStates = this.computeStatesOverwriteForPartition(stateModelDef, preferenceList, currentStateOutput, idealState, partition, monitoredResolver);
        if (optionalOverwrittenStates.isPresent()) {
            return optionalOverwrittenStates.get();
        }
        HashMap<String, String> currentStateMap = new HashMap<String, String>(currentStateOutput.getCurrentStateMap(idealState.getResourceName(), partition));
        ArrayList currentInstances = new ArrayList(currentStateMap.keySet());
        Collections.sort(currentInstances);
        HashMap<String, String> pendingStates = new HashMap<String, String>(currentStateOutput.getPendingStateMap(idealState.getResourceName(), partition));
        for (String instance : pendingStates.keySet()) {
            if (currentStateMap.containsKey(instance)) continue;
            currentStateMap.put(instance, stateModelDef.getInitialState());
            currentInstances.add(instance);
        }
        HashSet<String> instancesToDrop = new HashSet<String>();
        Iterator it = currentInstances.iterator();
        while (it.hasNext()) {
            String instance = (String)it.next();
            String state = (String)currentStateMap.get(instance);
            if (state != null) continue;
            it.remove();
            instancesToDrop.add(instance);
        }
        if (preferenceList == null) {
            preferenceList = Collections.emptyList();
        }
        boolean isPreferenceListEmpty = preferenceList.isEmpty();
        int numExtraReplicas = this.getNumExtraReplicas(clusterConfig);
        int numReplicas = preferenceList.size();
        ArrayList<String> instanceToAdd = new ArrayList<String>(preferenceList);
        instanceToAdd.removeAll(currentInstances);
        ArrayList<String> combinedPreferenceList = new ArrayList<String>();
        if (currentInstances.size() <= numReplicas && numReplicas + numExtraReplicas - currentInstances.size() > 0) {
            int subListSize = numReplicas + numExtraReplicas - currentInstances.size();
            combinedPreferenceList.addAll(instanceToAdd.subList(0, Math.min(subListSize, instanceToAdd.size())));
        }
        HashMap<String, String> currentMapWithPreferenceList = new HashMap<String, String>(currentStateMap);
        currentMapWithPreferenceList.keySet().retainAll(preferenceList);
        combinedPreferenceList.addAll(currentInstances);
        combinedPreferenceList.sort(new AbstractRebalancer.PreferenceListNodeComparator(currentStateMap, stateModelDef, preferenceList));
        boolean bl = isWaged = WagedValidationUtil.isWagedEnabled(idealState) && cache != null;
        if (isWaged && !isPreferenceListEmpty && instanceToAdd.size() > 0) {
            for (String string : instanceToAdd) {
                if (!combinedPreferenceList.contains(string) || cache.checkAndReduceCapacity(string, idealState.getResourceName(), partition.getPartitionName())) continue;
                LOG.info("Instance: {} has no capacity to hold resource: {}, partition: {}, removing it from combinedPreferenceList.", new Object[]{string, idealState.getResourceName(), partition.getPartitionName()});
                combinedPreferenceList.remove(string);
            }
        }
        Map<String, String> bestPossibleStateMap = this.computeBestPossibleMap(combinedPreferenceList, stateModelDef, currentStateMap, liveInstances, disabledInstancesForPartition);
        for (String instance : instancesToDrop) {
            bestPossibleStateMap.put(instance, HelixDefinedState.DROPPED.name());
        }
        if (!currentMapWithPreferenceList.values().contains(HelixDefinedState.ERROR.name()) && bestPossibleStateMap.size() > numReplicas && this.readyToDrop(currentStateMap, bestPossibleStateMap, preferenceList, combinedPreferenceList)) {
            void var25_31;
            boolean bl2 = false;
            while (var25_31 < combinedPreferenceList.size() - numReplicas) {
                String instanceToDrop = (String)combinedPreferenceList.get(combinedPreferenceList.size() - var25_31 - 1);
                bestPossibleStateMap.put(instanceToDrop, HelixDefinedState.DROPPED.name());
                ++var25_31;
            }
        }
        for (String instance : combinedPreferenceList) {
            if (!currentStateMap.containsKey(instance) || !((String)currentStateMap.get(instance)).equals(HelixDefinedState.ERROR.name())) continue;
            bestPossibleStateMap.put(instance, HelixDefinedState.ERROR.name());
        }
        return bestPossibleStateMap;
    }

    private boolean readyToDrop(Map<String, String> currentStateMap, Map<String, String> bestPossibleMap, List<String> preferenceList, List<String> combinedPreferenceList) {
        HashSet<String> preferenceWithActiveState = new HashSet<String>(preferenceList);
        preferenceWithActiveState.retainAll(combinedPreferenceList);
        for (String instance : preferenceWithActiveState) {
            if (currentStateMap.containsKey(instance) && currentStateMap.get(instance).equals(bestPossibleMap.get(instance))) continue;
            return false;
        }
        return true;
    }

    private int getNumExtraReplicas(ClusterConfig clusterConfig) {
        int numExtraReplicas = 1;
        List<StateTransitionThrottleConfig> stateTransitionThrottleConfigs = clusterConfig.getStateTransitionThrottleConfigs();
        for (StateTransitionThrottleConfig throttleConfig : stateTransitionThrottleConfigs) {
            if (!StateTransitionThrottleConfig.ThrottleScope.PARTITION.equals((Object)throttleConfig.getThrottleScope()) || !StateTransitionThrottleConfig.RebalanceType.LOAD_BALANCE.equals((Object)throttleConfig.getRebalanceType())) continue;
            numExtraReplicas = (int)Math.min((long)numExtraReplicas, throttleConfig.getMaxPartitionInTransition());
        }
        return numExtraReplicas;
    }
}

