/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.monitoring.mbeans;

import java.util.concurrent.ThreadPoolExecutor;
import javax.management.JMException;
import javax.management.ObjectName;
import org.apache.helix.monitoring.mbeans.MBeanRegistrar;
import org.apache.helix.monitoring.mbeans.MonitorDomainNames;
import org.apache.helix.monitoring.mbeans.ThreadPoolExecutorMonitorMBean;

public class ThreadPoolExecutorMonitor
implements ThreadPoolExecutorMonitorMBean {
    public static final String TYPE = "Type";
    private ObjectName _objectName;
    private ThreadPoolExecutor _executor;
    private String _type;

    public ThreadPoolExecutorMonitor(String type, ThreadPoolExecutor executor) throws JMException {
        this._type = type;
        this._executor = executor;
        this._objectName = MBeanRegistrar.register(this, MonitorDomainNames.HelixThreadPoolExecutor.name(), TYPE, type);
    }

    public void unregister() {
        MBeanRegistrar.unregister(this._objectName);
    }

    @Override
    public String getSensorName() {
        return String.format("%s.%s", MonitorDomainNames.HelixThreadPoolExecutor.name(), this._type);
    }

    @Override
    public int getThreadPoolCoreSizeGauge() {
        return this._executor.getCorePoolSize();
    }

    @Override
    public int getThreadPoolMaxSizeGauge() {
        return this._executor.getMaximumPoolSize();
    }

    @Override
    public int getQueueSizeGauge() {
        return this._executor.getQueue().size();
    }

    @Override
    public int getNumOfActiveThreadsGauge() {
        return this._executor.getActiveCount();
    }
}

