/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.constants;

import com.google.common.collect.ImmutableSet;
import java.util.Set;

public class InstanceConstants {
    public static final String INSTANCE_NOT_DISABLED = "INSTANCE_NOT_DISABLED";
    public static final Set<InstanceOperation> ASSIGNABLE_INSTANCE_OPERATIONS = ImmutableSet.of((Object)((Object)InstanceOperation.ENABLE), (Object)((Object)InstanceOperation.DISABLE));
    public static final Set<InstanceOperation> INSTANCE_DISABLED_OVERRIDABLE_OPERATIONS = ImmutableSet.of((Object)((Object)InstanceOperation.ENABLE), (Object)((Object)InstanceOperation.EVACUATE));
    public static final Set<InstanceOperation> UNROUTABLE_INSTANCE_OPERATIONS = ImmutableSet.of((Object)((Object)InstanceOperation.SWAP_IN), (Object)((Object)InstanceOperation.UNKNOWN));

    public static enum InstanceOperation {
        ENABLE,
        DISABLE,
        EVACUATE,
        SWAP_IN,
        UNKNOWN;

    }

    public static enum InstanceOperationSource {
        ADMIN(0),
        USER(1),
        AUTOMATION(2),
        DEFAULT(3);

        private final int _priority;

        private InstanceOperationSource(int priority) {
            this._priority = priority;
        }

        public int getPriority() {
            return this._priority;
        }

        public static InstanceOperationSource instanceDisabledTypeToInstanceOperationSource(InstanceDisabledType disabledType) {
            switch (disabledType) {
                case CLOUD_EVENT: {
                    return AUTOMATION;
                }
                case USER_OPERATION: {
                    return USER;
                }
            }
            return DEFAULT;
        }
    }

    @Deprecated
    public static enum InstanceDisabledType {
        CLOUD_EVENT,
        USER_OPERATION,
        DEFAULT_INSTANCE_DISABLE_TYPE;

    }
}

