/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixManager;
import org.apache.helix.HelixProperty;
import org.apache.helix.InstanceType;
import org.apache.helix.PropertyKey;
import org.apache.helix.model.Error;
import org.apache.helix.model.Message;
import org.apache.helix.model.StatusUpdate;
import org.apache.helix.zookeeper.datamodel.ZNRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatusUpdateUtil {
    static Logger _logger = LoggerFactory.getLogger(StatusUpdateUtil.class);
    public static final boolean ERROR_LOG_TO_ZK_ENABLED = Boolean.getBoolean("helix.StateUpdateUtil.errorLog.enabled");
    Map<String, String> _recordedMessages = new ConcurrentHashMap<String, String>();

    public ZNRecord createEmptyStatusUpdateRecord(String id) {
        return new ZNRecord(id);
    }

    ZNRecord createMessageLogRecord(Message message) {
        ZNRecord result = new ZNRecord(this.getStatusUpdateRecordName(message));
        String mapFieldKey = "MESSAGE " + message.getMsgId();
        result.setMapField(mapFieldKey, new TreeMap<String, String>());
        for (String simpleFieldKey : message.getRecord().getSimpleFields().keySet()) {
            result.getMapField(mapFieldKey).put(simpleFieldKey, message.getRecord().getSimpleField(simpleFieldKey));
        }
        if (message.getResultMap() != null) {
            result.setMapField("MessageResult", message.getResultMap());
        }
        return result;
    }

    public ZNRecord createMessageStatusUpdateRecord(Message message, Level level, Class classInfo, String additionalInfo) {
        ZNRecord result = this.createEmptyStatusUpdateRecord(this.getStatusUpdateRecordName(message));
        TreeMap<String, String> contentMap = new TreeMap<String, String>();
        contentMap.put("Message state", message.getMsgState() == null ? "NULL" : message.getMsgState().toString());
        contentMap.put("AdditionalInfo", additionalInfo);
        contentMap.put("Class", classInfo.toString());
        contentMap.put("MSG_ID", message.getMsgId());
        result.setMapField(this.generateMapFieldId(level, this.getRecordIdForMessage(message)), contentMap);
        return result;
    }

    private String getRecordIdForMessage(Message message) {
        if (message.getMsgType().equals((Object)Message.MessageType.STATE_TRANSITION)) {
            return message.getPartitionName() + " Trans:" + message.getFromState().charAt(0) + "->" + message.getToState().charAt(0) + "  " + UUID.randomUUID().toString();
        }
        return message.getMsgType() + " " + UUID.randomUUID().toString();
    }

    private String generateMapFieldId(Level level, String recordId) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd-HHmmss.SSSSSS");
        String time = formatter.format(new Date());
        return String.format("%4s %26s ", level.toString(), time) + recordId;
    }

    @Deprecated
    public void logMessageStatusUpdateRecord(Message message, Level level, Class classInfo, String additionalInfo, HelixDataAccessor accessor) {
        try {
            ZNRecord record = this.createMessageStatusUpdateRecord(message, level, classInfo, additionalInfo);
            this.publishStatusUpdateRecord(record, message, level, accessor, message.getTgtName().equalsIgnoreCase(InstanceType.CONTROLLER.name()));
        }
        catch (Exception e) {
            _logger.error("Exception while logging status update", (Throwable)e);
        }
    }

    public void logMessageStatusUpdateRecord(Message message, Level level, Class classInfo, String additionalInfo, HelixManager manager) {
        try {
            ZNRecord record = this.createMessageStatusUpdateRecord(message, level, classInfo, additionalInfo);
            this.publishStatusUpdateRecord(record, message, level, manager.getHelixDataAccessor(), manager.getInstanceType().equals((Object)InstanceType.CONTROLLER) || manager.getInstanceType().equals((Object)InstanceType.CONTROLLER_PARTICIPANT));
        }
        catch (Exception e) {
            _logger.error("Exception while logging status update", (Throwable)e);
        }
    }

    public void logError(ErrorType errorType, Class classInfo, String additionalInfo, HelixManager helixManager) {
        if (helixManager != null) {
            this.logError(errorType, "ErrorInfo", helixManager.getInstanceName(), helixManager.getSessionId(), additionalInfo, classInfo, helixManager.getHelixDataAccessor(), helixManager.getInstanceType().equals((Object)InstanceType.CONTROLLER) || helixManager.getInstanceType().equals((Object)InstanceType.CONTROLLER_PARTICIPANT));
        } else {
            _logger.error("Exception while logging error. HelixManager is null.");
        }
    }

    private void logError(ErrorType errorType, String updateKey, String instanceName, String sessionId, String additionalInfo, Class classInfo, HelixDataAccessor accessor, boolean isController) {
        try {
            ZNRecord record = this.createEmptyStatusUpdateRecord(sessionId + "__" + instanceName);
            TreeMap<String, String> contentMap = new TreeMap<String, String>();
            contentMap.put("AdditionalInfo", additionalInfo);
            contentMap.put("Class", classInfo.toString());
            contentMap.put("SessionId", sessionId);
            record.setMapField(this.generateMapFieldId(Level.HELIX_ERROR, updateKey), contentMap);
            this.publishErrorRecord(record, instanceName, errorType.name(), updateKey, sessionId, accessor, isController);
        }
        catch (Exception e) {
            _logger.error("Exception while logging error", (Throwable)e);
        }
    }

    public void logError(Message message, Class classInfo, String additionalInfo, HelixManager manager) {
        this.logMessageStatusUpdateRecord(message, Level.HELIX_ERROR, classInfo, additionalInfo, manager);
    }

    public void logError(Message message, Class classInfo, Throwable e, String additionalInfo, HelixManager manager) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        this.logMessageStatusUpdateRecord(message, Level.HELIX_ERROR, classInfo, additionalInfo + sw.toString(), manager);
    }

    public void logInfo(Message message, Class classInfo, String additionalInfo, HelixManager manager) {
        this.logMessageStatusUpdateRecord(message, Level.HELIX_INFO, classInfo, additionalInfo, manager);
    }

    public void logWarning(Message message, Class classInfo, String additionalInfo, HelixManager manager) {
        this.logMessageStatusUpdateRecord(message, Level.HELIX_WARNING, classInfo, additionalInfo, manager);
    }

    @Deprecated
    public void logError(Message message, Class classInfo, String additionalInfo, HelixDataAccessor accessor) {
        this.logMessageStatusUpdateRecord(message, Level.HELIX_ERROR, classInfo, additionalInfo, accessor);
    }

    @Deprecated
    public void logError(Message message, Class classInfo, Exception e, String additionalInfo, HelixDataAccessor accessor) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        this.logMessageStatusUpdateRecord(message, Level.HELIX_ERROR, classInfo, additionalInfo + sw.toString(), accessor);
    }

    @Deprecated
    public void logInfo(Message message, Class classInfo, String additionalInfo, HelixDataAccessor accessor) {
        this.logMessageStatusUpdateRecord(message, Level.HELIX_INFO, classInfo, additionalInfo, accessor);
    }

    @Deprecated
    public void logWarning(Message message, Class classInfo, String additionalInfo, HelixDataAccessor accessor) {
        this.logMessageStatusUpdateRecord(message, Level.HELIX_WARNING, classInfo, additionalInfo, accessor);
    }

    private String getStatusUpdateKey(Message message) {
        if (message.getMsgType().equalsIgnoreCase(Message.MessageType.STATE_TRANSITION.name())) {
            return message.getPartitionName();
        }
        return message.getMsgId();
    }

    String getStatusUpdateSubPath(Message message) {
        if (message.getMsgType().equalsIgnoreCase(Message.MessageType.STATE_TRANSITION.name())) {
            return message.getResourceName();
        }
        return message.getMsgType();
    }

    String getStatusUpdateRecordName(Message message) {
        if (message.getMsgType().equalsIgnoreCase(Message.MessageType.STATE_TRANSITION.name())) {
            return message.getTgtSessionId() + "__" + message.getResourceName();
        }
        return message.getMsgId();
    }

    void publishStatusUpdateRecord(ZNRecord record, Message message, Level level, HelixDataAccessor accessor, boolean isController) {
        String instanceName = message.getTgtName();
        String statusUpdateSubPath = this.getStatusUpdateSubPath(message);
        String statusUpdateKey = this.getStatusUpdateKey(message);
        String sessionId = message.getExecutionSessionId();
        if (sessionId == null) {
            sessionId = message.getTgtSessionId();
        }
        if (sessionId == null) {
            sessionId = "*";
        }
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        if (!this._recordedMessages.containsKey(message.getMsgId())) {
            ZNRecord statusUpdateRecord = this.createMessageLogRecord(message);
            PropertyKey propertyKey = isController ? keyBuilder.controllerTaskStatus(statusUpdateSubPath, statusUpdateKey) : keyBuilder.stateTransitionStatus(instanceName, sessionId, statusUpdateSubPath, statusUpdateKey);
            accessor.updateProperty(propertyKey, new StatusUpdate(statusUpdateRecord));
            if (_logger.isTraceEnabled()) {
                _logger.trace("StatusUpdate path:" + propertyKey.getPath() + ", updates:" + statusUpdateRecord);
            }
            this._recordedMessages.put(message.getMsgId(), message.getMsgId());
        }
        PropertyKey propertyKey = isController ? keyBuilder.controllerTaskStatus(statusUpdateSubPath, statusUpdateKey) : keyBuilder.stateTransitionStatus(instanceName, sessionId, statusUpdateSubPath, statusUpdateKey);
        accessor.updateProperty(propertyKey, new StatusUpdate(record));
        if (_logger.isTraceEnabled()) {
            _logger.trace("StatusUpdate path:" + propertyKey.getPath() + ", updates:" + record);
        }
        if (Level.HELIX_ERROR == level) {
            this.publishErrorRecord(record, instanceName, statusUpdateSubPath, statusUpdateKey, sessionId, accessor, isController);
        }
    }

    void publishErrorRecord(ZNRecord record, String instanceName, String updateSubPath, String updateKey, String sessionId, HelixDataAccessor accessor, boolean isController) {
        if (!ERROR_LOG_TO_ZK_ENABLED) {
            return;
        }
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        if (isController) {
            accessor.setProperty(keyBuilder.controllerTaskError(updateSubPath), new Error(record));
        } else {
            accessor.updateProperty(keyBuilder.stateTransitionError(instanceName, sessionId, updateSubPath, updateKey), new Error(record));
        }
    }

    public static enum ErrorType {
        RebalanceResourceFailure;

    }

    public static enum Level {
        HELIX_ERROR,
        HELIX_WARNING,
        HELIX_INFO;

    }

    public static class StatusUpdateContents {
        private final List<Transition> _transitions;
        private final Map<String, TaskStatus> _taskMessages;

        private StatusUpdateContents(List<Transition> transitions, Map<String, TaskStatus> taskMessages) {
            this._transitions = transitions;
            this._taskMessages = taskMessages;
        }

        public static StatusUpdateContents getStatusUpdateContents(HelixDataAccessor accessor, String instance, String resourceGroup, String partition) {
            return StatusUpdateContents.getStatusUpdateContents(accessor, instance, resourceGroup, null, partition);
        }

        public static StatusUpdateContents getStatusUpdateContents(HelixDataAccessor accessor, String instance, String resourceGroup, String sessionID, String partition) {
            PropertyKey.Builder keyBuilder = accessor.keyBuilder();
            List<ZNRecord> instances = HelixProperty.convertToList(accessor.getChildValues(keyBuilder.instanceConfigs(), true));
            ArrayList<ZNRecord> partitionRecords = new ArrayList<ZNRecord>();
            for (ZNRecord znRecord : instances) {
                String instanceName = znRecord.getId();
                if (!instanceName.equals(instance)) continue;
                List<String> sessions = accessor.getChildNames(keyBuilder.sessions(instanceName));
                for (String session : sessions) {
                    if (sessionID != null && !session.equals(sessionID)) continue;
                    List<String> resourceGroups = accessor.getChildNames(keyBuilder.stateTransitionStatus(instanceName, session));
                    for (String resourceGroupName : resourceGroups) {
                        if (!resourceGroupName.equals(resourceGroup)) continue;
                        List<String> partitionStrings = accessor.getChildNames(keyBuilder.stateTransitionStatus(instanceName, session, resourceGroupName));
                        for (String partitionString : partitionStrings) {
                            ZNRecord partitionRecord = ((HelixProperty)accessor.getProperty(keyBuilder.stateTransitionStatus(instanceName, session, resourceGroupName, partitionString))).getRecord();
                            if (!partitionString.equals(partition)) continue;
                            partitionRecords.add(partitionRecord);
                        }
                    }
                }
            }
            return new StatusUpdateContents(StatusUpdateContents.getSortedTransitions(partitionRecords), StatusUpdateContents.getTaskMessages(partitionRecords));
        }

        public List<Transition> getTransitions() {
            return this._transitions;
        }

        public Map<String, TaskStatus> getTaskMessages() {
            return this._taskMessages;
        }

        private static List<Transition> getSortedTransitions(List<ZNRecord> partitionRecords) {
            ArrayList<Transition> transitions = new ArrayList<Transition>();
            for (ZNRecord partition : partitionRecords) {
                Map<String, Map<String, String>> mapFields = partition.getMapFields();
                for (String key : mapFields.keySet()) {
                    if (!key.startsWith("MESSAGE")) continue;
                    Map<String, String> m = mapFields.get(key);
                    long createTimeStamp = 0L;
                    try {
                        createTimeStamp = Long.parseLong(m.get("CREATE_TIMESTAMP"));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    transitions.add(new Transition(m.get("MSG_ID"), createTimeStamp, m.get("FROM_STATE"), m.get("TO_STATE")));
                }
            }
            Collections.sort(transitions);
            return transitions;
        }

        private static Map<String, TaskStatus> getTaskMessages(List<ZNRecord> partitionRecords) {
            HashMap<String, TaskStatus> taskMessages = new HashMap<String, TaskStatus>();
            for (ZNRecord partition : partitionRecords) {
                Map<String, Map<String, String>> mapFields = partition.getMapFields();
                for (String key : mapFields.keySet()) {
                    if (!key.contains("STATE_TRANSITION")) continue;
                    Map<String, String> m = mapFields.get(key);
                    String id = m.get("MSG_ID");
                    String statusString = m.get("AdditionalInfo");
                    TaskStatus status = TaskStatus.UNKNOWN;
                    if (statusString.contains("scheduled")) {
                        status = TaskStatus.SCHEDULED;
                    } else if (statusString.contains("invoking")) {
                        status = TaskStatus.INVOKING;
                    } else if (statusString.contains("completed")) {
                        status = TaskStatus.COMPLETED;
                    }
                    taskMessages.put(id, status);
                }
            }
            return taskMessages;
        }
    }

    public static enum TaskStatus {
        UNKNOWN,
        NEW,
        SCHEDULED,
        INVOKING,
        COMPLETED,
        FAILED;

    }

    public static class Transition
    implements Comparable<Transition> {
        private final String _msgID;
        private final long _timeStamp;
        private final String _from;
        private final String _to;

        public Transition(String msgID, long timeStamp, String from, String to) {
            this._msgID = msgID;
            this._timeStamp = timeStamp;
            this._from = from;
            this._to = to;
        }

        @Override
        public int compareTo(Transition t) {
            if (this._timeStamp < t._timeStamp) {
                return -1;
            }
            if (this._timeStamp > t._timeStamp) {
                return 1;
            }
            return 0;
        }

        public boolean equals(Transition t) {
            return this._timeStamp == t._timeStamp && this._from.equals(t._from) && this._to.equals(t._to);
        }

        public String getFromState() {
            return this._from;
        }

        public String getToState() {
            return this._to;
        }

        public String getMsgID() {
            return this._msgID;
        }

        public String toString() {
            return this._msgID + ":" + this._timeStamp + ":" + this._from + "->" + this._to;
        }
    }
}

