/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.rebalancer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.helix.HelixException;
import org.apache.helix.controller.dataproviders.ResourceControllerDataProvider;
import org.apache.helix.controller.rebalancer.AbstractRebalancer;
import org.apache.helix.controller.stages.CurrentStateOutput;
import org.apache.helix.model.IdealState;
import org.apache.helix.model.LiveInstance;
import org.apache.helix.model.StateModelDefinition;
import org.apache.helix.zookeeper.datamodel.ZNRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class AutoRebalancer
extends AbstractRebalancer<ResourceControllerDataProvider> {
    private static final Logger LOG = LoggerFactory.getLogger(AutoRebalancer.class);

    @Override
    public IdealState computeNewIdealState(String resourceName, IdealState currentIdealState, CurrentStateOutput currentStateOutput, ResourceControllerDataProvider clusterData) {
        IdealState cachedIdealState = this.getCachedIdealState(resourceName, clusterData);
        if (cachedIdealState != null) {
            LOG.debug("Use cached IdealState for " + resourceName);
            return cachedIdealState;
        }
        LOG.info("Computing IdealState for " + resourceName);
        List<String> partitions = this.getStablePartitionList(clusterData, currentIdealState);
        String stateModelName = currentIdealState.getStateModelDefRef();
        StateModelDefinition stateModelDef = clusterData.getStateModelDef(stateModelName);
        if (stateModelDef == null) {
            LOG.error("State Model Definition null for resource: " + resourceName);
            throw new HelixException("State Model Definition null for resource: " + resourceName);
        }
        Map<String, LiveInstance> assignableLiveInstance = clusterData.getAssignableLiveInstances();
        int replicas = currentIdealState.getReplicaCount(assignableLiveInstance.size());
        LinkedHashMap<String, Integer> stateCountMap = stateModelDef.getStateCountMap(assignableLiveInstance.size(), replicas);
        ArrayList<String> assignableLiveNodes = new ArrayList<String>(assignableLiveInstance.keySet());
        ArrayList<String> assignableNodes = new ArrayList<String>(clusterData.getAssignableInstances());
        assignableNodes.removeAll(clusterData.getDisabledInstances());
        assignableLiveNodes.retainAll(assignableNodes);
        Map<String, Map<String, String>> currentMapping = this.currentMapping(currentStateOutput, resourceName, partitions, stateCountMap);
        HashSet<String> taggedNodes = new HashSet<String>();
        HashSet<String> taggedLiveNodes = new HashSet<String>();
        if (currentIdealState.getInstanceGroupTag() != null) {
            for (String instanceName : assignableNodes) {
                if (!clusterData.getAssignableInstanceConfigMap().get(instanceName).containsTag(currentIdealState.getInstanceGroupTag())) continue;
                taggedNodes.add(instanceName);
                if (!assignableLiveInstance.containsKey(instanceName)) continue;
                taggedLiveNodes.add(instanceName);
            }
            if (!taggedLiveNodes.isEmpty()) {
                if (LOG.isInfoEnabled()) {
                    LOG.info("found the following participants with tag " + currentIdealState.getInstanceGroupTag() + " for " + resourceName + ": " + taggedLiveNodes);
                }
            } else if (taggedNodes.isEmpty()) {
                LOG.warn("Resource " + resourceName + " has tag " + currentIdealState.getInstanceGroupTag() + " but no configured participants have this tag");
            } else {
                LOG.warn("Resource " + resourceName + " has tag " + currentIdealState.getInstanceGroupTag() + " but no live participants have this tag");
            }
            assignableNodes = new ArrayList(taggedNodes);
            assignableLiveNodes = new ArrayList(taggedLiveNodes);
        }
        Collections.sort(assignableNodes);
        Collections.sort(assignableLiveNodes);
        int maxPartition = currentIdealState.getMaxPartitionsPerInstance();
        this._rebalanceStrategy = this.getRebalanceStrategy(currentIdealState.getRebalanceStrategy(), partitions, resourceName, stateCountMap, maxPartition);
        ZNRecord newMapping = this._rebalanceStrategy.computePartitionAssignment(assignableNodes, assignableLiveNodes, currentMapping, clusterData);
        LOG.debug("currentMapping: {}", currentMapping);
        LOG.debug("stateCountMap: {}", stateCountMap);
        LOG.debug("assignableLiveNodes: {}", assignableLiveNodes);
        LOG.debug("assignableNodes: {}", assignableNodes);
        LOG.debug("maxPartition: {}", (Object)maxPartition);
        LOG.debug("newMapping: {}", (Object)newMapping);
        IdealState newIdealState = new IdealState(resourceName);
        newIdealState.getRecord().setSimpleFields(currentIdealState.getRecord().getSimpleFields());
        newIdealState.setRebalanceMode(IdealState.RebalanceMode.FULL_AUTO);
        newIdealState.getRecord().setListFields(newMapping.getListFields());
        return newIdealState;
    }
}

