/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.rest.server.service;

import io.netty.util.internal.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.helix.AccessOption;
import org.apache.helix.ConfigAccessor;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.PropertyKey;
import org.apache.helix.model.ClusterConfig;
import org.apache.helix.model.InstanceConfig;
import org.apache.helix.model.LiveInstance;
import org.apache.helix.rest.server.json.cluster.ClusterInfo;
import org.apache.helix.rest.server.json.cluster.ClusterTopology;
import org.apache.helix.rest.server.service.ClusterService;

public class ClusterServiceImpl
implements ClusterService {
    private final HelixDataAccessor _dataAccessor;
    private final ConfigAccessor _configAccessor;

    public ClusterServiceImpl(HelixDataAccessor dataAccessor, ConfigAccessor configAccessor) {
        this._dataAccessor = dataAccessor;
        this._configAccessor = configAccessor;
    }

    @Override
    public ClusterTopology getClusterTopology(String cluster) {
        String zoneField = this._configAccessor.getClusterConfig(cluster).getFaultZoneType();
        PropertyKey.Builder keyBuilder = this._dataAccessor.keyBuilder();
        List instanceConfigs = this._dataAccessor.getChildValues(keyBuilder.instanceConfigs(), true);
        HashMap<String, 1> instanceMapByZone = new HashMap<String, 1>();
        if (instanceConfigs != null && !instanceConfigs.isEmpty()) {
            for (InstanceConfig instanceConfig : instanceConfigs) {
                if (!instanceConfig.getDomainAsMap().containsKey(zoneField)) continue;
                String instanceName = instanceConfig.getInstanceName();
                final ClusterTopology.Instance instance = new ClusterTopology.Instance(instanceName);
                String zoneId = (String)instanceConfig.getDomainAsMap().get(zoneField);
                if (instanceMapByZone.containsKey(zoneId)) {
                    ((List)instanceMapByZone.get(zoneId)).add(instance);
                    continue;
                }
                instanceMapByZone.put(zoneId, new ArrayList<ClusterTopology.Instance>(){
                    {
                        this.add(instance);
                    }
                });
            }
        }
        ArrayList<ClusterTopology.Zone> zones = new ArrayList<ClusterTopology.Zone>();
        for (String zoneId : instanceMapByZone.keySet()) {
            ClusterTopology.Zone zone = new ClusterTopology.Zone(zoneId);
            zone.setInstances((List)instanceMapByZone.get(zoneId));
            zones.add(zone);
        }
        return new ClusterTopology(cluster, zones, instanceConfigs.stream().map(InstanceConfig::getInstanceName).collect(Collectors.toSet()));
    }

    @Override
    public ClusterInfo getClusterInfo(String clusterId) {
        ClusterInfo.Builder builder = new ClusterInfo.Builder(clusterId);
        PropertyKey.Builder keyBuilder = this._dataAccessor.keyBuilder();
        LiveInstance controller = (LiveInstance)this._dataAccessor.getProperty(this._dataAccessor.keyBuilder().controllerLeader());
        if (controller != null) {
            builder.controller(controller.getInstanceName());
        } else {
            builder.controller("No Lead Controller");
        }
        return builder.paused(this._dataAccessor.getBaseDataAccessor().exists(keyBuilder.pause().getPath(), AccessOption.PERSISTENT)).maintenance(this._dataAccessor.getBaseDataAccessor().exists(keyBuilder.maintenance().getPath(), AccessOption.PERSISTENT)).idealStates(this._dataAccessor.getChildNames(keyBuilder.idealStates())).instances(this._dataAccessor.getChildNames(keyBuilder.instances())).liveInstances(this._dataAccessor.getChildNames(keyBuilder.liveInstances())).build();
    }

    @Override
    public boolean isClusterTopologyAware(String clusterId) {
        ClusterConfig config = this._configAccessor.getClusterConfig(clusterId);
        return config.isTopologyAwareEnabled() && !StringUtil.isNullOrEmpty((String)config.getFaultZoneType()) && !StringUtil.isNullOrEmpty((String)config.getTopology());
    }
}

