/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.collect.modbus;

import java.util.List;
import org.apache.hertzbeat.collector.collect.plc.AbstractPlcCollectImpl;
import org.apache.hertzbeat.common.entity.job.Metrics;
import org.apache.hertzbeat.common.entity.job.protocol.ModbusProtocol;
import org.apache.hertzbeat.common.entity.job.protocol.PlcProtocol;
import org.apache.hertzbeat.common.entity.message.CollectRep;
import org.apache.plc4x.java.api.PlcConnection;
import org.apache.plc4x.java.api.messages.PlcReadRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.util.StringUtils;

public class ModbusCollectImpl
extends AbstractPlcCollectImpl {
    private static final Logger log = LoggerFactory.getLogger(ModbusCollectImpl.class);

    @Override
    public void preCheck(Metrics metrics) throws IllegalArgumentException {
        ModbusProtocol modbus = metrics.getModbus();
        List registerAddressList = modbus.getRegisterAddresses();
        if (!StringUtils.hasText((String)modbus.getSlaveId())) {
            modbus.setSlaveId("1");
        }
        if (!StringUtils.hasText((String)modbus.getTimeout())) {
            modbus.setTimeout("5000");
        }
        PlcProtocol plc = metrics.getPlc() == null ? new PlcProtocol() : metrics.getPlc();
        plc.setRegisterAddresses(registerAddressList);
        BeanUtils.copyProperties((Object)modbus, (Object)plc);
        metrics.setPlc(plc);
        super.preCheck(metrics);
    }

    @Override
    public void collect(CollectRep.MetricsData.Builder builder, Metrics metrics) {
        super.collect(builder, metrics);
    }

    public String supportProtocol() {
        return "modbus";
    }

    @Override
    protected String getConnectionString(Metrics metrics) {
        ModbusProtocol plcProtocol = metrics.getModbus();
        return "modbus-tcp:tcp://" + plcProtocol.getHost() + ":" + plcProtocol.getPort() + "?unit-identifier=" + plcProtocol.getSlaveId();
    }

    @Override
    protected PlcReadRequest buildRequest(Metrics metrics, PlcConnection connection) {
        ModbusProtocol modbus = metrics.getModbus();
        List registerAddressList = modbus.getRegisterAddresses();
        PlcReadRequest.Builder requestBuilder = connection.readRequestBuilder();
        for (int i = 0; i < registerAddressList.size(); ++i) {
            String s1 = modbus.getAddressSyntax() + ":" + (String)registerAddressList.get(i);
            requestBuilder.addTagAddress(metrics.getModbus().getAddressSyntax() + ":" + i, s1);
        }
        return requestBuilder.build();
    }
}

