/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.beeline.hs2connection;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import org.apache.hive.beeline.hs2connection.BeelineHS2ConnectionFileParseException;
import org.apache.hive.beeline.hs2connection.BeelineSiteParseException;
import org.apache.hive.jdbc.Utils;

public class HS2ConnectionFileUtils {
    public static String getUrl(Properties props) throws BeelineHS2ConnectionFileParseException {
        if (props == null || props.isEmpty()) {
            return null;
        }
        String urlPrefix = (String)props.remove("url_prefix");
        if (urlPrefix == null || urlPrefix.isEmpty()) {
            throw new BeelineHS2ConnectionFileParseException("url_prefix parameter cannot be empty");
        }
        String hosts = (String)props.remove("hosts");
        if (hosts == null || hosts.isEmpty()) {
            throw new BeelineHS2ConnectionFileParseException("hosts parameter cannot be empty");
        }
        String defaultDB = (String)props.remove("defaultDB");
        if (defaultDB == null) {
            defaultDB = "default";
        }
        String hiveConfProperties = "";
        if (props.containsKey("hiveconf")) {
            hiveConfProperties = HS2ConnectionFileUtils.extractHiveVariables((String)props.remove("hiveconf"), true);
        }
        String hiveVarProperties = "";
        if (props.containsKey("hivevar")) {
            hiveVarProperties = HS2ConnectionFileUtils.extractHiveVariables((String)props.remove("hivevar"), false);
        }
        StringBuilder urlSb = new StringBuilder();
        urlSb.append(urlPrefix.trim());
        urlSb.append(hosts.trim());
        urlSb.append(File.separator);
        urlSb.append(defaultDB.trim());
        ArrayList<String> keys = new ArrayList<String>(props.stringPropertyNames());
        Collections.sort(keys);
        for (String propertyName : keys) {
            urlSb.append(";");
            urlSb.append(propertyName);
            urlSb.append("=");
            urlSb.append(props.getProperty(propertyName));
        }
        if (!hiveConfProperties.isEmpty()) {
            urlSb.append(hiveConfProperties.toString());
        }
        if (!hiveVarProperties.isEmpty()) {
            urlSb.append(hiveVarProperties.toString());
        }
        return urlSb.toString();
    }

    private static String extractHiveVariables(String propertyValue, boolean isHiveConf) throws BeelineHS2ConnectionFileParseException {
        StringBuilder hivePropertiesList = new StringBuilder();
        String delimiter = isHiveConf ? "?" : "#";
        hivePropertiesList.append(delimiter);
        HS2ConnectionFileUtils.addPropertyValues(propertyValue, hivePropertiesList);
        return hivePropertiesList.toString();
    }

    private static void addPropertyValues(String value, StringBuilder hivePropertiesList) throws BeelineHS2ConnectionFileParseException {
        String[] values = value.split(",");
        boolean first = true;
        for (String keyValuePair : values) {
            String[] keyValue = keyValuePair.split("=");
            if (keyValue.length != 2) {
                throw new BeelineHS2ConnectionFileParseException("Unable to parse " + keyValuePair + " in hs2 connection config file");
            }
            if (!first) {
                hivePropertiesList.append(";");
            }
            first = false;
            hivePropertiesList.append(keyValue[0].trim());
            hivePropertiesList.append("=");
            hivePropertiesList.append(keyValue[1].trim());
        }
    }

    public static String getNamedUrl(Properties userNamedConnectionURLs, String urlName) throws BeelineSiteParseException {
        String jdbcURL = null;
        if (urlName != null && !urlName.isEmpty()) {
            jdbcURL = userNamedConnectionURLs.getProperty(urlName);
            if (jdbcURL == null) {
                throw new BeelineSiteParseException("The named url: " + urlName + " is not specified in the connection configuration file: beeline-site.xml");
            }
            return jdbcURL;
        }
        String defaultURLName = userNamedConnectionURLs.getProperty("default");
        jdbcURL = userNamedConnectionURLs.getProperty(defaultURLName);
        if (jdbcURL != null) {
            return jdbcURL;
        }
        return null;
    }

    public static Properties mergeUserConnectionPropertiesAndBeelineSite(Properties userConnectionProperties, Utils.JdbcConnectionParams jdbcConnectionParams) throws BeelineHS2ConnectionFileParseException {
        String hiveVarProperties;
        Properties mergedConnectionProperties = new Properties();
        userConnectionProperties.setProperty("url_prefix", "jdbc:hive2://");
        String host = HS2ConnectionFileUtils.getMergedProperty(userConnectionProperties, jdbcConnectionParams.getSuppliedURLAuthority(), "hosts", null);
        if (host != null) {
            mergedConnectionProperties.setProperty("hosts", host);
        }
        String defaultDB = HS2ConnectionFileUtils.getMergedProperty(userConnectionProperties, jdbcConnectionParams.getDbName(), "defaultDB", "default");
        mergedConnectionProperties.setProperty("defaultDB", defaultDB);
        String hiveConfProperties = HS2ConnectionFileUtils.getMergedPropertiesString(userConnectionProperties, "hiveconf", jdbcConnectionParams.getHiveConfs());
        if (!hiveConfProperties.isEmpty()) {
            mergedConnectionProperties.setProperty("hiveconf", hiveConfProperties);
        }
        if (!(hiveVarProperties = HS2ConnectionFileUtils.getMergedPropertiesString(userConnectionProperties, "hivevar", jdbcConnectionParams.getHiveVars())).isEmpty()) {
            mergedConnectionProperties.setProperty("hivevar", hiveVarProperties);
        }
        for (Map.Entry entry : jdbcConnectionParams.getSessionVars().entrySet()) {
            mergedConnectionProperties.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
        if (userConnectionProperties != null) {
            for (String propName : userConnectionProperties.stringPropertyNames()) {
                mergedConnectionProperties.setProperty(propName, userConnectionProperties.getProperty(propName));
            }
        }
        return mergedConnectionProperties;
    }

    private static String getMergedProperty(Properties userConnectionProperties, String valueFromJdbcUri, String propertyKey, String defaultValue) {
        String value = null;
        if (userConnectionProperties != null) {
            value = (String)userConnectionProperties.remove(propertyKey);
        }
        if (value == null || value.isEmpty()) {
            value = valueFromJdbcUri;
        }
        if (value == null || value.isEmpty()) {
            value = defaultValue;
        }
        return value;
    }

    private static String getMergedPropertiesString(Properties userConnectionProperties, String propertyKey, Map<String, String> propertiesFromJdbcConnParams) throws BeelineHS2ConnectionFileParseException {
        Object properties = "";
        if (userConnectionProperties != null && userConnectionProperties.containsKey(propertyKey)) {
            properties = HS2ConnectionFileUtils.extractHiveVariables((String)userConnectionProperties.remove(propertyKey), true);
        }
        Object propertiesFromJdbcUri = "";
        for (Map.Entry<String, String> entry : propertiesFromJdbcConnParams.entrySet()) {
            if (((String)properties).contains(entry.getKey())) continue;
            if (!((String)propertiesFromJdbcUri).isEmpty()) {
                propertiesFromJdbcUri = (String)propertiesFromJdbcUri + ",";
            }
            propertiesFromJdbcUri = (String)propertiesFromJdbcUri + entry.getKey() + "=" + entry.getValue();
        }
        if (!((String)propertiesFromJdbcUri).isEmpty()) {
            if (!((String)properties).isEmpty()) {
                properties = (String)properties + ",";
            }
            properties = (String)properties + (String)propertiesFromJdbcUri;
        }
        return properties;
    }
}

