/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.rpc;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.channels.spi.SelectorProvider;
import org.apache.accumulo.core.util.HostAndPort;
import org.apache.hadoop.net.NetUtils;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

public class TTimeoutTransport {
    private static volatile Method GET_INPUT_STREAM_METHOD = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Method getNetUtilsInputStreamMethod() {
        if (null != GET_INPUT_STREAM_METHOD) return GET_INPUT_STREAM_METHOD;
        Class<TTimeoutTransport> clazz = TTimeoutTransport.class;
        synchronized (TTimeoutTransport.class) {
            if (null != GET_INPUT_STREAM_METHOD) return GET_INPUT_STREAM_METHOD;
            try {
                GET_INPUT_STREAM_METHOD = NetUtils.class.getMethod("getInputStream", Socket.class, Long.TYPE);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return GET_INPUT_STREAM_METHOD;
        }
    }

    private static InputStream getInputStream(Socket socket, long timeout) {
        try {
            return (InputStream)TTimeoutTransport.getNetUtilsInputStreamMethod().invoke(null, socket, timeout);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static TTransport create(HostAndPort addr, long timeoutMillis) throws IOException {
        return TTimeoutTransport.create(new InetSocketAddress(addr.getHost(), addr.getPort()), timeoutMillis);
    }

    public static TTransport create(SocketAddress addr, long timeoutMillis) throws IOException {
        Socket socket = null;
        try {
            socket = SelectorProvider.provider().openSocketChannel().socket();
            socket.setSoLinger(false, 0);
            socket.setTcpNoDelay(true);
            socket.connect(addr, (int)timeoutMillis);
            BufferedInputStream input = new BufferedInputStream(TTimeoutTransport.getInputStream(socket, timeoutMillis), 10240);
            BufferedOutputStream output = new BufferedOutputStream(NetUtils.getOutputStream((Socket)socket, (long)timeoutMillis), 10240);
            return new TIOStreamTransport((InputStream)input, (OutputStream)output);
        }
        catch (IOException e) {
            try {
                if (socket != null) {
                    socket.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw e;
        }
    }
}

