/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.auth.ldap;

import java.util.ArrayList;
import java.util.List;
import javax.security.sasl.AuthenticationException;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hive.com.google.common.collect.ImmutableList;
import org.apache.hive.service.auth.ldap.DirSearch;
import org.apache.hive.service.auth.ldap.Filter;
import org.apache.hive.service.auth.ldap.FilterFactory;

public class ChainFilterFactory
implements FilterFactory {
    private final List<FilterFactory> chainedFactories;

    public ChainFilterFactory(FilterFactory ... factories) {
        this.chainedFactories = ImmutableList.copyOf(factories);
    }

    @Override
    public Filter getInstance(HiveConf conf) {
        ArrayList<Filter> filters = new ArrayList<Filter>();
        for (FilterFactory factory : this.chainedFactories) {
            Filter filter = factory.getInstance(conf);
            if (filter == null) continue;
            filters.add(filter);
        }
        return filters.isEmpty() ? null : new ChainFilter(ImmutableList.copyOf(filters));
    }

    private static final class ChainFilter
    implements Filter {
        private final List<Filter> chainedFilters;

        public ChainFilter(List<Filter> chainedFilters) {
            this.chainedFilters = chainedFilters;
        }

        @Override
        public void apply(DirSearch client, String user) throws AuthenticationException {
            for (Filter filter : this.chainedFilters) {
                filter.apply(client, user);
            }
        }
    }
}

