/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafkaesque.clients.admin;

import java.util.Map;
import java.util.Set;
import org.apache.kafkaesque.clients.admin.KafkaAdminClient;
import org.apache.kafkaesque.common.KafkaFuture;
import org.apache.kafkaesque.common.TopicPartition;
import org.apache.kafkaesque.common.annotation.InterfaceStability;
import org.apache.kafkaesque.common.internals.KafkaFutureImpl;
import org.apache.kafkaesque.common.protocol.Errors;

@InterfaceStability.Evolving
public class DeleteConsumerGroupOffsetsResult {
    private final KafkaFuture<Map<TopicPartition, Errors>> future;
    private final Set<TopicPartition> partitions;

    DeleteConsumerGroupOffsetsResult(KafkaFuture<Map<TopicPartition, Errors>> future, Set<TopicPartition> partitions) {
        this.future = future;
        this.partitions = partitions;
    }

    public KafkaFuture<Void> partitionResult(TopicPartition partition) {
        if (!this.partitions.contains(partition)) {
            throw new IllegalArgumentException("Partition " + partition + " was not included in the original request");
        }
        KafkaFutureImpl<Void> result = new KafkaFutureImpl<Void>();
        this.future.whenComplete((topicPartitions, throwable) -> {
            if (throwable != null) {
                result.completeExceptionally((Throwable)throwable);
            } else if (!this.maybeCompleteExceptionally((Map<TopicPartition, Errors>)topicPartitions, partition, result)) {
                result.complete(null);
            }
        });
        return result;
    }

    public KafkaFuture<Void> all() {
        KafkaFutureImpl<Void> result = new KafkaFutureImpl<Void>();
        this.future.whenComplete((topicPartitions, throwable) -> {
            if (throwable != null) {
                result.completeExceptionally((Throwable)throwable);
            } else {
                for (TopicPartition partition : this.partitions) {
                    if (!this.maybeCompleteExceptionally((Map<TopicPartition, Errors>)topicPartitions, partition, result)) continue;
                    return;
                }
                result.complete(null);
            }
        });
        return result;
    }

    private boolean maybeCompleteExceptionally(Map<TopicPartition, Errors> partitionLevelErrors, TopicPartition partition, KafkaFutureImpl<Void> result) {
        Throwable exception = KafkaAdminClient.getSubLevelError(partitionLevelErrors, partition, "Offset deletion result for partition \"" + partition + "\" was not included in the response");
        if (exception != null) {
            result.completeExceptionally(exception);
            return true;
        }
        return false;
    }
}

