/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.catalog.desc;

import java.io.DataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.api.Catalog;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.ddl.DDLOperation;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.ddl.ShowUtils;
import org.apache.hadoop.hive.ql.ddl.catalog.desc.DescCatalogDesc;
import org.apache.hadoop.hive.ql.ddl.catalog.desc.DescCatalogFormatter;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public class DescCatalogOperation
extends DDLOperation<DescCatalogDesc> {
    public DescCatalogOperation(DDLOperationContext context, DescCatalogDesc desc) {
        super(context, desc);
    }

    @Override
    public int execute() throws Exception {
        try (DataOutputStream outStream = ShowUtils.getOutputStream(new Path(((DescCatalogDesc)this.desc).getResFile()), this.context);){
            Catalog catalog = this.context.getDb().getMSC().getCatalog(((DescCatalogDesc)this.desc).getCatName());
            if (catalog == null) {
                throw new HiveException(ErrorMsg.CATALOG_NOT_EXISTS, new String[]{((DescCatalogDesc)this.desc).getCatName()});
            }
            int createTime = 0;
            if (((DescCatalogDesc)this.desc).isExtended()) {
                createTime = catalog.getCreateTime();
            }
            DescCatalogFormatter formatter = DescCatalogFormatter.getFormatter(this.context.getConf());
            formatter.showCatalogDescription(outStream, catalog.getName(), catalog.getDescription(), catalog.getLocationUri(), createTime);
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e, ErrorMsg.GENERIC_ERROR);
        }
        return 0;
    }
}

