/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.dataconnector.create;

import java.util.Map;
import org.apache.hadoop.hive.metastore.api.DataConnector;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLSemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.dataconnector.create.CreateDataConnectorDesc;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;

@DDLSemanticAnalyzerFactory.DDLType(types={950})
public class CreateDataConnectorAnalyzer
extends BaseSemanticAnalyzer {
    public CreateDataConnectorAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    public void analyzeInternal(ASTNode root) throws SemanticException {
        boolean ifNotExists = false;
        String comment = null;
        String url = null;
        String type = null;
        Map<String, String> props = null;
        String connectorName = CreateDataConnectorAnalyzer.unescapeIdentifier(root.getChild(0).getText());
        block7: for (int i = 1; i < root.getChildCount(); ++i) {
            ASTNode childNode = (ASTNode)root.getChild(i);
            switch (childNode.getToken().getType()) {
                case 1051: {
                    ifNotExists = true;
                    continue block7;
                }
                case 971: {
                    comment = CreateDataConnectorAnalyzer.unescapeSQLString(childNode.getChild(0).getText());
                    continue block7;
                }
                case 973: {
                    props = CreateDataConnectorAnalyzer.getProps((ASTNode)childNode.getChild(0));
                    continue block7;
                }
                case 975: {
                    url = CreateDataConnectorAnalyzer.unescapeSQLString(childNode.getChild(0).getText());
                    continue block7;
                }
                case 974: {
                    type = CreateDataConnectorAnalyzer.unescapeSQLString(childNode.getChild(0).getText());
                    continue block7;
                }
                default: {
                    throw new SemanticException("Unrecognized token in CREATE CONNECTOR statement");
                }
            }
        }
        CreateDataConnectorDesc desc = null;
        DataConnector connector = new DataConnector(connectorName, type, url);
        if (comment != null) {
            connector.setDescription(comment);
        }
        if (props != null) {
            connector.setParameters(props);
        }
        desc = new CreateDataConnectorDesc(connectorName, type, url, ifNotExists, comment, props);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), desc)));
        this.outputs.add(new WriteEntity(connector, WriteEntity.WriteType.DDL_NO_LOCK));
    }
}

