/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.dataconnector.show;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.ddl.ShowUtils;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.formatting.MapBuilder;
import org.apache.hadoop.hive.ql.metadata.formatting.MetaDataFormatUtils;

abstract class ShowDataConnectorsFormatter {
    ShowDataConnectorsFormatter() {
    }

    static ShowDataConnectorsFormatter getFormatter(HiveConf conf) {
        if (MetaDataFormatUtils.isJson(conf)) {
            return new JsonShowDataConnectorsFormatter();
        }
        return new TextShowDataConnectorsFormatter();
    }

    abstract void showDataConnectors(DataOutputStream var1, List<String> var2) throws HiveException;

    static class JsonShowDataConnectorsFormatter
    extends ShowDataConnectorsFormatter {
        JsonShowDataConnectorsFormatter() {
        }

        @Override
        void showDataConnectors(DataOutputStream out, List<String> connectors) throws HiveException {
            ShowUtils.asJson(out, MapBuilder.create().put("connectors", connectors).build());
        }
    }

    static class TextShowDataConnectorsFormatter
    extends ShowDataConnectorsFormatter {
        TextShowDataConnectorsFormatter() {
        }

        @Override
        void showDataConnectors(DataOutputStream out, List<String> connectors) throws HiveException {
            try {
                for (String connector : connectors) {
                    out.write(connector.getBytes(StandardCharsets.UTF_8));
                    out.write(10);
                }
            }
            catch (IOException e) {
                throw new HiveException((Throwable)e);
            }
        }
    }
}

