/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;

public enum AlterTableType {
    ADDCOLS("add columns"),
    DROP_COLUMN("drop column"),
    REPLACE_COLUMNS("replace columns"),
    RENAME_COLUMN("rename column"),
    UPDATE_COLUMNS("update columns"),
    ADDPARTITION("add partition"),
    DROPPARTITION("drop partition"),
    RENAMEPARTITION("rename partition"),
    ALTERPARTITION("alter partition"),
    SETPARTITIONSPEC("set partition spec"),
    EXECUTE("execute"),
    CREATE_BRANCH("create branch"),
    DROP_BRANCH("drop branch"),
    RENAME_BRANCH("rename branch"),
    CREATE_TAG("create tag"),
    DROP_TAG("drop tag"),
    REPLACE_SNAPSHOTREF("replace branch/tag"),
    ADD_CONSTRAINT("add constraint"),
    DROP_CONSTRAINT("drop constraint"),
    SET_SERDE("set serde"),
    SET_SERDE_PROPS("set serde props"),
    SET_FILE_FORMAT("add fileformat"),
    CLUSTERED_BY("clustered by"),
    NOT_SORTED("not sorted"),
    NOT_CLUSTERED("not clustered"),
    ALTERLOCATION("set location"),
    SKEWED_BY("skewed by"),
    NOT_SKEWED("not skewed"),
    SET_SKEWED_LOCATION("alter skew location"),
    INTO_BUCKETS("alter bucket number"),
    ADDPROPS("set properties"),
    DROPPROPS("unset properties"),
    TOUCH("touch"),
    RENAME("rename"),
    OWNER("set owner"),
    ARCHIVE("archive"),
    UNARCHIVE("unarchive"),
    COMPACT("compact"),
    TRUNCATE("truncate"),
    MERGEFILES("merge files"),
    UPDATESTATS("update stats");

    private final String name;
    public static final List<AlterTableType> NON_NATIVE_TABLE_ALLOWED;
    public static final Set<AlterTableType> SUPPORT_PARTIAL_PARTITION_SPEC;

    private AlterTableType(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    static {
        NON_NATIVE_TABLE_ALLOWED = ImmutableList.of((Object)((Object)ADDPROPS), (Object)((Object)DROPPROPS), (Object)((Object)ADDCOLS), (Object)((Object)EXECUTE));
        SUPPORT_PARTIAL_PARTITION_SPEC = ImmutableSet.of((Object)((Object)ADDCOLS), (Object)((Object)DROP_COLUMN), (Object)((Object)REPLACE_COLUMNS), (Object)((Object)RENAME_COLUMN), (Object)((Object)ADDPROPS), (Object)((Object)DROPPROPS), (Object[])new AlterTableType[]{SET_SERDE, SET_SERDE_PROPS, SET_FILE_FORMAT});
    }
}

