/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.drop;

import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.llap.LlapHiveUtils;
import org.apache.hadoop.hive.llap.ProactiveEviction;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.ql.ddl.DDLOperation;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.ddl.DDLUtils;
import org.apache.hadoop.hive.ql.ddl.table.drop.DropTableDesc;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.InvalidTableException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.PartitionIterable;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.HiveTableName;
import org.apache.hadoop.hive.ql.parse.ReplicationSpec;

public class DropTableOperation
extends DDLOperation<DropTableDesc> {
    public DropTableOperation(DDLOperationContext context, DropTableDesc desc) {
        super(context, desc);
    }

    @Override
    public int execute() throws HiveException {
        Map dbParams;
        Table table = this.getTable();
        if (table == null) {
            return 0;
        }
        if (((DropTableDesc)this.desc).getValidationRequired() && (table.isView() || table.isMaterializedView())) {
            if (((DropTableDesc)this.desc).isIfExists()) {
                return 0;
            }
            if (table.isView()) {
                throw new HiveException("Cannot drop a view with DROP TABLE");
            }
            throw new HiveException("Cannot drop a materialized view with DROP TABLE");
        }
        ReplicationSpec replicationSpec = ((DropTableDesc)this.desc).getReplicationSpec();
        if (replicationSpec.isInReplicationScope() && !replicationSpec.allowEventReplacementInto(dbParams = this.context.getDb().getDatabase(table.getDbName()).getParameters())) {
            if (table.isPartitioned()) {
                PartitionIterable partitions = new PartitionIterable(this.context.getDb(), table, null, MetastoreConf.getIntVar((Configuration)this.context.getConf(), (MetastoreConf.ConfVars)MetastoreConf.ConfVars.BATCH_RETRIEVE_MAX));
                for (Partition p : partitions) {
                    if (!replicationSpec.allowEventReplacementInto(dbParams)) continue;
                    this.context.getDb().dropPartition(table.getDbName(), table.getTableName(), p.getValues(), true);
                }
            }
            LOG.debug("DDLTask: Drop Table is skipped as table {} is newer than update", (Object)((DropTableDesc)this.desc).getTableName());
            return 0;
        }
        this.context.getDb().dropTable(table, ((DropTableDesc)this.desc).isPurge());
        DDLUtils.addIfAbsentByName(new WriteEntity(table, WriteEntity.WriteType.DDL_NO_LOCK), this.context);
        if (LlapHiveUtils.isLlapMode((Configuration)this.context.getConf())) {
            TableName tableName = HiveTableName.of(table);
            ProactiveEviction.Request.Builder llapEvictRequestBuilder = ProactiveEviction.Request.Builder.create();
            llapEvictRequestBuilder.addTable(tableName.getDb(), tableName.getTable());
            ProactiveEviction.evict((Configuration)this.context.getConf(), llapEvictRequestBuilder.build());
        }
        return 0;
    }

    private Table getTable() throws HiveException {
        try {
            return this.context.getDb().getTable(((DropTableDesc)this.desc).getTableName());
        }
        catch (InvalidTableException e) {
            return null;
        }
    }
}

