/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.info.show.tables;

import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.ql.ddl.DDLDesc;
import org.apache.hadoop.hive.ql.plan.Explain;

@Explain(displayName="Show Tables", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
public class ShowTablesDesc
implements DDLDesc,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String TABLES_VIEWS_SCHEMA = "tab_name#string";
    private static final String EXTENDED_TABLES_SCHEMA = "tab_name,table_type#string,string";
    private final String resFile;
    private final String dbName;
    private final String pattern;
    private final TableType typeFilter;
    private final boolean isExtended;

    public ShowTablesDesc(Path resFile, String dbName, String pattern, TableType typeFilter, boolean isExtended) {
        this.resFile = resFile.toString();
        this.dbName = dbName;
        this.pattern = pattern;
        this.typeFilter = typeFilter;
        this.isExtended = isExtended;
    }

    @Explain(displayName="pattern")
    public String getPattern() {
        return this.pattern;
    }

    @Explain(displayName="result file", explainLevels={Explain.Level.EXTENDED})
    public String getResFile() {
        return this.resFile;
    }

    @Explain(displayName="database name", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public String getDbName() {
        return this.dbName;
    }

    @Explain(displayName="extended", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED}, displayOnlyOnTrue=true)
    public boolean isExtended() {
        return this.isExtended;
    }

    @Explain(displayName="table type filter", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public String getTypeFilterString() {
        return this.typeFilter.name();
    }

    public TableType getTypeFilter() {
        return this.typeFilter;
    }

    public String getSchema() {
        return this.isExtended ? EXTENDED_TABLES_SCHEMA : TABLES_VIEWS_SCHEMA;
    }
}

