/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.storage.set.fileformat;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.ddl.table.AbstractAlterTableOperation;
import org.apache.hadoop.hive.ql.ddl.table.AlterTableUtils;
import org.apache.hadoop.hive.ql.ddl.table.storage.set.fileformat.AlterTableSetFileFormatDesc;
import org.apache.hadoop.hive.ql.io.orc.OrcInputFormat;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;

public class AlterTableSetFileFormatOperation
extends AbstractAlterTableOperation<AlterTableSetFileFormatDesc> {
    public AlterTableSetFileFormatOperation(DDLOperationContext context, AlterTableSetFileFormatDesc desc) {
        super(context, desc);
    }

    @Override
    protected void doAlteration(Table table, Partition partition) throws HiveException {
        StorageDescriptor sd = this.getStorageDescriptor(table, partition);
        if (AlterTableUtils.isSchemaEvolutionEnabled(table, (Configuration)this.context.getConf()) && sd.getInputFormat().equals(OrcInputFormat.class.getName()) && !((AlterTableSetFileFormatDesc)this.desc).getInputFormat().equals(OrcInputFormat.class.getName())) {
            throw new HiveException(ErrorMsg.CANNOT_CHANGE_FILEFORMAT, new String[]{"ORC", ((AlterTableSetFileFormatDesc)this.desc).getDbTableName()});
        }
        sd.setInputFormat(((AlterTableSetFileFormatDesc)this.desc).getInputFormat());
        sd.setOutputFormat(((AlterTableSetFileFormatDesc)this.desc).getOutputFormat());
        if (((AlterTableSetFileFormatDesc)this.desc).getSerdeName() != null) {
            sd.getSerdeInfo().setSerializationLib(((AlterTableSetFileFormatDesc)this.desc).getSerdeName());
        }
    }
}

