/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.view.materialized.alter.rewrite;

import org.apache.calcite.rel.RelNode;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.api.EnvironmentContext;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLOperation;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.ddl.view.materialized.alter.rewrite.AlterMaterializedViewRewriteDesc;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.MaterializationValidationResult;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.CalcitePlanner;
import org.apache.hadoop.hive.ql.parse.ParseUtils;
import org.apache.hadoop.hive.ql.processors.CompileProcessor;

public class AlterMaterializedViewRewriteOperation
extends DDLOperation<AlterMaterializedViewRewriteDesc> {
    public AlterMaterializedViewRewriteOperation(DDLOperationContext context, AlterMaterializedViewRewriteDesc desc) {
        super(context, desc);
    }

    @Override
    public int execute() throws HiveException {
        Table mv = this.context.getDb().getTable(((AlterMaterializedViewRewriteDesc)this.desc).getMaterializedViewName());
        if (mv.isRewriteEnabled() == ((AlterMaterializedViewRewriteDesc)this.desc).isRewriteEnable()) {
            return 0;
        }
        Table newMV = mv.copy();
        if (((AlterMaterializedViewRewriteDesc)this.desc).isRewriteEnable()) {
            try {
                QueryState qs = new QueryState.Builder().withHiveConf(this.context.getConf()).build();
                CalcitePlanner planner = new CalcitePlanner(qs);
                Context ctx = new Context((Configuration)this.context.getConf());
                ctx.setIsLoadingMaterializedView(true);
                planner.initCtx(ctx);
                planner.init(false);
                RelNode plan = planner.genLogicalPlan(ParseUtils.parse(newMV.getViewExpandedText(), ctx));
                if (plan == null) {
                    Object msg = "Cannot enable automatic rewriting for materialized view.";
                    if (ctx.getCboInfo() != null) {
                        msg = (String)msg + " " + ctx.getCboInfo();
                    }
                    throw new HiveException((String)msg);
                }
                MaterializationValidationResult validationResult = planner.getMaterializationValidationResult();
                String validationErrorMessage = validationResult.getErrorMessage();
                if (validationResult.getSupportedRewriteAlgorithms().isEmpty()) {
                    throw new HiveException(validationErrorMessage);
                }
                if (StringUtils.isNotBlank((CharSequence)validationErrorMessage)) {
                    CompileProcessor.console.printError(validationErrorMessage);
                }
            }
            catch (Exception e) {
                throw new HiveException((Throwable)e);
            }
        }
        newMV.setRewriteEnabled(((AlterMaterializedViewRewriteDesc)this.desc).isRewriteEnable());
        EnvironmentContext environmentContext = new EnvironmentContext();
        environmentContext.putToProperties("DO_NOT_UPDATE_STATS", "true");
        this.context.getDb().alterTable(newMV, false, environmentContext, true);
        return 0;
    }
}

