/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.QueryPlan;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.TaskQueue;
import org.apache.hadoop.hive.ql.exec.FetchOperator;
import org.apache.hadoop.hive.ql.exec.ListSinkOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.mr.ExecMapper;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.io.HiveInputFormat;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.VirtualColumn;
import org.apache.hadoop.hive.ql.plan.FetchWork;
import org.apache.hadoop.hive.ql.plan.FileSinkDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hadoop.hive.ql.plan.api.StageType;
import org.apache.hadoop.hive.serde2.ColumnProjectionUtils;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FetchTask
extends Task<FetchWork>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int maxRows = 100;
    private FetchOperator fetch;
    private ListSinkOperator sink;
    private List fetchedData;
    private int currentRow;
    private int totalRows;
    private static final Logger LOG = LoggerFactory.getLogger(FetchTask.class);
    JobConf job = null;
    private boolean cachingEnabled = false;

    public void setValidWriteIdList(String writeIdStr) {
        this.fetch.setValidWriteIdList(writeIdStr);
    }

    @Override
    public void initialize(QueryState queryState, QueryPlan queryPlan, TaskQueue taskQueue, Context context) {
        super.initialize(queryState, queryPlan, taskQueue, context);
        ((FetchWork)this.work).initializeForFetch(context.getOpContext());
        this.fetchedData = new ArrayList();
        try {
            this.job = new JobConf((Configuration)this.conf);
            this.initFetch();
        }
        catch (Exception e) {
            LOG.error("Initialize failed", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private List<VirtualColumn> getVirtualColumns(Operator<?> ts) {
        if (ts instanceof TableScanOperator && ts.getConf() != null) {
            return ((TableScanDesc)((TableScanOperator)ts).getConf()).getVirtualCols();
        }
        return null;
    }

    @Override
    public int execute() {
        if (this.cachingEnabled) {
            this.executeInner(this.fetchedData);
        }
        return 0;
    }

    public TableDesc getTblDesc() {
        return ((FetchWork)this.work).getTblDesc();
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    public boolean fetch(List res) {
        if (this.cachingEnabled) {
            if (this.currentRow >= this.fetchedData.size()) {
                return false;
            }
            int toIndex = Math.min(this.fetchedData.size(), this.currentRow + this.maxRows);
            res.addAll(this.fetchedData.subList(this.currentRow, toIndex));
            this.currentRow = toIndex;
            return true;
        }
        return this.executeInner(res);
    }

    public boolean isFetchFrom(FileSinkDesc fs) {
        return fs.getFinalDirName().equals((Object)((FetchWork)this.work).getTblDir());
    }

    @Override
    public StageType getType() {
        return StageType.FETCH;
    }

    public String getName() {
        return "FETCH";
    }

    public void clearFetch() throws HiveException {
        if (this.fetch != null) {
            this.fetch.clearFetchContext();
        }
        this.fetchedData.clear();
    }

    public void resetFetch() throws HiveException {
        if (this.cachingEnabled) {
            this.currentRow = 0;
        } else {
            this.clearFetch();
            this.initFetch();
        }
    }

    @Override
    public boolean canExecuteInParallel() {
        return false;
    }

    private boolean executeInner(List target) {
        int rowsRet;
        this.sink.reset(target);
        if (this.cachingEnabled) {
            rowsRet = ((FetchWork)this.work).getLimit() >= 0 ? ((FetchWork)this.work).getLimit() : Integer.MAX_VALUE;
        } else {
            rowsRet = ((FetchWork)this.work).getLeastNumRows();
            if (rowsRet <= 0) {
                rowsRet = ((FetchWork)this.work).getLimit() >= 0 ? Math.min(((FetchWork)this.work).getLimit() - this.totalRows, this.maxRows) : this.maxRows;
            }
        }
        try {
            if (rowsRet <= 0 || ((FetchWork)this.work).getLimit() == this.totalRows) {
                this.fetch.clearFetchContext();
                boolean bl = false;
                return bl;
            }
            boolean fetched = false;
            while (this.sink.getNumRows() < rowsRet) {
                if (!this.fetch.pushRow()) {
                    if (((FetchWork)this.work).getLeastNumRows() > 0) {
                        throw new HiveException("leastNumRows check failed");
                    }
                    this.fetch.closeOperator();
                    boolean bl = fetched;
                    return bl;
                }
                fetched = true;
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            this.console.printError("Failed with exception " + e.getClass().getName() + ":" + e.getMessage(), "\n" + StringUtils.stringifyException((Throwable)e));
            throw new RuntimeException(e);
        }
        finally {
            this.totalRows += this.sink.getNumRows();
        }
    }

    private void initFetch() throws HiveException {
        Operator<?> source = ((FetchWork)this.work).getSource();
        if (source instanceof TableScanOperator) {
            TableScanOperator ts = (TableScanOperator)source;
            ColumnProjectionUtils.appendReadColumns((Configuration)this.job, ts.getNeededColumnIDs(), ts.getNeededColumns(), ts.getNeededNestedColumnPaths(), (boolean)((TableScanDesc)ts.getConf()).hasVirtualCols());
            HiveInputFormat.pushFiltersAndAsOf(this.job, ts, null);
            AcidUtils.setAcidOperationalProperties((Configuration)this.job, ((TableScanDesc)ts.getConf()).isTranscationalTable(), ((TableScanDesc)ts.getConf()).getAcidOperationalProperties());
        }
        this.sink = ((FetchWork)this.work).getSink();
        this.fetch = new FetchOperator((FetchWork)this.work, this.job, source, this.getVirtualColumns(source));
        source.initialize((Configuration)this.conf, new ObjectInspector[]{this.fetch.getOutputObjectInspector()});
        this.totalRows = 0;
        ExecMapper.setDone(false);
    }

    public void setCachingEnabled(boolean cachingEnabled) {
        this.cachingEnabled = cachingEnabled;
    }

    public boolean isCachingEnabled() {
        return this.cachingEnabled;
    }

    public int getNumRows() {
        return this.totalRows;
    }
}

