/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.hive.common.BlobStorageUtils;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.common.HiveStatsUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.ddl.DDLUtils;
import org.apache.hadoop.hive.ql.ddl.table.create.CreateTableDesc;
import org.apache.hadoop.hive.ql.ddl.view.create.CreateMaterializedViewDesc;
import org.apache.hadoop.hive.ql.exec.StatsTask;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.mr.MapRedTask;
import org.apache.hadoop.hive.ql.exec.mr.MapredLocalTask;
import org.apache.hadoop.hive.ql.exec.repl.util.ReplUtils;
import org.apache.hadoop.hive.ql.hooks.LineageInfo;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.io.HiveFileFormatUtils;
import org.apache.hadoop.hive.ql.io.merge.MergeFileTask;
import org.apache.hadoop.hive.ql.lockmgr.HiveLock;
import org.apache.hadoop.hive.ql.lockmgr.HiveLockManager;
import org.apache.hadoop.hive.ql.lockmgr.HiveLockMode;
import org.apache.hadoop.hive.ql.lockmgr.HiveLockObj;
import org.apache.hadoop.hive.ql.lockmgr.HiveLockObject;
import org.apache.hadoop.hive.ql.lockmgr.LockException;
import org.apache.hadoop.hive.ql.log.PerfLogger;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveStorageHandler;
import org.apache.hadoop.hive.ql.metadata.HiveUtils;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.physical.BucketingSortingCtx;
import org.apache.hadoop.hive.ql.parse.ExplainConfiguration;
import org.apache.hadoop.hive.ql.plan.DynamicPartitionCtx;
import org.apache.hadoop.hive.ql.plan.LoadFileDesc;
import org.apache.hadoop.hive.ql.plan.LoadMultiFilesDesc;
import org.apache.hadoop.hive.ql.plan.LoadTableDesc;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.MapredWork;
import org.apache.hadoop.hive.ql.plan.MoveWork;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.api.StageType;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.util.DirectionUtils;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoveTask
extends Task<MoveWork>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(MoveTask.class);
    private final PerfLogger perfLogger = SessionState.getPerfLogger();

    private boolean moveFilesUsingManifestFile(FileSystem fs, Path sourcePath, Path targetPath) throws HiveException, IOException {
        if (((MoveWork)this.work).isCTAS() && BlobStorageUtils.isBlobStorageFileSystem((Configuration)this.conf, (FileSystem)fs) && fs.exists(new Path(sourcePath, "_blob_manifest_file"))) {
            ArrayList<String> filesKept;
            LOG.debug("Attempting to copy using the paths available in {}", (Object)new Path(sourcePath, "_blob_manifest_file"));
            try (FSDataInputStream inStream = fs.open(new Path(sourcePath, "_blob_manifest_file"));){
                String paths = IOUtils.toString((InputStream)inStream, (Charset)Charset.defaultCharset());
                filesKept = new ArrayList<String>(Arrays.asList(paths.split(System.lineSeparator())));
            }
            Path srcPath = new Path(filesKept.remove(0));
            LOG.info("Copying files {} from {} to {}", new Object[]{filesKept, srcPath, targetPath});
            Utilities.moveSpecifiedFilesInParallel((Configuration)this.conf, fs, srcPath, targetPath, new HashSet<String>(filesKept));
            return true;
        }
        return false;
    }

    public void flattenUnionSubdirectories(Path sourcePath) throws HiveException {
        try {
            FileSystem fs = sourcePath.getFileSystem((Configuration)this.conf);
            LOG.info("Checking {} for subdirectories to flatten", (Object)sourcePath);
            HashSet<Path> unionSubdirs = new HashSet<Path>();
            if (fs.exists(sourcePath)) {
                RemoteIterator i = fs.listFiles(sourcePath, true);
                String prefix = "HIVE_UNION_SUBDIR_";
                while (i.hasNext()) {
                    Path path = ((LocatedFileStatus)i.next()).getPath();
                    Path parent = path.getParent();
                    if (!parent.getName().startsWith(prefix)) continue;
                    String parentOfParent = parent.getParent().toString();
                    String parentNameSuffix = parent.getName().substring(prefix.length());
                    fs.rename(path, new Path(parentOfParent + "/" + parentNameSuffix + "_" + path.getName()));
                    unionSubdirs.add(parent);
                }
                for (Path path : unionSubdirs) {
                    LOG.info("This subdirectory has been flattened: " + path.toString());
                    fs.delete(path, true);
                }
            }
        }
        catch (Exception e) {
            throw new HiveException("Unable to flatten " + sourcePath, (Throwable)e);
        }
    }

    private void moveFile(Path sourcePath, Path targetPath, boolean isDfsDir) throws HiveException {
        try {
            this.perfLogger.perfLogBegin("MoveTask", "FileMoves");
            String mesg = "Moving data to " + (isDfsDir ? "" : "local ") + "directory " + targetPath.toString();
            String mesg_detail = " from " + sourcePath.toString();
            this.console.printInfo(mesg, mesg_detail);
            FileSystem fs = sourcePath.getFileSystem((Configuration)this.conf);
            if (this.moveFilesUsingManifestFile(fs, sourcePath, targetPath)) {
                this.perfLogger.perfLogEnd("MoveTask", "FileMoves");
                return;
            }
            if (isDfsDir) {
                this.moveFileInDfs(sourcePath, targetPath, this.conf);
            } else {
                LocalFileSystem dstFs = FileSystem.getLocal((Configuration)this.conf);
                this.moveFileFromDfsToLocal(sourcePath, targetPath, fs, (FileSystem)dstFs);
            }
            this.perfLogger.perfLogEnd("MoveTask", "FileMoves");
        }
        catch (Exception e) {
            throw new HiveException("Unable to move source " + sourcePath + " to destination " + targetPath, (Throwable)e);
        }
    }

    private void moveFileInDfs(Path sourcePath, Path targetPath, HiveConf conf) throws HiveException, IOException {
        FileSystem srcFs;
        FileSystem tgtFs;
        try {
            tgtFs = targetPath.getFileSystem((Configuration)conf);
        }
        catch (IOException e) {
            LOG.error("Failed to get dest fs", (Throwable)e);
            throw new HiveException(e.getMessage(), (Throwable)e);
        }
        try {
            srcFs = sourcePath.getFileSystem((Configuration)conf);
        }
        catch (IOException e) {
            LOG.error("Failed to get src fs", (Throwable)e);
            throw new HiveException(e.getMessage(), (Throwable)e);
        }
        if (srcFs.exists(sourcePath)) {
            Path deletePath = null;
            if (HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_INSERT_INTO_MULTILEVEL_DIRS)) {
                deletePath = this.createTargetPath(targetPath, tgtFs);
            }
            if (((MoveWork)this.work).isNeedCleanTarget()) {
                Hive.clearDestForSubDirSrc(conf, targetPath, sourcePath, false);
            }
            if (!Hive.moveFile(conf, sourcePath, targetPath, true, false, false)) {
                try {
                    if (deletePath != null) {
                        tgtFs.delete(deletePath, true);
                    }
                }
                catch (IOException e) {
                    LOG.info("Unable to delete the path created for facilitating rename: {}", (Object)deletePath);
                }
                throw new HiveException("Unable to rename: " + sourcePath + " to: " + targetPath);
            }
        } else if (!tgtFs.mkdirs(targetPath)) {
            throw new HiveException("Unable to make directory: " + targetPath);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void moveFileFromDfsToLocal(Path sourcePath, Path targetPath, FileSystem fs, FileSystem dstFs) throws HiveException, IOException {
        if (dstFs.exists(targetPath)) {
            FileStatus[] destFiles;
            if (!dstFs.isDirectory(targetPath)) throw new HiveException("Target " + targetPath + " is not a local directory.");
            for (FileStatus destFile : destFiles = dstFs.listStatus(targetPath)) {
                if (dstFs.delete(destFile.getPath(), true)) continue;
                throw new IOException("Unable to clean the destination directory: " + targetPath);
            }
        } else if (!FileUtils.mkdir((FileSystem)dstFs, (Path)targetPath, (Configuration)this.conf)) {
            throw new HiveException("Failed to create local target directory " + targetPath);
        }
        if (!fs.exists(sourcePath)) return;
        FileStatus[] srcs = fs.listStatus(sourcePath, FileUtils.HIDDEN_FILES_PATH_FILTER);
        for (FileStatus status : srcs) {
            fs.copyToLocalFile(status.getPath(), targetPath);
        }
    }

    private Path createTargetPath(Path targetPath, FileSystem fs) throws IOException {
        Path deletePath = null;
        Path mkDirPath = targetPath.getParent();
        if (mkDirPath != null && !fs.exists(mkDirPath)) {
            for (Path actualPath = mkDirPath; actualPath != null && !fs.exists(actualPath); actualPath = actualPath.getParent()) {
                deletePath = actualPath;
            }
            fs.mkdirs(mkDirPath);
        }
        return deletePath;
    }

    private void releaseLocks(LoadTableDesc ltd) throws HiveException {
        if (!this.conf.getBoolVar(HiveConf.ConfVars.HIVE_SUPPORT_CONCURRENCY)) {
            LOG.debug("No locks to release because Hive concurrency support is not enabled");
            return;
        }
        if (this.context.getHiveTxnManager().supportsAcid()) {
            return;
        }
        HiveLockManager lockMgr = this.context.getHiveTxnManager().getLockManager();
        WriteEntity output = this.context.getLoadTableOutputMap().get(ltd);
        List<HiveLockObj> lockObjects = this.context.getOutputLockObjects().get(output);
        if (CollectionUtils.isEmpty(lockObjects)) {
            LOG.debug("No locks found to release");
            return;
        }
        LOG.info("Releasing {} locks", (Object)lockObjects.size());
        for (HiveLockObj lockObj : lockObjects) {
            List<HiveLock> locks = lockMgr.getLocks(lockObj.getObj(), false, true);
            for (HiveLock lock : locks) {
                if (lock.getHiveLockMode() != lockObj.getMode() || !this.context.getHiveLocks().remove(lock)) continue;
                try {
                    lockMgr.unlock(lock);
                }
                catch (LockException le) {
                    LOG.warn("Could not release lock {}", (Object)lock.getHiveLockObject().getName(), (Object)le);
                }
            }
        }
    }

    public boolean hasFollowingStatsTask() {
        if (this.getNumChild() == 1) {
            return this.getChildTasks().get(0) instanceof StatsTask;
        }
        return false;
    }

    private boolean resetStatisticsProps(Table table) {
        if (this.hasFollowingStatsTask()) {
            return false;
        }
        return !((MoveWork)this.work).getIsInReplicationScope();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int execute() {
        try {
            this.initializeFromDeferredContext();
        }
        catch (HiveException he) {
            return this.processHiveException(he);
        }
        boolean shouldFlattenUnionSubdirectories = HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_TEZ_UNION_FLATTEN_SUBDIRECTORIES);
        if (Utilities.FILE_OP_LOGGER.isTraceEnabled()) {
            Utilities.FILE_OP_LOGGER.trace("Executing MoveWork " + System.identityHashCode(this.work) + " with " + ((MoveWork)this.work).getLoadFileWork() + "; " + ((MoveWork)this.work).getLoadTableWork() + "; " + ((MoveWork)this.work).getLoadMultiFilesWork());
        }
        if (this.context.getExplainAnalyze() == ExplainConfiguration.AnalyzeState.RUNNING) {
            return 0;
        }
        try (LocalTableLock lock = this.acquireLockForFileMove(((MoveWork)this.work).getLoadTableWork());){
            LoadTableDesc tbd;
            LoadMultiFilesDesc lmfd;
            if (this.checkAndCommitNatively((MoveWork)this.work, (Configuration)this.conf)) {
                int n2 = 0;
                return n2;
            }
            Hive db = this.getHive();
            LoadFileDesc lfd = ((MoveWork)this.work).getLoadFileWork();
            if (lfd != null) {
                Path sourcePath;
                Path targetPath = lfd.getTargetDir();
                if (targetPath.equals((Object)(sourcePath = lfd.getSourcePath()))) {
                    Utilities.FILE_OP_LOGGER.debug("MoveTask not moving " + sourcePath);
                } else {
                    Utilities.FILE_OP_LOGGER.debug("MoveTask moving " + sourcePath + " to " + targetPath);
                    if (shouldFlattenUnionSubdirectories) {
                        this.flattenUnionSubdirectories(sourcePath);
                    }
                    if (lfd.getWriteType() == AcidUtils.Operation.INSERT) {
                        assert (lfd.getIsDfsDir());
                        FileSystem srcFs = sourcePath.getFileSystem((Configuration)this.conf);
                        FileStatus[] srcs = srcFs.globStatus(sourcePath);
                        if (srcs != null) {
                            Hive.moveAcidFiles(srcFs, srcs, targetPath, null, this.conf);
                        } else {
                            LOG.debug("No files found to move from " + sourcePath + " to " + targetPath);
                        }
                    } else {
                        FileSystem targetFs;
                        if (lfd.getIsDfsDir() && !(targetFs = targetPath.getFileSystem((Configuration)this.conf)).exists(targetPath.getParent())) {
                            targetFs.mkdirs(targetPath.getParent());
                        }
                        this.moveFile(sourcePath, targetPath, lfd.getIsDfsDir());
                    }
                }
            }
            if ((lmfd = ((MoveWork)this.work).getLoadMultiFilesWork()) != null) {
                boolean isDfsDir = lmfd.getIsDfsDir();
                List<String> targetPrefixes = lmfd.getTargetPrefixes();
                for (int i = 0; i < lmfd.getSourceDirs().size(); ++i) {
                    FileSystem srcFs;
                    FileStatus[] children;
                    Path srcPath = lmfd.getSourceDirs().get(i);
                    Path destPath = lmfd.getTargetDirs().get(i);
                    if (destPath.equals((Object)srcPath)) continue;
                    String filePrefix = targetPrefixes == null ? null : targetPrefixes.get(i);
                    FileSystem destFs = destPath.getFileSystem((Configuration)this.conf);
                    if (filePrefix == null) {
                        if (!destFs.exists(destPath.getParent())) {
                            destFs.mkdirs(destPath.getParent());
                        }
                        Utilities.FILE_OP_LOGGER.debug("MoveTask moving (multi-file) " + srcPath + " to " + destPath);
                        this.moveFile(srcPath, destPath, isDfsDir);
                        continue;
                    }
                    if (!destFs.exists(destPath)) {
                        destFs.mkdirs(destPath);
                    }
                    if ((children = (srcFs = srcPath.getFileSystem((Configuration)this.conf)).listStatus(srcPath)) != null) {
                        for (FileStatus child : children) {
                            Path childSrc = child.getPath();
                            Path childDest = new Path(destPath, filePrefix + childSrc.getName());
                            Utilities.FILE_OP_LOGGER.debug("MoveTask moving (multi-file) " + childSrc + " to " + childDest);
                            this.moveFile(childSrc, childDest, isDfsDir);
                        }
                    } else {
                        Utilities.FILE_OP_LOGGER.debug("MoveTask skipping empty directory (multi-file) " + srcPath);
                    }
                    if (srcFs.delete(srcPath, false)) continue;
                    throw new IOException("Couldn't delete " + srcPath + " after moving all the files");
                }
            }
            if ((tbd = ((MoveWork)this.work).getLoadTableWork()) != null) {
                boolean isFullAcidOp;
                this.logMessage(tbd);
                Table table = db.getTable(tbd.getTable().getTableName());
                this.checkFileFormats(db, tbd, table);
                boolean bl = isFullAcidOp = ((MoveWork)this.work).getLoadTableWork().getWriteType() != AcidUtils.Operation.NOT_ACID && !tbd.isMmTable();
                if (shouldFlattenUnionSubdirectories) {
                    this.flattenUnionSubdirectories(tbd.getSourcePath());
                }
                LineageInfo.DataContainer dc = null;
                if (tbd.getPartitionSpec().size() == 0) {
                    dc = new LineageInfo.DataContainer(table.getTTable());
                    if (Utilities.FILE_OP_LOGGER.isTraceEnabled()) {
                        Utilities.FILE_OP_LOGGER.trace("loadTable called from " + tbd.getSourcePath() + " into " + tbd.getTable().getTableName());
                    }
                    int statementId = tbd.getStmtId();
                    if (tbd.isDirectInsert() || tbd.isMmTable()) {
                        statementId = this.queryPlan.getStatementIdForAcidWriteType(((MoveWork)this.work).getLoadTableWork().getWriteId(), tbd.getMoveTaskId(), ((MoveWork)this.work).getLoadTableWork().getWriteType(), tbd.getSourcePath(), statementId);
                        LOG.debug("The statementId used when loading the dynamic partitions is " + statementId);
                    }
                    db.loadTable(tbd.getSourcePath(), tbd.getTable().getTableName(), tbd.getLoadFileType(), ((MoveWork)this.work).isSrcLocal(), this.isSkewedStoredAsDirs(tbd), isFullAcidOp, this.resetStatisticsProps(table), tbd.getWriteId(), statementId, tbd.isInsertOverwrite(), tbd.isDirectInsert());
                    if (((MoveWork)this.work).getOutputs() != null) {
                        DDLUtils.addIfAbsentByName(new WriteEntity(table, this.getWriteType(tbd, ((MoveWork)this.work).getLoadTableWork().getWriteType())), ((MoveWork)this.work).getOutputs());
                    }
                } else {
                    LOG.info("Partition is: {}", tbd.getPartitionSpec());
                    TaskInformation ti = new TaskInformation(this, tbd.getSourcePath().toUri().toString());
                    this.inferTaskInformation(ti);
                    DynamicPartitionCtx dpCtx = tbd.getDPCtx();
                    if (dpCtx != null && dpCtx.getNumDPCols() > 0) {
                        this.moveFilesUsingManifestFile(tbd.getSourcePath().getFileSystem((Configuration)this.conf), tbd.getSourcePath(), dpCtx.getRootPath());
                        dc = this.handleDynParts(db, table, tbd, ti, dpCtx);
                    } else {
                        dc = this.handleStaticParts(db, table, tbd, ti);
                    }
                }
                if (dc != null) {
                    List<FieldSchema> tableCols = null;
                    switch (((MoveWork)this.work).getLoadTableWork().getWriteType()) {
                        case DELETE: 
                        case UPDATE: {
                            tableCols = new ArrayList<FieldSchema>();
                            break;
                        }
                        default: {
                            tableCols = table.getCols();
                        }
                    }
                    this.queryState.getLineageState().setLineage(tbd.getSourcePath(), dc, tableCols);
                }
                this.releaseLocks(tbd);
            }
            long moveFilesDuration = this.perfLogger.getDuration("FileMoves");
            this.console.printInfo(String.format("Time taken to move files:\t %d ms", moveFilesDuration));
            int n = 0;
            return n;
        }
        catch (HiveException he) {
            return this.processHiveException(he);
        }
        catch (Exception e) {
            this.console.printError("Failed with exception " + e.getMessage(), "\n" + StringUtils.stringifyException((Throwable)e));
            this.setException(e);
            LOG.error("MoveTask failed", (Throwable)e);
            return ReplUtils.handleException(((MoveWork)this.work).isReplication(), e, ((MoveWork)this.work).getDumpDirectory(), ((MoveWork)this.work).getMetricCollector(), this.getName(), this.conf);
        }
    }

    private int processHiveException(HiveException he) {
        int errorCode = 1;
        if (he.getCanonicalErrorMsg() != ErrorMsg.GENERIC_ERROR) {
            errorCode = he.getCanonicalErrorMsg().getErrorCode();
            if (he.getCanonicalErrorMsg() == ErrorMsg.UNRESOLVED_RT_EXCEPTION) {
                this.console.printError("Failed with exception " + he.getMessage(), "\n" + StringUtils.stringifyException((Throwable)he));
            } else {
                this.console.printError("Failed with exception " + he.getMessage() + "\nRemote Exception: " + he.getRemoteErrorMsg());
                this.console.printInfo("\n", StringUtils.stringifyException((Throwable)he), false);
            }
        }
        this.setException(he);
        errorCode = ReplUtils.handleException(((MoveWork)this.work).isReplication(), he, ((MoveWork)this.work).getDumpDirectory(), ((MoveWork)this.work).getMetricCollector(), this.getName(), this.conf);
        return errorCode;
    }

    private void initializeFromDeferredContext() throws HiveException {
        if (null != this.getDeferredWorkContext()) {
            ((MoveWork)this.work).initializeFromDeferredContext(this.getDeferredWorkContext());
        }
    }

    public void logMessage(LoadTableDesc tbd) {
        StringBuilder mesg = new StringBuilder("Loading data to table ").append(tbd.getTable().getTableName());
        if (tbd.getPartitionSpec().size() > 0) {
            mesg.append(" partition (");
            Map<String, String> partSpec = tbd.getPartitionSpec();
            for (String key : partSpec.keySet()) {
                mesg.append(key).append('=').append(partSpec.get(key)).append(", ");
            }
            mesg.setLength(mesg.length() - 2);
            mesg.append(')');
        }
        String mesg_detail = " from " + tbd.getSourcePath();
        if (Utilities.FILE_OP_LOGGER.isTraceEnabled()) {
            Utilities.FILE_OP_LOGGER.trace(mesg.toString() + " " + mesg_detail);
        }
        this.console.printInfo(mesg.toString(), mesg_detail);
    }

    private LineageInfo.DataContainer handleStaticParts(Hive db, Table table, LoadTableDesc tbd, TaskInformation ti) throws HiveException, IOException, InvalidOperationException {
        List partVals = MetaStoreUtils.getPvals(table.getPartCols(), tbd.getPartitionSpec());
        db.validatePartitionNameCharacters(partVals);
        if (Utilities.FILE_OP_LOGGER.isTraceEnabled()) {
            Utilities.FILE_OP_LOGGER.trace("loadPartition called from " + tbd.getSourcePath() + " into " + tbd.getTable().getTableName());
        }
        db.loadPartition(tbd.getSourcePath(), db.getTable(tbd.getTable().getTableName()), tbd.getPartitionSpec(), tbd.getLoadFileType(), tbd.getInheritTableSpecs(), tbd.getInheritLocation(), this.isSkewedStoredAsDirs(tbd), ((MoveWork)this.work).isSrcLocal(), ((MoveWork)this.work).getLoadTableWork().getWriteType() != AcidUtils.Operation.NOT_ACID && !tbd.isMmTable(), this.resetStatisticsProps(table), tbd.getWriteId(), tbd.getStmtId(), tbd.isInsertOverwrite(), tbd.isDirectInsert());
        Partition partn = db.getPartition(table, tbd.getPartitionSpec(), false);
        if (!(tbd.isMmTable() || ti.bucketCols == null && ti.sortCols == null)) {
            this.updatePartitionBucketSortColumns(db, table, partn, ti.bucketCols, ti.numBuckets, ti.sortCols);
        }
        LineageInfo.DataContainer dc = new LineageInfo.DataContainer(table.getTTable(), partn.getTPartition());
        if (((MoveWork)this.work).getOutputs() != null) {
            DDLUtils.addIfAbsentByName(new WriteEntity(partn, this.getWriteType(tbd, ((MoveWork)this.work).getLoadTableWork().getWriteType())), ((MoveWork)this.work).getOutputs());
        }
        return dc;
    }

    private LineageInfo.DataContainer handleDynParts(Hive db, Table table, LoadTableDesc tbd, TaskInformation ti, DynamicPartitionCtx dpCtx) throws HiveException, IOException, InvalidOperationException {
        LineageInfo.DataContainer dc;
        int statementId = tbd.getStmtId();
        if (tbd.isDirectInsert() || tbd.isMmTable()) {
            statementId = this.queryPlan.getStatementIdForAcidWriteType(((MoveWork)this.work).getLoadTableWork().getWriteId(), tbd.getMoveTaskId(), ((MoveWork)this.work).getLoadTableWork().getWriteType(), tbd.getSourcePath(), statementId);
            LOG.debug("The statementId used when loading the dynamic partitions is " + statementId);
        }
        Map<String, List<Path>> dynamicPartitionSpecs = null;
        if (tbd.isMmTable() || tbd.isDirectInsert()) {
            dynamicPartitionSpecs = this.queryPlan.getDynamicPartitionSpecs(((MoveWork)this.work).getLoadTableWork().getWriteId(), tbd.getMoveTaskId(), ((MoveWork)this.work).getLoadTableWork().getWriteType(), tbd.getSourcePath());
        }
        Map<Path, Utilities.PartitionDetails> dps = Utilities.getFullDPSpecs((Configuration)this.conf, dpCtx, dynamicPartitionSpecs);
        this.console.printInfo(System.getProperty("line.separator"));
        long startTime = Time.monotonicNow();
        Map<Map<String, String>, Partition> dp = db.loadDynamicPartitions(tbd, tbd.getLbCtx() == null ? 0 : tbd.getLbCtx().calculateListBucketingLevel(), ((MoveWork)this.work).getLoadTableWork().getWriteType() != AcidUtils.Operation.NOT_ACID && !tbd.isMmTable(), ((MoveWork)this.work).getLoadTableWork().getWriteId(), statementId, this.resetStatisticsProps(table), ((MoveWork)this.work).getLoadTableWork().getWriteType(), dps);
        if (dp != null && dp.size() > 0) {
            this.pushFeed(Task.FeedType.DYNAMIC_PARTITIONS, dp.values());
        }
        String loadTime = String.format("Time taken to load dynamic partitions:\t %.3f seconds", (double)(Time.monotonicNow() - startTime) / 1000.0);
        this.console.printInfo(loadTime);
        LOG.info(loadTime);
        if (dp.size() == 0 && this.conf.getBoolVar(HiveConf.ConfVars.HIVE_ERROR_ON_EMPTY_PARTITION)) {
            throw new HiveException("This query creates no partitions. To turn off this error, set hive.error.on.empty.partition=false.");
        }
        startTime = Time.monotonicNow();
        for (Map.Entry<Map<String, String>, Partition> entry : dp.entrySet()) {
            Partition partn = entry.getValue();
            if (!(tbd.isMmTable() || ti.bucketCols == null && ti.sortCols == null)) {
                this.updatePartitionBucketSortColumns(db, table, partn, ti.bucketCols, ti.numBuckets, ti.sortCols);
            }
            WriteEntity enty = new WriteEntity(partn, this.getWriteType(tbd, ((MoveWork)this.work).getLoadTableWork().getWriteType()));
            if (((MoveWork)this.work).getOutputs() != null) {
                DDLUtils.addIfAbsentByName(enty, ((MoveWork)this.work).getOutputs());
            }
            if (this.queryPlan.getOutputs() == null) {
                this.queryPlan.setOutputs(new LinkedHashSet<WriteEntity>());
            }
            this.queryPlan.getOutputs().add(enty);
            dc = new LineageInfo.DataContainer(table.getTTable(), partn.getTPartition());
            if (((MoveWork)this.work).getLoadTableWork().getWriteType() != AcidUtils.Operation.DELETE && ((MoveWork)this.work).getLoadTableWork().getWriteType() != AcidUtils.Operation.UPDATE) {
                this.queryState.getLineageState().setLineage(tbd.getSourcePath(), dc, table.getCols());
            }
            LOG.info("Loading partition " + entry.getKey());
        }
        this.console.printInfo(String.format("Time taken for adding to write entity:\t %.3f seconds", (double)(Time.monotonicNow() - startTime) / 1000.0));
        dc = null;
        return dc;
    }

    private void inferTaskInformation(TaskInformation ti) {
        while (ti.task.getParentTasks() != null && ti.task.getParentTasks().size() == 1) {
            MoveTask mt;
            ti.task = ti.task.getParentTasks().get(0);
            if (ti.task instanceof MergeFileTask || ti.task instanceof MapredLocalTask) break;
            if (ti.task instanceof MapRedTask) {
                MapredWork work = (MapredWork)ti.task.getWork();
                MapWork mapWork = work.getMapWork();
                ti.bucketCols = mapWork.getBucketedColsByDirectory().get(ti.path);
                ti.sortCols = mapWork.getSortedColsByDirectory().get(ti.path);
                if (work.getReduceWork() != null) {
                    ti.numBuckets = work.getReduceWork().getNumReduceTasks();
                }
                if (ti.bucketCols != null || ti.sortCols != null) assert (work.isFinalMapRed());
                break;
            }
            if (!(ti.task instanceof MoveTask) || ((MoveWork)(mt = (MoveTask)ti.task).getWork()).getLoadFileWork() == null) continue;
            ti.path = ((MoveWork)mt.getWork()).getLoadFileWork().getSourcePath().toUri().toString();
        }
    }

    private void checkFileFormats(Hive db, LoadTableDesc tbd, Table table) throws HiveException {
        if (((MoveWork)this.work).getCheckFileFormat()) {
            ArrayList<FileStatus> files;
            FileSystem srcFs;
            try {
                srcFs = tbd.getSourcePath().getFileSystem((Configuration)this.conf);
                FileStatus[] dirs = srcFs.globStatus(tbd.getSourcePath());
                files = new ArrayList<FileStatus>();
                for (int i = 0; dirs != null && i < dirs.length; ++i) {
                    files.addAll(Arrays.asList(srcFs.listStatus(dirs[i].getPath(), FileUtils.HIDDEN_FILES_PATH_FILTER)));
                    if (files.size() <= 0) {
                        continue;
                    }
                    break;
                }
            }
            catch (IOException e) {
                throw new HiveException("addFiles: filesystem error in check phase", (Throwable)e);
            }
            if (HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_CHECK_FILEFORMAT)) {
                boolean flag = true;
                if (tbd.getDPCtx() == null) {
                    Partition oldPart;
                    flag = tbd.getPartitionSpec() == null || tbd.getPartitionSpec().isEmpty() ? HiveFileFormatUtils.checkInputFormat(srcFs, this.conf, tbd.getTable().getInputFileFormatClass(), files) : ((oldPart = db.getPartition(table, tbd.getPartitionSpec(), false)) == null ? HiveFileFormatUtils.checkInputFormat(srcFs, this.conf, tbd.getTable().getInputFileFormatClass(), files) : HiveFileFormatUtils.checkInputFormat(srcFs, this.conf, oldPart.getInputFormatClass(), files));
                    if (!flag) {
                        throw new HiveException(ErrorMsg.WRONG_FILE_FORMAT);
                    }
                } else {
                    LOG.warn("Skipping file format check as dpCtx is not null");
                }
            }
        }
    }

    WriteEntity.WriteType getWriteType(LoadTableDesc tbd, AcidUtils.Operation operation) {
        if (tbd.getLoadFileType() == LoadTableDesc.LoadFileType.REPLACE_ALL || tbd.isInsertOverwrite()) {
            return WriteEntity.WriteType.INSERT_OVERWRITE;
        }
        switch (operation) {
            case DELETE: {
                return WriteEntity.WriteType.DELETE;
            }
            case UPDATE: {
                return WriteEntity.WriteType.UPDATE;
            }
        }
        return WriteEntity.WriteType.INSERT;
    }

    private LocalTableLock acquireLockForFileMove(LoadTableDesc loadTableWork) throws HiveException {
        LockFileMoveMode mode = LockFileMoveMode.fromConf(this.conf);
        if (mode == LockFileMoveMode.NONE) {
            return new LocalTableLock();
        }
        if (mode == LockFileMoveMode.DP && loadTableWork.getDPCtx() == null) {
            return new LocalTableLock();
        }
        WriteEntity output = this.context.getLoadTableOutputMap().get(loadTableWork);
        List<HiveLockObj> lockObjects = this.context.getOutputLockObjects().get(output);
        if (lockObjects == null) {
            return new LocalTableLock();
        }
        TableDesc table = loadTableWork.getTable();
        if (table == null) {
            return new LocalTableLock();
        }
        Hive db = this.getHive();
        Table baseTable = db.getTable(loadTableWork.getTable().getTableName());
        HiveLockObject.HiveLockObjectData lockData = new HiveLockObject.HiveLockObjectData(this.queryPlan.getQueryId(), String.valueOf(System.currentTimeMillis()), "IMPLICIT", this.queryPlan.getQueryStr(), this.conf);
        HiveLockObject lock = new HiveLockObject(baseTable, lockData);
        for (HiveLockObj hiveLockObj : lockObjects) {
            HiveLockMode l;
            if (!Arrays.equals(hiveLockObj.getObj().getPaths(), lock.getPaths()) || (l = hiveLockObj.getMode()) != HiveLockMode.EXCLUSIVE && l != HiveLockMode.SEMI_SHARED) continue;
            return new LocalTableLock();
        }
        return new LocalTableLock(lock);
    }

    private boolean isSkewedStoredAsDirs(LoadTableDesc tbd) {
        return tbd.getLbCtx() != null && tbd.getLbCtx().isSkewedStoredAsDir();
    }

    private void updatePartitionBucketSortColumns(Hive db, Table table, Partition partn, List<BucketingSortingCtx.BucketCol> bucketCols, int numBuckets, List<BucketingSortingCtx.SortCol> sortCols) throws IOException, InvalidOperationException, HiveException {
        boolean updateBucketCols = false;
        if (bucketCols != null) {
            FileSystem fileSys = partn.getDataLocation().getFileSystem((Configuration)this.conf);
            List fileStatus = HiveStatsUtils.getFileStatusRecurse((Path)partn.getDataLocation(), (int)1, (FileSystem)fileSys);
            if (fileStatus.size() == numBuckets) {
                ArrayList<String> newBucketCols = new ArrayList<String>();
                updateBucketCols = true;
                for (BucketingSortingCtx.BucketCol bucketCol : bucketCols) {
                    if (bucketCol.getIndexes().get(0) < partn.getCols().size()) {
                        newBucketCols.add(partn.getCols().get(bucketCol.getIndexes().get(0)).getName());
                        continue;
                    }
                    updateBucketCols = false;
                    break;
                }
                if (updateBucketCols) {
                    partn.getBucketCols().clear();
                    partn.getBucketCols().addAll(newBucketCols);
                    partn.getTPartition().getSd().setNumBuckets(numBuckets);
                }
            }
        }
        boolean updateSortCols = false;
        if (sortCols != null) {
            ArrayList<Order> newSortCols = new ArrayList<Order>();
            updateSortCols = true;
            for (BucketingSortingCtx.SortCol sortCol : sortCols) {
                if (sortCol.getIndexes().get(0) < partn.getCols().size()) {
                    newSortCols.add(new Order(partn.getCols().get(sortCol.getIndexes().get(0)).getName(), DirectionUtils.signToCode(sortCol.getSortOrder())));
                    continue;
                }
                updateSortCols = false;
                break;
            }
            if (updateSortCols) {
                partn.getSortCols().clear();
                partn.getSortCols().addAll(newSortCols);
            }
        }
        if (updateBucketCols || updateSortCols) {
            db.alterPartition(table.getCatalogName(), table.getDbName(), table.getTableName(), partn, null, true);
        }
    }

    public boolean isLocal() {
        LoadTableDesc tbd = ((MoveWork)this.work).getLoadTableWork();
        if (tbd != null) {
            return false;
        }
        LoadFileDesc lfd = ((MoveWork)this.work).getLoadFileWork();
        if (lfd != null) {
            return !lfd.getIsDfsDir();
        }
        return false;
    }

    @Override
    public StageType getType() {
        return StageType.MOVE;
    }

    public String getName() {
        return "MOVE";
    }

    @Override
    public boolean canExecuteInParallel() {
        return false;
    }

    private boolean checkAndCommitNatively(MoveWork moveWork, Configuration configuration) throws HiveException {
        HiveStorageHandler storageHandler;
        String storageHandlerClass = null;
        Properties commitProperties = null;
        Context.Operation operation = this.context.getOperation();
        LoadTableDesc loadTableWork = moveWork.getLoadTableWork();
        if (loadTableWork != null) {
            if (loadTableWork.isUseAppendForLoad()) {
                loadTableWork.getMdTable().getStorageHandler().appendFiles(loadTableWork.getMdTable().getTTable(), loadTableWork.getSourcePath().toUri(), loadTableWork.getLoadFileType() == LoadTableDesc.LoadFileType.REPLACE_ALL, loadTableWork.getPartitionSpec());
                return true;
            }
            TableDesc tableDesc = moveWork.getLoadTableWork().getTable();
            storageHandlerClass = tableDesc.getProperties().getProperty("storage_handler");
            commitProperties = new Properties(tableDesc.getProperties());
            if (moveWork.getLoadTableWork().isInsertOverwrite()) {
                operation = Context.Operation.IOW;
            }
        } else if (moveWork.getLoadFileWork() != null) {
            CreateTableDesc createTableDesc = moveWork.getLoadFileWork().getCtasCreateTableDesc();
            String location = null;
            if (createTableDesc != null) {
                storageHandlerClass = createTableDesc.getStorageHandler();
                commitProperties = new Properties();
                commitProperties.put("name", createTableDesc.getDbTableName());
                location = createTableDesc.getLocation();
            } else {
                CreateMaterializedViewDesc createViewDesc = moveWork.getLoadFileWork().getCreateViewDesc();
                if (createViewDesc != null) {
                    storageHandlerClass = createViewDesc.getStorageHandler();
                    commitProperties = new Properties();
                    commitProperties.put("name", createViewDesc.getViewName());
                    location = createViewDesc.getLocation();
                }
            }
            if (location != null) {
                commitProperties.put("location", location);
            }
        }
        if (storageHandlerClass != null && (storageHandler = HiveUtils.getStorageHandler(configuration, storageHandlerClass)).commitInMoveTask()) {
            storageHandler.storageHandlerCommit(commitProperties, operation);
            return true;
        }
        return false;
    }

    class LocalTableLock
    implements Closeable {
        private Optional<HiveLockObject> lock;
        private HiveLock lockObj;

        public LocalTableLock(HiveLockObject lock) throws LockException {
            this.lock = Optional.of(lock);
            LOG.debug("LocalTableLock; locking: " + lock);
            HiveLockManager lockMgr = MoveTask.this.context.getHiveTxnManager().getLockManager();
            this.lockObj = lockMgr.lock(lock, HiveLockMode.SEMI_SHARED, true);
            LOG.debug("LocalTableLock; locked: " + lock);
        }

        public LocalTableLock() {
            this.lock = Optional.empty();
        }

        @Override
        public void close() throws IOException {
            if (!this.lock.isPresent()) {
                return;
            }
            LOG.debug("LocalTableLock; unlocking: " + this.lock);
            try {
                HiveLockManager lockMgr = MoveTask.this.context.getHiveTxnManager().getLockManager();
                lockMgr.unlock(this.lockObj);
            }
            catch (LockException e1) {
                throw new IOException((Throwable)((Object)e1));
            }
            LOG.debug("LocalTableLock; unlocked: " + this.lock);
        }
    }

    private static final class TaskInformation {
        public List<BucketingSortingCtx.BucketCol> bucketCols = null;
        public List<BucketingSortingCtx.SortCol> sortCols = null;
        public int numBuckets = -1;
        public Task task;
        public String path;

        public TaskInformation(Task task, String path) {
            this.task = task;
            this.path = path;
        }
    }

    static enum LockFileMoveMode {
        NONE,
        DP,
        ALL;


        public static LockFileMoveMode fromConf(HiveConf conf) {
            if (!conf.getBoolVar(HiveConf.ConfVars.HIVE_SUPPORT_CONCURRENCY)) {
                return NONE;
            }
            String lockFileMoveMode = conf.getVar(HiveConf.ConfVars.HIVE_LOCK_FILE_MOVE_MODE).toUpperCase();
            return LockFileMoveMode.valueOf(lockFileMoveMode);
        }
    }
}

