/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.repl;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.management.ObjectName;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.repl.ReplScope;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.exec.repl.DirCopyWork;
import org.apache.hadoop.hive.ql.exec.repl.OptimisedBootstrapUtils;
import org.apache.hadoop.hive.ql.exec.repl.ReplAck;
import org.apache.hadoop.hive.ql.exec.repl.ReplLoadWorkMBean;
import org.apache.hadoop.hive.ql.exec.repl.ReplStatsTracker;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.events.DatabaseEvent;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.events.filesystem.BootstrapEventsIterator;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.events.filesystem.ConstraintEventsIterator;
import org.apache.hadoop.hive.ql.exec.repl.incremental.IncrementalLoadEventsIterator;
import org.apache.hadoop.hive.ql.exec.repl.incremental.IncrementalLoadTasksBuilder;
import org.apache.hadoop.hive.ql.exec.repl.util.TaskTracker;
import org.apache.hadoop.hive.ql.exec.util.Retryable;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.repl.metric.ReplicationMetricCollector;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.session.LineageState;
import org.apache.hadoop.metrics2.util.MBeans;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Explain(displayName="Replication Load Operator", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
public class ReplLoadWork
implements Serializable,
ReplLoadWorkMBean {
    private static final Logger LOG = LoggerFactory.getLogger(ReplLoadWork.class);
    private static boolean enableMBeansRegistrationForTests = false;
    public static boolean disableMbeanUnregistrationForTests = false;
    final String dbNameToLoadIn;
    final ReplScope currentReplScope;
    final String dumpDirectory;
    private boolean lastReplIDUpdated;
    private String sourceDbName;
    private Long dumpExecutionId;
    private final transient ReplicationMetricCollector metricCollector;
    final boolean replScopeModified;
    private final ConstraintEventsIterator constraintsIterator;
    private int loadTaskRunCount = 0;
    private DatabaseEvent.State state = null;
    private final transient BootstrapEventsIterator bootstrapIterator;
    private transient IncrementalLoadTasksBuilder incrementalLoadTasksBuilder;
    private transient Task<?> rootTask;
    private Iterator<String> externalTableDataCopyItr;
    private ReplStatsTracker replStatsTracker;
    private String scheduledQueryName;
    private Long executionId;
    private boolean shouldFailover;
    public boolean isFirstFailover;
    public boolean isSecondFailover;
    public List<String> tablesToBootstrap = new LinkedList<String>();
    public List<String> tablesToDrop = new LinkedList<String>();
    final LineageState sessionStateLineageState;

    public ReplLoadWork(HiveConf hiveConf, String dumpDirectory, String sourceDbName, String dbNameToLoadIn, ReplScope currentReplScope, LineageState lineageState, boolean isIncrementalDump, Long eventTo, Long dumpExecutionId, ReplicationMetricCollector metricCollector, boolean replScopeModified) throws IOException, SemanticException {
        this.sessionStateLineageState = lineageState;
        this.dumpDirectory = dumpDirectory;
        this.dbNameToLoadIn = dbNameToLoadIn;
        this.currentReplScope = currentReplScope;
        this.sourceDbName = sourceDbName;
        this.dumpExecutionId = dumpExecutionId;
        this.metricCollector = metricCollector;
        this.replScopeModified = replScopeModified;
        if (currentReplScope != null && StringUtils.isNotBlank((CharSequence)dbNameToLoadIn)) {
            currentReplScope.setDbName(dbNameToLoadIn);
        }
        this.rootTask = null;
        if (isIncrementalDump) {
            ObjectName name = this.initializeMetricsMBeans(hiveConf, dbNameToLoadIn);
            if (this.replStatsTracker == null) {
                int numEvents = hiveConf.getIntVar(HiveConf.ConfVars.REPL_STATS_TOP_EVENTS_COUNTS);
                if (numEvents < 0) {
                    LOG.warn("Invalid value configured for {}, Using default of {}", (Object)HiveConf.ConfVars.REPL_STATS_TOP_EVENTS_COUNTS, (Object)HiveConf.ConfVars.REPL_STATS_TOP_EVENTS_COUNTS.defaultIntVal);
                    numEvents = HiveConf.ConfVars.REPL_STATS_TOP_EVENTS_COUNTS.defaultIntVal;
                }
                this.replStatsTracker = new ReplStatsTracker(numEvents);
            }
            if (metricCollector != null) {
                metricCollector.setMetricsMBean(name);
            }
            Path failoverReadyMarker = new Path(dumpDirectory, ReplAck.FAILOVER_READY_MARKER.toString());
            FileSystem fs = failoverReadyMarker.getFileSystem((Configuration)hiveConf);
            this.shouldFailover = hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_REPL_FAILOVER_START) && fs.exists(failoverReadyMarker);
            Path dumpDirParent = new Path(dumpDirectory).getParent();
            this.isFirstFailover = OptimisedBootstrapUtils.checkFileExists(dumpDirParent, hiveConf, "event_ack");
            this.isSecondFailover = !this.isFirstFailover && OptimisedBootstrapUtils.checkFileExists(dumpDirParent, hiveConf, "_failover_bootstrap_table_list");
            Path incBootstrapDir = new Path(dumpDirectory, "_bootstrap");
            if (this.isSecondFailover) {
                String[] bootstrappedTables = OptimisedBootstrapUtils.getBootstrapTableList(new Path(dumpDirectory).getParent(), hiveConf);
                LOG.info("Optimised bootstrap load for database {} with initial bootstrapped table list as {}", (Object)dbNameToLoadIn, this.tablesToBootstrap);
                if (fs.exists(incBootstrapDir)) {
                    Path tableMetaPath = new Path(incBootstrapDir, "metadata/" + sourceDbName);
                    this.tablesToBootstrap = Stream.of(fs.listStatus(tableMetaPath)).map(st -> st.getPath().getName()).collect(Collectors.toList());
                } else {
                    this.tablesToBootstrap = Collections.emptyList();
                }
                List<String> tableList = Arrays.asList(bootstrappedTables);
                this.tablesToDrop = ListUtils.subtract(tableList, this.tablesToBootstrap);
                LOG.info("Optimised bootstrap for database {} with drop table list as {} and bootstrap table list as {}", new Object[]{dbNameToLoadIn, this.tablesToDrop, this.tablesToBootstrap});
            }
            if (fs.exists(incBootstrapDir)) {
                this.bootstrapIterator = new BootstrapEventsIterator(new Path(incBootstrapDir, "metadata").toString(), dbNameToLoadIn, true, hiveConf, metricCollector);
                this.constraintsIterator = new ConstraintEventsIterator(dumpDirectory, hiveConf);
            } else {
                this.bootstrapIterator = null;
                this.constraintsIterator = null;
            }
            try {
                this.incrementalLoadTasksBuilder = new IncrementalLoadTasksBuilder(dbNameToLoadIn, dumpDirectory, new IncrementalLoadEventsIterator(dumpDirectory, hiveConf), hiveConf, eventTo, metricCollector, this.replStatsTracker, this.shouldFailover, this.tablesToBootstrap.size());
            }
            catch (HiveException e) {
                throw new SemanticException(e.getMessage(), (Throwable)e);
            }
        } else {
            this.bootstrapIterator = new BootstrapEventsIterator(new Path(dumpDirectory, "metadata").toString(), dbNameToLoadIn, true, hiveConf, metricCollector);
            this.constraintsIterator = new ConstraintEventsIterator(new Path(dumpDirectory, "metadata").toString(), hiveConf);
            this.incrementalLoadTasksBuilder = null;
        }
    }

    private ObjectName initializeMetricsMBeans(HiveConf hiveConf, String dbNameToLoadIn) {
        try {
            this.scheduledQueryName = hiveConf.get("scheduled.query.schedulename", "");
            if (!StringUtils.isEmpty((CharSequence)this.scheduledQueryName) || enableMBeansRegistrationForTests) {
                this.executionId = hiveConf.getLong("scheduled.query.executionid", 0L);
                String metricsName = "Database-" + dbNameToLoadIn + " Policy-" + this.scheduledQueryName;
                this.unRegisterMBeanIfRegistered("HiveServer2", metricsName, Collections.emptyMap());
                ObjectName name = MBeans.register((String)"HiveServer2", (String)metricsName, (Object)this);
                return name;
            }
        }
        catch (Exception e) {
            LOG.error("Failed to initialise Metrics MBean, Status won't be updated in the JMX", (Throwable)e);
        }
        return null;
    }

    private void unRegisterMBeanIfRegistered(String serviceName, String nameName, Map<String, String> additionalParameters) {
        String additionalKeys = additionalParameters.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + (String)entry.getValue()).collect(Collectors.joining(","));
        String nameStr = "Hadoop:service=" + serviceName + ",name=" + nameName + (String)(additionalKeys.isEmpty() ? "" : "," + additionalKeys);
        try {
            ObjectName name = ObjectName.getInstance(nameStr);
            MBeans.unregister((ObjectName)name);
            LOG.debug("Successfully attempted to unregistered the MBean {}", (Object)name);
        }
        catch (Exception e) {
            LOG.debug("Unable to unregister MBean {}", (Object)nameStr, (Object)e);
        }
    }

    BootstrapEventsIterator bootstrapIterator() {
        return this.bootstrapIterator;
    }

    boolean shouldFailover() {
        return this.shouldFailover;
    }

    ConstraintEventsIterator constraintsIterator() {
        return this.constraintsIterator;
    }

    int executedLoadTask() {
        return ++this.loadTaskRunCount;
    }

    void updateDbEventState(DatabaseEvent.State state) {
        this.state = state;
    }

    DatabaseEvent databaseEvent(HiveConf hiveConf) {
        return this.state.toEvent(hiveConf);
    }

    boolean hasDbState() {
        return this.state != null;
    }

    boolean isIncrementalLoad() {
        return this.incrementalLoadTasksBuilder != null;
    }

    boolean hasBootstrapLoadTasks() {
        return this.bootstrapIterator != null && this.bootstrapIterator.hasNext() || this.constraintsIterator != null && this.constraintsIterator.hasNext();
    }

    IncrementalLoadTasksBuilder incrementalLoadTasksBuilder() {
        return this.incrementalLoadTasksBuilder;
    }

    public Task<?> getRootTask() {
        return this.rootTask;
    }

    @Override
    public String getDumpDirectory() {
        return this.dumpDirectory;
    }

    public void setRootTask(Task<?> rootTask) {
        this.rootTask = rootTask;
    }

    public boolean isLastReplIDUpdated() {
        return this.lastReplIDUpdated;
    }

    public void setLastReplIDUpdated(boolean lastReplIDUpdated) {
        this.lastReplIDUpdated = lastReplIDUpdated;
    }

    public String getSourceDbName() {
        return this.sourceDbName;
    }

    public ReplicationMetricCollector getMetricCollector() {
        return this.metricCollector;
    }

    public Long getDumpExecutionId() {
        return this.dumpExecutionId;
    }

    public List<Task<?>> externalTableCopyTasks(TaskTracker tracker, HiveConf conf) throws IOException {
        if (conf.getBoolVar(HiveConf.ConfVars.REPL_DUMP_SKIP_IMMUTABLE_DATA_COPY)) {
            return Collections.emptyList();
        }
        ArrayList tasks = new ArrayList();
        Retryable retryable = Retryable.builder().withHiveConf(conf).withRetryOnException(UncheckedIOException.class).build();
        try {
            retryable.executeCallable(() -> {
                try {
                    int numEntriesToSkip;
                    int n = numEntriesToSkip = tasks == null ? 0 : tasks.size();
                    while (this.externalTableDataCopyItr.hasNext() && tracker.canAddMoreTasks()) {
                        if (numEntriesToSkip > 0) {
                            this.externalTableDataCopyItr.next();
                            --numEntriesToSkip;
                            continue;
                        }
                        DirCopyWork dirCopyWork = new DirCopyWork(this.metricCollector, new Path(this.dumpDirectory).getParent().toString());
                        dirCopyWork.loadFromString(this.externalTableDataCopyItr.next());
                        Task<DirCopyWork> task = TaskFactory.get(dirCopyWork, conf);
                        tasks.add(task);
                        tracker.addTask(task);
                        LOG.debug("Added task for {}", (Object)dirCopyWork);
                    }
                }
                catch (UncheckedIOException e) {
                    LOG.error("Reading entry for data copy failed for external tables, attempting retry.", (Throwable)e);
                    throw e;
                }
                return null;
            });
        }
        catch (Exception e) {
            throw new IOException(ErrorMsg.REPL_RETRY_EXHAUSTED.format(e.getMessage()));
        }
        LOG.info("Added total {} tasks for external table locations copy.", (Object)tasks.size());
        return tasks;
    }

    public Iterator<String> getExternalTableDataCopyItr() {
        return this.externalTableDataCopyItr;
    }

    public void setExternalTableDataCopyItr(Iterator<String> externalTableDataCopyItr) {
        this.externalTableDataCopyItr = externalTableDataCopyItr;
    }

    @Override
    public String getSourceDatabase() {
        return this.sourceDbName;
    }

    @Override
    public String getTargetDatabase() {
        return this.dbNameToLoadIn;
    }

    @Override
    public String getReplicationType() {
        return this.isIncrementalLoad() ? "INCREMENTAL" : "BOOTSTRAP";
    }

    @Override
    public String getScheduledQueryName() {
        return this.scheduledQueryName;
    }

    @Override
    public Long getExecutionId() {
        return this.executionId;
    }

    @Override
    public String getReplStats() {
        try {
            if (this.replStatsTracker != null) {
                return this.replStatsTracker.toString();
            }
            return "N/A";
        }
        catch (Exception e) {
            return "Got Error" + e.getMessage();
        }
    }

    @Override
    public String getCurrentEventId() {
        try {
            if (this.replStatsTracker != null) {
                return this.replStatsTracker.getLastEventId();
            }
            return "";
        }
        catch (Exception e) {
            return "Got Error" + e.getMessage();
        }
    }

    @Override
    public Long getLastEventId() {
        if (this.incrementalLoadTasksBuilder != null) {
            return this.incrementalLoadTasksBuilder.eventTo();
        }
        return -1L;
    }

    @VisibleForTesting
    public static void setMbeansParamsForTesting(boolean enableRegistration, boolean disableUnregistration) {
        enableMBeansRegistrationForTests = enableRegistration;
        disableMbeanUnregistrationForTests = disableUnregistration;
    }
}

