/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.repl.atlas;

import com.sun.jersey.api.client.UniformInterfaceException;
import java.util.Random;
import java.util.concurrent.Callable;
import org.apache.atlas.AtlasServiceException;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryingClientTimeBased {
    private static final long MINIMUM_DELAY_IN_SEC = 60L;
    private static final Logger LOG = LoggerFactory.getLogger(RetryingClientTimeBased.class);
    private static final String ERROR_MESSAGE_NO_ENTITIES = "no entities to create/update";
    private static final String ERROR_MESSAGE_IN_PROGRESS = "import or export is in progress";
    private static final String ATLAS_ERROR_CODE_IMPORT_EMPTY_ZIP = "empty ZIP file";
    protected long totalDurationInSeconds;
    protected long initialDelayInSeconds;
    protected long maxRetryDelayInSeconds;
    protected double backOff;
    protected int maxJitterInSeconds;

    protected <T> T invokeWithRetry(Callable<T> func) throws SemanticException {
        long startTime = System.currentTimeMillis();
        long delay = this.initialDelayInSeconds;
        while (true) {
            try {
                LOG.debug("Retrying method: {}", (Object)func.getClass().getName(), null);
                return func.call();
            }
            catch (Exception e) {
                if (this.processImportExportLockException(e, delay)) {
                    delay = this.getNextDelay(delay);
                    if (this.elapsedTimeInSeconds(startTime) + delay <= this.totalDurationInSeconds) continue;
                    throw new SemanticException(ErrorMsg.REPL_RETRY_EXHAUSTED.format(new String[0]), (Throwable)e);
                }
                if (this.processInvalidParameterException(e)) {
                    LOG.info("There is nothing to export/import.");
                    return null;
                }
                LOG.error(func.getClass().getName(), (Throwable)e);
                throw new SemanticException(ErrorMsg.REPL_RETRY_EXHAUSTED.format(new String[0]), (Throwable)e);
            }
            break;
        }
    }

    private long getNextDelay(long currentDelay) {
        if (currentDelay <= 0L) {
            currentDelay = 60L;
        }
        currentDelay = (long)((double)currentDelay * this.backOff);
        if (this.maxJitterInSeconds > 0) {
            currentDelay += (long)new Random().nextInt(this.maxJitterInSeconds);
        }
        if (currentDelay > this.maxRetryDelayInSeconds) {
            currentDelay = this.maxRetryDelayInSeconds;
        }
        return currentDelay;
    }

    private long elapsedTimeInSeconds(long fromTimeMillis) {
        return (System.currentTimeMillis() - fromTimeMillis) / 1000L;
    }

    private boolean processInvalidParameterException(Exception e) {
        if (e instanceof UniformInterfaceException) {
            return true;
        }
        if (!(e instanceof AtlasServiceException)) {
            return false;
        }
        if (e.getMessage() == null) {
            return false;
        }
        return e.getMessage().contains(ERROR_MESSAGE_NO_ENTITIES) || e.getMessage().contains(ATLAS_ERROR_CODE_IMPORT_EMPTY_ZIP);
    }

    private boolean processImportExportLockException(Exception e, long delay) throws SemanticException {
        String excMessage;
        if (!(e instanceof AtlasServiceException)) {
            return false;
        }
        String string = excMessage = e.getMessage() == null ? "" : e.getMessage();
        if (excMessage.contains(ERROR_MESSAGE_IN_PROGRESS)) {
            try {
                LOG.info("Atlas in-progress operation detected. Will pause for: {} seconds", (Object)delay);
                Thread.sleep(delay * 1000L);
            }
            catch (InterruptedException intEx) {
                LOG.error("Pause wait interrupted!", (Throwable)intEx);
                throw new SemanticException((Throwable)intEx);
            }
            return true;
        }
        return false;
    }
}

