/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.WMFullResourcePlan;
import org.apache.hadoop.hive.metastore.api.WMTrigger;
import org.apache.hadoop.hive.ql.exec.tez.KillTriggerActionHandler;
import org.apache.hadoop.hive.ql.exec.tez.RestrictedConfigChecker;
import org.apache.hadoop.hive.ql.exec.tez.SessionExpirationTracker;
import org.apache.hadoop.hive.ql.exec.tez.TezSessionPool;
import org.apache.hadoop.hive.ql.exec.tez.TezSessionPoolManagerMetrics;
import org.apache.hadoop.hive.ql.exec.tez.TezSessionPoolSession;
import org.apache.hadoop.hive.ql.exec.tez.TezSessionState;
import org.apache.hadoop.hive.ql.exec.tez.TriggerValidatorRunnable;
import org.apache.hadoop.hive.ql.exec.tez.YarnQueueHelper;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.wm.ExecutionTrigger;
import org.apache.hadoop.hive.ql.wm.SessionTriggerProvider;
import org.apache.hadoop.hive.ql.wm.Trigger;
import org.apache.hadoop.hive.ql.wm.TriggerActionHandler;
import org.apache.hadoop.hive.shims.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TezSessionPoolManager
extends TezSessionPoolSession.AbstractTriggerValidator
implements TezSessionPoolSession.Manager,
SessionExpirationTracker.RestartImpl {
    private static final Logger LOG = LoggerFactory.getLogger(TezSessionPoolManager.class);
    private Semaphore llapQueue;
    private HiveConf initConf = null;
    private int numConcurrentLlapQueries = -1;
    private CustomQueueAllowed customQueueAllowed = CustomQueueAllowed.TRUE;
    private TezSessionPool<TezSessionPoolSession> defaultSessionPool;
    private SessionExpirationTracker expirationTracker;
    private RestrictedConfigChecker restrictedConfig;
    private volatile boolean hasInitialSessions = false;
    private static TezSessionPoolManager instance = null;
    private final List<TezSessionState> openSessions = new LinkedList<TezSessionState>();
    private SessionTriggerProvider sessionTriggerProvider;
    private TriggerActionHandler<?> triggerActionHandler;
    private TriggerValidatorRunnable triggerValidatorRunnable;
    private YarnQueueHelper yarnQueueChecker;
    private TezSessionPoolManagerMetrics metrics = new TezSessionPoolManagerMetrics(this);

    public static TezSessionPoolManager getInstance() {
        TezSessionPoolManager local = instance;
        if (local == null) {
            instance = local = new TezSessionPoolManager();
        }
        return local;
    }

    protected TezSessionPoolManager() {
    }

    public void startPool(HiveConf conf, WMFullResourcePlan resourcePlan) throws Exception {
        if (this.restrictedConfig == null) {
            throw new AssertionError((Object)"setupPool or setupNonPool needs to be called first");
        }
        if (this.defaultSessionPool != null) {
            this.defaultSessionPool.start();
        }
        if (this.expirationTracker != null) {
            this.expirationTracker.start();
        }
        this.initTriggers(conf);
        if (resourcePlan != null) {
            Collection<String> appliedTriggers = this.updateTriggers(resourcePlan);
            LOG.info("Updated tez session pool manager with triggers {} from active resource plan: {}", appliedTriggers, (Object)(resourcePlan.getPlan() == null ? "null" : resourcePlan.getPlan().getName()));
        }
        this.metrics.start(conf);
    }

    public void setupPool(HiveConf conf) throws Exception {
        final String[] defaultQueueList = HiveConf.getTrimmedStringsVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_SERVER2_TEZ_DEFAULT_QUEUES);
        this.initConf = conf;
        int emptyNames = 0;
        for (String queueName : defaultQueueList) {
            if (!queueName.isEmpty()) continue;
            ++emptyNames;
        }
        int numSessions = conf.getIntVar(HiveConf.ConfVars.HIVE_SERVER2_TEZ_SESSIONS_PER_DEFAULT_QUEUE);
        int numSessionsTotal = numSessions * (defaultQueueList.length - emptyNames);
        if (numSessionsTotal > 0) {
            boolean enableAmRegistry = false;
            this.defaultSessionPool = new TezSessionPool<TezSessionPoolSession>(this.initConf, numSessionsTotal, enableAmRegistry, new TezSessionPool.SessionObjectFactory<TezSessionPoolSession>(){
                int queueIx = 0;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public TezSessionPoolSession create(TezSessionPoolSession oldSession) {
                    if (oldSession != null) {
                        return TezSessionPoolManager.this.createAndInitSession(oldSession.getQueueName(), oldSession.isDefault(), oldSession.getConf());
                    }
                    String[] stringArray = defaultQueueList;
                    synchronized (defaultQueueList) {
                        int localQueueIx = this.queueIx++;
                        if (this.queueIx == defaultQueueList.length) {
                            this.queueIx = 0;
                        }
                        // ** MonitorExit[var3_2] (shouldn't be in output)
                        HiveConf sessionConf = new HiveConf(TezSessionPoolManager.this.initConf);
                        return TezSessionPoolManager.this.createAndInitSession(defaultQueueList[localQueueIx], true, sessionConf);
                    }
                }
            });
        }
        this.setupNonPool(conf);
        this.expirationTracker = SessionExpirationTracker.create(conf, this);
        this.hasInitialSessions = numSessionsTotal > 0;
    }

    public void setupNonPool(HiveConf conf) {
        this.initConf = conf;
        this.numConcurrentLlapQueries = conf.getIntVar(HiveConf.ConfVars.HIVE_SERVER2_LLAP_CONCURRENT_QUERIES);
        this.llapQueue = new Semaphore(this.numConcurrentLlapQueries, true);
        String queueAllowedStr = HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_SERVER2_TEZ_SESSION_CUSTOM_QUEUE_ALLOWED);
        try {
            this.customQueueAllowed = CustomQueueAllowed.valueOf(queueAllowedStr.toUpperCase());
        }
        catch (Exception ex) {
            throw new RuntimeException("Invalid value '" + queueAllowedStr + "' for " + HiveConf.ConfVars.HIVE_SERVER2_TEZ_SESSION_CUSTOM_QUEUE_ALLOWED.varname);
        }
        if (this.customQueueAllowed == CustomQueueAllowed.TRUE && HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_SERVER2_TEZ_QUEUE_ACCESS_CHECK)) {
            this.yarnQueueChecker = new YarnQueueHelper(conf);
        }
        this.restrictedConfig = new RestrictedConfigChecker(conf);
    }

    public void initTriggers(HiveConf conf) {
        if (this.triggerValidatorRunnable == null) {
            long triggerValidationIntervalMs = HiveConf.getTimeVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_TRIGGER_VALIDATION_INTERVAL, (TimeUnit)TimeUnit.MILLISECONDS);
            this.sessionTriggerProvider = new SessionTriggerProvider(this.openSessions, new LinkedList<Trigger>());
            this.triggerActionHandler = new KillTriggerActionHandler();
            this.triggerValidatorRunnable = new TriggerValidatorRunnable(this.sessionTriggerProvider, this.triggerActionHandler);
            this.startTriggerValidator(triggerValidationIntervalMs);
        }
    }

    private TezSessionPoolSession createAndInitSession(String queue, boolean isDefault, HiveConf conf) {
        TezSessionPoolSession sessionState = this.createSession(TezSessionState.makeSessionId(), conf);
        if (queue != null) {
            sessionState.setQueueName(queue);
        }
        if (isDefault) {
            sessionState.setDefault();
        }
        LOG.info("Created new tez session for queue: " + queue + " with session id: " + sessionState.getSessionId());
        return sessionState;
    }

    private TezSessionState getSession(HiveConf conf, boolean doOpen) throws Exception {
        boolean jobNameSet;
        boolean hasQueue;
        String queueName = conf.get("tez.queue.name");
        boolean bl = hasQueue = queueName != null && !queueName.isEmpty();
        if (hasQueue) {
            switch (this.customQueueAllowed) {
                case FALSE: {
                    throw new HiveException("Specifying tez.queue.name is not allowed");
                }
                case IGNORE: {
                    LOG.warn("User has specified " + queueName + " queue; ignoring the setting");
                    queueName = null;
                    hasQueue = false;
                    conf.unset("tez.queue.name");
                }
            }
            if (this.yarnQueueChecker != null) {
                SessionState ss = SessionState.get();
                String userName = null;
                if (ss != null) {
                    String string = userName = ss.getAuthenticator() != null ? ss.getAuthenticator().getUserName() : ss.getUserName();
                }
                if (userName == null) {
                    userName = Utils.getUGI().getShortUserName();
                    LOG.info("No session user set; using the UGI user " + userName);
                }
                this.yarnQueueChecker.checkQueueAccess(queueName, userName);
            }
        }
        if (this.restrictedConfig != null) {
            this.restrictedConfig.validate(conf);
        }
        if (this.initConf != null) {
            conf.set(HiveConf.ConfVars.LLAP_CACHE_DEFAULT_FS_FILE_ID.varname, HiveConf.getVarWithoutType((Configuration)this.initConf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_CACHE_DEFAULT_FS_FILE_ID));
        }
        boolean nonDefaultUser = conf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_ENABLE_DOAS);
        boolean bl2 = jobNameSet = !HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_TEZ_JOB_NAME).equals("HIVE-%s");
        if (nonDefaultUser || !this.hasInitialSessions || hasQueue || jobNameSet) {
            LOG.info("QueueName: {} nonDefaultUser: {} defaultQueuePool: {} hasInitialSessions: {} jobNameSet: {}.", new Object[]{queueName, nonDefaultUser, this.defaultSessionPool, this.hasInitialSessions, jobNameSet});
            return this.getNewSessionState(conf, queueName, doOpen);
        }
        LOG.info("Choosing a session from the defaultQueuePool");
        return this.defaultSessionPool.getSession();
    }

    private TezSessionState getNewSessionState(HiveConf conf, String queueName, boolean doOpen) throws Exception {
        TezSessionPoolSession retTezSessionState = this.createAndInitSession(queueName, false, conf);
        if (queueName != null) {
            conf.set("tez.queue.name", queueName);
        }
        if (doOpen) {
            retTezSessionState.open();
            LOG.info("Started a new session for queue: " + queueName + " session id: " + retTezSessionState.getSessionId());
        }
        return retTezSessionState;
    }

    @Override
    public void returnAfterUse(TezSessionPoolSession session) throws Exception {
        this.returnSession(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void returnSession(TezSessionState tezSessionState) throws Exception {
        boolean isInterrupted = Thread.interrupted();
        boolean llap = tezSessionState.getLegacyLlapMode();
        try {
            if (isInterrupted) {
                LOG.info("returnSession invoked with interrupt status set");
            }
            if (llap && this.numConcurrentLlapQueries > 0) {
                this.llapQueue.release();
            }
            tezSessionState.setLegacyLlapMode(false);
            if (tezSessionState.isDefault() && tezSessionState instanceof TezSessionPoolSession) {
                LOG.info("The session " + tezSessionState.getSessionId() + " belongs to the pool. Put it back in");
                this.defaultSessionPool.returnSession((TezSessionPoolSession)tezSessionState);
            }
        }
        finally {
            if (isInterrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static void closeIfNotDefault(TezSessionState tezSessionState, boolean keepTmpDir) throws Exception {
        LOG.info("Closing tez session if not default: " + tezSessionState);
        if (!tezSessionState.isDefault()) {
            tezSessionState.close(keepTmpDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws Exception {
        if (instance == null || !this.hasInitialSessions) {
            return;
        }
        ArrayList<TezSessionState> sessionsToClose = null;
        List<TezSessionState> list = this.openSessions;
        synchronized (list) {
            sessionsToClose = new ArrayList<TezSessionState>(this.openSessions);
        }
        for (TezSessionState sessionState : sessionsToClose) {
            if (!sessionState.isDefault()) continue;
            sessionState.close(false);
        }
        if (this.expirationTracker != null) {
            this.expirationTracker.stop();
        }
        if (this.triggerValidatorRunnable != null) {
            this.stopTriggerValidator();
        }
        this.metrics.stop();
        instance = null;
    }

    @Override
    public void destroy(TezSessionState tezSessionState) throws Exception {
        LOG.warn("We are closing a " + (tezSessionState.isDefault() ? "default" : "non-default") + " session because of retry failure.");
        tezSessionState.close(false);
    }

    @Override
    TriggerValidatorRunnable getTriggerValidatorRunnable() {
        return this.triggerValidatorRunnable;
    }

    protected TezSessionPoolSession createSession(String sessionId, HiveConf conf) {
        return new TezSessionPoolSession(sessionId, this, this.expirationTracker, conf);
    }

    private static boolean canWorkWithSameSession(TezSessionState session, HiveConf conf) throws HiveException {
        if (session == null || conf == null || !session.isOpen()) {
            return false;
        }
        try {
            String userName = Utils.getUGI().getShortUserName();
            LOG.info("The current user: " + userName + ", session user: " + session.getUser());
            if (!userName.equals(session.getUser())) {
                LOG.info("Different users incoming: " + userName + " existing: " + session.getUser());
                return false;
            }
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e);
        }
        boolean doAsEnabled = conf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_ENABLE_DOAS);
        if (doAsEnabled != session.getConf().getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_ENABLE_DOAS)) {
            return false;
        }
        if (!session.isDefault()) {
            String queueName = session.getQueueName();
            String confQueueName = conf.get("tez.queue.name");
            LOG.info("Current queue name is " + queueName + " incoming queue name is " + confQueueName);
            if (queueName != null && confQueueName == null) {
                LOG.info("Incoming queue null is reset to current queue " + queueName);
                confQueueName = queueName;
            }
            return queueName == null ? confQueueName == null : queueName.equals(confQueueName);
        }
        throw new HiveException("The pool session " + session + " should have been returned to the pool");
    }

    public TezSessionState getSession(TezSessionState session, HiveConf conf, boolean doOpen, boolean llap) throws Exception {
        if (llap && this.numConcurrentLlapQueries > 0) {
            this.llapQueue.acquire();
        }
        if (TezSessionPoolManager.canWorkWithSameSession(session, conf)) {
            session.setLegacyLlapMode(llap);
            return session;
        }
        if (session != null) {
            TezSessionPoolManager.closeIfNotDefault(session, false);
        }
        session = this.getSession(conf, doOpen);
        session.setLegacyLlapMode(llap);
        return session;
    }

    @Override
    public TezSessionState reopen(TezSessionState sessionState) throws Exception {
        HiveConf sessionConf = sessionState.getConf();
        if (sessionState.getQueueName() != null && sessionConf.get("tez.queue.name") == null) {
            sessionConf.set("tez.queue.name", sessionState.getQueueName());
        }
        TezSessionPoolManager.reopenInternal(sessionState);
        return sessionState;
    }

    static void reopenInternal(TezSessionState sessionState) throws Exception {
        sessionState.close(true);
        sessionState.open(sessionState.extractHiveResources());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeNonDefaultSessions() throws Exception {
        ArrayList<TezSessionState> sessionsToClose = null;
        List<TezSessionState> list = this.openSessions;
        synchronized (list) {
            sessionsToClose = new ArrayList<TezSessionState>(this.openSessions);
        }
        for (TezSessionState sessionState : sessionsToClose) {
            System.err.println("Shutting down tez session.");
            TezSessionPoolManager.closeIfNotDefault(sessionState, false);
        }
    }

    @Override
    public void closeAndReopenExpiredSession(TezSessionPoolSession oldSession) throws Exception {
        String queueName = oldSession.getQueueName();
        if (queueName == null) {
            LOG.warn("Pool session has a null queue: " + oldSession);
        }
        this.defaultSessionPool.replaceSession(oldSession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerOpenSession(TezSessionPoolSession session) {
        List<TezSessionState> list = this.openSessions;
        synchronized (list) {
            this.openSessions.add(session);
            this.updateSessions();
        }
    }

    private void updateSessions() {
        if (this.sessionTriggerProvider != null) {
            this.sessionTriggerProvider.setSessions(this.getSessions());
        }
    }

    public Collection<String> updateTriggers(WMFullResourcePlan appliedRp) {
        HashSet<String> triggerNames = new HashSet<String>();
        if (this.sessionTriggerProvider != null) {
            List wmTriggers = appliedRp != null ? appliedRp.getTriggers() : null;
            ArrayList<ExecutionTrigger> triggers = new ArrayList<ExecutionTrigger>();
            if (wmTriggers != null) {
                for (WMTrigger wmTrigger : wmTriggers) {
                    if (!wmTrigger.isSetIsInUnmanaged() || !wmTrigger.isIsInUnmanaged()) continue;
                    triggers.add(ExecutionTrigger.fromWMTrigger(wmTrigger));
                    triggerNames.add(wmTrigger.getTriggerName());
                }
            }
            this.sessionTriggerProvider.setTriggers(Collections.unmodifiableList(triggers));
        }
        return triggerNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterOpenSession(TezSessionPoolSession session) {
        LOG.debug("Closed a pool session [{}]", (Object)this);
        List<TezSessionState> list = this.openSessions;
        synchronized (list) {
            this.openSessions.remove(session);
            this.updateSessions();
        }
        if (this.defaultSessionPool != null) {
            this.defaultSessionPool.notifyClosed(session);
        }
    }

    @VisibleForTesting
    public SessionExpirationTracker getExpirationTracker() {
        return this.expirationTracker;
    }

    List<String> getTriggerCounterNames() {
        ArrayList<String> counterNames = new ArrayList<String>();
        if (this.sessionTriggerProvider != null) {
            List<Trigger> activeTriggers = this.sessionTriggerProvider.getTriggers();
            for (Trigger trigger : activeTriggers) {
                counterNames.add(trigger.getExpression().getCounterLimit().getName());
            }
        }
        return counterNames;
    }

    public List<TezSessionState> getSessions() {
        return new LinkedList<TezSessionState>(this.openSessions);
    }

    private static enum CustomQueueAllowed {
        TRUE,
        FALSE,
        IGNORE;

    }
}

