/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.expressions.MathFuncDoubleToDouble;

public class FuncPowerDoubleToDouble
extends MathFuncDoubleToDouble {
    private static final long serialVersionUID = 1L;
    private final double power;

    public FuncPowerDoubleToDouble(int colNum, double power, int outputColumnNum) {
        super(colNum, outputColumnNum);
        this.power = power;
    }

    public FuncPowerDoubleToDouble() {
        this.power = -1.0;
    }

    @Override
    public double func(double d) {
        return StrictMath.pow(d, this.power);
    }

    public double getPower() {
        return this.power;
    }

    @Override
    protected void cleanup(DoubleColumnVector outputColVector, int[] sel, boolean selectedInUse, int n) {
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        VectorExpressionDescriptor.Builder b = new VectorExpressionDescriptor.Builder();
        b.setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(2).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.FLOAT_FAMILY, VectorExpressionDescriptor.ArgumentType.FLOAT_FAMILY).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.SCALAR);
        return b.build();
    }
}

